/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.DeadProductionEliminator;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.Simplifier;
import xtc.parser.UnaryOperator;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Runtime;

public class TreeExtractor
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected final boolean keepLexical;
    protected boolean isGeneric;
    protected boolean isList;
    protected boolean isTextOnly;
    protected boolean isToken;
    protected boolean setsValue;

    public TreeExtractor(Runtime runtime, Analyzer analyzer, AST ast, boolean keepLexical) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = ast;
        this.keepLexical = keepLexical;
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            this.analyzer.process(p);
        }
        new Simplifier(this.runtime, this.analyzer).dispatch(m);
        new DeadProductionEliminator(this.runtime, this.analyzer).dispatch(m);
        m.header = null;
        m.body = null;
        m.footer = null;
        m.attributes = null;
        for (Production p : m.productions) {
            p.attributes = null;
            p.type = null;
        }
    }

    public void visit(FullProduction p) {
        this.isGeneric = Generifier.isGeneric(p);
        this.isList = AST.isList(p.type);
        this.isTextOnly = p.getBooleanProperty("textOnly");
        this.isToken = p.getBooleanProperty("token");
        this.setsValue = false;
        if (this.isGeneric && DirectLeftRecurser.isTransformable(p)) {
            for (Sequence s : p.choice.alternatives) {
                Binding b;
                if (DirectLeftRecurser.isRecursive(s, p) || null == (b = this.analyzer.bind(s.elements))) continue;
                b.name = "yyValue";
            }
        }
        if ((this.isTextOnly || this.isToken) && !this.keepLexical) {
            p.choice = new OrderedChoice(new Sequence());
            p.setProperty("redacted", Boolean.TRUE);
        } else {
            this.dispatch(p.choice);
        }
        String s = this.ast.extern(p.type);
        p.dType = this.isGeneric ? "define<Node>" : (this.isTextOnly ? "define<String>" : (this.isToken ? "define<Token>" : (this.isList ? "define<" + s + '>' : (this.setsValue ? "define<" + s + '>' : "expand<" + s + '>'))));
    }

    public void visit(OrderedChoice c) {
        for (Sequence alt : c.alternatives) {
            this.dispatch(alt);
        }
    }

    public void visit(Sequence s) {
        s.name = null;
        for (int i = 0; i < s.size(); ++i) {
            Element e = s.get(i);
            if (s.size() - 1 == i && e instanceof OrderedChoice) {
                this.dispatch(e);
                continue;
            }
            if (e instanceof VoidedElement || e instanceof SemanticPredicate || e instanceof ValueElement) {
                s.elements.remove(i);
                --i;
                continue;
            }
            if (e instanceof Action) {
                Action a = (Action)e;
                if (a.setsValue()) {
                    this.setsValue = true;
                    a.code.clear();
                    a.indent.clear();
                    a.code.add("yyValue = ...");
                    a.indent.add(0);
                    continue;
                }
                s.elements.remove(i);
                --i;
                continue;
            }
            if (e instanceof Binding) {
                Binding b = (Binding)e;
                if (!this.isGeneric || this.isGeneric && !"yyValue".equals(b.name)) {
                    e = b.element;
                    s.elements.set(i, e);
                }
            } else if (!(this.isGeneric || this.isList || this.isTextOnly || this.isToken)) {
                s.elements.remove(i);
                --i;
                continue;
            }
            if (e instanceof NonTerminal) {
                FullProduction p = this.analyzer.lookup((NonTerminal)e);
                if (AST.isVoid(p.type)) {
                    s.elements.remove(i);
                    --i;
                    continue;
                }
            }
            this.dispatch(e);
        }
    }

    public void visit(CharCase c) {
        this.dispatch(c.element);
    }

    public void visit(CharSwitch s) {
        for (CharCase c : s.cases) {
            this.dispatch(c);
        }
        this.dispatch(s.base);
    }

    public void visit(UnaryOperator op) {
        this.dispatch(op.element);
        op.element = Analyzer.strip(op.element);
    }

    public void visit(Element e) {
    }
}

