/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Quantification;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringValue;
import xtc.parser.TextTester;
import xtc.parser.TokenValue;
import xtc.parser.Tokenizer;
import xtc.parser.ValueElement;
import xtc.tree.Attribute;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.type.Wildcard;
import xtc.util.Runtime;

public class Transformer
extends Visitor {
    public static final String ELEMENT_MARKER = "el";
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected boolean hasParseTree;
    protected FullProduction production;

    public Transformer(Runtime runtime, Analyzer analyzer, AST ast) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = ast;
    }

    protected void process(FullProduction p) {
        FullProduction saved = this.production;
        this.production = p;
        new Deducer().dispatch(this.production);
        new Lifter().dispatch(this.production);
        new Desugarer().dispatch(this.production);
        new Typer().dispatch(p);
        this.production = saved;
    }

    protected boolean isMemoized() {
        return this.production.isMemoized();
    }

    public boolean changesState() {
        return this.production.hasAttribute(Constants.ATT_RESETTING) || this.production.hasAttribute(Constants.ATT_STATEFUL);
    }

    protected boolean isVoid() {
        return AST.isVoid(this.production.type);
    }

    protected boolean isTextOnly() {
        return this.production.getBooleanProperty("textOnly");
    }

    protected boolean isToken() {
        return this.production.getBooleanProperty("token");
    }

    protected boolean isGeneric() {
        return Generifier.isGeneric(this.production);
    }

    protected boolean isList() {
        return AST.isList(this.production.type);
    }

    protected boolean isLeftRecursive() {
        return DirectLeftRecurser.isTransformable(this.production);
    }

    protected Production current() {
        return this.production;
    }

    protected boolean retainRepetitions() {
        return this.runtime.test("optimizeRepeated") && !this.isMemoized() || this.runtime.test("optionValued");
    }

    protected boolean retainOptions() {
        return this.runtime.test("optimizeOptional") || this.runtime.test("optionValued");
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        this.hasParseTree = m.hasAttribute(Constants.ATT_PARSE_TREE);
        for (int i = 0; i < m.productions.size(); ++i) {
            Production p = m.productions.get(i);
            this.analyzer.startAdding();
            this.analyzer.process(p);
            i += this.analyzer.addNewProductionsAt(i + 1);
        }
    }

    public void visit(FullProduction p) {
        this.process(p);
    }

    public class Typer
    extends Visitor {
        protected List<Element> elements;
        protected Type type;

        public void visit(Production p) {
            if (Analyzer.isSynthetic(p.name) && AST.isAny(p.type)) {
                this.elements = new ArrayList<Element>();
                this.type = Wildcard.TYPE;
                this.dispatch(p.choice);
                if (!this.type.isWildcard() && !AST.isAny(this.type)) {
                    if (Transformer.this.runtime.test("optionVerbose")) {
                        System.err.println("[Adjusting " + p.qName + "'s type to " + Transformer.this.ast.extern(this.type) + ']');
                    }
                    p.type = Transformer.this.ast.concretize(this.type, AST.ANY);
                }
            }
        }

        public void visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                this.dispatch(alt);
            }
        }

        public void visit(Sequence s) {
            int base = this.elements.size();
            Iterator<Element> iter = s.elements.iterator();
            while (iter.hasNext()) {
                Element e = iter.next();
                if (!iter.hasNext() && e instanceof OrderedChoice) {
                    this.dispatch(e);
                    continue;
                }
                this.elements.add(e);
            }
            if (!s.hasTrailingChoice()) {
                Binding b = Analyzer.getBinding(this.elements);
                if (null != b && ("yyValue".equals(b.name) || 0 != s.size() && s.get(s.size() - 1) instanceof BindingValue && b.name.equals(((BindingValue)s.get((int)(s.size() - 1))).binding.name))) {
                    this.type = Transformer.this.ast.unify(this.type, Transformer.this.analyzer.type(b.element), false);
                } else if (!Analyzer.setsNullValue(this.elements)) {
                    this.type = AST.ANY;
                }
            }
            if (0 == base) {
                this.elements.clear();
            } else {
                this.elements.subList(base, this.elements.size()).clear();
            }
        }
    }

    public class Desugarer
    extends Visitor {
        protected void process(Sequence s, NonTerminal nt) {
            if (s.hasTrailingChoice()) {
                OrderedChoice c = (OrderedChoice)s.get(s.size() - 1);
                for (Sequence alt : c.alternatives) {
                    this.process(alt, nt);
                }
            } else {
                if (null != nt) {
                    s.add(nt);
                }
                if (Transformer.this.isVoid()) {
                    s.add(NullValue.VALUE);
                } else if (Transformer.this.isTextOnly()) {
                    s.add(StringValue.VALUE);
                } else if (Transformer.this.isToken()) {
                    s.add(TokenValue.VALUE);
                } else assert (false);
            }
        }

        public void visit(Production p) {
            Element e = Analyzer.strip(p.choice);
            if (e instanceof Repetition && !Transformer.this.retainRepetitions()) {
                Binding b;
                Sequence s;
                if (Transformer.this.runtime.test("optionVerbose")) {
                    System.err.println("[Desugaring repetition in " + p.qName + ']');
                }
                if (!(s = (Sequence)((Repetition)e).element).hasTrailingChoice() && null != (b = Analyzer.getBinding(s.elements)) && b.element instanceof NonTerminal) {
                    p.setProperty("repeated", b.element);
                }
                p.choice = (OrderedChoice)this.dispatch(e);
            } else if (e instanceof Option && !Transformer.this.retainOptions()) {
                if (Transformer.this.runtime.test("optionVerbose")) {
                    System.err.println("[Desugaring option in " + p.qName + ']');
                }
                p.choice = (OrderedChoice)this.dispatch(e);
                p.setProperty("option", Boolean.TRUE);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Element visit(Repetition r) {
            Binding b;
            List<Object> oldAlternatives;
            Sequence repeated = (Sequence)r.element;
            if (1 == repeated.size() && repeated.hasTrailingChoice()) {
                oldAlternatives = ((OrderedChoice)repeated.get((int)0)).alternatives;
            } else {
                oldAlternatives = new ArrayList<Sequence>(1);
                oldAlternatives.add(repeated);
            }
            ArrayList<Sequence> newAlternatives = new ArrayList<Sequence>(oldAlternatives.size() + (r.once ? oldAlternatives.size() : 1));
            Type type = Wildcard.TYPE;
            if (!(Transformer.this.isVoid() || Transformer.this.isTextOnly() || Transformer.this.isToken())) {
                for (Sequence sequence : oldAlternatives) {
                    b = Analyzer.getBinding(sequence.elements);
                    if (null == b) {
                        Transformer.this.runtime.error("unable to bind repeated element", sequence);
                        continue;
                    }
                    type = Transformer.this.ast.unify(type, Transformer.this.analyzer.type(b.element), false);
                }
                type = AST.listOf(Transformer.this.ast.concretize(type, AST.ANY));
                if (Analyzer.isSynthetic(Transformer.this.current().name)) {
                    if (Transformer.this.runtime.test("optionVerbose")) {
                        System.err.println("[Adjusting " + Transformer.this.current().qName + "'s type to " + Transformer.this.ast.extern(type) + ']');
                    }
                    Transformer.this.current().type = type;
                }
            }
            for (Sequence sequence : oldAlternatives) {
                void var7_11;
                if (r.once) {
                    Sequence sequence2 = Transformer.this.analyzer.copy(sequence);
                }
                if (Transformer.this.isVoid() || Transformer.this.isTextOnly() || Transformer.this.isToken()) {
                    this.process((Sequence)var7_11, Transformer.this.current().name);
                } else {
                    Binding b1 = Analyzer.getBinding(var7_11.elements);
                    Binding b2 = new Binding(Transformer.this.analyzer.variable(), Transformer.this.current().name);
                    if (null != b1) {
                        var7_11.add(b2).add(new ProperListValue(type, b1, b2));
                    }
                }
                newAlternatives.add((Sequence)var7_11);
            }
            if (r.once) {
                for (Sequence sequence : oldAlternatives) {
                    if (Transformer.this.isVoid() || Transformer.this.isTextOnly() || Transformer.this.isToken()) {
                        this.process(sequence, null);
                    } else {
                        b = Analyzer.getBinding(sequence.elements);
                        if (null != b) {
                            sequence.add(new ProperListValue(type, b));
                        }
                    }
                    newAlternatives.add(sequence);
                }
            } else {
                Sequence s = new Sequence();
                if (Transformer.this.isVoid()) {
                    s.add(NullValue.VALUE);
                } else if (Transformer.this.isTextOnly()) {
                    s.add(StringValue.VALUE);
                } else if (Transformer.this.isToken()) {
                    s.add(TokenValue.VALUE);
                } else {
                    s.add(EmptyListValue.VALUE);
                }
                newAlternatives.add(s);
            }
            return new OrderedChoice(newAlternatives);
        }

        public Element visit(Option o) {
            List<Object> oldAlternatives;
            Sequence optional = (Sequence)o.element;
            if (1 == optional.size() && optional.hasTrailingChoice()) {
                oldAlternatives = ((OrderedChoice)optional.get((int)0)).alternatives;
            } else {
                oldAlternatives = new ArrayList<Sequence>(1);
                oldAlternatives.add(optional);
            }
            ArrayList<Sequence> newAlternatives = new ArrayList<Sequence>(oldAlternatives.size() + 1);
            for (Sequence sequence : oldAlternatives) {
                if (Transformer.this.isVoid() || Transformer.this.isTextOnly() || Transformer.this.isToken()) {
                    this.process(sequence, null);
                } else {
                    Binding b = Analyzer.getBinding(sequence.elements);
                    if (null != b) {
                        b.name = "yyValue";
                    }
                }
                newAlternatives.add(sequence);
            }
            Sequence alt = new Sequence();
            if (Transformer.this.isTextOnly()) {
                alt.add(StringValue.VALUE);
            } else if (Transformer.this.isToken()) {
                alt.add(TokenValue.VALUE);
            } else {
                alt.add(NullValue.VALUE);
            }
            newAlternatives.add(alt);
            return new OrderedChoice(newAlternatives);
        }
    }

    public class Lifter
    extends GrammarVisitor {
        public Lifter() {
            super(Transformer.this.runtime, Transformer.this.analyzer);
        }

        protected Binding bind(Element e) {
            return new Binding(this.analyzer.variable(Transformer.ELEMENT_MARKER), e);
        }

        protected Sequence process(Element e, boolean bound) {
            if (e instanceof OrderedChoice) {
                if (!Transformer.this.isTextOnly() && !Transformer.this.isToken() && (bound || Analyzer.setsValue(e, false))) {
                    return Sequence.ensure((Element)this.dispatch(this.bind(e)));
                }
                this.isLastElement = true;
                return Sequence.ensure((Element)this.dispatch(e));
            }
            Sequence s = Sequence.ensure(e);
            if (!Transformer.this.isTextOnly() && !Transformer.this.isToken() && Analyzer.setsValue(e, false)) {
                return Sequence.ensure((Element)this.dispatch(this.bind(new OrderedChoice(s))));
            }
            if (!Transformer.this.isTextOnly() && !Transformer.this.isToken() && bound && s.hasTrailingChoice()) {
                return Sequence.ensure((Element)this.dispatch(this.bind(new OrderedChoice(s))));
            }
            if (!Transformer.this.isTextOnly() && !Transformer.this.isToken() && bound) {
                Binding b = this.analyzer.bind(s.elements, Transformer.ELEMENT_MARKER);
                if (null == b) {
                    this.runtime.error("unable to deduce value", s);
                }
                return Sequence.ensure((Element)this.dispatch(s));
            }
            if (this.isPredicate && s.hasTrailingChoice()) {
                return Sequence.ensure((Element)this.dispatch(new OrderedChoice(s)));
            }
            this.isLastElement = true;
            return Sequence.ensure((Element)this.dispatch(s));
        }

        protected void lift(Type type, NonTerminal nt, OrderedChoice c) {
            FullProduction p = new FullProduction(new ArrayList<Attribute>(Transformer.this.current().attributes), type, nt, nt.qualify(this.analyzer.module().name.name), c);
            if (this.runtime.test("optionVerbose")) {
                System.err.println("[Lifting expression into new production " + p.qName + ']');
            }
            p.attributes.remove(Constants.ATT_PUBLIC);
            p.attributes.remove(Constants.ATT_EXPLICIT);
            p.attributes.remove(Constants.ATT_STATEFUL);
            p.attributes.remove(Constants.ATT_RESETTING);
            if (Transformer.this.isTextOnly()) {
                TextTester.markTextOnly(p, this.runtime.test("optionVerbose"));
            } else if (Transformer.this.isToken()) {
                Tokenizer.markToken(p, this.runtime.test("optionVerbose"));
            }
            Transformer.this.process(p);
            this.analyzer.add(p);
        }

        @Override
        public Element visit(OrderedChoice c) {
            boolean top = this.isTopLevel;
            this.isTopLevel = false;
            boolean voided = this.isVoided;
            this.isVoided = false;
            boolean bound = this.isBound;
            this.isBound = false;
            boolean last = this.isLastElement;
            boolean bl = this.transformInPlace = top && Analyzer.strip(c) instanceof Quantification;
            if ((top || last) && !this.isPredicate) {
                int size = c.alternatives.size();
                for (int i = 0; i < size; ++i) {
                    this.isLastElement = top || last;
                    c.alternatives.set(i, (Sequence)this.dispatch(c.alternatives.get(i)));
                }
                this.isLastElement = false;
                return c;
            }
            NonTerminal nt = this.analyzer.choice();
            Type type = Transformer.this.isTextOnly() ? AST.STRING : (Transformer.this.isToken() ? AST.TOKEN : (bound || (Transformer.this.isGeneric() || Transformer.this.isList()) && !voided && !this.isPredicate ? AST.ANY : AST.VOID));
            this.lift(type, nt, c);
            this.isLastElement = false;
            return nt;
        }

        @Override
        public Element visit(Repetition r) {
            NonTerminal nt;
            this.isTopLevel = false;
            boolean voided = this.isVoided;
            this.isVoided = false;
            boolean bound = this.isBound;
            this.isBound = false;
            this.isLastElement = false;
            boolean inPlace = this.transformInPlace;
            this.transformInPlace = false;
            if (Transformer.this.retainRepetitions() && (!bound || !Transformer.this.isTextOnly() && !Transformer.this.isToken()) || inPlace && (!Transformer.this.changesState() || Transformer.this.retainRepetitions()) && (!Transformer.this.isGeneric() || Transformer.this.retainRepetitions())) {
                boolean b = bound || Transformer.this.isGeneric() && !voided && !this.isPredicate || Transformer.this.isList() && !voided && !this.isPredicate || inPlace && !Transformer.this.isVoid();
                r.element = this.process(r.element, b);
                return r;
            }
            NonTerminal nonTerminal = nt = r.once ? this.analyzer.plus() : this.analyzer.star();
            Type type = Transformer.this.isTextOnly() ? AST.STRING : (Transformer.this.isToken() ? AST.TOKEN : (bound || (Transformer.this.isGeneric() || Transformer.this.isList()) && !voided && !this.isPredicate ? AST.WILD_LIST : AST.VOID));
            OrderedChoice c = new OrderedChoice(r);
            c.setLocation(r);
            this.lift(type, nt, c);
            return nt;
        }

        @Override
        public Element visit(Option o) {
            this.isTopLevel = false;
            boolean voided = this.isVoided;
            this.isVoided = false;
            boolean bound = this.isBound;
            this.isBound = false;
            this.isLastElement = false;
            boolean inPlace = this.transformInPlace;
            this.transformInPlace = false;
            if (Transformer.this.retainOptions() && (!bound || !Transformer.this.isTextOnly() && !Transformer.this.isToken()) || inPlace && (!Transformer.this.changesState() || Transformer.this.retainOptions()) && (!Transformer.this.isGeneric() || Transformer.this.retainOptions())) {
                boolean b = bound || Transformer.this.isGeneric() && !voided && !this.isPredicate || Transformer.this.isList() && !voided && !this.isPredicate || inPlace && !Transformer.this.isVoid();
                o.element = this.process(o.element, b);
                return o;
            }
            NonTerminal nt = this.analyzer.option();
            Type type = Transformer.this.isTextOnly() ? AST.STRING : (Transformer.this.isToken() ? AST.TOKEN : (bound || (Transformer.this.isGeneric() || Transformer.this.isList()) && !voided && !this.isPredicate ? AST.ANY : AST.VOID));
            OrderedChoice c = new OrderedChoice(o);
            c.setLocation(o);
            this.lift(type, nt, c);
            return nt;
        }

        @Override
        public Element visit(Predicate p) {
            this.isTopLevel = false;
            this.isVoided = false;
            this.isBound = false;
            this.isLastElement = false;
            boolean predicate = this.isPredicate;
            this.isPredicate = true;
            p.element = this.process(p.element, false);
            this.isPredicate = predicate;
            return p;
        }
    }

    public class Deducer
    extends Visitor {
        protected List<Element> elements;

        public void visit(Production p) {
            Element e = Analyzer.strip(p.choice);
            if (!(Transformer.this.isGeneric() || Transformer.this.isList() || Transformer.this.isLeftRecursive() || e instanceof Repetition && !Transformer.this.retainRepetitions() || e instanceof Option && !Transformer.this.retainOptions())) {
                if (Transformer.this.runtime.test("optionVerbose")) {
                    System.err.println("[Deducing semantic value for " + p.qName + "]");
                }
                this.elements = new ArrayList<Element>();
                this.dispatch(p.choice);
            }
        }

        public void visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                this.dispatch(alt);
            }
        }

        public void visit(Sequence s) {
            int base = this.elements.size();
            Iterator<Element> iter = s.elements.iterator();
            while (iter.hasNext()) {
                Element e = iter.next();
                if (!iter.hasNext() && e instanceof OrderedChoice) {
                    this.dispatch(e);
                    continue;
                }
                this.elements.add(e);
            }
            if (!s.hasTrailingChoice()) {
                String text;
                if (Transformer.this.isVoid()) {
                    s.add(NullValue.VALUE);
                } else if (Transformer.this.isTextOnly()) {
                    text = Transformer.this.analyzer.matchingText(new Sequence(this.elements));
                    if (null == text || !Transformer.this.runtime.test("optimizeTerminals")) {
                        s.add(StringValue.VALUE);
                    } else {
                        s.add(new StringValue(text));
                    }
                } else if (Transformer.this.isToken()) {
                    text = Transformer.this.analyzer.matchingText(new Sequence(this.elements));
                    if (null == text || !Transformer.this.runtime.test("optimizeTerminals")) {
                        s.add(TokenValue.VALUE);
                    } else {
                        s.add(new TokenValue(text));
                    }
                } else if (this.elements.isEmpty()) {
                    s.add(NullValue.VALUE);
                } else {
                    Binding b = Transformer.this.analyzer.bind(this.elements);
                    if (null != b) {
                        if (Analyzer.isSynthetic(b.name)) {
                            b.name = "yyValue";
                        } else if (!"yyValue".equals(b.name)) {
                            s.add(new BindingValue(b));
                        }
                    }
                }
            }
            if (!(Transformer.this.isVoid() || Transformer.this.isTextOnly() || Transformer.this.isToken())) {
                int size = s.size();
                if (s.hasTrailingChoice() || 0 != size && s.get(size - 1) instanceof ValueElement) {
                    --size;
                }
                for (int i = 0; i < size; ++i) {
                    Element e = this.elements.get(base + i);
                    if (s.get(i) == e) continue;
                    s.elements.set(i, e);
                }
            }
            if (0 == base) {
                this.elements.clear();
            } else {
                this.elements.subList(base, this.elements.size()).clear();
            }
        }
    }
}

