/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.List;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.Terminal;
import xtc.parser.UnaryOperator;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Runtime;

public class Tokenizer
extends GrammarVisitor {
    public Tokenizer(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    @Override
    public Object visit(Module m) {
        List<Production> todo;
        new Tester(this.runtime, this.analyzer).dispatch(m);
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            if (!p.getBooleanProperty("lexical") && !AST.isVoid(p.type)) continue;
            this.analyzer.notWorkingOnAny();
            this.analyzer.consumesInput(p.qName);
        }
        if (m.hasProperty("root")) {
            todo = new ArrayList<Production>(1);
            todo.add(this.analyzer.lookup((NonTerminal)m.getProperty("root")));
        } else {
            todo = m.productions;
        }
        for (Production p : todo) {
            if (this.analyzer.isProcessed(p.qName) || !p.hasAttribute(Constants.ATT_PUBLIC)) continue;
            this.analyzer.processed(p.qName);
            if (p.getBooleanProperty("lexical")) {
                this.analyzer.notWorkingOnAny();
                if (!this.analyzer.consumesInput(p.qName)) continue;
                Tokenizer.markToken(p, this.runtime.test("optionVerbose"));
                continue;
            }
            this.analyzer.process(p);
        }
        return null;
    }

    public Element visit(NonTerminal nt) {
        FullProduction p = this.analyzer.lookup(nt);
        if (!this.analyzer.isProcessed(p.qName)) {
            this.analyzer.processed(p.qName);
            if (p.getBooleanProperty("lexical")) {
                if (this.analyzer.consumesInput(nt)) {
                    Tokenizer.markToken(p, this.runtime.test("optionVerbose"));
                }
            } else {
                this.dispatch(p);
            }
        }
        return nt;
    }

    public static void markToken(Production p, boolean verbose) {
        if (verbose) {
            System.err.println("[Recognizing " + p.qName + " as token-level]");
        }
        p.setProperty("token", Boolean.TRUE);
        p.removeProperty("textOnly");
    }

    public static class Tester
    extends Visitor {
        protected final Runtime runtime;
        protected final Analyzer analyzer;
        protected boolean isLexical;

        public Tester(Runtime runtime, Analyzer analyzer) {
            this.runtime = runtime;
            this.analyzer = analyzer;
        }

        protected void mark(Production p) {
            if (this.runtime.test("optionVerbose")) {
                System.err.println("[Recognizing " + p.qName + " as lexical syntax]");
            }
            p.setProperty("lexical", Boolean.TRUE);
        }

        public void visit(Module m) {
            this.analyzer.register(this);
            this.analyzer.init(m);
            for (Production p : m.productions) {
                if (this.analyzer.isProcessed(p.qName)) continue;
                if (p.getBooleanProperty("textOnly")) {
                    this.mark(p);
                    this.analyzer.processed(p.qName);
                    continue;
                }
                if (!AST.isVoid(p.type)) {
                    this.analyzer.processed(p.qName);
                    continue;
                }
                this.isLexical = true;
                this.analyzer.process(p);
                if (this.isLexical) {
                    for (NonTerminal nt : this.analyzer.working()) {
                        FullProduction p2 = this.analyzer.lookup(nt);
                        this.mark(p2);
                        this.analyzer.processed(p2.qName);
                    }
                    continue;
                }
                this.analyzer.processed(p.qName);
            }
        }

        public void visit(Production p) {
            Object closure = this.analyzer.enter(p);
            this.analyzer.workingOn(p.qName);
            this.dispatch(p.choice);
            this.analyzer.exit(closure);
        }

        public void visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                this.dispatch(alt);
                if (this.isLexical) continue;
                return;
            }
        }

        public void visit(Sequence s) {
            for (Element e : s.elements) {
                this.dispatch(e);
                if (this.isLexical) continue;
                return;
            }
        }

        public void visit(SemanticPredicate p) {
        }

        public void visit(Binding b) {
            if ("yyValue".equals(b.name)) {
                this.isLexical = false;
            } else {
                this.dispatch(b.element);
            }
        }

        public void visit(NonTerminal nt) {
            FullProduction p;
            try {
                p = this.analyzer.lookup(nt);
            }
            catch (IllegalArgumentException x) {
                this.isLexical = false;
                return;
            }
            if (null == p) {
                this.isLexical = false;
            } else if (this.analyzer.isProcessed(p.qName)) {
                if (!p.getBooleanProperty("lexical")) {
                    this.isLexical = false;
                }
            } else if (!this.analyzer.isBeingWorkedOn(p.qName) && !p.getBooleanProperty("textOnly")) {
                if (AST.isVoid(p.type)) {
                    this.dispatch(p);
                } else {
                    this.isLexical = false;
                }
            }
        }

        public void visit(CharCase c) {
            this.dispatch(c.element);
        }

        public void visit(CharSwitch s) {
            for (CharCase kase : s.cases) {
                this.dispatch(kase);
                if (this.isLexical) continue;
                return;
            }
            this.dispatch(s.base);
        }

        public void visit(Terminal t) {
        }

        public void visit(UnaryOperator op) {
            this.dispatch(op.element);
        }

        public void visit(NullLiteral l) {
        }

        public void visit(NodeMarker m) {
            this.isLexical = false;
        }

        public void visit(Action a) {
            if (a.setsValue()) {
                this.isLexical = false;
            }
        }

        public void visit(ParserAction pa) {
            this.isLexical = false;
        }

        public void visit(Element e) {
            this.isLexical = false;
        }
    }
}

