/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.parser.Terminal;
import xtc.parser.UnaryOperator;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Runtime;

public class TextTester
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean isTextOnly;

    public TextTester(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    public void visit(Grammar g) {
        this.analyzer.register(this);
        this.analyzer.init(g);
        for (Module m : g.modules) {
            this.analyzer.process(m);
            for (Production p : m.productions) {
                if (!p.isFull() || this.analyzer.isProcessed(p.qName)) continue;
                if (!AST.isString(p.type)) {
                    this.analyzer.processed(p.qName);
                    continue;
                }
                this.isTextOnly = true;
                this.analyzer.process(p);
                if (this.isTextOnly) {
                    for (NonTerminal nt : this.analyzer.working()) {
                        FullProduction p2 = this.analyzer.lookupGlobally(nt);
                        TextTester.markTextOnly(p2, this.runtime.test("optionVerbose"));
                        this.analyzer.processed(p2.qName);
                    }
                    continue;
                }
                this.analyzer.processed(p.qName);
            }
        }
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            if (this.analyzer.isProcessed(p.qName)) continue;
            if (!AST.isString(p.type)) {
                this.analyzer.processed(p.qName);
                continue;
            }
            this.isTextOnly = true;
            this.analyzer.process(p);
            if (this.isTextOnly) {
                for (NonTerminal nt : this.analyzer.working()) {
                    FullProduction p2 = this.analyzer.lookup(nt);
                    TextTester.markTextOnly(p2, this.runtime.test("optionVerbose"));
                    this.analyzer.processed(p2.qName);
                }
                continue;
            }
            this.analyzer.processed(p.qName);
        }
    }

    public void visit(Production p) {
        Object closure = this.analyzer.enter(p);
        this.analyzer.workingOn(p.qName);
        this.dispatch(p.choice);
        this.analyzer.exit(closure);
    }

    public void visit(OrderedChoice c) {
        for (Sequence alt : c.alternatives) {
            this.dispatch(alt);
            if (this.isTextOnly) continue;
            return;
        }
    }

    public void visit(Sequence s) {
        for (Element e : s.elements) {
            this.dispatch(e);
            if (this.isTextOnly) continue;
            return;
        }
    }

    public void visit(Predicate p) {
    }

    public void visit(Binding b) {
        if ("yyValue".equals(b.name)) {
            this.isTextOnly = false;
        } else {
            this.dispatch(b.element);
        }
    }

    public void visit(NonTerminal nt) {
        FullProduction p;
        try {
            p = this.analyzer.lookup(nt);
        }
        catch (IllegalArgumentException x) {
            this.isTextOnly = false;
            return;
        }
        if (null == p) {
            this.isTextOnly = false;
        } else if (this.analyzer.isProcessed(p.qName)) {
            if (!p.getBooleanProperty("textOnly")) {
                this.isTextOnly = false;
            }
        } else if (!this.analyzer.isBeingWorkedOn(p.qName)) {
            if (AST.isString(p.type)) {
                this.dispatch(p);
            } else {
                this.isTextOnly = false;
            }
        }
    }

    public void visit(CharCase c) {
        this.dispatch(c.element);
    }

    public void visit(CharSwitch s) {
        for (CharCase kase : s.cases) {
            this.dispatch(kase);
            if (this.isTextOnly) continue;
            return;
        }
        this.dispatch(s.base);
    }

    public void visit(Terminal t) {
    }

    public void visit(UnaryOperator op) {
        this.dispatch(op.element);
    }

    public void visit(NullLiteral l) {
    }

    public void visit(NodeMarker m) {
        this.isTextOnly = false;
    }

    public void visit(Action a) {
        if (a.setsValue()) {
            this.isTextOnly = false;
        }
    }

    public void visit(ParserAction pa) {
        this.isTextOnly = false;
    }

    public void visit(Element e) {
        this.isTextOnly = false;
    }

    public static void markTextOnly(Production p, boolean verbose) {
        if (verbose) {
            System.err.println("[Recognizing " + p.qName + " as text-only]");
        }
        p.setProperty("textOnly", Boolean.TRUE);
    }
}

