/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import xtc.parser.Analyzer;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.Element;
import xtc.parser.GrammarVisitor;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.VoidedElement;
import xtc.type.AST;
import xtc.util.Runtime;

public class Simplifier
extends GrammarVisitor {
    public Simplifier(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    @Override
    public Element visit(OrderedChoice c) {
        boolean top = this.isTopLevel;
        this.isTopLevel = false;
        for (int i = 0; i < c.alternatives.size(); ++i) {
            this.needsSequence = true;
            Sequence s = (Sequence)this.dispatch(c.alternatives.get(i));
            if (1 == s.size() && s.get(0) instanceof OrderedChoice) {
                OrderedChoice c2 = (OrderedChoice)s.get(0);
                c.alternatives.remove(i);
                c.alternatives.addAll(i, c2.alternatives);
                i += c2.alternatives.size() - 1;
                continue;
            }
            c.alternatives.set(i, s);
        }
        this.needsSequence = false;
        if (!top && 1 == c.alternatives.size()) {
            return c.alternatives.get(0);
        }
        return c;
    }

    @Override
    public Element visit(Repetition r) {
        this.isTopLevel = false;
        this.needsSequence = true;
        Element e = (Element)this.dispatch(r.element);
        Element naked = Analyzer.strip(e);
        if (naked instanceof Repetition) {
            Repetition r2 = (Repetition)naked;
            r.once = r.once && r2.once;
            r.element = r2.element;
            return r;
        }
        if (naked instanceof Option) {
            r.once = false;
            r.element = ((Option)naked).element;
            return r;
        }
        r.element = e;
        return r;
    }

    @Override
    public Element visit(Option o) {
        this.isTopLevel = false;
        this.needsSequence = true;
        Element e = (Element)this.dispatch(o.element);
        Element naked = Analyzer.strip(e);
        if (naked instanceof Option) {
            o.element = ((Option)naked).element;
            return o;
        }
        if (naked instanceof Repetition) {
            ((Repetition)naked).once = false;
            naked.setLocation(o);
            return naked;
        }
        o.element = e;
        return o;
    }

    @Override
    public Element visit(Sequence s) {
        this.isTopLevel = false;
        boolean preserve = this.needsSequence;
        this.needsSequence = false;
        for (int i = 0; i < s.size(); ++i) {
            Element e = (Element)this.dispatch(s.get(i));
            if (e instanceof Sequence) {
                Sequence s2 = (Sequence)e;
                s.elements.remove(i);
                s.elements.addAll(i, s2.elements);
                i += s2.size() - 1;
                continue;
            }
            s.elements.set(i, e);
        }
        int size = s.size();
        for (int i = 0; i < size - 1; ++i) {
            CharClass c;
            Element e1 = s.get(i);
            Element e2 = s.get(i + 1);
            if (!(e1 instanceof NotFollowedBy) || !(e2 instanceof AnyChar)) continue;
            e1 = ((NotFollowedBy)e1).element;
            if (e1 instanceof CharClass) {
                c = (CharClass)e1;
                if (c.exclusive) continue;
                c.exclusive = true;
                s.elements.set(i, c);
                s.elements.remove(i + 1);
                --size;
                continue;
            }
            if (!(e1 instanceof CharLiteral)) continue;
            c = new CharClass(true, new ArrayList<CharRange>(1));
            c.ranges.add(new CharRange(((CharLiteral)e1).c));
            s.elements.set(i, c);
            s.elements.remove(i + 1);
            --size;
        }
        if (1 == s.size() && !preserve) {
            return s.get(0);
        }
        return s;
    }

    @Override
    public Element visit(VoidedElement v) {
        this.isTopLevel = false;
        this.needsSequence = false;
        v.element = Analyzer.strip((Element)this.dispatch(v.element));
        if (v.element instanceof NonTerminal && AST.isVoid(this.analyzer.lookup((NonTerminal)((NonTerminal)v.element)).type)) {
            return v.element;
        }
        if (v.element instanceof VoidedElement) {
            return v.element;
        }
        if (v.element instanceof Sequence) {
            OrderedChoice c = new OrderedChoice(new ArrayList<Sequence>(1));
            c.alternatives.add((Sequence)v.element);
            c.setLocation(v.element);
            v.element = c;
        }
        return v;
    }

    @Override
    public Element visit(Binding b) {
        this.isTopLevel = false;
        this.needsSequence = false;
        b.element = Analyzer.strip((Element)this.dispatch(b.element));
        if (b.element instanceof Sequence) {
            OrderedChoice c = new OrderedChoice(new ArrayList<Sequence>(1));
            c.alternatives.add((Sequence)b.element);
            c.setLocation(b.element);
            b.element = c;
        }
        return b;
    }

    @Override
    public Element visit(StringMatch m) {
        this.isTopLevel = false;
        this.needsSequence = false;
        m.element = Analyzer.strip((Element)this.dispatch(m.element));
        if (m.element instanceof Sequence) {
            OrderedChoice c = new OrderedChoice(new ArrayList<Sequence>(1));
            c.alternatives.add((Sequence)m.element);
            c.setLocation(m.element);
            m.element = c;
        } else if (m.element instanceof Repetition && !this.analyzer.current().isMemoized() && this.runtime.test("optimizeRepeated") || m.element instanceof Option && this.runtime.test("optimizeOptional")) {
            OrderedChoice c = new OrderedChoice(new ArrayList<Sequence>(1));
            c.alternatives.add(new Sequence(m.element));
            c.setLocation(m.element);
            m.element = c;
        }
        return m;
    }

    public Element visit(CharClass c) {
        this.isTopLevel = false;
        this.needsSequence = false;
        if (!c.exclusive && 1 == c.ranges.size()) {
            CharRange r = c.ranges.get(0);
            if (r.first == r.last) {
                CharLiteral cl = new CharLiteral(r.first);
                cl.setLocation(c);
                return cl;
            }
        }
        return c.normalize();
    }
}

