/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import xtc.parser.Element;
import xtc.parser.OrderedChoice;
import xtc.parser.SequenceName;

public class Sequence
extends Element {
    public SequenceName name;
    public List<Element> elements;

    public Sequence() {
        this(null, new ArrayList<Element>());
    }

    public Sequence(int capacity) {
        this(null, new ArrayList<Element>(capacity));
    }

    public Sequence(List<Element> elements) {
        this(null, elements);
    }

    public Sequence(SequenceName name, List<Element> elements) {
        this.name = name;
        this.elements = elements;
    }

    public Sequence(Element element) {
        if (element instanceof Sequence) {
            Sequence s = (Sequence)element;
            this.elements = new ArrayList<Element>(s.elements);
            this.name = s.name;
        } else {
            this.elements = new ArrayList<Element>(1);
            this.elements.add(element);
        }
        this.setLocation(element);
    }

    @Override
    public Element.Tag tag() {
        return Element.Tag.SEQUENCE;
    }

    public Sequence clear() {
        this.elements.clear();
        return this;
    }

    public Sequence add(Element e) {
        this.elements.add(e);
        return this;
    }

    public Sequence addAll(List<Element> l) {
        this.elements.addAll(l);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Element get(int idx) {
        return this.elements.get(idx);
    }

    public boolean hasTrailingChoice() {
        int size = this.elements.size();
        return 0 < size && this.elements.get(size - 1) instanceof OrderedChoice;
    }

    public Sequence subSequence(int start) {
        return this.subSequence(start, this.elements.size());
    }

    public Sequence subSequence(int start, int end) {
        Sequence s = new Sequence(new ArrayList<Element>(this.elements.subList(start, end)));
        s.setLocation(this);
        return s;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sequence)) {
            return false;
        }
        return this.elements.equals(((Sequence)o).elements);
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append('(');
        boolean first = true;
        for (Element e : this.elements) {
            if (first) {
                first = false;
            } else {
                out.append(' ');
            }
            e.write(out);
        }
        out.append(')');
    }

    public static Sequence ensure(Element e) {
        if (e instanceof Sequence) {
            return (Sequence)e;
        }
        Sequence s = new Sequence(e);
        s.setLocation(e);
        return s;
    }
}

