/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.Production;
import xtc.util.Runtime;

public class RootFinder
extends GrammarVisitor {
    protected Set<NonTerminal> topLevel = new HashSet<NonTerminal>();

    public RootFinder(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    @Override
    public Object visit(Module m) {
        if (m.hasProperty("root")) {
            return null;
        }
        this.analyzer.register(this);
        this.analyzer.init(m);
        this.topLevel.clear();
        for (Production p : m.productions) {
            if (!p.hasAttribute(Constants.ATT_PUBLIC)) continue;
            this.topLevel.add(p.qName);
        }
        if (1 == this.topLevel.size()) {
            m.setProperty("root", this.topLevel.toArray()[0]);
            return null;
        }
        for (NonTerminal nt : this.topLevel) {
            this.analyzer.unmarkAll();
            this.analyzer.mark(this.topLevel);
            this.analyzer.notWorkingOnAny();
            this.dispatch(nt);
            if (this.analyzer.hasMarked()) continue;
            if (this.runtime.test("optionVerbose")) {
                System.err.println("[Recognizing " + nt + " as real root]");
            }
            m.setProperty("root", nt);
            break;
        }
        return null;
    }

    public Element visit(NonTerminal nt) {
        FullProduction p = this.analyzer.lookup(nt);
        if (!this.analyzer.isBeingWorkedOn(p.qName)) {
            this.analyzer.workingOn(p.qName);
            this.analyzer.unmark(p.qName);
            this.dispatch(p);
        }
        return nt;
    }
}

