/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.AlternativeAddition;
import xtc.parser.AlternativeRemoval;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharClass;
import xtc.parser.CharRange;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.HtmlPrinter;
import xtc.parser.InternalElement;
import xtc.parser.LeftRecurser;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleImport;
import xtc.parser.ModuleMap;
import xtc.parser.ModuleModification;
import xtc.parser.ModuleName;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.PParser;
import xtc.parser.ParseException;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.PrettyPrinter;
import xtc.parser.Production;
import xtc.parser.ProductionOverride;
import xtc.parser.ReachabilityChecker;
import xtc.parser.Renamer;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SequenceName;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.TextTester;
import xtc.parser.UnaryOperator;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.ErrorT;
import xtc.type.Type;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class Resolver
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected int phase;
    protected Map<NonTerminal, NonTerminal> badNTs;
    protected boolean hasState;
    protected boolean isMofunctor;
    protected boolean isPredicate;
    protected Set<SequenceName> sequenceNames;
    private final Visitor checkRepetitionsVisitor = new Visitor(){

        public void visit(Repetition r) {
            this.dispatch(r.element);
            if (Resolver.this.analyzer.matchesEmpty(r.element) && !(Analyzer.strip(r.element) instanceof Action)) {
                Resolver.this.runtime.error("repeated element matches empty input", r);
            }
        }

        public void visit(Option o) {
            this.dispatch(o.element);
            if (!(Resolver.this.analyzer.restrictsInput(o.element) || Analyzer.strip(o.element) instanceof Action || Resolver.this.analyzer.grammar().modules.get(0).hasAttribute(Constants.ATT_NO_WARNINGS) || Resolver.this.analyzer.current().hasAttribute(Constants.ATT_NO_WARNINGS))) {
                Resolver.this.runtime.warning("optional element already matches empty input", o);
            }
        }

        public void visit(Production p) {
            this.dispatch(p.choice);
        }

        public void visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                this.dispatch(alt);
            }
        }

        public void visit(Sequence s) {
            for (Element e : s.elements) {
                this.dispatch(e);
            }
        }

        public void visit(UnaryOperator op) {
            this.dispatch(op.element);
        }

        public void visit(Element e) {
        }
    };
    private final Visitor checkExplicitVisitor = new Visitor(){

        public void visit(Production p) {
            if (p.hasAttribute(Constants.ATT_EXPLICIT) && Resolver.this.analyzer.matchesEmpty(p.choice)) {
                Resolver.this.runtime.error("explicit production matches empty input", p);
            }
        }
    };

    public Resolver(Runtime runtime, Analyzer analyzer, AST ast) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = ast;
        this.badNTs = new IdentityHashMap<NonTerminal, NonTerminal>();
        this.sequenceNames = new HashSet<SequenceName>();
    }

    protected void signature(Module m) {
        System.out.print("module ");
        System.out.print(m.name.name);
        if (m.name.hasProperty("xtc.Constants.Original") || null != m.parameters) {
            System.out.print(" = ");
            ModuleName base = m.name.hasProperty("xtc.Constants.Original") ? (ModuleName)m.name.getProperty("xtc.Constants.Original") : m.name;
            System.out.print(base.name);
            if (null == m.parameters) {
                System.out.print("()");
            } else {
                System.out.print(m.parameters.toString());
            }
        }
        if (null != m.dependencies) {
            for (ModuleDependency dep : m.dependencies) {
                if (!dep.isModification()) continue;
                System.out.println();
                System.out.print("       modifies ");
                System.out.print(dep.visibleName().name);
                break;
            }
            boolean first = true;
            for (ModuleDependency dep : m.dependencies) {
                if (!dep.isImport()) continue;
                if (first) {
                    System.out.println();
                    System.out.print("       imports ");
                    first = false;
                } else {
                    System.out.println(',');
                    System.out.print("               ");
                }
                System.out.print(dep.visibleName().name);
            }
        }
        System.out.println(';');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Module load(String name) throws IOException, ParseException {
        File file = this.runtime.locate(Utilities.toPath(name, "rats"));
        if (!file.exists()) {
            throw new FileNotFoundException(file + ": file not found");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + ": not a file");
        }
        if (Integer.MAX_VALUE < file.length()) {
            throw new IllegalArgumentException(file + ": file too large");
        }
        Reader in = null;
        try {
            in = this.runtime.getReader(file);
            PParser parser = new PParser(in, file.toString(), (int)file.length());
            Module module = (Module)parser.value(parser.pModule(0));
            return module;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException x) {}
            }
        }
    }

    protected void rename(Module module, ModuleMap renaming) {
        module.name = module.name.rename(renaming);
        if (null != module.parameters) {
            module.parameters.rename(renaming);
        }
        if (null != module.dependencies) {
            for (ModuleDependency dep : module.dependencies) {
                dep.rename(renaming);
            }
        }
        Renamer renamer = new Renamer(this.runtime, this.analyzer, renaming);
        for (Production p : module.productions) {
            if (null != p.qName) {
                p.qName = p.qName.rename(renaming);
            }
            renamer.dispatch(p);
        }
    }

    protected Production strip(Production p) {
        if (null != p && null != p.choice) {
            p.choice = Analyzer.stripChoices(p.choice);
        }
        return p;
    }

    protected void apply(AlternativeAddition p1, FullProduction p2) {
        int length2 = p2.choice.alternatives.size();
        int index = -1;
        for (int i = 0; i < length2; ++i) {
            if (!p1.sequence.equals(p2.choice.alternatives.get((int)i).name)) continue;
            index = i;
            break;
        }
        if (-1 == index) {
            StringBuilder buf = new StringBuilder();
            buf.append("unable to add new alternative");
            if (1 != p1.choice.alternatives.size()) {
                buf.append('s');
            }
            if (p1.isBefore) {
                buf.append(" before ");
            } else {
                buf.append(" after ");
            }
            buf.append("non-existent alternative '");
            buf.append(p1.sequence.name);
            buf.append("'");
            this.runtime.error(buf.toString(), p1.sequence);
        } else {
            if (!p1.isBefore) {
                ++index;
            }
            p2.choice.alternatives.addAll(index, p1.choice.alternatives);
        }
    }

    protected void apply(AlternativeRemoval p1, FullProduction p2) {
        for (SequenceName name : p1.sequences) {
            boolean removed = false;
            Iterator<Sequence> iter = p2.choice.alternatives.iterator();
            while (iter.hasNext()) {
                if (!name.equals(iter.next().name)) continue;
                iter.remove();
                removed = true;
                break;
            }
            if (removed) continue;
            this.runtime.error("unable to remove non-existent alternative '" + name + "'", name);
        }
    }

    protected void apply(ProductionOverride p1, FullProduction p2) {
        if (null != p1.attributes) {
            p2.attributes = p1.attributes;
        }
        if (null != p1.choice) {
            if (p1.isComplete) {
                p2.choice = p1.choice;
            } else {
                for (Sequence s1 : p1.choice.alternatives) {
                    if (null == s1.name) {
                        this.runtime.error("overriding sequence without name", s1);
                        continue;
                    }
                    int length2 = p2.choice.alternatives.size();
                    boolean changed = false;
                    for (int i = 0; i < length2; ++i) {
                        Sequence s2 = p2.choice.alternatives.get(i);
                        if (!s1.name.equals(s2.name)) continue;
                        p2.choice.alternatives.set(i, s1);
                        changed = true;
                        break;
                    }
                    if (changed) continue;
                    this.runtime.error("unable to override non-existent alternative '" + s1.name + "'", s1);
                }
            }
        }
    }

    protected Grammar load(Module m) {
        if (null != m.parameters && 0 < m.parameters.size()) {
            this.runtime.error("parameterized top-level module '" + m.name.name + "'", m.name);
            return null;
        }
        PrettyPrinter pp = null;
        if (this.runtime.test("optionLoaded")) {
            pp = new PrettyPrinter(this.runtime.console(), this.ast, true);
            pp.dispatch(m);
            pp.flush();
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        HashMap<String, Module> moduleMap = new HashMap<String, Module>();
        HashMap<ModuleName, ModuleDependency> loaded = new HashMap<ModuleName, ModuleDependency>();
        IdentityHashMap<ModuleDependency, Boolean> conflicts = new IdentityHashMap<ModuleDependency, Boolean>();
        modules.add(m);
        moduleMap.put(m.name.name, m);
        loaded.put(m.name, new ModuleImport(m.name));
        ArrayList<ModuleDependency> workList = new ArrayList<ModuleDependency>();
        if (null != m.dependencies) {
            for (ModuleDependency dep : m.dependencies) {
                if (dep.isModification()) {
                    boolean process = true;
                    if (null != m.modification) {
                        this.runtime.error("duplicate modifies declaration", dep);
                        process = false;
                    }
                    if (dep.visibleName().equals(m.name)) {
                        this.runtime.error("module '" + m.name + "' modifies itself", dep);
                        process = false;
                    }
                    if (!process) continue;
                    m.modification = (ModuleModification)dep;
                    workList.add(dep);
                    continue;
                }
                workList.add(dep);
            }
        }
        if (this.runtime.test("optionDependencies")) {
            this.signature(m);
        }
        while (!workList.isEmpty()) {
            StringBuilder buf;
            int parameterNumber;
            ModuleDependency dep = (ModuleDependency)workList.remove(0);
            if (loaded.containsKey(dep.visibleName())) {
                ModuleDependency dep2 = (ModuleDependency)loaded.get(dep.visibleName());
                if (dep.isConsistentWith(dep2)) continue;
                if (!conflicts.containsKey(dep2)) {
                    conflicts.put(dep2, Boolean.TRUE);
                    this.runtime.error("inconsistent instantiation of module '" + dep2.module + dep2.arguments + "' as '" + dep2.visibleName() + "'", dep2);
                }
                this.runtime.error("inconsistent instantiation of module '" + dep.module + dep.arguments + "' as '" + dep.visibleName() + "'", dep);
                continue;
            }
            if (this.runtime.test("optionVerbose")) {
                String path = Utilities.toPath(dep.module.name, "rats");
                File file = null;
                try {
                    file = this.runtime.locate(path);
                }
                catch (Exception x) {
                    // empty catch block
                }
                if (null == file) {
                    System.err.println("[Loading module " + dep.module + "]");
                } else {
                    System.err.println("[Loading module " + dep.module + " from " + file + "]");
                }
            }
            Module m2 = null;
            try {
                m2 = this.load(dep.module.name);
            }
            catch (IllegalArgumentException x) {
                this.runtime.error(x.getMessage(), dep);
            }
            catch (FileNotFoundException x) {
                this.runtime.error(x.getMessage(), dep);
            }
            catch (IOException x) {
                if (null == x.getMessage()) {
                    this.runtime.error("I/O error while accessing corresponding file", dep);
                } else {
                    this.runtime.error(x.getMessage(), dep);
                }
            }
            catch (ParseException x) {
                System.err.print(x.getMessage());
                this.runtime.error();
            }
            loaded.put(dep.visibleName(), dep);
            if (null == m2) continue;
            if (this.runtime.test("optionLoaded")) {
                pp.dispatch(m2);
                pp.flush();
            }
            boolean moduleError = false;
            if (!dep.module.equals(m2.name)) {
                String path = Utilities.toPath(dep.module.name, "rats");
                File file = null;
                try {
                    file = this.runtime.locate(path);
                }
                catch (Exception x) {
                    // empty catch block
                }
                if (null == file) {
                    this.runtime.error("module name '" + m2.name + "' inconsistent with file name", m2.name);
                    moduleError = true;
                } else {
                    this.runtime.error("module name '" + m2.name + "' inconsistent with file name " + file, m2.name);
                    moduleError = true;
                }
            }
            if (null != m2.parameters) {
                int size = m2.parameters.size();
                block11: for (int i = 0; i < size; ++i) {
                    ModuleName name = m2.parameters.get(i);
                    if (m2.name.equals(name)) {
                        this.runtime.error("module parameter '" + name + "' same as module name", name);
                        moduleError = true;
                    }
                    for (int j = 0; j < i; ++j) {
                        if (!name.equals(m2.parameters.get(j))) continue;
                        this.runtime.error("duplicate module parameter '" + name + "'", name);
                        moduleError = true;
                        continue block11;
                    }
                }
            }
            int argumentNumber = dep.arguments.size();
            int n = parameterNumber = null != m2.parameters ? m2.parameters.size() : 0;
            if (argumentNumber != parameterNumber) {
                buf = new StringBuilder();
                buf.append(argumentNumber);
                buf.append(" argument");
                if (1 != argumentNumber) {
                    buf.append('s');
                }
                buf.append(" for module '");
                buf.append(m2.name.name);
                buf.append("' with ");
                buf.append(parameterNumber);
                buf.append(" parameter");
                if (1 != parameterNumber) {
                    buf.append('s');
                }
                this.runtime.error(buf.toString(), dep);
                moduleError = true;
            }
            if (moduleError) continue;
            if (0 != argumentNumber || !dep.module.equals(dep.visibleName())) {
                if (this.runtime.test("optionVerbose")) {
                    buf = new StringBuilder();
                    buf.append("[Instantiating module ");
                    buf.append(m2.name);
                    buf.append('(');
                    for (int i = 0; i < argumentNumber; ++i) {
                        buf.append(dep.arguments.get((int)i).name);
                        buf.append('/');
                        buf.append(m2.parameters.get((int)i).name);
                        if (i + 1 >= argumentNumber) continue;
                        buf.append(", ");
                    }
                    buf.append(") as ");
                    buf.append(dep.visibleName().name);
                    buf.append(']');
                    System.err.println(buf.toString());
                }
                ModuleMap renaming = 0 != argumentNumber ? new ModuleMap(m2.parameters, dep.arguments) : new ModuleMap();
                if (!dep.module.equals(dep.visibleName())) {
                    renaming.put(dep.module, dep.visibleName());
                }
                this.rename(m2, renaming);
            }
            modules.add(m2);
            moduleMap.put(m2.name.name, m2);
            if (null != m2.dependencies) {
                for (ModuleDependency dep2 : m2.dependencies) {
                    if (dep2.isModification()) {
                        boolean process = true;
                        if (null != m2.modification) {
                            this.runtime.error("duplicate modifies declaration", dep2);
                            process = false;
                        }
                        if (dep2.visibleName().equals(m2.name)) {
                            this.runtime.error("module '" + m2.name + "' modifies itself", dep2);
                            process = false;
                        }
                        if (!process) continue;
                        m2.modification = (ModuleModification)dep2;
                        workList.add(dep2);
                        continue;
                    }
                    workList.add(dep2);
                }
            }
            if (this.runtime.test("optionDependencies")) {
                this.signature(m2);
            }
            if (null == m2.parameters) continue;
            m2.setProperty("xtc.Constants.Arguments", m2.parameters);
            m2.parameters = null;
        }
        HashMap<ModuleName, Boolean> checking = new HashMap<ModuleName, Boolean>();
        HashSet<ModuleName> checked = new HashSet<ModuleName>();
        for (Module m2 : modules) {
            if (checked.contains(m2.name)) continue;
            checking.clear();
            do {
                if (checking.containsKey(m2.name)) {
                    boolean circular = (Boolean)checking.get(m2.name);
                    if (circular) break;
                    checking.put(m2.name, Boolean.TRUE);
                    continue;
                }
                checking.put(m2.name, Boolean.FALSE);
            } while (null != m2.modification && null != (m2 = (Module)moduleMap.get(m2.modification.visibleName().name)));
            for (Module m3 : modules) {
                if (!checking.containsKey(m3.name)) continue;
                checked.add(m3.name);
                if (!((Boolean)checking.get(m3.name)).booleanValue()) continue;
                this.runtime.error("circular modifies dependency", m3.modification);
            }
        }
        Grammar g = new Grammar(modules);
        if (this.runtime.test("optionInstantiated")) {
            if (this.runtime.test("optionHtml")) {
                new HtmlPrinter(this.runtime, this.analyzer, this.ast, false).dispatch(g);
            } else {
                pp = new PrettyPrinter(this.runtime.console(), this.ast, true);
                pp.dispatch(g);
                pp.flush();
            }
        }
        return this.runtime.seenError() ? null : g;
    }

    protected List<Attribute> check(Grammar g) {
        this.analyzer.register(this);
        this.analyzer.init(g);
        this.phase = 1;
        Module root = g.modules.get(0);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String stateName = null;
        boolean stateError = false;
        for (Module m2 : g.modules) {
            Attribute state;
            Object value;
            if (m2.hasAttribute(Constants.ATT_STATEFUL.getName()) && null != (value = (state = Attribute.get(Constants.ATT_STATEFUL.getName(), m2.attributes)).getValue()) && value instanceof String && !((String)value).startsWith("\"")) {
                if (null == stateName) {
                    attributes.add(state);
                    stateName = (String)state.getValue();
                }
                if (!stateName.equals(state.getValue())) {
                    stateError = true;
                }
            }
            if (!m2.hasAttribute("setOfString") && !m2.hasAttribute("flag")) continue;
            for (Attribute att : m2.attributes) {
                String name = att.getName();
                if (!"setOfString".equals(name) && !"flag".equals(name) || attributes.contains(att)) continue;
                attributes.add(att);
            }
        }
        HashSet<ModuleName> visited = new HashSet<ModuleName>();
        boolean hasTopLevel = false;
        for (Module m2 : g.modules) {
            this.analyzer.process(m2);
            this.hasState = false;
            boolean bl = this.isMofunctor = null != m2.modification;
            if (null != m2.attributes) {
                int length = m2.attributes.size();
                for (int i = 0; i < length; ++i) {
                    Attribute att = m2.attributes.get(i);
                    String name = att.getName();
                    Object value = att.getValue();
                    if (!(Constants.ATT_WITH_LOCATION.equals(att) || Constants.ATT_CONSTANT.equals(att) || Constants.ATT_RAW_TYPES.equals(att) || Constants.ATT_VERBOSE.equals(att) || Constants.ATT_NO_WARNINGS.equals(att) || Constants.ATT_IGNORING_CASE.equals(att) || Constants.ATT_STATEFUL.getName().equals(name) || "parser".equals(name) || "main".equals(name) || "printer".equals(name) || "visibility".equals(name) || "setOfString".equals(name) || "flag".equals(name) || "factory".equals(name) || Constants.ATT_FLATTEN.equals(att) || Constants.ATT_GENERIC_AS_VOID.equals(att) || Constants.ATT_PARSE_TREE.equals(att) || Constants.ATT_PROFILE.equals(att) || Constants.ATT_DUMP.equals(att))) {
                        this.runtime.error("unrecognized grammar-wide attribute '" + att + "'", att);
                    } else {
                        for (int j = 0; j < i; ++j) {
                            Attribute att2 = m2.attributes.get(j);
                            if (name.equals("setOfString") || name.equals("flag")) {
                                if (att.equals(att2)) {
                                    this.runtime.error("duplicate attribute '" + att + "'", att);
                                    break;
                                }
                                if (null == value || !value.equals(att2.getValue())) continue;
                                this.runtime.error("duplicate field name '" + att + "'", att);
                                continue;
                            }
                            if (!name.equals(att2.getName())) continue;
                            this.runtime.error("duplicate attribute '" + name + "'", att);
                            break;
                        }
                    }
                    if (Constants.ATT_STATEFUL.getName().equals(name)) {
                        if (null == value) {
                            this.runtime.error("stateful attribute without class name", att);
                        } else if (!(value instanceof String)) {
                            this.runtime.error("stateful attribute with invalid value", att);
                        } else if (((String)value).startsWith("\"")) {
                            this.runtime.error("stateful attribute with invalid value", att);
                        } else if (stateError) {
                            this.runtime.error("inconsistent state class across modules", att);
                        }
                        this.hasState = true;
                        continue;
                    }
                    if ("parser".equals(name)) {
                        if (null == value) {
                            this.runtime.error("parser attribute without class name", att);
                            continue;
                        }
                        if (!(value instanceof String)) {
                            this.runtime.error("parser attribute with invalid value", att);
                            continue;
                        }
                        if (!((String)value).startsWith("\"")) continue;
                        this.runtime.error("parser attribute with invalid value", att);
                        continue;
                    }
                    if ("main".equals(name)) {
                        if (this.runtime.test("optionLGPL")) {
                            this.runtime.error("main attribute incompatible with LGPL", att);
                            continue;
                        }
                        if (null == value) {
                            this.runtime.error("main attribute without nonterminal value", att);
                            continue;
                        }
                        if (!(value instanceof String)) {
                            this.runtime.error("main attribute with invalid value", att);
                            continue;
                        }
                        if (((String)value).startsWith("\"")) {
                            this.runtime.error("main attribute with invalid value", att);
                            continue;
                        }
                        NonTerminal nt = new NonTerminal((String)value);
                        FullProduction p = null;
                        boolean err = false;
                        try {
                            p = this.analyzer.lookup(nt);
                        }
                        catch (IllegalArgumentException x) {
                            this.runtime.error("main attribute with ambiguous nonterminal '" + nt + "'", att);
                            err = true;
                        }
                        if (err) continue;
                        if (null == p) {
                            this.runtime.error("main attribute with undefined nonterminal '" + nt + "'", att);
                            continue;
                        }
                        if (!this.analyzer.isDefined(p, m2)) {
                            this.runtime.error("main attribute with another module's nonterminal '" + nt + "'", att);
                            continue;
                        }
                        if (p.hasAttribute(Constants.ATT_PUBLIC)) continue;
                        this.runtime.error("main attribute with non-public nonterminal '" + nt + "'", att);
                        continue;
                    }
                    if ("printer".equals(name)) {
                        if (this.runtime.test("optionLGPL")) {
                            this.runtime.error("printer attribute incompatible with LGPL", att);
                        } else if (null == value) {
                            this.runtime.error("printer attribute without class name", att);
                        } else if (!(value instanceof String)) {
                            this.runtime.error("printer attribute with invalid value", att);
                        } else if (((String)value).startsWith("\"")) {
                            this.runtime.error("printer attribute with invalid value", att);
                        }
                        if (m2.hasAttribute("main")) continue;
                        this.runtime.error("printer attribute without main attribute", att);
                        continue;
                    }
                    if ("visibility".equals(name)) {
                        if (null == value) {
                            this.runtime.error("visibility attribute without value", att);
                            continue;
                        }
                        if (Constants.ATT_PUBLIC.getValue().equals(value) || Constants.ATT_PACKAGE_PRIVATE.getValue().equals(value)) continue;
                        this.runtime.error("visibility attribute with invalid value", att);
                        continue;
                    }
                    if ("setOfString".equals(name)) {
                        if (null == value) {
                            this.runtime.error("string set attribute without set value", att);
                            continue;
                        }
                        if (!(value instanceof String)) {
                            this.runtime.error("string set attribute with invalid value", att);
                            continue;
                        }
                        if (!((String)value).startsWith("\"")) continue;
                        this.runtime.error("string set attribute with invalid value", att);
                        continue;
                    }
                    if ("flag".equals(name)) {
                        if (null == value) {
                            this.runtime.error("flag attribute without flag value", att);
                            continue;
                        }
                        if (!(value instanceof String)) {
                            this.runtime.error("flag attribute with invalid value", att);
                            continue;
                        }
                        if (!((String)value).startsWith("\"")) continue;
                        this.runtime.error("flag attribute with invalid value", att);
                        continue;
                    }
                    if ("factory".equals(name)) {
                        if (null == value) {
                            this.runtime.error("factory attribute without class name", att);
                            continue;
                        }
                        if (!(value instanceof String)) {
                            this.runtime.error("factory attribute with invalid value", att);
                            continue;
                        }
                        if (!((String)value).startsWith("\"")) continue;
                        this.runtime.error("factory attribute with invalud value", att);
                        continue;
                    }
                    if (Constants.ATT_GENERIC_AS_VOID.equals(att)) {
                        if (!m2.hasAttribute(Constants.ATT_PARSE_TREE)) continue;
                        this.runtime.error("genericAsVoid attribute incompatible with withParseTree attribute", att);
                        continue;
                    }
                    if (Constants.ATT_DUMP.equals(att)) {
                        if (!this.runtime.test("optionLGPL")) continue;
                        this.runtime.error("dump attribute incompatible with LGPL", att);
                        continue;
                    }
                    if (!Constants.ATT_RAW_TYPES.equals(att)) continue;
                    this.runtime.warning("the rawTypes attribute has been deprecated", att);
                    this.runtime.errConsole().loc(att).pln(": warning: and will be removed in a future release").flush();
                }
            }
            if (!this.hasState) {
                this.hasState = this.analyzer.hasAttribute(m2, Constants.ATT_STATEFUL.getName(), visited);
                visited.clear();
            }
            for (Production p : m2.productions) {
                this.sequenceNames.clear();
                this.analyzer.process(p);
                try {
                    if (!p.isPartial() && p != this.analyzer.lookup(p.name)) {
                        this.runtime.error("duplicate definition for nonterminal '" + p.name + "'", p);
                    }
                }
                catch (IllegalArgumentException x) {
                    this.runtime.error("duplicate definition for nonterminal '" + p.name + "'", p);
                }
                if (!p.hasAttribute(Constants.ATT_PUBLIC)) continue;
                if (this.analyzer.isDefined(p, root)) {
                    hasTopLevel = true;
                    continue;
                }
                p.attributes.remove(Constants.ATT_PUBLIC);
            }
        }
        if (!hasTopLevel) {
            this.runtime.error("no public nonterminal", g.modules.get((int)0).productions.get(0));
        }
        return attributes;
    }

    protected void applyModifications(Grammar g) {
        this.analyzer.register(this);
        this.analyzer.init(g);
        this.phase = 2;
        Module root = g.modules.get(0);
        HashSet<ModuleName> imports = new HashSet<ModuleName>();
        HashMap<ModuleName, Boolean> modified = new HashMap<ModuleName, Boolean>();
        imports.add(root.name);
        this.analyzer.trace(root, imports, modified);
        Iterator<Module> iter = g.modules.iterator();
        while (iter.hasNext()) {
            Module m = iter.next();
            if (imports.contains(m.name) || modified.containsKey(m.name)) continue;
            if (this.runtime.test("optionVerbose")) {
                System.err.println("[Unloading unused module " + m.name + "]");
            }
            this.analyzer.remove(m);
            iter.remove();
        }
        if (0 != modified.size()) {
            ArrayList<Module> mofunctors = new ArrayList<Module>();
            HashSet<Module> erroneous = new HashSet<Module>();
            HashSet<Module> checked = new HashSet<Module>();
            HashMap<NonTerminal, Production> targetProductions = new HashMap<NonTerminal, Production>();
            HashMap<NonTerminal, Production> productions = new HashMap<NonTerminal, Production>();
            while (true) {
                mofunctors.clear();
                Module base = null;
                for (Module m : g.modules) {
                    if (null == m.modification || erroneous.contains(m)) continue;
                    do {
                        mofunctors.add(m);
                        m = this.analyzer.lookup(m.modification.visibleName());
                    } while (null != m.modification);
                    base = m;
                    if (!erroneous.contains(base)) break;
                    erroneous.addAll(mofunctors);
                    base = null;
                    break;
                }
                if (null == base) break;
                Module target = base;
                for (int i = mofunctors.size() - 1; i >= 0; --i) {
                    Module source = (Module)mofunctors.get(i);
                    if (this.runtime.test("optionVerbose")) {
                        System.err.println("[Applying module " + source.name + " to module " + target.name + "]");
                    }
                    if (((Boolean)modified.get(target.name)).booleanValue() || modified.containsKey(target.name) && imports.contains(target.name)) {
                        if (this.runtime.test("optionVerbose")) {
                            System.err.println("[Copying modified module " + target.name + "]");
                        }
                        target = this.analyzer.copy(target);
                    } else {
                        if (this.runtime.test("optionVerbose")) {
                            System.err.println("[Removing modified module " + target.name + "]");
                        }
                        this.analyzer.remove(target);
                        g.remove(target);
                    }
                    if (this.runtime.test("optionVerbose")) {
                        System.err.println("[Removing modifying module " + source.name + "]");
                    }
                    this.analyzer.remove(source);
                    g.replace(source, target);
                    this.rename(target, new ModuleMap(target.name, source.name));
                    target.documentation = source.documentation;
                    target.name = source.name;
                    target.removeProperty("xtc.Constants.Arguments");
                    if (source.hasProperty("xtc.Constants.Arguments")) {
                        target.setProperty("xtc.Constants.Arguments", source.getProperty("xtc.Constants.Arguments"));
                    }
                    Iterator<ModuleDependency> iter2 = source.dependencies.iterator();
                    while (iter2.hasNext()) {
                        if (!iter2.next().isModification()) continue;
                        iter2.remove();
                    }
                    if (null == target.dependencies) {
                        target.dependencies = source.dependencies;
                    } else {
                        target.dependencies.addAll(source.dependencies);
                    }
                    if (null != source.header) {
                        if (null == target.header) {
                            target.header = source.header;
                        } else {
                            target.header.add(source.header);
                        }
                    }
                    if (null != source.body) {
                        if (null == target.body) {
                            target.body = source.body;
                        } else {
                            target.body.add(source.body);
                        }
                    }
                    if (null != source.footer) {
                        if (null == target.footer) {
                            target.footer = source.footer;
                        } else {
                            target.footer.add(source.footer);
                        }
                    }
                    if (null != target.attributes) {
                        if (target.hasAttribute(Constants.ATT_STATEFUL.getName())) {
                            if (null == source.attributes) {
                                source.attributes = new ArrayList<Attribute>();
                            }
                            if (!source.hasAttribute(Constants.ATT_STATEFUL.getName())) {
                                source.attributes.add(Attribute.get(Constants.ATT_STATEFUL.getName(), target.attributes));
                            }
                        }
                        if (target.hasAttribute("setOfString") || target.hasAttribute("flag")) {
                            if (null == source.attributes) {
                                source.attributes = new ArrayList<Attribute>();
                            }
                            for (Attribute att : target.attributes) {
                                String name = att.getName();
                                if (!"setOfString".equals(name) && !"flag".equals(name) || source.attributes.contains(att)) continue;
                                source.attributes.add(att);
                            }
                        }
                    }
                    target.attributes = source.attributes;
                    targetProductions.clear();
                    productions.clear();
                    for (Production p : target.productions) {
                        if (!(p = this.strip(p)).isFull() || productions.containsKey(p.name)) continue;
                        targetProductions.put(p.name, p);
                        productions.put(p.name, p);
                    }
                    for (Production p : source.productions) {
                        if (!(p = this.strip(p)).isFull() || productions.containsKey(p.name)) continue;
                        productions.put(p.name, p);
                    }
                    int errorCount = this.runtime.errorCount();
                    for (Production p1 : source.productions) {
                        FullProduction p2 = (FullProduction)productions.get(p1.name);
                        if (p1.isFull()) {
                            if (targetProductions.containsKey(p1.name)) continue;
                            target.productions.add(p1);
                            targetProductions.put(p1.name, p1);
                            continue;
                        }
                        if (null == p2) continue;
                        if (p1.isAddition()) {
                            this.apply((AlternativeAddition)p1, p2);
                            continue;
                        }
                        if (p1.isRemoval()) {
                            this.apply((AlternativeRemoval)p1, p2);
                            continue;
                        }
                        if (p1.isOverride()) {
                            this.apply((ProductionOverride)p1, p2);
                            continue;
                        }
                        throw new AssertionError((Object)("Unrecognized production " + p1));
                    }
                    if (this.runtime.test("optionVerbose")) {
                        System.err.println("[Adding resulting module " + target.name + "]");
                    }
                    this.analyzer.add(target);
                    checked.add(target);
                    this.analyzer.process(target);
                    for (Production p : target.productions) {
                        this.sequenceNames.clear();
                        this.analyzer.process(p);
                    }
                    if (this.runtime.errorCount() == errorCount) continue;
                    erroneous.add(target);
                    List l = mofunctors.subList(0, i);
                    erroneous.addAll(l);
                    checked.addAll(l);
                }
                root = g.modules.get(0);
                imports.clear();
                modified.clear();
                imports.add(root.name);
                this.analyzer.trace(root, imports, modified);
            }
            this.phase = 3;
            for (Module m : g.modules) {
                if (checked.contains(m)) continue;
                this.analyzer.process(m);
                for (Production p : m.productions) {
                    this.analyzer.process(p);
                }
            }
        }
        if (this.runtime.test("optionApplied")) {
            if (this.runtime.test("optionHtml")) {
                new HtmlPrinter(this.runtime, this.analyzer, this.ast, false).dispatch(g);
            } else {
                PrettyPrinter pp = new PrettyPrinter(this.runtime.console(), this.ast, true);
                pp.dispatch(g);
                pp.flush();
            }
        }
    }

    protected void internTypes(Grammar g) {
        boolean hasNode = false;
        boolean hasToken = false;
        boolean hasFormatting = false;
        boolean hasAction = false;
        if (g.modules.get(0).hasAttribute(Constants.ATT_PARSE_TREE)) {
            hasToken = true;
            hasFormatting = true;
        }
        for (Module m : g.modules) {
            for (Production p : m.productions) {
                if (!this.ast.isGenericNode(p.dType)) continue;
                hasNode = true;
                for (Sequence s : p.choice.alternatives) {
                    Element first;
                    Element element = first = s.isEmpty() ? null : Analyzer.stripAndUnbind(s.get(0));
                    if (!p.name.equals(first) && !p.qName.equals(first)) continue;
                    hasAction = true;
                }
            }
        }
        if (!g.modules.get(0).hasAttribute(Constants.ATT_GENERIC_AS_VOID)) {
            if (hasNode) {
                g.modules.get(0).setProperty("generic", Boolean.TRUE);
            }
            if (hasAction) {
                g.modules.get(0).setProperty("recursive", Boolean.TRUE);
            }
        }
        this.ast.initialize(hasNode, hasToken, hasFormatting, hasAction);
        for (Module m : g.modules) {
            for (Production p : m.productions) {
                Type t;
                try {
                    t = this.ast.intern(p.dType);
                }
                catch (IllegalArgumentException x) {
                    this.runtime.error(x.getMessage() + " for production '" + p.name + "'", p);
                    t = ErrorT.TYPE;
                }
                p.type = t;
            }
        }
        for (Module m : g.modules) {
            for (Production p : m.productions) {
                if (!p.hasAttribute(Constants.ATT_VARIANT)) continue;
                if (AST.isToken(p.type)) {
                    this.runtime.error("variant production for token type", p);
                    continue;
                }
                if (AST.isNode(p.type)) continue;
                this.runtime.error("variant production without node type", p);
            }
        }
    }

    protected void checkRecursions(Grammar g) {
        new TextTester(this.runtime, this.analyzer).dispatch(g);
        LeftRecurser recurser = new LeftRecurser(this.runtime, this.analyzer);
        recurser.dispatch(g);
        Set<NonTerminal> recursive = recurser.recursive();
        for (Module m : g.modules) {
            for (Production p : m.productions) {
                if (!recursive.contains(p.qName)) continue;
                this.runtime.error("left-recursive definition for nonterminal '" + p.name + "'", p);
            }
        }
    }

    protected void checkRepetitions(Grammar g) {
        this.analyzer.register(this.checkRepetitionsVisitor);
        this.analyzer.init(g);
        for (Module m : g.modules) {
            this.analyzer.process(m);
            for (Production p : m.productions) {
                if (!p.isFull()) continue;
                this.analyzer.process(p);
            }
        }
    }

    protected void checkExplicit(Grammar g) {
        this.analyzer.register(this.checkExplicitVisitor);
        this.analyzer.init(g);
        for (Module m : g.modules) {
            this.analyzer.process(m);
            for (Production p : m.productions) {
                if (!p.isFull()) continue;
                this.analyzer.process(p);
            }
        }
    }

    protected Module combine(Grammar g, List<Attribute> attributes) {
        Module m = g.modules.get(0);
        m.dependencies = null;
        m.modification = null;
        if (0 < attributes.size()) {
            if (null == m.attributes) {
                m.attributes = attributes;
            } else {
                for (Attribute att : attributes) {
                    if (m.attributes.contains(att)) continue;
                    m.attributes.add(att);
                }
            }
        }
        ArrayList<Action> headers = new ArrayList<Action>();
        ArrayList<Action> bodies = new ArrayList<Action>();
        ArrayList<Action> footers = new ArrayList<Action>();
        for (Module m2 : g.modules) {
            if (null != m2.header && !headers.contains(m2.header)) {
                headers.add(m2.header);
            }
            if (null != m2.body && !bodies.contains(m2.body)) {
                bodies.add(m2.body);
            }
            if (null == m2.footer || footers.contains(m2.footer)) continue;
            footers.add(m2.footer);
        }
        m.header = null;
        for (Action a : headers) {
            if (null == m.header) {
                m.header = a;
                continue;
            }
            m.header.add(a);
        }
        m.body = null;
        for (Action a : bodies) {
            if (null == m.body) {
                m.body = a;
                continue;
            }
            m.body.add(a);
        }
        m.footer = null;
        for (Action a : footers) {
            if (null == m.footer) {
                m.footer = a;
                continue;
            }
            m.footer.add(a);
        }
        for (Module m2 : g.modules) {
            if (m == m2) continue;
            m.productions.addAll(m2.productions);
        }
        return m;
    }

    public Object visit(Module m) {
        this.badNTs.clear();
        Grammar g = this.load(m);
        if (this.runtime.seenError() || this.runtime.test("optionLoaded") || this.runtime.test("optionDependencies") || this.runtime.test("optionInstantiated")) {
            return null;
        }
        List<Attribute> attributes = this.check(g);
        this.applyModifications(g);
        if (this.runtime.test("optionApplied")) {
            return null;
        }
        this.internTypes(g);
        this.checkRecursions(g);
        this.checkRepetitions(g);
        new ReachabilityChecker(this.runtime, this.analyzer).dispatch(g);
        this.checkExplicit(g);
        if (this.runtime.seenError()) {
            return null;
        }
        this.analyzer.uniquify();
        return this.combine(g, attributes);
    }

    public void visit(Production p) {
        if (1 == this.phase) {
            if (Constants.ATT_PACKAGE_PRIVATE.getValue().equals(p.dType) || Constants.ATT_INLINE.getName().equals(p.dType)) {
                this.runtime.error("attribute '" + p.dType + "' as type for production '" + p.name + "'", p);
            } else if ((Constants.ATT_WITH_LOCATION.getName().equals(p.dType) || Constants.ATT_CONSTANT.getName().equals(p.dType) || Constants.ATT_EXPLICIT.getName().equals(p.dType) || Constants.ATT_NO_INLINE.getName().equals(p.dType) || Constants.ATT_MEMOIZED.getName().equals(p.dType) || Constants.ATT_VERBOSE.getName().equals(p.dType) || Constants.ATT_VARIANT.getName().equals(p.dType) || Constants.ATT_IGNORING_CASE.getName().equals(p.dType) || Constants.ATT_STATEFUL.getName().equals(p.dType) || Constants.ATT_RESETTING.getName().equals(p.dType)) && !p.isPartial() && !this.analyzer.grammar().modules.get(0).hasAttribute(Constants.ATT_NO_WARNINGS) && !p.hasAttribute(Constants.ATT_NO_WARNINGS)) {
                this.runtime.warning("attribute '" + p.dType + "' as type for production " + p.name + "'", p);
            }
            if (p.isPartial()) {
                if (!this.isMofunctor) {
                    this.runtime.error("production modification '" + p.name + "' without modifies declaration", p);
                } else {
                    FullProduction p2 = null;
                    try {
                        p2 = this.analyzer.lookup(p.name);
                    }
                    catch (IllegalArgumentException x) {
                        // empty catch block
                    }
                    if (null == p2 || !this.analyzer.isDefined(p2, this.analyzer.currentModule())) {
                        this.runtime.error("production modification '" + p.name + "' without full production", p);
                    } else if (!p.dType.equals(p2.dType)) {
                        this.runtime.error("type '" + p.dType + "' of production modification '" + p.name + "' does not match full production's type", p);
                    }
                }
            }
            if (null != p.attributes) {
                int length = p.attributes.size();
                block2: for (int i = 0; i < length; ++i) {
                    Attribute att = p.attributes.get(i);
                    if (!(Constants.ATT_PUBLIC.equals(att) || Constants.ATT_PROTECTED.equals(att) || Constants.ATT_PRIVATE.equals(att) || Constants.ATT_TRANSIENT.equals(att) || Constants.ATT_INLINE.equals(att) || Constants.ATT_NO_INLINE.equals(att) || Constants.ATT_MEMOIZED.equals(att) || Constants.ATT_WITH_LOCATION.equals(att) || Constants.ATT_CONSTANT.equals(att) || Constants.ATT_VARIANT.equals(att) || Constants.ATT_EXPLICIT.equals(att) || Constants.ATT_VERBOSE.equals(att) || Constants.ATT_NO_WARNINGS.equals(att) || Constants.ATT_IGNORING_CASE.equals(att) || Constants.ATT_STATEFUL.equals(att) || Constants.ATT_RESETTING.equals(att))) {
                        this.runtime.error("unrecognized per-production attribute '" + att + "'", att);
                        continue;
                    }
                    if (!this.hasState && Constants.ATT_STATEFUL.equals(att)) {
                        this.runtime.error("stateful attribute without grammar-wide stateful attribute", att);
                        continue;
                    }
                    if (!this.hasState && Constants.ATT_RESETTING.equals(att)) {
                        this.runtime.error("resetting attribute without grammar-wide stateful attribute", att);
                        continue;
                    }
                    for (int j = 0; j < i; ++j) {
                        if (!att.equals(p.attributes.get(j))) continue;
                        this.runtime.error("duplicate attribute '" + att.getName() + "'", att);
                        continue block2;
                    }
                }
                if (p.hasAttribute(Constants.ATT_MEMOIZED)) {
                    if (p.hasAttribute(Constants.ATT_TRANSIENT)) {
                        this.runtime.error("memozied attribute contradicts transient attribute", Attribute.get(Constants.ATT_MEMOIZED.getName(), p.attributes));
                    }
                    if (p.hasAttribute(Constants.ATT_INLINE)) {
                        this.runtime.error("memoized attribute contradicts inline attribute", Attribute.get(Constants.ATT_MEMOIZED.getName(), p.attributes));
                    }
                }
                if (p.hasAttribute(Constants.ATT_TRANSIENT) && p.hasAttribute(Constants.ATT_INLINE)) {
                    this.runtime.error("inline attribute subsumes transient attribute", Attribute.get(Constants.ATT_INLINE.getName(), p.attributes));
                }
                if (p.hasAttribute(Constants.ATT_INLINE) && p.hasAttribute(Constants.ATT_NO_INLINE)) {
                    this.runtime.error("inline attribute contradicts noinline attribute", Attribute.get(Constants.ATT_NO_INLINE.getName(), p.attributes));
                }
            }
        }
        this.dispatch(p.choice);
    }

    public void visit(OrderedChoice c) {
        for (Sequence alt : c.alternatives) {
            this.dispatch(alt);
        }
    }

    public void visit(Repetition r) {
        if (1 == this.phase && Analyzer.strip(r.element) instanceof Action) {
            this.runtime.error("repeated action", r);
        }
        this.dispatch(r.element);
    }

    public void visit(Option o) {
        if (1 == this.phase && Analyzer.strip(o.element) instanceof Action) {
            this.runtime.error("optional action", o);
        }
        this.dispatch(o.element);
    }

    public void visit(Sequence s) {
        if ((1 == this.phase || 2 == this.phase) && null != s.name) {
            if (this.sequenceNames.contains(s.name)) {
                this.runtime.error("duplicate sequence name '" + s.name + "'", s);
            } else {
                this.sequenceNames.add(s.name);
            }
        }
        for (Element e : s.elements) {
            this.dispatch(e);
        }
    }

    public void visit(Predicate p) {
        if (1 == this.phase && this.isPredicate) {
            this.runtime.error("syntactic predicate within syntactic predicate", p);
        }
        boolean pred = this.isPredicate;
        this.isPredicate = true;
        this.dispatch(p.element);
        this.isPredicate = pred;
    }

    public void visit(SemanticPredicate p) {
        if (1 == this.phase) {
            if (!(p.element instanceof Action)) {
                this.runtime.error("malformed semantic predicate", p);
            } else {
                Action a = (Action)p.element;
                if (null == a.code || 0 >= a.code.size()) {
                    this.runtime.error("empty test for semantic predicate", p);
                }
            }
        }
        this.dispatch(p.element);
    }

    public void visit(VoidedElement v) {
        if (1 == this.phase) {
            Element voided = Analyzer.strip(v.element);
            switch (voided.tag()) {
                case FOLLOWED_BY: 
                case NOT_FOLLOWED_BY: 
                case SEMANTIC_PREDICATE: {
                    this.runtime.error("voided predicate", v);
                    break;
                }
                case BINDING: {
                    this.runtime.error("voided binding", v);
                    break;
                }
                case ACTION: {
                    this.runtime.error("voided action", v);
                    break;
                }
                case PARSER_ACTION: {
                    this.runtime.error("voided parser action", v);
                    break;
                }
                case NULL: {
                    this.runtime.error("voided null literal", v);
                    break;
                }
                case NODE_MARKER: {
                    this.runtime.error("voided node marker", v);
                }
            }
        }
        this.dispatch(v.element);
    }

    public void visit(Binding b) {
        if (1 == this.phase) {
            Element bound = Analyzer.strip(b.element);
            switch (bound.tag()) {
                case FOLLOWED_BY: 
                case NOT_FOLLOWED_BY: 
                case SEMANTIC_PREDICATE: {
                    this.runtime.error("binding for predicate", b);
                    break;
                }
                case VOIDED: {
                    this.runtime.error("binding for voided element", b);
                    break;
                }
                case BINDING: {
                    this.runtime.error("binding for binding", b);
                    break;
                }
                case NONTERMINAL: {
                    NonTerminal nt = (NonTerminal)bound;
                    FullProduction p = null;
                    try {
                        p = this.analyzer.lookup(nt);
                    }
                    catch (IllegalArgumentException x) {
                        // empty catch block
                    }
                    if (null == p || !this.ast.isVoid(p.dType)) break;
                    this.runtime.error("binding for void nonterminal '" + nt + "'", b);
                    break;
                }
                case ACTION: {
                    this.runtime.error("binding for action", b);
                    break;
                }
                case PARSER_ACTION: {
                    this.runtime.error("binding for parser action", b);
                    break;
                }
                case NODE_MARKER: {
                    this.runtime.error("binding for node marker", b);
                }
            }
        }
        this.dispatch(b.element);
    }

    public void visit(StringMatch m) {
        if (1 == this.phase) {
            Element matched = Analyzer.strip(m.element);
            switch (matched.tag()) {
                case FOLLOWED_BY: 
                case NOT_FOLLOWED_BY: 
                case SEMANTIC_PREDICATE: {
                    this.runtime.error("string match on predicate", m);
                    break;
                }
                case VOIDED: {
                    this.runtime.error("string match on voided element", m);
                    break;
                }
                case BINDING: {
                    this.runtime.error("string match on binding (try binding the match instead)", m);
                    break;
                }
                case STRING_MATCH: {
                    this.runtime.error("string match on another string match", m);
                    break;
                }
                case NONTERMINAL: {
                    NonTerminal nt = (NonTerminal)matched;
                    FullProduction p = null;
                    try {
                        p = this.analyzer.lookup(nt);
                    }
                    catch (IllegalArgumentException x) {
                        // empty catch block
                    }
                    if (null == p || !this.ast.isVoid(p.dType)) break;
                    this.runtime.error("string match on void nonterminal '" + nt + "'", m);
                    break;
                }
                case ANY_CHAR: 
                case CHAR_CLASS: 
                case CHAR_LITERAL: 
                case CHAR_SWITCH: 
                case STRING_LITERAL: {
                    this.runtime.error("match for terminal", m);
                    break;
                }
                case ACTION: {
                    this.runtime.error("match for action", m);
                    break;
                }
                case PARSER_ACTION: {
                    this.runtime.error("match for parser action", m);
                    break;
                }
                case NODE_MARKER: {
                    this.runtime.error("match for node marker", m);
                }
            }
        }
        this.dispatch(m.element);
    }

    public void visit(NonTerminal nt) {
        FullProduction p = null;
        try {
            p = this.analyzer.lookup(nt);
        }
        catch (IllegalArgumentException x) {
            if (nt.hasProperty("xtc.Constants.Original")) {
                if (!this.badNTs.containsKey(nt)) {
                    this.runtime.error("ambiguous renamed nonterminal '" + nt + "'", nt);
                    this.badNTs.put(nt, nt);
                }
            } else if (!this.badNTs.containsKey(nt)) {
                this.runtime.error("ambiguous nonterminal '" + nt + "'", nt);
                this.badNTs.put(nt, nt);
            }
            return;
        }
        if (null == p) {
            if (nt.hasProperty("xtc.Constants.Original")) {
                if (!this.badNTs.containsKey(nt)) {
                    this.runtime.error("undefined renamed nonterminal '" + nt + "'", nt);
                    this.badNTs.put(nt, nt);
                }
            } else if (!this.badNTs.containsKey(nt)) {
                this.runtime.error("undefined nonterminal '" + nt + "'", nt);
                this.badNTs.put(nt, nt);
            }
        }
    }

    public void visit(Terminal t) {
    }

    public void visit(StringLiteral l) {
        if (1 == this.phase && 0 == l.text.length()) {
            this.runtime.error("empty string literal", l);
        }
    }

    public void visit(CharClass c) {
        if (1 != this.phase) {
            return;
        }
        int length = c.ranges.size();
        if (0 >= length) {
            this.runtime.error("empty character class", c);
        } else {
            ArrayList<CharRange> list = new ArrayList<CharRange>(c.ranges);
            Collections.sort(list);
            for (int i = 0; i < length - 1; ++i) {
                boolean single2;
                CharRange r1 = list.get(i);
                CharRange r2 = list.get(i + 1);
                if (r1.last < r2.first) continue;
                boolean single1 = r1.first == r1.last;
                boolean bl = single2 = r2.first == r2.last;
                if (single1) {
                    if (single2) {
                        this.runtime.error("duplicate character '" + Utilities.escape(r1.last, 12) + "' in character class", c);
                        continue;
                    }
                    this.runtime.error("character '" + Utilities.escape(r1.last, 12) + "' already contained in range " + Utilities.escape(r2.first, 12) + "-" + Utilities.escape(r2.last, 12), c);
                    continue;
                }
                if (single2) {
                    this.runtime.error("character '" + Utilities.escape(r2.first, 12) + "' already contained in range " + Utilities.escape(r1.first, 12) + "-" + Utilities.escape(r1.last, 12), c);
                    continue;
                }
                this.runtime.error("ranges " + Utilities.escape(r1.first, 12) + "-" + Utilities.escape(r1.last, 12) + " and " + Utilities.escape(r2.first, 12) + "-" + Utilities.escape(r2.last, 12) + " overlap", c);
            }
        }
    }

    public void visit(NullLiteral l) {
    }

    public void visit(NodeMarker m) {
        if (!this.ast.isGenericNode(this.analyzer.current().dType)) {
            this.runtime.error("node marker in non-generic production", m);
        } else if (this.isPredicate) {
            this.runtime.error("node marker in predicate", m);
        }
    }

    public void visit(Action a) {
    }

    public void visit(ParserAction pa) {
        if (1 == this.phase) {
            if (!(pa.element instanceof Action)) {
                this.runtime.error("malformed parser action", pa);
            }
            if (this.isPredicate) {
                this.runtime.error("parser action within syntactic predicate", pa);
            }
        }
        this.dispatch(pa.element);
    }

    public void visit(InternalElement e) {
        if (1 == this.phase) {
            this.runtime.error("internal element", (Element)((Object)e));
        }
    }
}

