/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Analyzer;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.MetaData;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.util.Runtime;

public class ReferenceCounter
extends GrammarVisitor {
    protected boolean isTransformable;

    public ReferenceCounter(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    @Override
    public Object visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            MetaData md = (MetaData)p.getProperty("metaData");
            md.usageCount = 0;
            md.selfCount = 0;
        }
        for (Production p : m.productions) {
            this.isTransformable = (this.runtime.test("optimizeLeftRecursions") || this.runtime.test("optimizeLeftIterations")) && DirectLeftRecurser.isTransformable((FullProduction)p);
            this.analyzer.process(p);
        }
        return null;
    }

    @Override
    public Element visit(OrderedChoice c) {
        boolean top = this.isTopLevel;
        this.isTopLevel = false;
        this.isBound = false;
        boolean last = this.isLastElement;
        int length = c.alternatives.size();
        for (int i = 0; i < length; ++i) {
            this.isLastElement = top || last;
            this.needsSequence = true;
            Sequence s = c.alternatives.get(i);
            if (top && this.isTransformable && DirectLeftRecurser.isRecursive(s, (FullProduction)this.analyzer.current())) {
                this.dispatch(s.subSequence(1));
                continue;
            }
            this.dispatch(s);
        }
        this.isLastElement = false;
        this.needsSequence = false;
        return c;
    }

    public Element visit(NonTerminal nt) {
        MetaData md = (MetaData)this.analyzer.lookup(nt).getProperty("metaData");
        ++md.usageCount;
        if (this.analyzer.current().name.equals(nt)) {
            ++md.selfCount;
        }
        if (this.isRepeatedOnce && (this.analyzer.current().isMemoized() || !this.runtime.test("optimizeRepeated"))) {
            ++md.usageCount;
            if (this.analyzer.current().name.equals(nt)) {
                ++md.selfCount;
            }
        }
        return nt;
    }
}

