/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Analyzer;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.parser.UnaryOperator;
import xtc.tree.Visitor;
import xtc.util.Runtime;

public class ReachabilityChecker
extends Visitor {
    protected Runtime runtime;
    protected Analyzer analyzer;

    public ReachabilityChecker(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    public void visit(Grammar g) {
        this.analyzer.register(this);
        this.analyzer.init(g);
        for (Module m : g.modules) {
            this.analyzer.process(m);
            for (Production p : m.productions) {
                if (!p.isFull()) continue;
                this.analyzer.process(p);
            }
        }
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            this.analyzer.process(p);
        }
    }

    public void visit(FullProduction p) {
        this.dispatch(p.choice);
    }

    public void visit(OrderedChoice c) {
        int size = c.alternatives.size();
        for (int i = 0; i < size; ++i) {
            Sequence s = c.alternatives.get(i);
            if (!this.analyzer.restrictsInput(s) && i < size - 1) {
                this.runtime.error("unreachable alternative", c.alternatives.get(i + 1));
                break;
            }
            this.dispatch(s);
        }
    }

    public void visit(Sequence s) {
        for (Element e : s.elements) {
            this.dispatch(e);
        }
    }

    public void visit(UnaryOperator op) {
        this.dispatch(op.element);
    }

    public void visit(CharSwitch s) {
        for (CharCase kase : s.cases) {
            this.dispatch(kase.element);
        }
        this.dispatch(s.base);
    }

    public void visit(Element e) {
    }
}

