/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Annotator;
import xtc.parser.ChoiceExpander;
import xtc.parser.CodeGenerator;
import xtc.parser.DeadProductionEliminator;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.DuplicateProductionFolder;
import xtc.parser.ElementVoider;
import xtc.parser.GenericVoider;
import xtc.parser.Generifier;
import xtc.parser.HtmlPrinter;
import xtc.parser.Inliner;
import xtc.parser.ListMaker;
import xtc.parser.MetaDataCreator;
import xtc.parser.MetaDataSetter;
import xtc.parser.Module;
import xtc.parser.PParser;
import xtc.parser.ParseException;
import xtc.parser.PrefixFolder;
import xtc.parser.PrettyPrinter;
import xtc.parser.ProductionVoider;
import xtc.parser.ReachabilityChecker;
import xtc.parser.ReferenceCounter;
import xtc.parser.Resolver;
import xtc.parser.Result;
import xtc.parser.RootFinder;
import xtc.parser.Simplifier;
import xtc.parser.TerminalOptimizer;
import xtc.parser.Tokenizer;
import xtc.parser.Transformer;
import xtc.parser.TransientMarker;
import xtc.parser.TreeExtractor;
import xtc.parser.TreeTyper;
import xtc.parser.ValueChecker;
import xtc.parser.VariantSorter;
import xtc.tree.Attribute;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.type.JavaAST;
import xtc.util.Tool;
import xtc.util.Utilities;

public class Rats
extends Tool {
    @Override
    public String getName() {
        return "Rats! Parser Generator";
    }

    @Override
    public String getCopy() {
        return "(C) 2004-2009 Robert Grimm";
    }

    @Override
    public String getExplanation() {
        return "By default, Rats! performs all optimizations besides the errors2 and left1 optimizations.  If one or more individual optimizations are specified as command line flags, all other optimizations are automatically disabled.  The choices2 optimization includes choices1, errors1 is complimentary to errors2, and left1 and left2 are mutually exclusive.";
    }

    @Override
    public void init() {
        super.init();
        this.runtime.bool("loaded", "optionLoaded", false, "Print every module after loading, then stop.").bool("instantiated", "optionInstantiated", false, "Print all modules after loading and instantiating them, then stop.").bool("dependencies", "optionDependencies", false, "Print module dependencies after loading and instantiating, then stop.").bool("applied", "optionApplied", false, "Print all modules after applying modifications, then stop.").bool("valued", "optionValued", false, "Print grammar after reducing it to expressions that directly contribute to AST, then stop.").bool("processed", "optionProcessed", false, "Print full grammar before code generation, then stop.").bool("html", "optionHtml", false, "Create HTML for instantiated, applied, valued, or processed options.").bool("variant", "optionVariant", false, "Enforce variant types for productions having node values.").bool("ast", "optionASTDefinition", false, "Print a formal definition of the grammar's AST, then stop.").bool("lgpl", "optionLGPL", false, "Create an LGPL compliant parser.").att("option", "grammarOption", true, "Add the specified attribute to the grammar's options.").bool("Onone", "doNotOptimize", false, "Perform no optimizations.").bool("Ochunks", "optimizeChunks", true, "Break memoization table into chunks.").bool("Ogrammar", "optimizeGrammar", true, "Fold duplicate productions and eliminate dead productions.").bool("Oterminals", "optimizeTerminals", true, "Optimize the recognition of terminals, incl. by using switches.").bool("Ocost", "optimizeCost", true, "Perform cost-based inlining.").bool("Otransient", "optimizeTransient", true, "Do not memoize transient productions.").bool("Onontransient", "optimizeNonTransient", true, "Mark suitable productions as transient.").bool("Orepeated", "optimizeRepeated", true, "Do not desugar transient repetitions.").bool("Oleft1", "optimizeLeftRecursions", false, "Convert direct left-recursions into equivalent right-recursions.").bool("Oleft2", "optimizeLeftIterations", true, "Convert direct left-recursions into equivalent iterations.").bool("Ooptional", "optimizeOptional", true, "Do not desugar options.").bool("Ochoices1", "optimizeChoices1", true, "Inline transient void or text-only productions into choices.").bool("Ochoices2", "optimizeChoices2", true, "Inline productions with the inline attribute into choices.").bool("Oerrors1", "optimizeErrors1", true, "Avoid creating parse errors for individual terms.").bool("Oerrors2", "optimizeErrors2", false, "Avoid creating parse errors for transient productions.").bool("Ovalues", "optimizeValues", true, "Avoid creating duplicate semantic values.").bool("Omatches", "optimizeMatches", true, "Optimize the performance of string matches.").bool("Oprefixes", "optimizePrefixes", true, "Fold common prefixes in choices.").bool("Ognodes", "optimizeGenericNodes", true, "Optimize the creation of generic nodes.").bool("Olocation", "optimizeLocation", true, "Optimize the annotation of nodes with their source locations.");
    }

    @Override
    public void prepare() {
        boolean doNotOptimize;
        boolean explicitOptimizations = this.runtime.hasPrefixValue("optimize");
        boolean bl = doNotOptimize = this.runtime.hasValue("doNotOptimize") && this.runtime.test("doNotOptimize");
        if (explicitOptimizations && doNotOptimize) {
            this.runtime.error("no optimizations incompatible with explicitly specified optimizations");
        }
        if (this.runtime.hasValue("optimizeLeftRecursions") && this.runtime.test("optimizeLeftRecursions") && this.runtime.hasValue("optimizeLeftIterations") && this.runtime.test("optimizeLeftIterations")) {
            this.runtime.error("left1 option mutually exclusive with left2 option");
        }
        if (explicitOptimizations || doNotOptimize) {
            this.runtime.initFlags("optimize", false);
        }
        this.runtime.initDefaultValues();
        if (this.runtime.test("optionSilent") && this.runtime.test("optionVerbose")) {
            this.runtime.error("can't run in silent and verbose mode at the same time");
        }
        if (this.runtime.test("optionLoaded")) {
            if (this.runtime.test("optionInstantiated")) {
                this.runtime.error("loaded option incompatible with instantiated option");
            }
            if (this.runtime.test("optionApplied")) {
                this.runtime.error("loaded option incompatible with applied option");
            }
            if (this.runtime.test("optionValued")) {
                this.runtime.error("loaded option incompatiable with valued option");
            }
            if (this.runtime.test("optionProcessed")) {
                this.runtime.error("loaded option incompatible with processed option");
            }
            if (this.runtime.test("optionASTDefinition")) {
                this.runtime.error("loaded option incompatible with ast option");
            }
        }
        if (this.runtime.test("optionInstantiated")) {
            if (this.runtime.test("optionApplied")) {
                this.runtime.error("instantiated option incompatible with applied option");
            }
            if (this.runtime.test("optionValued")) {
                this.runtime.error("instantiated option incompatible with valued option");
            }
            if (this.runtime.test("optionProcessed")) {
                this.runtime.error("instantiated option incompatible with processed option");
            }
            if (this.runtime.test("optionASTDefinition")) {
                this.runtime.error("instantiated option incompatible with ast option");
            }
        }
        if (this.runtime.test("optionApplied")) {
            if (this.runtime.test("optionValued")) {
                this.runtime.error("applied option incompatible with valued option");
            }
            if (this.runtime.test("optionProcessed")) {
                this.runtime.error("applied option incompatible with processed option");
            }
            if (this.runtime.test("optionASTDefinition")) {
                this.runtime.error("applied option incompatible with ast option");
            }
        }
        if (this.runtime.test("optionValued")) {
            if (this.runtime.test("optionProcessed")) {
                this.runtime.error("valued option incompatible with processed option");
            }
            if (this.runtime.test("optionASTDefinition")) {
                this.runtime.error("valued option incompatible with ast option");
            }
        }
        if (this.runtime.test("optionProcessed") && this.runtime.test("optionASTDefinition")) {
            this.runtime.error("processed option incompatible with ast option");
        }
        if (this.runtime.test("optionHtml")) {
            if (this.runtime.test("optionLoaded")) {
                this.runtime.error("loaded option incompatible with html option");
            } else if (!(this.runtime.test("optionInstantiated") || this.runtime.test("optionApplied") || this.runtime.test("optionValued") || this.runtime.test("optionProcessed"))) {
                this.runtime.error("html option requires instantiated, applied, valued or processed option");
            }
        }
    }

    @Override
    public Node parse(Reader in, File file) throws IOException, ParseException {
        long length = file.length();
        if (Integer.MAX_VALUE < length) {
            throw new IllegalArgumentException(file + ": file too large");
        }
        PParser parser = new PParser(in, file.toString(), (int)length);
        Result result = parser.pModule(0);
        Module mod = (Module)parser.value(result);
        String name = file.getName();
        int idx = name.lastIndexOf(46);
        if (-1 != idx) {
            name = name.substring(0, idx);
        }
        if (!name.equals(Utilities.unqualify(mod.name.name))) {
            this.runtime.error("module name '" + mod.name.name + "' inconsistent with file name '" + file + "'", mod.name);
        }
        return mod;
    }

    @Override
    public void process(Node node) {
        Printer out;
        Module module = (Module)node;
        Analyzer ana = new Analyzer();
        JavaAST ast = new JavaAST();
        Simplifier simple = new Simplifier(this.runtime, ana);
        DeadProductionEliminator dead = new DeadProductionEliminator(this.runtime, ana);
        DuplicateProductionFolder dup = new DuplicateProductionFolder(this.runtime, ana);
        PrefixFolder prefix = new PrefixFolder(this.runtime, ana);
        MetaDataCreator meta = new MetaDataCreator();
        ReferenceCounter ref = new ReferenceCounter(this.runtime, ana);
        TransientMarker trans = new TransientMarker(this.runtime, ana);
        Inliner line = new Inliner(this.runtime, ana);
        if (null == module.attributes) {
            module.attributes = new ArrayList<Attribute>();
        }
        module.attributes.addAll(this.runtime.getAttributeList("grammarOption"));
        module = (Module)new Resolver(this.runtime, ana, ast).dispatch(module);
        if (this.runtime.test("optionLoaded") || this.runtime.test("optionApplied") || null == module) {
            return;
        }
        if (module.hasAttribute(Constants.ATT_GENERIC_AS_VOID)) {
            new GenericVoider(this.runtime, ana).dispatch(module);
        }
        new RootFinder(this.runtime, ana).dispatch(module);
        simple.dispatch(module);
        if (this.runtime.test("optimizeGrammar")) {
            dead.dispatch(module);
        }
        new ElementVoider(this.runtime, ana).dispatch(module);
        if (this.runtime.test("optionVariant")) {
            new VariantSorter(this.runtime, ana, ast).dispatch(module);
            if (0 < this.runtime.errorCount()) {
                return;
            }
        }
        if (this.runtime.test("optimizeGrammar") && !this.runtime.test("optionASTDefinition")) {
            dup.dispatch(module);
        }
        if (this.runtime.test("optimizePrefixes")) {
            prefix.dispatch(module);
        }
        boolean changed = false;
        do {
            if (changed = ((Boolean)line.dispatch(module)).booleanValue()) {
                simple.dispatch(module);
                if (this.runtime.test("optimizeGrammar")) {
                    dead.dispatch(module);
                }
                if (this.runtime.test("optimizePrefixes")) {
                    prefix.dispatch(module);
                }
            }
            if (!this.runtime.test("optimizeNonTransient")) continue;
            meta.dispatch(module);
            ref.dispatch(module);
            trans.dispatch(module);
        } while (changed);
        if (module.hasAttribute(Constants.ATT_PARSE_TREE)) {
            new Tokenizer(this.runtime, ana).dispatch(module);
            new Annotator(this.runtime, ana).dispatch(module);
        }
        new Transformer(this.runtime, ana, ast).dispatch(module);
        if (!this.runtime.test("optionValued")) {
            new ListMaker(this.runtime, ana, ast).dispatch(module);
            new DirectLeftRecurser(this.runtime, ana, ast).dispatch(module);
            new Generifier(this.runtime, ana).dispatch(module);
            new ValueChecker(this.runtime, ana).dispatch(module);
        }
        if (0 < this.runtime.errorCount()) {
            return;
        }
        if (this.runtime.test("optionValued")) {
            new TreeExtractor(this.runtime, ana, ast, false).dispatch(module);
            if (this.runtime.test("optionHtml")) {
                new HtmlPrinter(this.runtime, ana, ast, true).dispatch(module);
            } else {
                new PrettyPrinter(this.runtime.console(), ast, true).dispatch(module);
                this.runtime.console().flush();
            }
            return;
        }
        if (this.runtime.test("optimizeChoices1") || this.runtime.test("optimizeChoices2")) {
            meta.dispatch(module);
            ref.dispatch(module);
            new ChoiceExpander(this.runtime, ana).dispatch(module);
        }
        if (this.runtime.test("optimizeTerminals")) {
            new ProductionVoider(this.runtime, ana).dispatch(module);
            new TerminalOptimizer(this.runtime, ana).dispatch(module);
        }
        if (this.runtime.test("optimizePrefixes")) {
            prefix.dispatch(module);
        }
        if (this.runtime.test("optimizeGrammar")) {
            dead.dispatch(module);
            if (!this.runtime.test("optionASTDefinition")) {
                dup.dispatch(module);
            }
        }
        if (this.runtime.test("optimizePrefixes")) {
            new ReachabilityChecker(this.runtime, ana).dispatch(module);
            if (0 < this.runtime.errorCount()) {
                return;
            }
        }
        meta.dispatch(module);
        ref.dispatch(module);
        if (this.runtime.test("optimizeNonTransient")) {
            trans.dispatch(module);
        }
        new MetaDataSetter(this.runtime, ana, ast).dispatch(module);
        if (0 < this.runtime.errorCount()) {
            return;
        }
        if (this.runtime.test("optionASTDefinition")) {
            new TreeTyper(this.runtime, ana, ast).dispatch(module);
            return;
        }
        if (this.runtime.test("optionProcessed")) {
            if (this.runtime.test("optionHtml")) {
                new HtmlPrinter(this.runtime, ana, ast, true).dispatch(module);
            } else {
                new PrettyPrinter(this.runtime.console(), ast, true).dispatch(module);
                this.runtime.console().flush();
            }
            return;
        }
        File file = new File(this.runtime.getOutputDirectory(), Utilities.getName(module.getClassName()) + ".java");
        try {
            out = new Printer(new PrintWriter(this.runtime.getWriter(file)));
        }
        catch (IOException x) {
            if (null == x.getMessage()) {
                this.runtime.error(file.toString() + ": I/O error");
            } else {
                this.runtime.error(file.toString() + ": " + x.getMessage());
            }
            return;
        }
        this.printHeader(out);
        new CodeGenerator(this.runtime, ana, ast, out).dispatch(module);
        out.flush().close();
    }

    public static void main(String[] args) {
        new Rats().run(args);
    }
}

