/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.SemanticPredicate;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;
import xtc.type.AST;
import xtc.util.Runtime;

public class ProductionVoider
extends GrammarVisitor {
    public ProductionVoider(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    @Override
    public Object visit(Module m) {
        boolean changed;
        do {
            changed = false;
            Tester tester = new Tester(this.runtime, this.analyzer);
            tester.dispatch(m);
            Set<NonTerminal> voidable = tester.voidable();
            this.analyzer.register(this);
            this.analyzer.init(m);
            for (Production p : m.productions) {
                if (!voidable.contains(p.qName)) continue;
                if (this.runtime.test("optionVerbose")) {
                    System.err.println("[Voiding " + p.qName + "]");
                }
                this.analyzer.process(p);
                changed = true;
                p.type = AST.VOID;
                p.setProperty("voided", Boolean.TRUE);
            }
        } while (changed);
        return null;
    }

    @Override
    public Element visit(VoidedElement v) {
        v.element = (Element)this.dispatch(v.element);
        return v.element;
    }

    @Override
    public Element visit(Binding b) {
        b.element = (Element)this.dispatch(b.element);
        if (Analyzer.isSynthetic(b.name)) {
            return b.element;
        }
        return b;
    }

    public Element visit(ValueElement e) {
        return NullValue.VALUE;
    }

    public static class Tester
    extends GrammarVisitor {
        protected boolean secondPhase;
        protected boolean voidable;

        public Tester(Runtime runtime, Analyzer analyzer) {
            super(runtime, analyzer);
        }

        public Set<NonTerminal> voidable() {
            return new HashSet<NonTerminal>(this.analyzer.marked());
        }

        @Override
        public Object visit(Module m) {
            this.analyzer.register(this);
            this.analyzer.init(m);
            this.secondPhase = false;
            for (Production p : m.productions) {
                if (p.hasAttribute(Constants.ATT_PUBLIC) || AST.isVoid(p.type)) continue;
                this.voidable = true;
                this.analyzer.process(p);
                if (!this.voidable) continue;
                this.analyzer.mark(p.qName);
            }
            this.secondPhase = true;
            for (Production p : m.productions) {
                this.analyzer.process(p);
            }
            return null;
        }

        @Override
        public Element visit(Binding b) {
            if ("yyValue".equals(b.name)) {
                this.voidable = false;
            }
            this.isBound = true;
            b.element = (Element)this.dispatch(b.element);
            return b;
        }

        public Element visit(NonTerminal nt) {
            if (this.secondPhase && this.isBound) {
                FullProduction p = this.analyzer.lookup(nt);
                if (this.analyzer.current() != p) {
                    this.analyzer.unmark(p.qName);
                }
            }
            this.isBound = false;
            return nt;
        }

        @Override
        public Element visit(SemanticPredicate p) {
            this.isBound = false;
            return p;
        }

        public Element visit(Action a) {
            this.isBound = false;
            this.voidable = !a.setsValue();
            return a;
        }

        @Override
        public Element visit(ParserAction pa) {
            this.isBound = false;
            this.voidable = false;
            return pa;
        }
    }
}

