/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.AlternativeAddition;
import xtc.parser.AlternativeRemoval;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FollowedBy;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleImport;
import xtc.parser.ModuleInstantiation;
import xtc.parser.ModuleList;
import xtc.parser.ModuleModification;
import xtc.parser.ModuleName;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.NullLiteral;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.ProductionOverride;
import xtc.parser.ProperListValue;
import xtc.parser.Properties;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SequenceName;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.TokenValue;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Utilities;

public class PrettyPrinter
extends Visitor {
    protected Printer printer;
    protected final AST ast;
    protected final boolean verbose;
    protected boolean newline;
    protected boolean parenChoice;
    protected boolean parenSequence;
    protected boolean isTopLevel;

    protected PrettyPrinter(AST ast, boolean verbose) {
        this.ast = ast;
        this.verbose = verbose;
    }

    public PrettyPrinter(Printer printer, AST ast, boolean verbose) {
        this.printer = printer;
        this.ast = ast;
        this.verbose = verbose;
        printer.register(this);
    }

    protected int stringEscapes() {
        return 8;
    }

    protected int regexEscapes() {
        return 12;
    }

    protected boolean isPrefix(Element e) {
        switch (e.tag()) {
            case VOIDED: 
            case BINDING: 
            case PARSER_ACTION: 
            case FOLLOWED_BY: 
            case NOT_FOLLOWED_BY: 
            case SEMANTIC_PREDICATE: 
            case STRING_MATCH: {
                return true;
            }
        }
        return false;
    }

    public void flush() {
        this.printer.flush();
    }

    public void visit(Attribute a) {
        if ("visibility".equals(a.getName())) {
            this.printer.p((String)a.getValue());
        } else {
            this.printer.p(a.getName());
            Object value = a.getValue();
            if (null != value) {
                this.printer.p('(').p(value.toString()).p(')');
            }
        }
    }

    public void visit(Grammar g) {
        for (Module m : g.modules) {
            this.dispatch(m);
        }
    }

    protected void printDocumentation(Module m) {
        if (!this.verbose || null == m.documentation) {
            return;
        }
        Comment c = m.documentation;
        int size = c.text.size();
        if (0 != size) {
            if (1 == size) {
                this.printer.indent().p("/** ").p(c.text.get(0)).pln(" */");
            } else {
                this.printer.indent().pln("/**");
                for (int i = 0; i < size; ++i) {
                    this.printer.indent().p(" * ").pln(c.text.get(i));
                }
                this.printer.indent().pln(" */");
            }
        }
    }

    protected void printModule(Module m) {
        this.printer.indent().p("module ").p(m.name);
        if (null != m.parameters && 0 < m.parameters.size()) {
            this.printer.p(m.parameters);
        }
        if (this.verbose && (m.name.hasProperty("xtc.Constants.Original") || m.hasProperty("xtc.Constants.Arguments"))) {
            ModuleName base = m.name.hasProperty("xtc.Constants.Original") ? (ModuleName)m.name.getProperty("xtc.Constants.Original") : m.name;
            ModuleList args = (ModuleList)m.getProperty("xtc.Constants.Arguments");
            this.printer.p(" /* = ").p(base);
            if (null == args) {
                this.printer.p("()");
            } else {
                this.printer.p(args);
            }
            this.printer.p(" */ ");
        }
        this.printer.pln(';');
    }

    protected void printActions(Module m) {
        if (null != m.header) {
            this.printer.pln().indent().p("header ").p(m.header);
            if (1 == m.header.code.size()) {
                this.printer.pln();
            }
        }
        if (null != m.body) {
            this.printer.pln().indent().p("body ").p(m.body);
            if (1 == m.body.code.size()) {
                this.printer.pln();
            }
        }
        if (null != m.footer) {
            this.printer.pln().indent().p("footer ").p(m.footer);
            if (1 == m.footer.code.size()) {
                this.printer.pln();
            }
        }
    }

    protected void printOption(Module m) {
        if (null != m.attributes && 0 < m.attributes.size()) {
            this.printer.pln().indent().p("option ");
            Iterator<Attribute> iter = m.attributes.iterator();
            while (iter.hasNext()) {
                this.printer.buffer().p(((Object)iter.next()).toString());
                if (iter.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p(';');
                }
                this.printer.fitMore();
            }
            this.printer.pln();
        }
    }

    public void visit(Module m) {
        this.printer.sep();
        this.printer.indent().p("// Generated by Rats!, version ").p("1.15.0").p(", ").p("(C) 2004-2009 Robert Grimm").pln('.');
        this.printer.sep();
        this.printer.pln();
        this.printDocumentation(m);
        this.printModule(m);
        if (null != m.dependencies && 0 < m.dependencies.size()) {
            this.printer.pln();
            for (ModuleDependency dep : m.dependencies) {
                this.printer.p(dep);
            }
        }
        this.printActions(m);
        this.printOption(m);
        this.printer.pln();
        for (Production p : m.productions) {
            this.printer.p(p);
        }
        this.printer.sep().pln();
    }

    protected void print(ModuleDependency dep, String name) {
        this.printer.indent().p(name).p(' ').p(dep.module);
        if (0 != dep.arguments.size()) {
            this.printer.p(dep.arguments);
        }
        if (null != dep.target) {
            this.printer.buffer().p(" as ").p(dep.target).fitMore();
        }
        this.printer.pln(';');
    }

    public void visit(ModuleImport imp) {
        this.print(imp, "import");
    }

    public void visit(ModuleInstantiation ins) {
        this.print(ins, "instantiate");
    }

    public void visit(ModuleModification mod) {
        this.print(mod, "modify");
    }

    public void visit(ModuleList list) {
        this.printer.p('(');
        Iterator<ModuleName> iter = list.names.iterator();
        while (iter.hasNext()) {
            this.printer.buffer().p(iter.next());
            if (iter.hasNext()) {
                this.printer.p(", ");
            }
            this.printer.fitMore();
        }
        this.printer.p(')');
    }

    public void visit(ModuleName name) {
        this.printer.p(name.name);
    }

    protected void enter(Production p) {
        if (this.verbose && p.hasProperty("duplicates")) {
            List<String> sources = Properties.getDuplicates(p);
            this.printer.indent().pln("/*");
            this.printer.indent().p(" * The following production is the result of ").p("folding duplicates ");
            Iterator<String> iterator = sources.iterator();
            while (iterator.hasNext()) {
                String name = iterator.next();
                this.printer.buffer();
                if (1 < sources.size() && !iterator.hasNext()) {
                    this.printer.p("and ");
                }
                this.printer.p(name);
                if (2 == sources.size() && iterator.hasNext()) {
                    this.printer.p(' ');
                } else if (iterator.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p('.');
                }
                this.printer.fit(" * ");
            }
            this.printer.pln();
            this.printer.indent().pln(" */");
        }
        this.printer.indent();
        if (null != p.attributes && 0 < p.attributes.size()) {
            for (Node node : p.attributes) {
                this.printer.p(node).p(' ');
            }
        }
        if (null != p.type) {
            if (AST.isVoid(p.type)) {
                this.printer.p("void ");
            } else if (AST.isGenericNode(p.type)) {
                this.printer.p("generic ");
            } else {
                this.printer.p(this.ast.extern(p.type)).p(' ');
            }
        } else if (null != p.dType) {
            this.printer.p(p.dType).p(' ');
        }
        this.printer.p(p.name.name);
        this.parenChoice = false;
        this.parenSequence = false;
    }

    protected void exit(Production p) {
        this.printer.pln();
    }

    public void visit(AlternativeAddition p) {
        this.enter(p);
        this.printer.p(" += ");
        if (!p.isBefore) {
            this.printer.pln().indentMore().p(p.sequence).pln(" ...");
            this.printer.indentMore().p("/ ");
        }
        this.isTopLevel = true;
        this.printer.p(p.choice);
        if (p.isBefore) {
            this.printer.indentMore().p("/ ").p(p.sequence).pln(" ...");
        }
        this.printer.indentMore().pln(';');
        this.exit(p);
    }

    public void visit(AlternativeRemoval p) {
        this.enter(p);
        this.printer.pln(" -=").incr().indent();
        Iterator<SequenceName> iter = p.sequences.iterator();
        while (iter.hasNext()) {
            this.printer.buffer().p(iter.next());
            if (iter.hasNext()) {
                this.printer.p(", ");
            }
            this.printer.fit();
        }
        this.printer.pln().indent().pln(';').decr();
        this.exit(p);
    }

    public void visit(ProductionOverride p) {
        this.enter(p);
        this.printer.p(" := ");
        if (null == p.choice) {
            this.printer.pln("... ;");
        } else if (p.isComplete) {
            this.isTopLevel = true;
            this.printer.p(p.choice).indentMore().pln(';');
        } else {
            this.printer.pln().indentMore().pln("...").indentMore().p("/ ");
            this.isTopLevel = true;
            this.printer.p(p.choice).indentMore().pln(';');
        }
        this.exit(p);
    }

    public void visit(FullProduction p) {
        this.enter(p);
        this.printer.p(" = ");
        if (1 == p.choice.alternatives.size() && 0 == p.choice.alternatives.get(0).size()) {
            if (p.getBooleanProperty("redacted")) {
                this.printer.p("... ");
            } else if (this.verbose) {
                this.printer.p("/* Empty */ ");
            }
            this.printer.pln(';');
        } else {
            this.isTopLevel = true;
            this.printer.p(p.choice).indentMore().pln(';');
        }
        this.exit(p);
    }

    protected void print(List<Sequence> alternatives, String mark) {
        boolean choice = this.parenChoice;
        boolean sequence = this.parenSequence;
        if (choice) {
            this.printer.p("( ");
        }
        if (this.isTopLevel) {
            this.isTopLevel = false;
        } else if (this.verbose) {
            this.printer.p("/* ").p(mark).p(" */ ");
        }
        this.printer.pln().incr();
        boolean first = true;
        for (Sequence s : alternatives) {
            if (first) {
                first = false;
                this.printer.indent();
            } else {
                this.printer.indent().p("/ ");
            }
            this.parenChoice = true;
            this.parenSequence = false;
            this.newline = false;
            this.printer.p(s);
            if (this.newline) continue;
            this.printer.pln();
        }
        this.printer.decr();
        if (choice) {
            this.printer.indent().p(')');
        }
        this.parenChoice = choice;
        this.parenSequence = sequence;
        this.newline = false;
    }

    public void visit(OrderedChoice c) {
        this.print(c.alternatives, "Choice");
    }

    public void visit(Repetition r) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean choice = this.parenChoice;
        boolean sequence = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer();
        if (this.isPrefix(r.element)) {
            this.printer.p('(');
        }
        this.printer.p(r.element);
        if (this.isPrefix(r.element)) {
            this.printer.p(')');
        }
        if (r.once) {
            this.printer.p('+');
        } else {
            this.printer.p('*');
        }
        this.printer.fit();
        this.parenChoice = choice;
        this.parenSequence = sequence;
    }

    public void visit(Option o) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean choice = this.parenChoice;
        boolean sequence = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer();
        if (this.isPrefix(o.element)) {
            this.printer.p('(');
        }
        this.printer.p(o.element);
        if (this.isPrefix(o.element)) {
            this.printer.p(')');
        }
        this.printer.p('?').fit();
        this.parenChoice = choice;
        this.parenSequence = sequence;
    }

    public void visit(SequenceName n) {
        this.printer.p('<').p(n.name).p('>');
    }

    public void visit(Sequence s) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean choice = this.parenChoice;
        boolean sequence = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        boolean first = true;
        for (Element e : s.elements) {
            if (first) {
                first = false;
                if (sequence) {
                    this.printer.p('(');
                }
                if (null != s.name) {
                    this.printer.p(s.name).p(' ');
                }
            } else {
                this.printer.p(' ');
            }
            this.printer.p(e);
        }
        if (sequence) {
            this.printer.p(')');
        }
        this.parenChoice = choice;
        this.parenSequence = sequence;
    }

    public void visit(FollowedBy p) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean choice = this.parenChoice;
        boolean sequence = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p('&').p(p.element).fit();
        this.parenChoice = choice;
        this.parenSequence = sequence;
    }

    public void visit(NotFollowedBy p) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean choice = this.parenChoice;
        boolean sequence = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p('!').p(p.element).fit();
        this.parenChoice = choice;
        this.parenSequence = sequence;
    }

    public void visit(SemanticPredicate p) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean choice = this.parenChoice;
        boolean sequence = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p('&').p(p.element).fit();
        this.parenChoice = choice;
        this.parenSequence = sequence;
    }

    public void visit(VoidedElement v) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("void:").p(v.element).fit();
    }

    public void visit(Binding b) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p(b.name).p(':').p(b.element).fit();
    }

    public void visit(StringMatch m) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('\"').escape(m.text, this.stringEscapes()).p("\":").p(m.element).fit();
    }

    public void visit(NonTerminal nt) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p(nt.name).fit();
    }

    public void visit(StringLiteral l) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('\"').escape(l.text, this.stringEscapes()).p('\"').fit();
    }

    public void visit(AnyChar a) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('_').fit();
    }

    public void visit(CharLiteral l) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('\'').escape(l.c, this.stringEscapes()).p('\'').fit();
    }

    public void visit(CharRange r) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        if (r.first == r.last) {
            this.printer.escape(r.first, this.regexEscapes());
        } else {
            this.printer.escape(r.first, this.regexEscapes()).p('-').escape(r.last, this.regexEscapes());
        }
    }

    public void visit(CharClass c) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer();
        if (c.exclusive) {
            if (this.verbose) {
                this.printer.p("/* Exclusive */ ");
            }
            this.printer.p('!');
        }
        this.printer.p('[');
        for (CharRange r : c.ranges) {
            this.printer.p(r);
        }
        this.printer.p(']');
        if (c.exclusive) {
            this.printer.p(" .");
        }
        this.printer.fit();
    }

    public void visit(CharCase c) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p(c.klass).p(' ').p(c.element);
    }

    public void visit(CharSwitch s) {
        boolean choice = this.parenChoice;
        boolean sequence = this.parenSequence;
        if (choice) {
            this.printer.p("( ");
        }
        if (this.verbose) {
            this.printer.pln("/* Switch */").incr();
        } else {
            this.printer.pln().incr();
        }
        boolean firstCase = true;
        boolean printed = false;
        CharClass klass = null;
        for (CharCase kase : s.cases) {
            if (null == kase.element) {
                if (null == klass) {
                    klass = new CharClass(new ArrayList<CharRange>());
                }
                klass.ranges.addAll(kase.klass.ranges);
                continue;
            }
            if (firstCase) {
                firstCase = false;
                this.printer.indent();
            } else {
                this.printer.indent().p("/ ");
            }
            this.parenChoice = true;
            this.parenSequence = false;
            this.newline = false;
            this.printer.p(kase);
            if (!this.newline) {
                this.printer.pln();
            }
            printed = true;
        }
        if (null != klass || null != s.base) {
            this.printer.indent();
            if (printed) {
                this.printer.p("/ ");
            }
            if (null != klass) {
                this.newline = false;
                this.printer.p('!').p(klass).p(' ');
            }
            if (null != s.base) {
                this.parenChoice = true;
                this.parenSequence = false;
                this.newline = false;
                this.printer.p("_ ").p(s.base);
            }
            if (!this.newline) {
                this.printer.pln();
            }
        }
        this.printer.decr();
        if (choice) {
            this.printer.indent().p(')');
        }
        this.parenChoice = choice;
        this.parenSequence = sequence;
        this.newline = false;
    }

    protected void print(String s) {
        this.printer.p(s);
    }

    protected void print(Action a, boolean caret) {
        if (this.newline) {
            this.printer.indent();
        }
        if (a.code.isEmpty()) {
            this.newline = false;
        } else if (1 == a.code.size()) {
            this.newline = false;
            this.printer.buffer();
            if (caret) {
                this.printer.p('^');
            }
            this.printer.p("{ ");
            this.print(a.code.get(0));
            this.printer.p(" }").fit();
        } else {
            this.newline = true;
            if (caret) {
                this.printer.p('^');
            }
            int baseLevel = this.printer.level();
            this.printer.pln('{').incr();
            int level = 0;
            Iterator<String> codeIter = a.code.iterator();
            Iterator<Integer> indentIter = a.indent.iterator();
            while (codeIter.hasNext()) {
                int i;
                int newLevel = indentIter.next();
                int diff = newLevel - level;
                level = newLevel;
                if (0 < diff) {
                    for (i = 0; i < diff; ++i) {
                        this.printer.incr();
                    }
                } else {
                    for (i = 0; i > diff; --i) {
                        this.printer.decr();
                    }
                }
                this.printer.indent();
                this.print(codeIter.next());
                this.printer.pln();
            }
            this.printer.setLevel(baseLevel).indent().pln('}');
        }
    }

    public void visit(NodeMarker m) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('@').p(m.name).fit();
    }

    public void visit(Action a) {
        this.print(a, false);
    }

    public void visit(ParserAction pa) {
        this.print((Action)pa.element, true);
    }

    public void visit(ParseTreeNode n) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("Formatting([");
        Iterator<Binding> iter = n.predecessors.iterator();
        while (iter.hasNext()) {
            this.printer.p(iter.next().name);
            if (!iter.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("], ");
        if (null == n.node) {
            this.printer.p("null");
        } else {
            this.printer.p(n.node.name);
        }
        this.printer.p(", [");
        iter = n.successors.iterator();
        while (iter.hasNext()) {
            this.printer.p(iter.next().name);
            if (!iter.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("])").fit();
    }

    public void visit(NullLiteral l) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("null").fit();
    }

    public void visit(NullValue v) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = null; */").fit();
    }

    protected void format(boolean isToken, String text) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean hasComment = -1 != text.indexOf("*/");
        this.printer.buffer();
        if (hasComment) {
            this.printer.p("//");
            this.newline = true;
        } else {
            this.printer.p("/*");
            this.newline = false;
        }
        this.printer.p(" value = ");
        if (isToken) {
            this.printer.p("Token(");
        }
        this.printer.p('\"').escape(text, this.stringEscapes()).p('\"');
        if (isToken) {
            this.printer.p(')');
        }
        this.printer.p(';');
        if (!hasComment) {
            this.printer.p(" */");
        }
        this.printer.fit();
        if (hasComment) {
            this.printer.pln();
        }
    }

    public void visit(StringValue v) {
        if (null == v.text) {
            if (this.newline) {
                this.printer.indent();
            }
            this.newline = false;
            this.printer.buffer().p("/* value = <text>; */").fit();
        } else {
            this.format(false, v.text);
        }
    }

    public void visit(TokenValue v) {
        if (null == v.text) {
            if (this.newline) {
                this.printer.indent();
            }
            this.newline = false;
            this.printer.buffer().p("/* value = Token(<text>); */").fit();
        } else {
            this.format(true, v.text);
        }
    }

    public void visit(BindingValue v) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = ").p(v.binding.name).p("; */").fit();
    }

    public void visit(EmptyListValue v) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = []; */").fit();
    }

    public void visit(ProperListValue v) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = ");
        if (null == v.tail) {
            this.printer.p('[');
            boolean first = true;
            for (Binding b : v.elements) {
                if (first) {
                    first = false;
                } else {
                    this.printer.p(", ");
                }
                this.printer.p(b.name);
            }
            this.printer.p(']');
        } else {
            for (Binding b : v.elements) {
                this.printer.p(b.name).p(':');
            }
            this.printer.p(v.tail.name);
        }
        this.printer.p("; */").fit();
    }

    public void visit(ActionBaseValue v) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = Action.run(").p(v.list.name).p(", ").p(v.seed.name).p("); */").fit();
    }

    public void visit(GenericNodeValue v) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = ");
        if (0 < v.formatting.size()) {
            this.printer.p("Formatting([], ");
        }
        this.printer.p("GNode(").p(Utilities.unqualify(v.name)).p(", [");
        Iterator iter = v.children.iterator();
        while (iter.hasNext()) {
            this.printer.p(((Binding)iter.next()).name);
            if (!iter.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("])");
        if (0 < v.formatting.size()) {
            this.printer.p(", [");
            boolean first = true;
            for (Binding b : v.formatting) {
                if (first) {
                    first = false;
                } else {
                    this.printer.p(", ");
                }
                this.printer.p(b.name);
            }
            this.printer.p("])");
        }
        this.printer.p("; */").fit();
    }

    public void visit(GenericActionValue v) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = Action->");
        if (0 < v.formatting.size()) {
            this.printer.p("Formatting([], ");
        }
        this.printer.p("GNode(").p(Utilities.unqualify(v.name)).p(", [");
        Iterator iter = v.children.iterator();
        this.printer.p(v.first);
        if (iter.hasNext()) {
            this.printer.p(", ");
        }
        while (iter.hasNext()) {
            this.printer.p(((Binding)iter.next()).name);
            if (!iter.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("])");
        if (0 < v.formatting.size()) {
            this.printer.p(", [");
            boolean first = true;
            for (Binding b : v.formatting) {
                if (first) {
                    first = false;
                } else {
                    this.printer.p(", ");
                }
                this.printer.p(b.name);
            }
            this.printer.p("])");
        }
        this.printer.p("; */").fit();
    }

    public void visit(GenericRecursionValue v) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = Action->");
        if (0 < v.formatting.size()) {
            this.printer.p("Formatting([], ");
        }
        this.printer.p("GNode(").p(Utilities.unqualify(v.name)).p(", [");
        Iterator iter = v.children.iterator();
        this.printer.p(v.first);
        if (iter.hasNext()) {
            this.printer.p(", ");
        }
        while (iter.hasNext()) {
            this.printer.p(((Binding)iter.next()).name);
            if (!iter.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("])");
        if (0 < v.formatting.size()) {
            this.printer.p(", [");
            boolean first = true;
            for (Binding b : v.formatting) {
                if (first) {
                    first = false;
                } else {
                    this.printer.p(", ");
                }
                this.printer.p(b.name);
            }
            this.printer.p("])");
        }
        this.printer.p(':').p(v.list.name).p("; */").fit();
    }
}

