/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.IOException;
import java.util.List;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.InternalElement;

public class ParseTreeNode
extends Element
implements InternalElement {
    public List<Binding> predecessors;
    public Binding node;
    public List<Binding> successors;

    public ParseTreeNode(List<Binding> predecessors, Binding node, List<Binding> successors) {
        this.predecessors = predecessors;
        this.node = node;
        this.successors = successors;
    }

    @Override
    public Element.Tag tag() {
        return Element.Tag.PARSE_TREE_NODE;
    }

    public int hashCode() {
        return 49 * this.predecessors.hashCode() + 7 * this.successors.hashCode() + (null == this.node ? 0 : this.node.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParseTreeNode)) {
            return false;
        }
        ParseTreeNode other = (ParseTreeNode)o;
        return this.predecessors.equals(other.predecessors) && (null == this.node ? null == other.node : this.node.equals(other.node)) && this.successors.equals(other.successors);
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append("ParseTreeNode([");
        boolean first = true;
        for (Binding b : this.predecessors) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            out.append(b.name);
        }
        out.append("], ");
        if (null == this.node) {
            out.append("null");
        } else {
            out.append(this.node.name);
        }
        out.append(", [");
        first = true;
        for (Binding b : this.successors) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            out.append(b.name);
        }
        out.append("])");
    }
}

