/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.IOException;
import xtc.parser.Element;
import xtc.parser.ModuleMap;
import xtc.util.Utilities;

public class NonTerminal
extends Element {
    public final String name;

    public NonTerminal(String name) {
        this.name = name;
    }

    public NonTerminal(NonTerminal nt) {
        this.name = nt.name;
    }

    @Override
    public Element.Tag tag() {
        return Element.Tag.NONTERMINAL;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonTerminal)) {
            return false;
        }
        return this.name.equals(((NonTerminal)o).name);
    }

    public boolean isQualified() {
        return Utilities.isQualified(this.name);
    }

    public String getQualifier() {
        return Utilities.getQualifier(this.name);
    }

    public NonTerminal qualify(String module) {
        if (Utilities.isQualified(this.name)) {
            return this;
        }
        return new NonTerminal(Utilities.qualify(module, this.name));
    }

    public NonTerminal unqualify() {
        if (Utilities.isQualified(this.name)) {
            return new NonTerminal(Utilities.getName(this.name));
        }
        return this;
    }

    public NonTerminal rename(ModuleMap renaming) {
        String qualifier;
        if (Utilities.isQualified(this.name) && renaming.containsKey(qualifier = Utilities.getQualifier(this.name))) {
            NonTerminal original = this.hasProperty("xtc.Constants.Original") ? (NonTerminal)this.getProperty("xtc.Constants.Original") : this;
            NonTerminal replacement = new NonTerminal(Utilities.qualify(renaming.get(qualifier), Utilities.getName(this.name)));
            replacement.setProperty("xtc.Constants.Original", original);
            replacement.setLocation(this);
            return replacement;
        }
        return this;
    }

    public String toIdentifier() {
        return Utilities.toIdentifier(this.name);
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append(this.name);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

