/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import xtc.parser.ModuleList;
import xtc.parser.ModuleMap;
import xtc.parser.ModuleName;
import xtc.tree.Node;

public abstract class ModuleDependency
extends Node {
    public ModuleName module;
    public ModuleList arguments;
    public ModuleName target;

    public ModuleDependency(ModuleName module, ModuleList arguments, ModuleName target) {
        this.module = module;
        this.arguments = null == arguments ? new ModuleList(new ArrayList<ModuleName>(0)) : arguments;
        this.target = module.equals(target) ? null : target;
    }

    public int hashCode() {
        if (null == this.target) {
            return this.module.hashCode();
        }
        return this.target.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleDependency)) {
            return false;
        }
        ModuleDependency other = (ModuleDependency)o;
        if (!this.module.equals(other.module)) {
            return false;
        }
        if (null == this.target ? null != other.target : !this.target.equals(other.target)) {
            return false;
        }
        return this.arguments.equals(other.arguments);
    }

    public boolean isImport() {
        return false;
    }

    public boolean isInstantiation() {
        return false;
    }

    public boolean isModification() {
        return false;
    }

    public ModuleName visibleName() {
        return null == this.target ? this.module : this.target;
    }

    public boolean isConsistentWith(ModuleDependency dep) {
        return !this.visibleName().equals(dep.visibleName()) || this.equals(dep) || this.arguments.isEmpty() && null == this.target;
    }

    public ModuleDependency rename(ModuleMap renaming) {
        this.module = this.module.rename(renaming);
        this.arguments = this.arguments.rename(renaming);
        if (null != this.target) {
            this.target = this.target.rename(renaming);
        }
        return this;
    }
}

