/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FollowedBy;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericValue;
import xtc.parser.MetaData;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.TokenValue;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.type.Wildcard;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class MetaDataSetter
extends Visitor {
    public static final Pattern IMPORT = Pattern.compile("import\\s+(static\\s+)??(\\S+?)(\\.\\*)??;");
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected boolean withLocation;
    protected boolean hasParseTree;
    protected boolean requiresLocatable;
    protected boolean requiresChar;
    protected boolean requiresIndex;
    protected boolean requiresResult;
    protected boolean requiresPredIndex;
    protected boolean requiresPredResult;
    protected boolean requiresPredMatch;
    protected boolean requiresBaseIndex;
    protected List<Boolean> repetitions;
    protected List<Type> boundRepetitions;
    protected List<Type> options;
    protected boolean createsNodeValue;
    protected boolean isTopLevel;
    protected boolean isRepeated;
    protected boolean isOptional;
    protected boolean isFirstElement;
    protected boolean isBound;
    protected boolean isPredicate;
    protected boolean isNotFollowedBy;
    protected boolean isLastInPredicate;
    protected int repetitionLevel;
    protected int optionLevel;

    public MetaDataSetter(Runtime runtime, Analyzer analyzer, AST ast) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = ast;
    }

    protected void importType(String name) {
        this.ast.importType(name, Utilities.getName(name));
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        String pkg = Utilities.getQualifier(m.getClassName());
        if (null != pkg) {
            this.ast.importModule(pkg + ".");
        }
        this.importType("java.io.Reader");
        if (m.hasAttribute("main")) {
            this.importType("java.io.BufferedReader");
            this.importType("java.io.BufferedWriter");
            this.importType("java.io.File");
            this.importType("java.io.FileReader");
            this.importType("java.io.OutputStreamWriter");
        }
        this.importType("java.io.IOException");
        if (m.hasAttribute(Constants.ATT_PROFILE)) {
            this.importType("java.util.HashMap");
        }
        if (m.hasAttribute("setOfString")) {
            this.importType("java.util.HashSet");
            this.importType("java.util.Set");
        }
        if (m.getBooleanProperty("recursive")) {
            this.importType("xtc.util.Action");
        }
        this.importType("xtc.util.Pair");
        if (m.hasAttribute(Constants.ATT_WITH_LOCATION)) {
            this.importType("xtc.tree.Locatable");
        }
        if (m.getBooleanProperty("generic") || m.hasAttribute("main")) {
            this.importType("xtc.tree.Node");
        }
        if (m.getBooleanProperty("generic")) {
            if (m.hasAttribute("factory")) {
                String factory = (String)m.getAttributeValue("factory");
                if (Utilities.isQualified(factory)) {
                    this.importType(factory);
                }
            } else {
                this.importType("xtc.tree.GNode");
            }
        }
        if (m.hasAttribute(Constants.ATT_PARSE_TREE)) {
            this.importType("xtc.tree.Token");
            this.importType("xtc.tree.Formatting");
        }
        if (m.hasAttribute(Constants.ATT_VERBOSE) || m.hasAttribute("main") || m.hasAttribute(Constants.ATT_PROFILE) || m.hasAttribute(Constants.ATT_DUMP)) {
            this.importType("xtc.tree.Printer");
        }
        if (m.hasAttribute("printer")) {
            this.importType("xtc.tree.Visitor");
        }
        this.importType("xtc.parser.ParserBase");
        this.importType("xtc.parser.Column");
        this.importType("xtc.parser.Result");
        this.importType("xtc.parser.SemanticValue");
        this.importType("xtc.parser.ParseError");
        if (null != m.header) {
            for (String line : m.header.code) {
                Matcher matcher = IMPORT.matcher(line);
                if (!matcher.lookingAt()) continue;
                if (null == matcher.group(3)) {
                    String name = matcher.group(2);
                    try {
                        this.ast.importType(name, Utilities.getName(name));
                    }
                    catch (IllegalArgumentException x) {
                        this.runtime.error("inconsistent imports for '" + Utilities.getName(name) + "'", m.header);
                    }
                    continue;
                }
                if (null == matcher.group(1)) {
                    this.ast.importModule(matcher.group(2) + ".");
                    continue;
                }
                this.ast.importModule(matcher.group(2) + "$");
            }
        }
        this.withLocation = m.hasAttribute(Constants.ATT_WITH_LOCATION);
        this.hasParseTree = m.hasAttribute(Constants.ATT_PARSE_TREE);
        this.requiresLocatable = false;
        for (Production p : m.productions) {
            this.analyzer.process(p);
        }
        if (this.requiresLocatable) {
            m.setProperty("locatable", Boolean.TRUE);
        }
    }

    public void visit(Production p) {
        Type t;
        int i;
        MetaData md = (MetaData)p.getProperty("metaData");
        this.requiresChar = false;
        this.requiresIndex = false;
        this.requiresResult = false;
        this.requiresPredIndex = false;
        this.requiresPredResult = false;
        this.requiresPredMatch = false;
        this.requiresBaseIndex = false;
        this.repetitions = md.repetitions;
        this.boundRepetitions = md.boundRepetitions;
        this.options = md.options;
        this.createsNodeValue = false;
        this.isTopLevel = true;
        this.isRepeated = false;
        this.isOptional = false;
        this.isFirstElement = false;
        this.isBound = false;
        this.isPredicate = false;
        this.isNotFollowedBy = false;
        this.isLastInPredicate = false;
        this.repetitionLevel = 0;
        this.optionLevel = 0;
        this.dispatch(p.choice);
        if (this.withLocation && this.createsNodeValue && Constants.FuzzyBoolean.MAYBE == this.ast.hasLocation(p.type)) {
            this.requiresLocatable = true;
        }
        md.requiresChar = this.requiresChar;
        md.requiresIndex = this.requiresIndex;
        md.requiresResult = this.requiresResult;
        md.requiresPredIndex = this.requiresPredIndex;
        md.requiresPredResult = this.requiresPredResult;
        md.requiresPredMatch = this.requiresPredMatch;
        md.requiresBaseIndex = this.requiresBaseIndex;
        int size = this.boundRepetitions.size();
        for (i = 0; i < size; ++i) {
            t = this.boundRepetitions.get(i);
            if (null == t) continue;
            this.boundRepetitions.set(i, AST.listOf(this.ast.concretize(t, AST.ANY)));
        }
        size = this.options.size();
        for (i = 0; i < size; ++i) {
            t = this.options.get(i);
            if (null == t) continue;
            this.options.set(i, this.ast.concretize(t, AST.ANY));
        }
    }

    public void visit(OrderedChoice c) {
        boolean top = this.isTopLevel;
        this.isTopLevel = false;
        for (Sequence alt : c.alternatives) {
            if (top) {
                this.isFirstElement = true;
            }
            this.dispatch(alt);
        }
    }

    public void visit(Repetition r) {
        this.isTopLevel = false;
        boolean repeated = this.isRepeated;
        this.isRepeated = true;
        boolean optional = this.isOptional;
        this.isOptional = false;
        this.isFirstElement = false;
        boolean bound = this.isBound;
        this.isBound = false;
        ++this.repetitionLevel;
        if (this.repetitions.size() < this.repetitionLevel) {
            this.repetitions.add(Boolean.FALSE);
            this.boundRepetitions.add(null);
        }
        if (r.once) {
            this.repetitions.set(this.repetitionLevel - 1, Boolean.TRUE);
        }
        if (bound) {
            if (null == this.boundRepetitions.get(this.repetitionLevel - 1)) {
                this.boundRepetitions.set(this.repetitionLevel - 1, Wildcard.TYPE);
            }
            Binding b1 = Analyzer.getBinding(((Sequence)r.element).elements);
            Type t1 = this.analyzer.type(b1.element);
            Type unity = this.ast.unify(t1, this.boundRepetitions.get(this.repetitionLevel - 1), false);
            this.boundRepetitions.set(this.repetitionLevel - 1, unity);
        }
        this.dispatch(r.element);
        this.isRepeated = repeated;
        this.isOptional = optional;
        --this.repetitionLevel;
    }

    public void visit(Option o) {
        this.isTopLevel = false;
        boolean repeated = this.isRepeated;
        this.isRepeated = false;
        boolean optional = this.isOptional;
        this.isOptional = false;
        this.isFirstElement = false;
        boolean bound = this.isBound;
        this.isBound = false;
        ++this.optionLevel;
        if (this.options.size() < this.optionLevel) {
            this.options.add(null);
        }
        if (bound) {
            if (null == this.options.get(this.optionLevel - 1)) {
                this.options.set(this.optionLevel - 1, Wildcard.TYPE);
            }
            Binding b1 = Analyzer.getBinding(((Sequence)o.element).elements);
            Type t1 = this.analyzer.type(b1.element);
            Type unity = this.ast.unify(t1, this.options.get(this.optionLevel - 1), false);
            this.options.set(this.optionLevel - 1, unity);
        }
        this.dispatch(o.element);
        this.isRepeated = repeated;
        this.isOptional = optional;
        --this.optionLevel;
    }

    public void visit(Sequence s) {
        this.isTopLevel = false;
        boolean repeated = this.isRepeated;
        this.isRepeated = false;
        boolean optional = this.isOptional;
        this.isOptional = false;
        this.isBound = false;
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            this.isLastInPredicate = this.isPredicate && !repeated && !optional && i == size - 1;
            this.dispatch(s.get(i));
        }
        this.isRepeated = repeated;
        this.isOptional = optional;
    }

    public void visit(FollowedBy p) {
        this.isTopLevel = false;
        this.isBound = false;
        boolean first = this.isFirstElement;
        this.isPredicate = true;
        this.isNotFollowedBy = false;
        this.dispatch(p.element);
        this.isPredicate = false;
        this.isFirstElement = first;
    }

    protected boolean isNotFollowedBy() {
        return this.isPredicate && this.isNotFollowedBy;
    }

    public void visit(NotFollowedBy p) {
        this.isTopLevel = false;
        this.isBound = false;
        this.requiresPredMatch = true;
        boolean first = this.isFirstElement;
        this.isPredicate = true;
        this.isNotFollowedBy = true;
        this.dispatch(p.element);
        this.isPredicate = false;
        this.isFirstElement = first;
    }

    public void visit(SemanticPredicate p) {
        this.isTopLevel = false;
        this.isBound = false;
        this.dispatch(p.element);
    }

    public void visit(VoidedElement v) {
        this.isTopLevel = false;
        this.isBound = false;
        this.dispatch(v.element);
    }

    public void visit(Binding b) {
        this.isTopLevel = false;
        this.isBound = true;
        this.dispatch(b.element);
    }

    public void visit(StringMatch m) {
        this.isTopLevel = false;
        this.isBound = false;
        if (!(this.isNotFollowedBy() || this.runtime.test("optimizeErrors1") && this.isFirstElement)) {
            this.requiresBaseIndex = true;
        }
        this.isFirstElement = false;
        this.dispatch(m.element);
    }

    public void visit(NonTerminal nt) {
        this.isTopLevel = false;
        this.isFirstElement = false;
        this.isBound = false;
        if (this.isPredicate) {
            this.requiresPredResult = true;
        } else {
            this.requiresResult = true;
        }
    }

    public void visit(AnyChar a) {
        this.isTopLevel = false;
        this.isFirstElement = false;
        this.isBound = false;
        this.requiresChar = true;
        if (this.isPredicate) {
            if (!this.isLastInPredicate) {
                this.requiresPredIndex = true;
            }
        } else {
            this.requiresIndex = true;
        }
    }

    public void visit(StringLiteral l) {
        this.isTopLevel = false;
        this.isBound = false;
        if (!(this.isNotFollowedBy() || this.runtime.test("optimizeErrors1") && this.isFirstElement)) {
            this.requiresBaseIndex = true;
        }
        this.isFirstElement = false;
        this.requiresChar = true;
        if (this.isPredicate) {
            if (!this.isLastInPredicate || 1 < l.text.length()) {
                this.requiresPredIndex = true;
            }
        } else {
            this.requiresIndex = true;
        }
    }

    public void visit(CharCase c) {
        if (null != c.element) {
            this.dispatch(c.element);
        }
    }

    public void visit(CharSwitch s) {
        this.isTopLevel = false;
        this.isFirstElement = false;
        this.isBound = false;
        this.requiresChar = true;
        if (this.isPredicate) {
            if (!this.isLastInPredicate) {
                this.requiresPredIndex = true;
            }
        } else {
            this.requiresIndex = true;
        }
        for (CharCase kase : s.cases) {
            this.dispatch(kase);
        }
        this.dispatch(s.base);
    }

    public void visit(Terminal t) {
        this.isTopLevel = false;
        this.isFirstElement = false;
        this.isBound = false;
        this.requiresChar = true;
        if (this.isPredicate) {
            if (!this.isLastInPredicate) {
                this.requiresPredIndex = true;
            }
        } else {
            this.requiresIndex = true;
        }
    }

    public void visit(Action a) {
        if (a.setsValue()) {
            this.createsNodeValue = true;
        }
        this.isTopLevel = false;
        this.isBound = false;
    }

    public void visit(ParserAction pa) {
        this.createsNodeValue = true;
        this.isTopLevel = false;
        this.isFirstElement = false;
        this.isBound = false;
        this.requiresBaseIndex = true;
    }

    protected boolean hasDirectLocation() {
        return this.withLocation && this.runtime.test("optimizeLocation") && AST.isNode(this.analyzer.current().type);
    }

    public void visit(TokenValue v) {
        if (!this.hasDirectLocation()) {
            this.createsNodeValue = true;
        }
        this.isTopLevel = false;
        this.isBound = false;
    }

    public void visit(ActionBaseValue v) {
        this.isTopLevel = false;
        this.isBound = false;
    }

    public void visit(GenericValue v) {
        this.isTopLevel = false;
        this.isBound = false;
    }

    public void visit(GenericActionValue v) {
        if (!this.hasDirectLocation()) {
            this.createsNodeValue = true;
        }
        this.isTopLevel = false;
        this.isBound = false;
    }

    public void visit(Element e) {
        this.isTopLevel = false;
        this.isBound = false;
    }
}

