/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FullProduction;
import xtc.parser.Module;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Sequence;
import xtc.parser.ValueElement;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.type.Wildcard;
import xtc.util.Runtime;

public class ListMaker
extends Visitor {
    public static final String MARKER = "l";
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected Type element;
    protected List<Element> elements;

    public ListMaker(Runtime runtime, Analyzer analyzer, AST ast) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = ast;
        this.elements = new ArrayList<Element>();
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        this.elements.clear();
        for (Production p : m.productions) {
            if (!AST.isList(p.type)) continue;
            this.element = this.runtime.test("optionVariant") && AST.isDynamicNode(AST.getArgument(p.type)) ? Wildcard.TYPE : null;
            this.analyzer.process(p);
            if (null == this.element || this.element.isError()) continue;
            p.type = AST.listOf(this.ast.concretize(this.element, AST.NULL_NODE));
        }
    }

    public void visit(FullProduction p) {
        this.dispatch(p.choice);
    }

    public void visit(OrderedChoice c) {
        for (Sequence alt : c.alternatives) {
            this.dispatch(alt);
        }
    }

    public void visit(Sequence s) {
        Element e;
        int base = this.elements.size();
        Iterator<Element> iter = s.elements.iterator();
        while (iter.hasNext()) {
            Element e2 = iter.next();
            if (!iter.hasNext() && e2 instanceof OrderedChoice) {
                this.dispatch(e2);
                continue;
            }
            this.elements.add(e2);
        }
        if (!s.hasTrailingChoice() && !Analyzer.setsValue(this.elements, false)) {
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            for (int i = 0; i < this.elements.size(); ++i) {
                e = this.elements.get(i);
                if (e instanceof Binding) {
                    bindings.add((Binding)e);
                    continue;
                }
                if (!this.analyzer.isBindable(e)) continue;
                Binding b = new Binding(this.analyzer.variable(MARKER), e);
                this.elements.set(i, b);
                bindings.add(b);
            }
            if (null != this.element && !this.element.isError()) {
                for (Binding b : bindings) {
                    Type u;
                    Type t = this.analyzer.type(b.element);
                    if (AST.isList(t)) {
                        t = AST.getArgument(t);
                    }
                    if ((u = this.ast.unify(this.element, t, true)).isError()) {
                        this.runtime.error("unable to determine consistent list element type", s);
                        this.runtime.errConsole().loc(s).p(": error: 1st type is '");
                        this.ast.print(this.element, this.runtime.errConsole(), false, true, null);
                        this.runtime.errConsole().pln("'");
                        this.runtime.errConsole().loc(s).p(": error: 2nd type is '");
                        this.ast.print(t, this.runtime.errConsole(), false, true, null);
                        this.runtime.errConsole().pln("'").flush();
                    }
                    this.element = u;
                }
            }
            if (bindings.isEmpty()) {
                s.add(EmptyListValue.VALUE);
            } else if (1 == bindings.size() && AST.isList(this.analyzer.type(((Binding)bindings.get((int)0)).element))) {
                Binding b = (Binding)bindings.get(0);
                if (Analyzer.isSynthetic(b.name)) {
                    b.name = "yyValue";
                } else {
                    s.add(new BindingValue(b));
                }
            } else {
                Binding last = (Binding)bindings.get(bindings.size() - 1);
                if (AST.isList(this.analyzer.type(last.element))) {
                    bindings.remove(bindings.size() - 1);
                    s.add(new ProperListValue(this.analyzer.current().type, bindings, last));
                } else {
                    s.add(new ProperListValue(this.analyzer.current().type, bindings, null));
                }
            }
        }
        int size = s.size();
        if (s.hasTrailingChoice() || 0 != size && s.get(size - 1) instanceof ValueElement) {
            --size;
        }
        for (int i = 0; i < size; ++i) {
            e = this.elements.get(base + i);
            if (s.get(i) == e) continue;
            s.elements.set(i, e);
        }
        if (0 == base) {
            this.elements.clear();
        } else {
            this.elements.subList(base, this.elements.size()).clear();
        }
    }
}

