/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Set;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.UnaryOperator;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;
import xtc.util.Runtime;

public class LeftRecurser
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean terminated;

    public LeftRecurser(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    public Set<NonTerminal> recursive() {
        return new HashSet<NonTerminal>(this.analyzer.marked());
    }

    public void visit(Grammar g) {
        this.analyzer.register(this);
        this.analyzer.init(g);
        for (Module m : g.modules) {
            this.analyzer.process(m);
            for (Production p : m.productions) {
                if (!p.isFull() || this.analyzer.isProcessed(p.qName)) continue;
                this.terminated = false;
                this.analyzer.process(p);
            }
        }
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            if (this.analyzer.isProcessed(p.qName)) continue;
            this.terminated = false;
            this.analyzer.process(p);
        }
    }

    public void visit(FullProduction p) {
        Object closure = this.analyzer.enter(p);
        this.analyzer.workingOn(p.qName);
        if ((this.runtime.test("optimizeLeftRecursions") || this.runtime.test("optimizeLeftIterations")) && DirectLeftRecurser.isTransformable(p)) {
            for (Sequence alt : p.choice.alternatives) {
                if (!DirectLeftRecurser.isBase(alt, p)) continue;
                this.dispatch(alt);
            }
        } else {
            this.dispatch(p.choice);
        }
        this.analyzer.notWorkingOn(p.qName);
        this.analyzer.exit(closure);
        this.analyzer.processed(p.qName);
    }

    public void visit(OrderedChoice c) {
        boolean more = false;
        for (Sequence alt : c.alternatives) {
            this.terminated = false;
            this.dispatch(alt);
            if (this.terminated) continue;
            more = true;
        }
        if (more) {
            this.terminated = false;
        }
    }

    public void visit(Repetition r) {
        this.dispatch(r.element);
        if (!r.once) {
            this.terminated = false;
        }
    }

    public void visit(Sequence s) {
        for (Element e : s.elements) {
            this.dispatch(e);
            if (!this.terminated) continue;
            break;
        }
    }

    public void visit(VoidedElement v) {
        this.dispatch(v.element);
    }

    public void visit(Binding b) {
        this.dispatch(b.element);
    }

    public void visit(StringMatch m) {
        this.dispatch(m.element);
    }

    public void visit(NonTerminal nt) {
        FullProduction p;
        try {
            p = this.analyzer.lookup(nt);
        }
        catch (IllegalArgumentException x) {
            this.terminated = true;
            return;
        }
        if (null != p) {
            if (this.analyzer.isBeingWorkedOn(p.qName)) {
                this.analyzer.mark(p.qName);
                p.setProperty("recursive", Boolean.TRUE);
                this.terminated = true;
            } else if (!this.analyzer.isProcessed(p.qName)) {
                this.dispatch(p);
            } else {
                this.terminated = true;
            }
        } else {
            this.terminated = true;
        }
    }

    public void visit(Terminal t) {
        this.terminated = true;
    }

    public void visit(UnaryOperator op) {
        this.dispatch(op.element);
        this.terminated = false;
    }

    public void visit(ParserAction pa) {
        this.dispatch(pa.element);
        this.terminated = true;
    }

    public void visit(Element e) {
    }
}

