/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CostEstimator;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.Production;
import xtc.type.AST;
import xtc.util.Runtime;

public class Inliner
extends GrammarVisitor {
    public static final int MAX_COST = 1;
    public static final boolean INLINE_PERSISTENT = true;
    protected boolean attributeState;
    protected boolean inlined;

    public Inliner(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    protected boolean isBasic(Production p) {
        return AST.isVoid(p.type) || p.getBooleanProperty("textOnly") || p.getBooleanProperty("token");
    }

    protected void inlined(Production p) {
        this.inlined = true;
        if (this.runtime.test("optionVerbose")) {
            System.err.println("[Inlining " + p.qName + " into " + this.analyzer.current().qName + "]");
        }
    }

    @Override
    public Object visit(Module m) {
        CostEstimator cost = null;
        boolean changed = false;
        if (this.runtime.test("optimizeCost")) {
            cost = new CostEstimator(this.analyzer);
        }
        do {
            if (this.runtime.test("optimizeCost")) {
                cost.dispatch(m);
            }
            this.analyzer.register(this);
            this.analyzer.init(m);
            this.attributeState = m.hasAttribute(Constants.ATT_STATEFUL.getName());
            this.inlined = false;
            for (Production p : m.productions) {
                this.analyzer.process(p);
            }
            if (!this.inlined) continue;
            changed = true;
        } while (this.inlined);
        return changed ? Boolean.TRUE : Boolean.FALSE;
    }

    public Element visit(NonTerminal nt) {
        boolean bound = this.isBound;
        this.isBound = false;
        FullProduction p = this.analyzer.lookup(nt);
        if (Generifier.isGeneric(p) || AST.isList(p.type) || p.hasAttribute(Constants.ATT_EXPLICIT) || this.attributeState && (p.hasAttribute(Constants.ATT_STATEFUL) || p.hasAttribute(Constants.ATT_RESETTING))) {
            return nt;
        }
        Element e = Analyzer.strip(p.choice);
        if (e instanceof NonTerminal) {
            if (!p.isMemoized() && !p.hasAttribute(Constants.ATT_NO_INLINE)) {
                this.inlined(p);
                NonTerminal copy = new NonTerminal((NonTerminal)e);
                copy.setLocation(nt);
                return copy;
            }
            return nt;
        }
        if (e instanceof Binding) {
            Binding b = (Binding)e;
            Element e2 = Analyzer.strip(b.element);
            if ("yyValue".equals(b.name) && e2 instanceof NonTerminal) {
                if (!p.isMemoized() && !p.hasAttribute(Constants.ATT_NO_INLINE)) {
                    this.inlined(p);
                    NonTerminal copy = new NonTerminal((NonTerminal)e2);
                    copy.setLocation(nt);
                    return copy;
                }
                return nt;
            }
        }
        if (!this.isBasic(this.analyzer.current()) || bound) {
            return nt;
        }
        if (this.runtime.test("optimizeCost") && 1 >= (Integer)p.getProperty("cost") && !p.hasAttribute(Constants.ATT_NO_INLINE)) {
            this.inlined(p);
            return this.analyzer.copy(p.choice);
        }
        return nt;
    }
}

