/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleName;
import xtc.parser.NonTerminal;
import xtc.parser.PrettyPrinter;
import xtc.parser.Production;
import xtc.parser.Properties;
import xtc.parser.SequenceName;
import xtc.parser.StringValue;
import xtc.parser.TokenValue;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.VisitingException;
import xtc.type.AST;
import xtc.util.Runtime;

public class HtmlPrinter
extends PrettyPrinter {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean isGrammar;
    protected int pNumber = -1;

    public HtmlPrinter(Runtime runtime, Analyzer analyzer, AST ast, boolean verbose) {
        super(ast, verbose);
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    @Override
    protected int stringEscapes() {
        return 24;
    }

    @Override
    protected int regexEscapes() {
        return 28;
    }

    protected void open(String name) throws IOException {
        File file = new File(this.runtime.getOutputDirectory(), name);
        this.printer = new Printer(new PrintWriter(this.runtime.getWriter(file)));
    }

    @Override
    protected void printDocumentation(Module m) {
        Comment c = m.documentation;
        if (!this.verbose || null == c || c.text.isEmpty()) {
            return;
        }
        this.printer.indent().pln("<div class=\"module-documentation\">");
        ArrayList<String> authors = null;
        String version = null;
        for (String s : c.text) {
            if (s.startsWith("@")) {
                if (s.startsWith("@author ")) {
                    if (null == authors) {
                        authors = new ArrayList<String>();
                    }
                    authors.add(s.substring(8));
                    continue;
                }
                if (!s.startsWith("@version ")) continue;
                version = s.substring(9);
                continue;
            }
            this.printer.indent().pln(s);
        }
        if (null != authors || null != version) {
            this.printer.indent().pln("<dl>");
            if (null != authors) {
                if (1 == authors.size()) {
                    this.printer.indent().pln("<dt>Author:</dt>").incr();
                } else {
                    this.printer.indent().pln("<dt>Authors:</dt>").incr();
                }
                this.printer.indent().p("<dd>");
                Iterator iter = authors.iterator();
                while (iter.hasNext()) {
                    this.printer.p((String)iter.next());
                    if (!iter.hasNext()) continue;
                    this.printer.p(", ");
                }
                this.printer.pln("</dd>").decr();
            }
            if (null != version) {
                this.printer.indent().pln("<dt>Version:</dt>").incr();
                this.printer.indent().p("<dd>").p(version).pln("</dd>").decr();
            }
            this.printer.indent().pln("</dl>");
        }
        this.printer.indent().pln("</div>");
    }

    @Override
    protected void printOption(Module m) {
        if (null != m.attributes && 0 < m.attributes.size()) {
            this.printer.pln().indent().p("option ");
            boolean isFirst = true;
            Iterator<Attribute> iter = m.attributes.iterator();
            while (iter.hasNext()) {
                int column;
                boolean highlight;
                Attribute att = iter.next();
                String name = att.getName();
                String attText = att.toString();
                boolean bl = highlight = this.analyzer.isTopLevel(m) || Constants.ATT_STATEFUL.getName().equals(name) || "setOfString".equals(name) || "flag".equals(name);
                if (isFirst) {
                    isFirst = false;
                } else if (this.printer.column() + attText.length() + 1 > 78) {
                    this.printer.pln().indentMore();
                }
                if (highlight) {
                    column = this.printer.column();
                    this.printer.p("<span class=\"highlight\">").column(column);
                }
                this.printer.p(attText);
                if (highlight) {
                    column = this.printer.column();
                    this.printer.p("</span>").column(column);
                }
                if (iter.hasNext()) {
                    this.printer.p(", ");
                    continue;
                }
                this.printer.p(';');
            }
            this.printer.pln();
        }
    }

    protected void print(Module m) {
        this.printer.indent().pln("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"");
        this.printer.indent().p("                      ").pln("\"http://www.w3.org/TR/html4/strict.dtd\">");
        this.printer.indent().pln("<html>");
        this.printer.indent().pln("<head>");
        this.printer.indent().p("<!-- Generated by Rats!, version ").p("1.15.0").p(", ").p("(C) 2004-2009 Robert Grimm").pln(" -->");
        this.printer.indent().p("<title>Module ").p(m.name).pln("</title>");
        this.printer.indent().p("<link rel=\"stylesheet\" href=\"grammar.css\" ").pln("type=\"text/css\">");
        this.printer.indent().pln("</head>");
        this.printer.indent().pln("<body>");
        this.printDocumentation(m);
        this.printer.indent().pln("<pre class=\"module-header\">");
        this.printModule(m);
        if (null != m.dependencies && 0 < m.dependencies.size()) {
            this.printer.pln();
            for (ModuleDependency dep : m.dependencies) {
                this.printer.p(dep);
            }
        }
        this.printActions(m);
        this.printOption(m);
        this.printer.indent().pln("</pre>");
        int length = m.productions.size();
        for (int i = 0; i < length; ++i) {
            this.pNumber = i;
            this.printer.p(m.productions.get(i));
        }
        this.printer.indent().pln("</body>");
    }

    @Override
    public void visit(Grammar g) {
        this.analyzer.register(this);
        this.analyzer.init(g);
        this.isGrammar = true;
        for (Module m : g.modules) {
            try {
                this.open(m.name + ".html");
            }
            catch (IOException x) {
                throw new VisitingException("Unable to access " + m.name + ".html", x);
            }
            this.printer.register(this);
            this.analyzer.process(m);
            this.print(m);
            this.printer.flush();
        }
    }

    @Override
    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        this.isGrammar = false;
        try {
            this.open(m.name + ".html");
        }
        catch (IOException x) {
            throw new VisitingException("Unable to access " + m.name + ".html", x);
        }
        this.printer.register(this);
        this.print(m);
        this.printer.flush();
    }

    protected void print(ModuleName name, boolean resolved) {
        int column;
        if (resolved) {
            column = this.printer.column();
            this.printer.p("<a href=\"").p(name.name).p(".html\">").column(column).p(name.name);
        } else {
            column = this.printer.column();
            this.printer.p("<a class=\"erroneous\" href=\"#\" title=\"Undefined module\">").column(column).p(name.name);
        }
        column = this.printer.column();
        this.printer.p("</a>").column(column);
    }

    @Override
    protected void print(ModuleDependency dep, String name) {
        Module m = this.analyzer.lookup(dep.visibleName());
        this.printer.indent().p(name).p(' ');
        if (!(null != dep.target || null == m && "instantiate".equals(name))) {
            this.print(dep.module, null != m);
        } else {
            this.printer.p(dep.module);
        }
        if (0 != dep.arguments.size()) {
            this.printer.p(dep.arguments);
        }
        if (!(null == dep.target || null == m && "instantiate".equals(name))) {
            this.print(dep.target, null != m);
        } else {
            this.printer.p(dep.target);
        }
        this.printer.pln(';');
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void enter(Production p) {
        if (this.verbose && p.hasProperty("duplicates")) {
            List<String> sources = Properties.getDuplicates(p);
            this.printer.indent().pln("<div class=\"production-documentation\">");
            this.printer.indent().p("The following production is the result of ").p("folding duplicates ");
            Iterator<String> iterator = sources.iterator();
            while (iterator.hasNext()) {
                String name = iterator.next();
                this.printer.buffer();
                if (1 < sources.size() && !iterator.hasNext()) {
                    this.printer.p("and ");
                }
                this.printer.p(name);
                if (2 == sources.size() && iterator.hasNext()) {
                    this.printer.p(' ');
                } else if (iterator.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p('.');
                }
                this.printer.fit();
            }
            this.printer.pln();
            this.printer.indent().pln("</div>");
        }
        this.printer.indent().pln("<pre class=\"production-body\">");
        this.printer.indent();
        if (p.isFull()) {
            this.printer.p("<a name=\"").p(p.name.name).p("\"></a>");
        } else {
            this.printer.p("<a name=\"").p(p.name.name).p('-').p(this.pNumber).p("\"></a>");
        }
        if (null != p.attributes && 0 < p.attributes.size()) {
            for (Node node : p.attributes) {
                this.printer.p(node).p(' ');
            }
        }
        if (null != p.type) {
            if (AST.isVoid(p.type)) {
                this.printer.p("void ");
            } else if (AST.isGenericNode(p.type)) {
                this.printer.p("generic ");
            } else {
                this.printer.p(this.ast.extern(p.type)).p(' ');
            }
        } else if (null != p.dType) {
            this.printer.p(p.dType).p(' ');
        }
        if (p.isPartial()) {
            void var3_9;
            boolean duplicate = false;
            Object var3_7 = null;
            try {
                FullProduction fullProduction = this.analyzer.lookup(p.name.qualify(this.analyzer.currentModule().name.name));
            }
            catch (IllegalArgumentException x) {
                duplicate = true;
            }
            if (null == var3_9) {
                this.printer.p("<a class=\"erroneous\" href=\"#\" title=\"");
                if (duplicate) {
                    this.printer.p("Ambiguous nonterminal");
                } else {
                    this.printer.p("Undefined nonterminal");
                }
            } else {
                Module m = this.analyzer.currentModule();
                String q = var3_9.qName.getQualifier();
                if (q.equals(m.name.name)) {
                    this.printer.p("<a href=\"#").p(p.name.name);
                } else {
                    this.printer.p("<a href=\"").p(q).p(".html#").p(p.name.name);
                }
            }
            this.printer.p("\">").p(p.name.name).p("</a>");
        } else {
            this.printer.p(p.name.name);
        }
        this.parenChoice = false;
        this.parenSequence = false;
    }

    @Override
    protected void exit(Production p) {
        this.printer.indent().pln("</pre>");
    }

    @Override
    public void visit(SequenceName n) {
        this.printer.p("&lt;").p(n.name).p("&gt;");
        this.printer.column(this.printer.column() - 6);
    }

    @Override
    public void visit(NonTerminal nt) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer();
        int column = this.printer.column();
        boolean duplicate = false;
        FullProduction p = null;
        try {
            p = this.analyzer.lookup(nt);
        }
        catch (IllegalArgumentException x) {
            duplicate = true;
        }
        if (null == p) {
            this.printer.p("<a class=\"erroneous\" href=\"#\" title=\"");
            if (duplicate) {
                this.printer.p("Ambiguous nonterminal");
            } else {
                this.printer.p("Undefined nonterminal");
            }
        } else if (this.isGrammar) {
            Module m = this.analyzer.currentModule();
            String q = p.qName.getQualifier();
            if (q.equals(m.name.name)) {
                this.printer.p("<a href=\"#").p(p.name.name);
            } else {
                this.printer.p("<a href=\"").p(q).p(".html#").p(p.name.name);
            }
        } else {
            this.printer.p("<a href=\"#").p(nt.name);
        }
        this.printer.p("\">").column(column).p(nt.name);
        column = this.printer.column();
        this.printer.p("</a>").column(column).fit();
    }

    @Override
    protected void print(String s) {
        int column = this.printer.column();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if ('<' == c) {
                this.printer.p("&lt;");
                continue;
            }
            if ('>' == c) {
                this.printer.p("&gt;");
                continue;
            }
            this.printer.p(c);
        }
        this.printer.column(column + length);
    }

    @Override
    public void visit(StringValue v) {
        if (null == v.text) {
            if (this.newline) {
                this.printer.indent();
            }
            this.newline = false;
            this.printer.buffer().p("/* value = &lt;text&gt;; */").column(this.printer.column() - 6).fit();
        } else {
            this.format(false, v.text);
        }
    }

    @Override
    public void visit(TokenValue v) {
        if (null == v.text) {
            if (this.newline) {
                this.printer.indent();
            }
            this.newline = false;
            this.printer.buffer().p("/* value = Token(&lt;text&gt;); */").column(this.printer.column() - 6).fit();
        } else {
            this.format(true, v.text);
        }
    }
}

