/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;
import xtc.util.Runtime;

public abstract class GrammarVisitor
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean isTopLevel;
    protected boolean isVoided;
    protected boolean isBound;
    protected boolean isLastElement;
    protected boolean isPredicate;
    protected boolean isRepeatedOnce;
    protected boolean needsSequence;
    protected boolean transformInPlace;

    public GrammarVisitor(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    public Object visit(Grammar g) {
        this.analyzer.register(this);
        this.analyzer.init(g);
        for (Module m : g.modules) {
            this.analyzer.process(m);
            for (Production p : m.productions) {
                this.analyzer.process(p);
            }
        }
        return null;
    }

    public Object visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            this.analyzer.process(p);
        }
        return null;
    }

    public Production visit(Production p) {
        Object closure = this.analyzer.enter(p);
        this.isTopLevel = true;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.isPredicate = false;
        this.isRepeatedOnce = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        p.choice = (OrderedChoice)this.dispatch(p.choice);
        this.analyzer.exit(closure);
        return p;
    }

    public Element visit(OrderedChoice c) {
        boolean top = this.isTopLevel;
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        boolean last = this.isLastElement;
        this.transformInPlace = false;
        int length = c.alternatives.size();
        for (int i = 0; i < length; ++i) {
            this.isLastElement = top || last;
            this.needsSequence = true;
            c.alternatives.set(i, (Sequence)this.dispatch(c.alternatives.get(i)));
        }
        this.isLastElement = false;
        this.needsSequence = false;
        return c;
    }

    public Element visit(Repetition r) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        boolean rep = this.isRepeatedOnce;
        this.isRepeatedOnce = r.once;
        this.needsSequence = false;
        this.transformInPlace = false;
        r.element = (Element)this.dispatch(r.element);
        this.isRepeatedOnce = rep;
        return r;
    }

    public Element visit(Option o) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        o.element = (Element)this.dispatch(o.element);
        return o;
    }

    public Element visit(Sequence s) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        boolean last = this.isLastElement;
        this.needsSequence = false;
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            this.isLastElement = last && i == size - 1;
            s.elements.set(i, (Element)this.dispatch(s.get(i)));
        }
        this.isLastElement = false;
        return s;
    }

    public Element visit(Predicate p) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        boolean seq = this.needsSequence;
        this.needsSequence = true;
        this.transformInPlace = false;
        boolean pred = this.isPredicate;
        this.isPredicate = true;
        p.element = (Element)this.dispatch(p.element);
        this.isPredicate = pred;
        this.needsSequence = seq;
        return p;
    }

    public Element visit(SemanticPredicate p) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        p.element = (Element)this.dispatch(p.element);
        return p;
    }

    public Element visit(VoidedElement v) {
        this.isTopLevel = false;
        this.isVoided = true;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        v.element = (Element)this.dispatch(v.element);
        return v;
    }

    public Element visit(Binding b) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = true;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        b.element = (Element)this.dispatch(b.element);
        return b;
    }

    public Element visit(StringMatch m) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = true;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        m.element = (Element)this.dispatch(m.element);
        return m;
    }

    public CharCase visit(CharCase c) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        c.element = (Element)this.dispatch(c.element);
        return c;
    }

    public Element visit(CharSwitch s) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        int length = s.cases.size();
        for (int i = 0; i < length; ++i) {
            s.cases.set(i, (CharCase)this.dispatch(s.cases.get(i)));
        }
        s.base = (Element)this.dispatch(s.base);
        return s;
    }

    public Element visit(ParserAction pa) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        pa.element = (Element)this.dispatch(pa.element);
        return pa;
    }

    public Element visit(Element e) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        return e;
    }
}

