/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.List;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GenericNodeValue;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.Production;
import xtc.parser.Properties;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class Generifier
extends Visitor {
    public static final String MARKER = "g";
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected List<Binding> children;
    protected List<NodeMarker> markers;

    public Generifier(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.children = new ArrayList<Binding>();
        this.markers = new ArrayList<NodeMarker>();
    }

    protected Binding bind(Element e) {
        Binding b = new Binding(this.analyzer.variable(MARKER), e);
        this.children.add(b);
        return b;
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            if (!Generifier.isGenericNode((FullProduction)p)) continue;
            this.analyzer.process(p);
        }
    }

    public void visit(FullProduction p) {
        p.choice = (OrderedChoice)this.dispatch(p.choice);
        if (AST.isDynamicNode(p.type)) {
            p.type = AST.NODE;
        }
        Generifier.markGenericNode(p, this.runtime.test("optionVerbose"));
    }

    public Element visit(OrderedChoice c) {
        int size = c.alternatives.size();
        for (int i = 0; i < size; ++i) {
            Sequence alternative = c.alternatives.get(i);
            if (Analyzer.setsValue(alternative, true)) continue;
            c.alternatives.set(i, (Sequence)this.dispatch(alternative));
        }
        return c;
    }

    public Element visit(Repetition r) {
        return this.bind(r);
    }

    public Element visit(Option o) {
        return this.bind(o);
    }

    public Element visit(Sequence s) {
        int base = this.children.size();
        int base2 = this.markers.size();
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            s.elements.set(i, (Element)this.dispatch(s.get(i)));
        }
        if (!s.hasTrailingChoice()) {
            String name = this.analyzer.current().qName.name;
            if (!this.markers.isEmpty()) {
                name = Utilities.qualify(Utilities.getQualifier(name), this.markers.get((int)(this.markers.size() - 1)).name);
            }
            List<Binding> formatting = s.hasProperty("formatting") ? Properties.getFormatting(s) : new ArrayList<Binding>(0);
            s.add(new GenericNodeValue(name, new ArrayList<Binding>(this.children), formatting));
        }
        if (0 == base) {
            this.children.clear();
        } else {
            this.children.subList(base, this.children.size()).clear();
        }
        if (0 == base2) {
            this.markers.clear();
        } else {
            this.markers.subList(base2, this.markers.size()).clear();
        }
        return s;
    }

    public Element visit(Binding b) {
        this.children.add(b);
        return b;
    }

    public Element visit(StringMatch m) {
        return this.bind(m);
    }

    public Element visit(NonTerminal nt) {
        FullProduction p = this.analyzer.lookup(nt);
        if (AST.isVoid(p.type)) {
            return nt;
        }
        return this.bind(nt);
    }

    public Element visit(StringLiteral l) {
        return this.bind(l);
    }

    public Element visit(ParseTreeNode n) {
        return this.bind(n);
    }

    public Element visit(NullLiteral l) {
        return this.bind(l);
    }

    public Element visit(NodeMarker m) {
        this.markers.add(m);
        return m;
    }

    public Element visit(Element e) {
        return e;
    }

    public static void markGenericNode(FullProduction p, boolean verbose) {
        if (verbose) {
            System.err.println("[Recognizing " + p.qName + " as generic node]");
        }
        p.setProperty("generic", "node");
    }

    public static void markGenericRecursion(FullProduction p, boolean verbose) {
        if (verbose) {
            System.err.println("[Recognizing " + p.qName + " as generic recursion]");
        }
        p.setProperty("generic", "recursion");
    }

    public static boolean isGeneric(FullProduction p) {
        if (p.hasProperty("generic")) {
            Object value = p.getProperty("generic");
            return "node".equals(value) || "recursion".equals(value);
        }
        return AST.isGenericNode(p.type);
    }

    public static boolean isGenericNode(FullProduction p) {
        if (p.hasProperty("generic")) {
            return "node".equals(p.getProperty("generic"));
        }
        return AST.isGenericNode(p.type) && !DirectLeftRecurser.isTransformable(p);
    }

    public static boolean isGenericRecursion(FullProduction p) {
        if (p.hasProperty("generic")) {
            return "recursion".equals(p.getProperty("generic"));
        }
        return AST.isGenericNode(p.type) && DirectLeftRecurser.isTransformable(p);
    }
}

