/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.parser.ActionBaseValue;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.GenericValue;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.UnaryOperator;
import xtc.tree.Attribute;
import xtc.tree.Visitor;

public class EquivalenceTester
extends Visitor {
    protected Map<String, String> nts = new HashMap<String, String>();
    protected Map<String, String> vars = new HashMap<String, String>();
    protected Element e2;

    public boolean areEquivalent(Production p1, Production p2) {
        if (!Attribute.areEquivalent(p1.attributes, p2.attributes)) {
            return false;
        }
        if (null == p1.type ? !p1.dType.equals(p2.dType) : !p1.type.equals(p2.type)) {
            return false;
        }
        this.nts.put(p2.name.name, p1.name.name);
        boolean result = this.areEquivalent(p1.choice, p2.choice);
        this.nts.remove(p2.name.name);
        return result;
    }

    public boolean areEquivalent(Element e1, Element e2) {
        if (null == e1 || null == e2) {
            return e1 == e2;
        }
        if (!e1.getClass().equals(e2.getClass())) {
            return false;
        }
        this.e2 = e2;
        return (Boolean)this.dispatch(e1);
    }

    protected boolean areEquivalent(List<Binding> l1, List<Binding> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<Binding> iter1 = l1.iterator();
        Iterator<Binding> iter2 = l2.iterator();
        while (iter1.hasNext()) {
            String var1 = iter1.next().name;
            String var2 = iter2.next().name;
            if (var1.equals(var2) || var1.equals(this.vars.get(var2))) continue;
            return false;
        }
        return true;
    }

    protected boolean areEquivalent(GenericValue v1, GenericValue v2) {
        if (!v1.name.equals(v2.name) && !v1.name.equals(this.nts.get(v2.name))) {
            return false;
        }
        return this.areEquivalent(v1.children, v2.children);
    }

    public Boolean visit(OrderedChoice c1) {
        OrderedChoice c2 = (OrderedChoice)this.e2;
        int l = c1.alternatives.size();
        if (l != c2.alternatives.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < l; ++i) {
            if (this.areEquivalent(c1.alternatives.get(i), c2.alternatives.get(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(Repetition r1) {
        Repetition r2 = (Repetition)this.e2;
        if (r1.once != r2.once) {
            return Boolean.FALSE;
        }
        return this.areEquivalent(r1.element, r2.element);
    }

    public Boolean visit(Sequence s1) {
        Sequence s2 = (Sequence)this.e2;
        int l = s1.elements.size();
        if (l != s2.elements.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < l; ++i) {
            if (this.areEquivalent(s1.elements.get(i), s2.elements.get(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(Binding b1) {
        Binding b2 = (Binding)this.e2;
        if (b1.name.equals(b2.name)) {
            return this.areEquivalent(b1.element, b2.element);
        }
        String alt = this.vars.get(b2.name);
        if (null == alt) {
            this.vars.put(b2.name, b1.name);
            boolean result = this.areEquivalent(b1.element, b2.element);
            this.vars.remove(b2.name);
            return result;
        }
        if (!b1.name.equals(alt)) {
            return Boolean.FALSE;
        }
        return this.areEquivalent(b1.element, b2.element);
    }

    public Boolean visit(StringMatch m1) {
        StringMatch m2 = (StringMatch)this.e2;
        return m1.text.equals(m2.text) && this.areEquivalent(m1.element, m2.element);
    }

    public Boolean visit(NonTerminal nt1) {
        NonTerminal nt2 = (NonTerminal)this.e2;
        return nt1.equals(nt2) || nt1.name.equals(this.nts.get(nt2.name));
    }

    public Boolean visit(CharSwitch s1) {
        CharSwitch s2 = (CharSwitch)this.e2;
        int l = s1.cases.size();
        if (l != s2.cases.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < l; ++i) {
            CharCase c1 = s1.cases.get(i);
            CharCase c2 = s2.cases.get(i);
            if (!this.areEquivalent(c1.klass, c2.klass)) {
                return Boolean.FALSE;
            }
            if (this.areEquivalent(c1.element, c2.element)) continue;
            return Boolean.FALSE;
        }
        if (null == s1.base) {
            return null == s2.base;
        }
        if (null == s2.base) {
            return Boolean.FALSE;
        }
        return this.areEquivalent(s1.base, s2.base);
    }

    public Boolean visit(ParseTreeNode n1) {
        ParseTreeNode n2 = (ParseTreeNode)this.e2;
        if (!this.areEquivalent(n1.predecessors, n2.predecessors)) {
            return Boolean.FALSE;
        }
        if (null == n1.node != (null == n2.node)) {
            return Boolean.FALSE;
        }
        if (null != n1.node && !n1.node.name.equals(n2.node.name) && !n1.node.name.equals(this.vars.get(n2.node.name))) {
            return Boolean.FALSE;
        }
        return this.areEquivalent(n1.successors, n2.successors);
    }

    public Boolean visit(ProperListValue v1) {
        ProperListValue v2 = (ProperListValue)this.e2;
        if (!v1.type.equals(v2.type)) {
            return Boolean.FALSE;
        }
        if (!this.areEquivalent(v1.elements, v2.elements)) {
            return Boolean.FALSE;
        }
        if (null == v1.tail != (null == v2.tail)) {
            return Boolean.FALSE;
        }
        return null == v1.tail || v1.tail.name.equals(v2.tail.name) || v1.tail.name.equals(this.vars.get(v2.tail.name));
    }

    public Boolean visit(BindingValue v1) {
        BindingValue v2 = (BindingValue)this.e2;
        return v1.binding.name.equals(v2.binding.name) || v1.binding.name.equals(this.vars.get(v2.binding.name));
    }

    public Boolean visit(ActionBaseValue v1) {
        ActionBaseValue v2 = (ActionBaseValue)this.e2;
        return !(!v1.list.name.equals(v2.list.name) && !v1.list.name.equals(this.vars.get(v2.list.name)) || !v1.seed.name.equals(v2.seed.name) && !v1.seed.name.equals(this.vars.get(v2.seed.name)));
    }

    public Boolean visit(GenericNodeValue v1) {
        GenericNodeValue v2 = (GenericNodeValue)this.e2;
        return this.areEquivalent(v1, v2) && this.areEquivalent(v1.formatting, v2.formatting);
    }

    public Boolean visit(GenericActionValue v1) {
        GenericActionValue v2 = (GenericActionValue)this.e2;
        if (!this.areEquivalent(v1, v2)) {
            return Boolean.FALSE;
        }
        if (!v1.first.equals(v2.first) && !v1.first.equals(this.vars.get(v2.first))) {
            return Boolean.FALSE;
        }
        return this.areEquivalent(v1.formatting, v2.formatting);
    }

    public Boolean visit(GenericRecursionValue v1) {
        GenericRecursionValue v2 = (GenericRecursionValue)this.e2;
        if (!this.areEquivalent(v1, v2)) {
            return Boolean.FALSE;
        }
        if (!v1.first.equals(v2.first) && !v1.first.equals(this.vars.get(v2.first))) {
            return Boolean.FALSE;
        }
        if (!this.areEquivalent(v1.formatting, v2.formatting)) {
            return Boolean.FALSE;
        }
        return v1.list.name.equals(v2.list.name) || v1.list.name.equals(this.vars.get(v2.list.name));
    }

    public Boolean visit(UnaryOperator op1) {
        UnaryOperator op2 = (UnaryOperator)this.e2;
        return this.areEquivalent(op1.element, op2.element);
    }

    public Boolean visit(Element e1) {
        return e1.equals(this.e2);
    }
}

