/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Quantification;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.VoidedElement;
import xtc.tree.Location;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Runtime;

public class ElementVoider
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean isTopLevel;
    protected boolean isLastElement;
    protected boolean suppressVoided;
    protected boolean hasValue;

    public ElementVoider(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    protected Element wrap(Element el) {
        VoidedElement result = new VoidedElement(el);
        Location loc = el.getLocation();
        result.setLocation(loc);
        if (this.runtime.test("optionVerbose")) {
            System.err.println("[Voiding expression at " + loc.line + ":" + loc.column + " in " + this.analyzer.current().qName + "]");
        }
        return result;
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            this.analyzer.process(p);
        }
    }

    public void visit(FullProduction p) {
        if (p.getBooleanProperty("textOnly") || p.getBooleanProperty("token")) {
            return;
        }
        this.isTopLevel = true;
        this.isLastElement = false;
        this.suppressVoided = AST.isVoid(p.type);
        this.hasValue = false;
        p.choice = (OrderedChoice)this.dispatch(p.choice);
    }

    public Element visit(OrderedChoice c) {
        boolean top = this.isTopLevel;
        this.isTopLevel = false;
        boolean last = this.isLastElement;
        boolean value = this.hasValue;
        if (!top && !last) {
            this.hasValue = false;
        }
        int size = c.alternatives.size();
        for (int i = 0; i < size; ++i) {
            this.isLastElement = top || last;
            c.alternatives.set(i, (Sequence)this.dispatch(c.alternatives.get(i)));
        }
        this.isLastElement = false;
        Element result = c;
        if (!top && !last) {
            if (this.hasValue) {
                this.hasValue = true;
            } else {
                this.hasValue = value;
                if (!this.suppressVoided) {
                    result = this.wrap(result);
                }
            }
        }
        return result;
    }

    public Element visit(Quantification q) {
        this.isTopLevel = false;
        this.isLastElement = true;
        boolean value = this.hasValue;
        this.hasValue = false;
        q.element = (Element)this.dispatch(q.element);
        this.isLastElement = false;
        Element result = q;
        if (this.hasValue) {
            this.hasValue = true;
        } else {
            this.hasValue = value;
            if (!this.suppressVoided) {
                result = this.wrap(result);
            }
        }
        return result;
    }

    public Element visit(Sequence s) {
        this.isTopLevel = false;
        boolean last = this.isLastElement;
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            this.isLastElement = last && i == size - 1;
            s.elements.set(i, (Element)this.dispatch(s.get(i)));
        }
        this.isLastElement = false;
        return s;
    }

    public Element visit(Predicate p) {
        this.isTopLevel = false;
        this.isLastElement = true;
        boolean value = this.hasValue;
        this.hasValue = false;
        boolean suppress = this.suppressVoided;
        this.suppressVoided = true;
        p.element = (Element)this.dispatch(p.element);
        this.isLastElement = false;
        this.hasValue = value;
        this.suppressVoided = suppress;
        return p;
    }

    public VoidedElement visit(VoidedElement v) {
        this.isTopLevel = false;
        this.isLastElement = true;
        boolean value = this.hasValue;
        this.hasValue = false;
        boolean suppress = this.suppressVoided;
        this.suppressVoided = true;
        v.element = (Element)this.dispatch(v.element);
        this.isLastElement = false;
        this.hasValue = value;
        this.suppressVoided = suppress;
        return v;
    }

    public Binding visit(Binding b) {
        this.isTopLevel = false;
        this.isLastElement = true;
        this.hasValue = false;
        boolean suppress = this.suppressVoided;
        this.suppressVoided = false;
        b.element = (Element)this.dispatch(b.element);
        if (b.element instanceof VoidedElement) {
            this.runtime.error("binding for expression without value", b);
        }
        this.isLastElement = false;
        this.hasValue = true;
        this.suppressVoided = suppress;
        return b;
    }

    public StringMatch visit(StringMatch m) {
        this.isTopLevel = false;
        this.isLastElement = true;
        this.hasValue = false;
        boolean suppress = this.suppressVoided;
        this.suppressVoided = false;
        m.element = (Element)this.dispatch(m.element);
        if (m.element instanceof VoidedElement) {
            this.runtime.error("match for expression without value", m);
        }
        this.isLastElement = false;
        this.hasValue = true;
        this.suppressVoided = suppress;
        return m;
    }

    public ParserAction visit(ParserAction pa) {
        this.isTopLevel = false;
        this.isLastElement = false;
        this.hasValue = true;
        return pa;
    }

    public Action visit(Action a) {
        this.isTopLevel = false;
        this.isLastElement = false;
        if (a.setsValue()) {
            this.hasValue = true;
        }
        return a;
    }

    public NonTerminal visit(NonTerminal nt) {
        this.isTopLevel = false;
        this.isLastElement = false;
        FullProduction p = this.analyzer.lookup(nt);
        if (!AST.isVoid(p.type)) {
            this.hasValue = true;
        }
        return nt;
    }

    public Element visit(Element e) {
        this.isTopLevel = false;
        this.isLastElement = false;
        this.hasValue = true;
        return e;
    }
}

