/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Element;
import xtc.parser.EquivalenceTester;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.Production;
import xtc.parser.Properties;
import xtc.tree.Attribute;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class DuplicateProductionFolder
extends GrammarVisitor {
    protected final Map<NonTerminal, NonTerminal> folded = new HashMap<NonTerminal, NonTerminal>();

    public DuplicateProductionFolder(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visit(Module m) {
        boolean changed;
        this.analyzer.register(this);
        this.analyzer.init(m);
        EquivalenceTester tester = new EquivalenceTester();
        boolean foundDuplicates = false;
        do {
            void var6_9;
            this.folded.clear();
            changed = false;
            int l = m.productions.size();
            boolean bl = false;
            while (var6_9 < l) {
                FullProduction p1 = (FullProduction)m.productions.get((int)var6_9);
                if (!(p1.hasAttribute(Constants.ATT_PUBLIC) || Generifier.isGeneric(p1) || this.analyzer.isMarked(p1.qName))) {
                    NonTerminal nt = null;
                    FullProduction shared = null;
                    List<String> sources = null;
                    boolean isTextOnly = false;
                    boolean isToken = false;
                    boolean hasOption = false;
                    for (void j = var6_9 + true; j < l; ++j) {
                        FullProduction p2 = (FullProduction)m.productions.get((int)j);
                        if (p2.hasAttribute(Constants.ATT_PUBLIC) || !tester.areEquivalent(p1, p2) || p1.getBooleanProperty("textOnly") != p2.getBooleanProperty("textOnly") || p1.getBooleanProperty("token") != p2.getBooleanProperty("token")) continue;
                        foundDuplicates = true;
                        changed = true;
                        if (null == nt) {
                            nt = this.analyzer.shared();
                            shared = p1;
                            if (p1.hasProperty("duplicates")) {
                                sources = Properties.getDuplicates(p1);
                            } else {
                                sources = new ArrayList<String>();
                                sources.add(p1.qName.toString());
                            }
                            isTextOnly = p1.getBooleanProperty("textOnly");
                            isToken = p1.getBooleanProperty("token");
                            hasOption = p1.hasProperty("option");
                            this.folded.put(p1.name, nt);
                        }
                        if (p2.hasProperty("duplicates")) {
                            sources.addAll(Properties.getDuplicates(p2));
                        } else {
                            sources.add(p2.qName.toString());
                        }
                        if (p2.hasProperty("option")) {
                            hasOption = true;
                        }
                        this.analyzer.mark(p2.qName);
                        this.folded.put(p2.name, nt);
                    }
                    if (null != nt) {
                        shared = new FullProduction(new ArrayList<Attribute>(shared.attributes), shared.type, nt, nt.qualify(this.analyzer.module().name.name), shared.choice);
                        shared.setProperty("duplicates", sources);
                        if (isTextOnly) {
                            shared.setProperty("textOnly", Boolean.TRUE);
                        }
                        if (isToken) {
                            shared.setProperty("token", Boolean.TRUE);
                        }
                        if (hasOption) {
                            shared.setProperty("option", Boolean.TRUE);
                        }
                        this.analyzer.remove(p1);
                        m.productions.remove((int)var6_9);
                        this.analyzer.startAdding();
                        this.analyzer.add(shared);
                        this.analyzer.addNewProductionsAt((int)var6_9);
                    }
                }
                ++var6_9;
            }
            if (!changed) break;
            for (Production p : m.productions) {
                this.dispatch(p);
            }
            Iterator<Production> iterator = m.productions.iterator();
            while (iterator.hasNext()) {
                Production p;
                p = iterator.next();
                if (!this.analyzer.isMarked(p.qName)) continue;
                this.analyzer.unmark(p.qName);
                this.analyzer.remove((FullProduction)p);
                iterator.remove();
            }
        } while (changed);
        if (this.runtime.test("optionVerbose") && foundDuplicates) {
            for (FullProduction fullProduction : m.productions) {
                if (!fullProduction.hasProperty("duplicates")) continue;
                String lst = Utilities.format(Properties.getDuplicates(fullProduction));
                System.err.println("[Folding " + lst + " into " + fullProduction.qName + ']');
            }
        }
        return null;
    }

    public Element visit(NonTerminal nt) {
        NonTerminal alt = this.folded.get(nt);
        return null == alt ? nt : alt;
    }
}

