/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.List;
import xtc.Constants;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Generifier;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.Properties;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.TokenValue;
import xtc.tree.Attribute;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class DirectLeftRecurser
extends Visitor {
    public static final int STATE_RECURSION = 1;
    public static final int STATE_BASE = 2;
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected boolean isVoid;
    protected boolean isTextOnly;
    protected boolean isToken;
    protected boolean isGeneric;
    protected boolean hasConstant;
    protected boolean hasParseTree;
    protected int state;
    protected boolean isTopLevel;
    protected boolean seenChoice;
    protected List<Binding> children;
    protected List<NodeMarker> markers;
    protected FullProduction pTail;
    protected Binding seed;
    protected String varAction;

    public DirectLeftRecurser(Runtime runtime, Analyzer analyzer, AST ast) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = ast;
        this.children = new ArrayList<Binding>();
        this.markers = new ArrayList<NodeMarker>();
    }

    protected Binding bind(Element e) {
        Binding b = new Binding(this.analyzer.variable("g"), e);
        this.children.add(b);
        return b;
    }

    public void visit(Module m) {
        if (!this.runtime.test("optimizeLeftRecursions") && !this.runtime.test("optimizeLeftIterations")) {
            return;
        }
        this.analyzer.register(this);
        this.analyzer.init(m);
        this.hasConstant = m.hasAttribute(Constants.ATT_CONSTANT);
        this.hasParseTree = m.hasAttribute(Constants.ATT_PARSE_TREE);
        for (int i = 0; i < m.productions.size(); ++i) {
            FullProduction p = (FullProduction)m.productions.get(i);
            if (!DirectLeftRecurser.isTransformable(p)) continue;
            if (this.runtime.test("optionVerbose")) {
                System.err.println("[Transforming left-recursion in " + p.qName + "]");
            }
            this.analyzer.startAdding();
            this.analyzer.process(p);
            i += this.analyzer.addNewProductionsAt(i + 1);
            p.removeProperty("transformable");
        }
    }

    public void visit(FullProduction p) {
        this.isVoid = AST.isVoid(p.type);
        this.isTextOnly = p.getBooleanProperty("textOnly");
        this.isToken = p.getBooleanProperty("token");
        this.isGeneric = AST.isGenericNode(p.type);
        this.isTopLevel = true;
        this.seenChoice = false;
        this.children.clear();
        this.markers.clear();
        this.seed = null;
        this.varAction = null;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(p.attributes);
        attributes.remove(Constants.ATT_PUBLIC);
        attributes.remove(Constants.ATT_EXPLICIT);
        attributes.remove(Constants.ATT_STATEFUL);
        attributes.remove(Constants.ATT_RESETTING);
        if (this.isGeneric && !attributes.contains(Constants.ATT_CONSTANT) && !this.hasConstant) {
            attributes.add(Constants.ATT_CONSTANT);
        }
        if (this.runtime.test("optimizeLeftIterations") && !attributes.contains(Constants.ATT_TRANSIENT)) {
            attributes.add(Constants.ATT_TRANSIENT);
        }
        attributes.remove(Constants.ATT_INLINE);
        Type type = null;
        type = this.isGeneric ? (this.runtime.test("optimizeLeftIterations") ? AST.actionOf(p.type) : AST.listOf(AST.actionOf(p.type))) : AST.VOID;
        this.pTail = new FullProduction(attributes, type, this.analyzer.tail(), null, new OrderedChoice());
        this.pTail.qName = this.pTail.name.qualify(this.analyzer.module().name.name);
        if (this.isGeneric) {
            this.varAction = this.analyzer.variable();
        }
        p.choice = (OrderedChoice)this.dispatch(p.choice);
        if (this.isGeneric && AST.isDynamicNode(p.type)) {
            p.type = AST.NODE;
        }
        if (!this.runtime.test("optimizeLeftIterations")) {
            Sequence s = new Sequence();
            if (this.isGeneric) {
                s.add(EmptyListValue.VALUE);
            } else {
                s.add(NullValue.VALUE);
            }
            this.pTail.choice.alternatives.add(s);
        }
        if (!this.runtime.test("optimizeLeftIterations") || !this.isVoid && !this.isTextOnly && !this.isToken) {
            this.analyzer.add(this.pTail);
        }
        if (this.isGeneric) {
            Generifier.markGenericRecursion((FullProduction)this.analyzer.current(), this.runtime.test("optionVerbose"));
        }
    }

    public Element visit(OrderedChoice c) {
        boolean top = this.isTopLevel;
        this.isTopLevel = false;
        for (int i = 0; i < c.alternatives.size(); ++i) {
            Sequence alternative = c.alternatives.get(i);
            if (top) {
                if (DirectLeftRecurser.isRecursive(alternative, (FullProduction)this.analyzer.current())) {
                    this.state = 1;
                    if (this.isGeneric && Analyzer.setsValue(alternative, false)) {
                        this.runtime.error("unable to determine value of recursion", alternative);
                    }
                    alternative.elements.remove(0);
                    c.alternatives.remove(i);
                    --i;
                    Sequence result = (Sequence)this.dispatch(alternative);
                    if (1 == result.size() && result.get(0) instanceof OrderedChoice) {
                        this.pTail.choice.alternatives.addAll(((OrderedChoice)result.get((int)0)).alternatives);
                        continue;
                    }
                    this.pTail.choice.alternatives.add(result);
                    continue;
                }
                this.state = 2;
                if (this.isGeneric) {
                    Binding b = Analyzer.getBinding(alternative.elements);
                    if (null == b && null == (b = this.analyzer.bind(alternative.elements, "g"))) {
                        this.runtime.error("unable to determine value of recursion's base case", alternative);
                        b = new Binding("v$dummy", alternative);
                    }
                    this.seed = b;
                    if (!"v$dummy".equals(b.name)) {
                        Type type = this.analyzer.type(b.element);
                        if (AST.isAny(type)) {
                            if (!this.analyzer.module().hasAttribute(Constants.ATT_NO_WARNINGS) && !this.analyzer.current().hasAttribute(Constants.ATT_NO_WARNINGS)) {
                                this.runtime.error("value of recursion's base case may not be a node", b.element);
                            }
                        } else if (!type.resolve().isWildcard() && !AST.isNode(type)) {
                            this.runtime.error("value of recursion's base case not a node", b.element);
                        }
                    }
                }
                c.alternatives.set(i, (Sequence)this.dispatch(alternative));
                continue;
            }
            c.alternatives.set(i, (Sequence)this.dispatch(alternative));
        }
        this.seenChoice = true;
        return c;
    }

    public Element visit(Repetition r) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(r);
        }
        return r;
    }

    public Element visit(Option o) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(o);
        }
        return o;
    }

    public Element visit(Sequence s) {
        this.isTopLevel = false;
        int base = this.children.size();
        int base2 = this.markers.size();
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            s.elements.set(i, (Element)this.dispatch(s.get(i)));
        }
        if (this.seenChoice) {
            this.seenChoice = false;
        } else if (1 == this.state) {
            if (this.runtime.test("optimizeLeftIterations")) {
                if (this.isGeneric) {
                    String name = this.analyzer.current().qName.name;
                    if (!this.markers.isEmpty()) {
                        name = Utilities.qualify(Utilities.getQualifier(name), this.markers.get((int)(this.markers.size() - 1)).name);
                    }
                    List<Binding> formatting = s.hasProperty("formatting") ? Properties.getFormatting(s) : new ArrayList<Binding>(0);
                    s.add(new GenericActionValue(name, this.varAction, new ArrayList<Binding>(this.children), formatting));
                }
            } else if (this.isGeneric) {
                Binding b = new Binding(this.analyzer.variable(), this.pTail.name);
                s.add(b);
                String name = this.analyzer.current().qName.name;
                if (!this.markers.isEmpty()) {
                    name = Utilities.qualify(Utilities.getQualifier(name), this.markers.get((int)(this.markers.size() - 1)).name);
                }
                List<Binding> formatting = s.hasProperty("formatting") ? Properties.getFormatting(s) : new ArrayList<Binding>(0);
                s.add(new GenericRecursionValue(name, this.varAction, new ArrayList<Binding>(this.children), formatting, b));
            } else {
                s.add(this.pTail.name);
                s.add(NullValue.VALUE);
            }
        } else if (2 == this.state) {
            if (this.runtime.test("optimizeLeftIterations")) {
                if (this.isGeneric) {
                    Binding b1 = new Binding(this.analyzer.variable(), this.pTail.name);
                    Repetition r = new Repetition(false, new Sequence(b1));
                    Binding b2 = new Binding(this.analyzer.variable(), r);
                    s.add(b2).add(new ActionBaseValue(b2, this.seed));
                } else {
                    Element e = this.analyzer.copy(Analyzer.strip(this.pTail.choice));
                    s.add(new Repetition(false, Sequence.ensure(e)));
                    if (this.isTextOnly) {
                        s.add(StringValue.VALUE);
                    } else if (this.isToken) {
                        s.add(TokenValue.VALUE);
                    } else {
                        s.add(NullValue.VALUE);
                    }
                }
            } else if (this.isGeneric) {
                Binding b = new Binding(this.analyzer.variable(), this.pTail.name);
                s.add(b).add(new ActionBaseValue(b, this.seed));
            } else if (this.isTextOnly) {
                s.add(this.pTail.name).add(StringValue.VALUE);
            } else if (this.isToken) {
                s.add(this.pTail.name).add(TokenValue.VALUE);
            } else {
                s.add(this.pTail.name).add(NullValue.VALUE);
            }
        } else {
            throw new IllegalStateException("Invalid state " + this.state);
        }
        if (this.isGeneric && 1 == this.state) {
            if (0 == base) {
                this.children.clear();
            } else {
                this.children.subList(base, this.children.size()).clear();
            }
            if (0 == base2) {
                this.markers.clear();
            } else {
                this.markers.subList(base2, this.markers.size()).clear();
            }
        }
        return s;
    }

    public Element visit(Binding b) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            if ("yyValue".equals(b.name)) {
                this.runtime.error("illegal binding to yyValue in left-recursive sequence", b);
            }
            this.children.add(b);
        }
        return b;
    }

    public Element visit(StringMatch m) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(m);
        }
        return m;
    }

    public Element visit(NonTerminal nt) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            FullProduction p = this.analyzer.lookup(nt);
            if (AST.isVoid(p.type)) {
                return nt;
            }
            return this.bind(nt);
        }
        return nt;
    }

    public Element visit(StringLiteral l) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(l);
        }
        return l;
    }

    public Element visit(ParseTreeNode n) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(n);
        }
        return n;
    }

    public Element visit(NullLiteral l) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(l);
        }
        return l;
    }

    public Element visit(NodeMarker m) {
        this.isTopLevel = false;
        this.markers.add(m);
        return m;
    }

    public Element visit(Element e) {
        this.isTopLevel = false;
        return e;
    }

    public static boolean isTransformable(FullProduction p) {
        if (!(AST.isVoid(p.type) || p.getBooleanProperty("textOnly") || p.getBooleanProperty("token") || AST.isGenericNode(p.type))) {
            return false;
        }
        if (p.hasProperty("transformable")) {
            return p.getBooleanProperty("transformable");
        }
        boolean seenRecursion = false;
        boolean seenBase = false;
        for (Sequence s : p.choice.alternatives) {
            if (s.isEmpty()) {
                p.setProperty("transformable", Boolean.FALSE);
                return false;
            }
            Element e = Analyzer.stripAndUnbind(s.get(0));
            if (p.name.equals(e) || p.qName.equals(e)) {
                if (!seenRecursion || !seenBase) {
                    seenRecursion = true;
                    continue;
                }
                p.setProperty("transformable", Boolean.FALSE);
                return false;
            }
            if (!seenRecursion) {
                p.setProperty("transformable", Boolean.FALSE);
                return false;
            }
            seenBase = true;
        }
        if (seenRecursion && seenBase) {
            p.setProperty("transformable", Boolean.TRUE);
            return true;
        }
        p.setProperty("transformable", Boolean.FALSE);
        return false;
    }

    public static boolean isRecursive(Sequence s, FullProduction p) {
        if (s.isEmpty()) {
            return false;
        }
        Element e = Analyzer.stripAndUnbind(s.get(0));
        return p.name.equals(e) || p.qName.equals(e);
    }

    public static boolean isBase(Sequence s, FullProduction p) {
        return !DirectLeftRecurser.isRecursive(s, p);
    }
}

