/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.Terminal;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;

public class CostEstimator
extends Visitor {
    protected final Analyzer analyzer;

    public CostEstimator(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            p.removeProperty("cost");
        }
        for (Production p : m.productions) {
            if (p.hasProperty("cost")) continue;
            this.analyzer.process(p);
        }
    }

    public Integer visit(Production p) {
        this.analyzer.workingOn(p.qName);
        Integer cost = (Integer)this.dispatch(p.choice);
        this.analyzer.notWorkingOn(p.qName);
        p.setProperty("cost", cost);
        return cost;
    }

    public Integer visit(OrderedChoice c) {
        int cost = 0;
        for (Sequence s : c.alternatives) {
            cost = CostEstimator.add(cost, (Integer)this.dispatch(s));
        }
        return cost;
    }

    public Integer visit(Repetition r) {
        return Integer.MAX_VALUE;
    }

    public Integer visit(Option o) {
        return CostEstimator.add(1, (Integer)this.dispatch(o.element));
    }

    public Integer visit(Sequence s) {
        int cost = 0;
        for (Element e : s.elements) {
            cost = CostEstimator.add(cost, (Integer)this.dispatch(e));
        }
        return cost;
    }

    public Integer visit(Predicate p) {
        return CostEstimator.add(1, (Integer)this.dispatch(p.element));
    }

    public Integer visit(VoidedElement v) {
        return (Integer)this.dispatch(v.element);
    }

    public Integer visit(Binding b) {
        return (Integer)this.dispatch(b.element);
    }

    public Integer visit(StringMatch m) {
        return CostEstimator.add(1, (Integer)this.dispatch(m.element));
    }

    public Integer visit(NonTerminal nt) {
        FullProduction p = this.analyzer.lookup(nt);
        if (this.analyzer.isBeingWorkedOn(p.qName)) {
            return Integer.MAX_VALUE;
        }
        return CostEstimator.add(1, p.hasProperty("cost") ? (Integer)p.getProperty("cost") : (Integer)this.dispatch(p));
    }

    public Integer visit(StringLiteral l) {
        return l.text.length();
    }

    public Integer visit(CharCase c) {
        if (null == c.element) {
            return 0;
        }
        return (Integer)this.dispatch(c.element);
    }

    public Integer visit(CharSwitch sw) {
        int cost = 0;
        for (CharCase kase : sw.cases) {
            cost = Math.max(cost, (Integer)this.dispatch(kase) + 1);
        }
        if (null == sw.base) {
            cost = Math.max(cost, (Integer)this.dispatch(sw.base) + 1);
        }
        return cost;
    }

    public Integer visit(Terminal t) {
        return 1;
    }

    public Integer visit(NodeMarker m) {
        return 0;
    }

    public Integer visit(Action a) {
        return 1;
    }

    public Integer visit(ParserAction a) {
        return Integer.MAX_VALUE;
    }

    public Integer visit(NullLiteral l) {
        return 0;
    }

    public Integer visit(StringValue v) {
        return null == v.text ? 1 : 0;
    }

    public Integer visit(ProperListValue v) {
        return v.elements.size();
    }

    public Integer visit(ActionBaseValue v) {
        return Integer.MAX_VALUE;
    }

    public Integer visit(GenericNodeValue v) {
        return 2;
    }

    public Integer visit(GenericActionValue v) {
        return 1;
    }

    public Integer visit(GenericRecursionValue v) {
        return 2;
    }

    public Integer visit(ValueElement v) {
        return 0;
    }

    protected static int add(int e1, int e2) {
        if (Integer.MAX_VALUE == e1 || Integer.MAX_VALUE == e2) {
            return Integer.MAX_VALUE;
        }
        long sum = e1 + e2;
        if (Integer.MAX_VALUE < sum) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }
}

