/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.List;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.AlternativeAddition;
import xtc.parser.AlternativeRemoval;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FollowedBy;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleImport;
import xtc.parser.ModuleInstantiation;
import xtc.parser.ModuleList;
import xtc.parser.ModuleModification;
import xtc.parser.ModuleName;
import xtc.parser.NotFollowedBy;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.ProductionOverride;
import xtc.parser.ProperListValue;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SequenceName;
import xtc.parser.StringMatch;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.Node;
import xtc.tree.Visitor;

public class Copier
extends Visitor {
    protected List<Binding> source = new ArrayList<Binding>();
    protected List<Binding> target = new ArrayList<Binding>();

    protected Binding match(Binding b) {
        int size = this.source.size();
        int idx = -1;
        for (int i = 0; i < size; ++i) {
            if (b != this.source.get(i)) continue;
            idx = i;
            break;
        }
        if (-1 == idx) {
            throw new IllegalArgumentException("Copying element without binding for " + b.name);
        }
        return this.target.get(idx);
    }

    protected void patch(List<Binding> bindings) {
        int size = bindings.size();
        for (int i = 0; i < size; ++i) {
            bindings.set(i, this.match(bindings.get(i)));
        }
    }

    public <T extends Element> T copy(T e) {
        this.source.clear();
        this.target.clear();
        return (T)((Element)this.dispatch(e));
    }

    public Grammar visit(Grammar g) {
        Grammar copy = new Grammar(new ArrayList<Module>(g.modules.size()));
        copy.setLocation(g);
        for (Module m : g.modules) {
            copy.modules.add((Module)this.dispatch(m));
        }
        return copy;
    }

    public Module visit(Module m) {
        Module copy = new Module();
        copy.setLocation(m);
        copy.documentation = (Comment)this.dispatch(m.documentation);
        copy.name = m.name;
        copy.parameters = (ModuleList)this.dispatch(m.parameters);
        if (null != m.dependencies) {
            copy.dependencies = new ArrayList<ModuleDependency>(m.dependencies.size());
            for (ModuleDependency dep : m.dependencies) {
                copy.dependencies.add((ModuleDependency)this.dispatch(dep));
            }
        }
        copy.modification = m.modification;
        copy.header = (Action)this.dispatch(m.header);
        copy.body = (Action)this.dispatch(m.body);
        copy.footer = (Action)this.dispatch(m.footer);
        if (null != m.attributes) {
            copy.attributes = new ArrayList<Attribute>(m.attributes);
        }
        copy.productions = new ArrayList<Production>(m.productions.size());
        for (Production p : m.productions) {
            copy.productions.add((Production)this.dispatch(p));
        }
        return copy;
    }

    public Comment visit(Comment c) {
        Node node = (Node)this.dispatch(c.getNode());
        Comment copy = new Comment(c.kind, new ArrayList<String>(c.text), node);
        copy.setLocation(c);
        return copy;
    }

    public ModuleImport visit(ModuleImport i) {
        ModuleImport copy = new ModuleImport(i.module, (ModuleList)this.dispatch(i.arguments), i.target);
        copy.setLocation(i);
        return copy;
    }

    public ModuleInstantiation visit(ModuleInstantiation i) {
        ModuleInstantiation copy = new ModuleInstantiation(i.module, (ModuleList)this.dispatch(i.arguments), i.target);
        copy.setLocation(i);
        return copy;
    }

    public ModuleModification visit(ModuleModification m) {
        ModuleModification copy = new ModuleModification(m.module, (ModuleList)this.dispatch(m.arguments), m.target);
        copy.setLocation(m);
        return copy;
    }

    public ModuleList visit(ModuleList l) {
        ModuleList copy = new ModuleList(new ArrayList<ModuleName>(l.names));
        copy.setLocation(l);
        return copy;
    }

    public FullProduction visit(FullProduction p) {
        FullProduction copy = new FullProduction(null, p.type, p.name, p.qName, this.copy(p.choice));
        copy.setLocation(p);
        if (null != p.attributes) {
            copy.attributes = new ArrayList(p.attributes);
        }
        copy.dType = p.dType;
        return copy;
    }

    public AlternativeAddition visit(AlternativeAddition p) {
        AlternativeAddition copy = new AlternativeAddition(p.dType, p.name, this.copy(p.choice), p.sequence, p.isBefore);
        copy.setLocation(p);
        copy.type = p.type;
        copy.qName = p.qName;
        return copy;
    }

    public AlternativeRemoval visit(AlternativeRemoval p) {
        AlternativeRemoval copy = new AlternativeRemoval(p.dType, p.name, new ArrayList<SequenceName>(p.sequences));
        copy.setLocation(p);
        copy.type = p.type;
        copy.qName = p.qName;
        return copy;
    }

    public ProductionOverride visit(ProductionOverride p) {
        ProductionOverride copy = new ProductionOverride(p.dType, p.name, this.copy(p.choice), p.isComplete);
        copy.setLocation(p);
        if (null != p.attributes) {
            copy.attributes = new ArrayList(p.attributes);
        }
        copy.type = p.type;
        copy.qName = p.qName;
        return copy;
    }

    public OrderedChoice visit(OrderedChoice c) {
        int length = c.alternatives.size();
        OrderedChoice copy = new OrderedChoice(new ArrayList<Sequence>(length));
        copy.setLocation(c);
        for (Sequence alt : c.alternatives) {
            copy.alternatives.add((Sequence)this.dispatch(alt));
        }
        return copy;
    }

    public Repetition visit(Repetition r) {
        Repetition copy = new Repetition(r.once, (Element)this.dispatch(r.element));
        copy.setLocation(r);
        return copy;
    }

    public Option visit(Option o) {
        Option copy = new Option((Element)this.dispatch(o.element));
        copy.setLocation(o);
        return copy;
    }

    public Sequence visit(Sequence s) {
        int size = s.size();
        Sequence copy = new Sequence(s.name, new ArrayList<Element>(size));
        copy.setLocation(s);
        for (int i = 0; i < size; ++i) {
            copy.add((Element)this.dispatch(s.get(i)));
        }
        return copy;
    }

    public FollowedBy visit(FollowedBy p) {
        FollowedBy copy = new FollowedBy((Element)this.dispatch(p.element));
        copy.setLocation(p);
        return copy;
    }

    public NotFollowedBy visit(NotFollowedBy p) {
        NotFollowedBy copy = new NotFollowedBy((Element)this.dispatch(p.element));
        copy.setLocation(p);
        return copy;
    }

    public SemanticPredicate visit(SemanticPredicate p) {
        SemanticPredicate copy = new SemanticPredicate((Action)this.dispatch(p.element));
        copy.setLocation(p);
        return copy;
    }

    public VoidedElement visit(VoidedElement v) {
        VoidedElement copy = new VoidedElement((Element)this.dispatch(v.element));
        copy.setLocation(v);
        return copy;
    }

    public Binding visit(Binding b) {
        Binding copy = new Binding(b.name, (Element)this.dispatch(b.element));
        copy.setLocation(b);
        this.source.add(b);
        this.target.add(copy);
        return copy;
    }

    public StringMatch visit(StringMatch m) {
        StringMatch copy = new StringMatch(m.text, (Element)this.dispatch(m.element));
        copy.setLocation(copy);
        return copy;
    }

    public CharClass visit(CharClass c) {
        CharClass copy = new CharClass(c.exclusive, new ArrayList<CharRange>(c.ranges.size()));
        copy.setLocation(c);
        copy.ranges.addAll(c.ranges);
        return copy;
    }

    public CharCase visit(CharCase c) {
        CharCase copy = new CharCase((CharClass)this.dispatch(c.klass), (Element)this.dispatch(c.element));
        copy.setLocation(c);
        return copy;
    }

    public CharSwitch visit(CharSwitch s) {
        int length = s.cases.size();
        CharSwitch copy = new CharSwitch(new ArrayList<CharCase>(length));
        copy.setLocation(s);
        for (CharCase kase : s.cases) {
            copy.cases.add((CharCase)this.dispatch(kase));
        }
        copy.base = (Element)this.dispatch(s.base);
        return copy;
    }

    public Action visit(Action a) {
        Action copy = new Action(new ArrayList<String>(a.code), new ArrayList<Integer>(a.indent));
        copy.setLocation(a);
        return copy;
    }

    public ParserAction visit(ParserAction pa) {
        ParserAction copy = new ParserAction((Action)this.dispatch(pa.element));
        copy.setLocation(pa);
        return copy;
    }

    public ParseTreeNode visit(ParseTreeNode n) {
        ParseTreeNode copy = new ParseTreeNode(new ArrayList<Binding>(n.predecessors), null, new ArrayList<Binding>(n.successors));
        copy.setLocation(n);
        this.patch(copy.predecessors);
        if (null != n.node) {
            copy.node = this.match(n.node);
        }
        this.patch(copy.successors);
        return copy;
    }

    public BindingValue visit(BindingValue v) {
        BindingValue copy = new BindingValue(this.match(v.binding));
        copy.setLocation(v);
        return copy;
    }

    public ProperListValue visit(ProperListValue v) {
        ProperListValue copy = new ProperListValue(v.type, new ArrayList<Binding>(v.elements), null);
        copy.setLocation(v);
        this.patch(copy.elements);
        if (null != v.tail) {
            copy.tail = this.match(v.tail);
        }
        return copy;
    }

    public ActionBaseValue visit(ActionBaseValue v) {
        ActionBaseValue copy = new ActionBaseValue(this.match(v.list), this.match(v.seed));
        copy.setLocation(v);
        return copy;
    }

    public GenericNodeValue visit(GenericNodeValue v) {
        GenericNodeValue copy = new GenericNodeValue(v.name, new ArrayList<Binding>(v.children), new ArrayList<Binding>(v.formatting));
        copy.setLocation(v);
        this.patch(copy.children);
        this.patch(copy.formatting);
        return copy;
    }

    public GenericActionValue visit(GenericActionValue v) {
        GenericActionValue copy = new GenericActionValue(v.name, v.first, new ArrayList<Binding>(v.children), new ArrayList<Binding>(v.formatting));
        copy.setLocation(v);
        this.patch(copy.children);
        this.patch(copy.formatting);
        return copy;
    }

    public GenericRecursionValue visit(GenericRecursionValue v) {
        GenericRecursionValue copy = new GenericRecursionValue(v.name, v.first, new ArrayList<Binding>(v.children), new ArrayList<Binding>(v.formatting), this.match(v.list));
        copy.setLocation(v);
        this.patch(copy.children);
        this.patch(copy.formatting);
        return copy;
    }

    public Element visit(Element e) {
        return e;
    }
}

