/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FollowedBy;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.MetaData;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.NullLiteral;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Properties;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.TokenValue;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.InstantiatedT;
import xtc.type.Type;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class CodeGenerator
extends Visitor {
    public static final int CHUNK_SIZE = 10;
    public static final String PREFIX_METHOD = "p";
    public static final String PREFIX_FIELD = "f";
    public static final String PREFIX_COUNT_FIELD = "c";
    public static final String PREFIX = "yy";
    public static final String PRINTER = "yyOut";
    public static final String STATE = "yyState";
    public static final String PARSE_CHAR = "character";
    public static final String ARG_INDEX = "yyStart";
    public static final String COLUMN = "yyColumn";
    public static final String CHAR = "yyC";
    public static final String INDEX = "yyIndex";
    public static final String RESULT = "yyResult";
    public static final String PRED_INDEX = "yyPredIndex";
    public static final String PRED_RESULT = "yyPredResult";
    public static final String PRED_MATCHED = "yyPredMatched";
    public static final String BASE_INDEX = "yyBase";
    public static final String NESTED_CHOICE = "yyChoice";
    public static final String REPETITION = "yyRepetition";
    public static final String OPTION = "yyOption";
    public static final String REPEATED = "yyRepeated";
    public static final String REP_VALUE = "yyRepValue";
    public static final String OP_VALUE = "yyOpValue";
    public static final String VALUE = "yyValue";
    public static final String PARSE_ERROR = "yyError";
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected final Printer printer;
    protected boolean attributeVerbose;
    protected boolean attributeWithLocation;
    protected boolean attributeConstant;
    protected boolean attributeFlatten;
    protected boolean attributeParseTree;
    protected boolean attributeRawTypes;
    protected boolean attributeIgnoringCase;
    protected boolean attributeStateful;
    protected boolean attributeStringSet;
    protected String stateClassName;
    protected String factoryClassName;
    protected boolean attributeMain;
    protected String mainMethodNonterminal = null;
    protected boolean attributePrinter;
    protected String printerClassName;
    protected boolean attributeProfile;
    protected boolean attributeDump;
    protected String className;
    protected boolean chunked;
    protected Map<NonTerminal, Integer> chunkMap;
    protected int chunkCount;
    protected boolean firstElement;
    protected boolean savedFirstElement;
    protected String baseIndex;
    protected boolean useBaseIndex;
    protected String savedBaseIndex;
    protected boolean savedUseBaseIndex;
    protected int indentLevel;
    protected int choiceLevel;
    protected boolean repeated;
    protected boolean savedRepeated;
    protected boolean repeatedOnce;
    protected boolean savedRepeatedOnce;
    protected int repetitionLevel;
    protected String repeatedElement;
    protected List<Type> repetitionTypes;
    protected boolean optional;
    protected boolean savedOptional;
    protected int optionLevel;
    protected String optionalElement;
    protected List<Type> optionTypes;
    protected boolean createsNodeValue;
    protected boolean seenTest;
    protected boolean endsWithParseError;
    protected Iterator<Element> elementIter;
    protected String indexName;
    protected String resultName;
    protected String bindingName;
    protected Element bindingElement;
    protected Type bindingType;
    protected boolean predicate;
    protected boolean notFollowedBy;
    protected Iterator<Element> predicateIter;

    public CodeGenerator(Runtime runtime, Analyzer analyzer, AST ast, Printer printer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = ast;
        this.printer = printer;
    }

    public String booleanT() {
        return "boolean";
    }

    public String charT() {
        return "char";
    }

    public String intT() {
        return "int";
    }

    public String indexT() {
        return "int";
    }

    public String extern(Type type) {
        return null == type ? null : this.ast.extern(type);
    }

    public String rawT(String type) {
        int idx = type.indexOf(60);
        return -1 == idx ? type : type.substring(0, idx);
    }

    public String nullExpr() {
        return "null";
    }

    public String stringExpr(String text) {
        return '\"' + Utilities.escape(text, 8) + '\"';
    }

    public String emptyListExpr() {
        return this.attributeRawTypes ? "Pair.EMPTY" : "Pair.empty()";
    }

    public String fieldName(NonTerminal nt, String prefix) {
        if (this.chunked) {
            return "yyColumn.chunk" + this.chunkMap.get(nt) + "." + prefix + nt.toIdentifier();
        }
        return "yyColumn." + prefix + nt.toIdentifier();
    }

    public String methodName(NonTerminal nt) {
        return PREFIX_METHOD + nt.toIdentifier();
    }

    protected void verbose() {
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Trace entering the specified production.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param name The name.");
        this.printer.indent().pln(" * @param index The index.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("protected void traceEnter(String name, int index) {").incr();
        this.printer.indent().pln("if (! DEBUG) return;");
        this.printer.pln();
        this.printer.indent().p(PRINTER).p(".p(\"enter \").p(name).p(\" @ \").").pln("p(index);");
        this.printer.indent().p("if (PEEK) ").p(PRINTER).p(".p(\" : \\\"\").").pln("escape(peek(index)).p('\\\"');");
        this.printer.indent().p(PRINTER).pln(".pln().flush();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Trace a successful exit from the specified ").pln("production.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param name The name.");
        this.printer.indent().pln(" * @param index The index.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("protected void traceSuccess(String name, ").pln("int index) {").incr();
        this.printer.indent().pln("if (! DEBUG) return;");
        this.printer.indent().p(PRINTER).p(".p(\"exit \").p(name).p(\" @ \").").pln("p(index).pln(\" with match\").flush();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Trace a failed exit from the specified ").pln("production.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param name The name.");
        this.printer.indent().pln(" * @param index The index.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("protected void traceFailure(String name, ").pln("int index) {").incr();
        this.printer.indent().pln("if (! DEBUG) return;");
        this.printer.indent().p(PRINTER).p(".p(\"exit \").p(name).p(\" @ \").").pln("p(index).pln(\" with error\").flush();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Trace a lookup in the memoization table for ").pln("the specified production.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param name The name.");
        this.printer.indent().pln(" * @param index The index.");
        this.printer.indent().pln(" * @param result The result.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("protected void traceLookup(String name, int index, ").pln("Result result) {").incr();
        this.printer.indent().pln("if (! DEBUG) return;");
        this.printer.pln();
        this.printer.indent().p(PRINTER).p(".p(\"lookup \").p(name).p(\" @ \").").pln("p(index);");
        this.printer.indent().p("if (PEEK) ").p(PRINTER).p(".p(\" : \\\"\").").pln("escape(peek(index)).p('\\\"');");
        this.printer.indent().p(PRINTER).pln(".p(\" -> \");");
        this.printer.indent().pln("if (result.hasValue()) {").incr();
        this.printer.indent().p(PRINTER).pln(".p(\"match\");");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().p(PRINTER).pln(".p(\"error\");");
        this.printer.decr().indent().pln('}');
        this.printer.indent().p(PRINTER).pln(".pln().flush();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void profile() {
        String name;
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Print a profile of the memoization table.");
        this.printer.indent().pln(" *");
        this.printer.indent().p(" * @param printer The printer for writing the ").pln("profile.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("public void profile(Printer printer) {").incr();
        this.printer.indent().pln("// Initialize the profile.");
        if (this.attributeRawTypes) {
            this.printer.indent().p("HashMap maxima = new HashMap();");
        } else {
            this.printer.indent().p("HashMap<String, Integer> maxima = ").pln("new HashMap<String, Integer>();");
        }
        this.printer.pln();
        int maxNameSize = 0;
        for (Production p : this.analyzer.module().productions) {
            if (this.runtime.test("optimizeTransient") && !p.isMemoized()) continue;
            name = p.name.toIdentifier();
            maxNameSize = Math.max(maxNameSize, name.length());
            if (this.attributeRawTypes) {
                this.printer.indent().p("maxima.put(\"").p(name).pln("\", Integer.valueOf(0));");
                continue;
            }
            this.printer.indent().p("maxima.put(\"").p(name).pln("\", 0);");
        }
        this.printer.pln();
        this.printer.indent().pln("// Process the memoization table.");
        this.printer.indent().pln("for (int i=0; i<yyCount; i++) {").incr();
        this.printer.indent().p(this.className).p("Column column = (").p(this.className).pln("Column)yyColumns[i];");
        this.printer.pln();
        this.printer.indent().pln("if (null != column) {").incr();
        if (0 == this.chunkCount) {
            for (Production p : this.analyzer.module().productions) {
                if (this.runtime.test("optimizeTransient") && !p.isMemoized()) continue;
                name = p.name.toIdentifier();
                this.printer.indent().p("profile(maxima, \"").p(name).p("\", ").buffer().p("column.").p(PREFIX_COUNT_FIELD).p(name).p(");").fit("        ").pln();
            }
        } else {
            int number = 0;
            int idx = 10;
            boolean first = true;
            for (Production p : this.analyzer.module().productions) {
                if (this.runtime.test("optimizeTransient") && !p.isMemoized()) continue;
                if (10 <= idx) {
                    ++number;
                    idx = 0;
                    if (first) {
                        first = false;
                    } else {
                        this.printer.decr().indent().pln('}');
                        this.printer.pln();
                    }
                    this.printer.indent().p("Chunk").p(number).p(" chunk").p(number).p(" = column.chunk").p(number).pln(';');
                    this.printer.indent().p("if (null != chunk").p(number).pln(") {").incr();
                }
                String name2 = p.name.toIdentifier();
                this.printer.indent().p("profile(maxima, \"").p(name2).p("\", ").buffer().p("chunk").p(number).p('.').p(PREFIX_COUNT_FIELD).p(name2).p(");").fit("        ").pln();
                ++idx;
            }
            this.printer.decr().indent().pln('}');
        }
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("// Print the profile.");
        for (Production p : this.analyzer.module().productions) {
            if (this.runtime.test("optimizeTransient") && !p.isMemoized()) continue;
            this.printer.indent().p("print(printer, ").p(maxNameSize).p(", maxima, ").buffer().p('\"').p(p.name.toIdentifier()).p("\");").fitMore().pln();
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Update the profile for the specified production").pln(" and count.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param maxima The profile.");
        this.printer.indent().pln(" * @param name The production's name.");
        this.printer.indent().pln(" * @param count The access count.");
        this.printer.indent().pln(" */");
        if (this.attributeRawTypes) {
            this.printer.indent().p("private void profile(HashMap maxima, String name, ").pln("int count) {").incr();
            this.printer.indent().pln("int old = ((Integer)maxima.get(name)).intValue();");
            this.printer.indent().pln("int max = Math.max(old, count);");
            this.printer.indent().p("if (old < max) ").pln("maxima.put(name, Integer.valueOf(max));");
        } else {
            this.printer.indent().p("private void profile(HashMap<String, Integer> ").pln("maxima,");
            this.printer.indent().pln("                     String name, int count) {").incr();
            this.printer.indent().pln("int old = maxima.get(name);");
            this.printer.indent().pln("int max = Math.max(old, count);");
            this.printer.indent().pln("if (old < max) maxima.put(name, max);");
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Print the profile for the specified production").pln(" and count.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param printer The printer.");
        this.printer.indent().pln(" * @param align The alignment.");
        this.printer.indent().pln(" * @param maxima The profile.");
        this.printer.indent().pln(" * @param name The production's name.");
        this.printer.indent().pln(" */");
        if (this.attributeRawTypes) {
            this.printer.indent().pln("private void print(Printer printer, int align,");
            this.printer.indent().pln("                   HashMap maxima, String name) {").incr();
            this.printer.indent().p("int count = ((Integer)maxima.get(name)).").pln("intValue();");
        } else {
            this.printer.indent().pln("private void print(Printer printer, int align,");
            this.printer.indent().p("                   HashMap<String, Integer> ").pln("maxima, String name) {").incr();
            this.printer.indent().pln("int count = maxima.get(name);");
        }
        this.printer.indent().pln("align    += 4;");
        this.printer.indent().pln("if (1 != count) {").incr();
        this.printer.indent().pln("printer.p(\"- \");");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("printer.p(\"* \");");
        this.printer.decr().indent().pln('}');
        this.printer.indent().pln("printer.p(name).align(align).p(\" : \").pln(count);");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void dump() {
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Dump the memoization table.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param printer The printer for writing the table.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("public void dump(Printer printer) {").incr();
        this.printer.indent().pln("for (int i=0; i<yyCount; i++) {").incr();
        this.printer.indent().p(this.className).p("Column column = (").p(this.className).pln("Column)yyColumns[i];");
        this.printer.indent().pln("printer.indent().p(i).p(\" = \");");
        this.printer.pln();
        this.printer.indent().pln("if (null == column) {").incr();
        this.printer.indent().pln("printer.pln(\"null;\");");
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("printer.pln('{').incr();");
        if (0 == this.chunkCount) {
            this.printer.pln();
            for (Production p : this.analyzer.module().productions) {
                if (this.runtime.test("optimizeTransient") && !p.isMemoized()) continue;
                String name = p.name.toIdentifier();
                this.printer.indent().p("dump(printer, \"").p(name).p("\", ").buffer().p("column.").p(PREFIX_FIELD).p(name).p(");").fit("     ").pln();
            }
        } else {
            int number = 0;
            int idx = 10;
            boolean first = true;
            for (Production p : this.analyzer.module().productions) {
                if (this.runtime.test("optimizeTransient") && !p.isMemoized()) continue;
                if (10 <= idx) {
                    ++number;
                    idx = 0;
                    if (first) {
                        first = false;
                    } else {
                        this.printer.pln();
                        this.printer.indent().pln("printer.decr().indent().pln(\"};\");");
                        this.printer.decr().indent().pln('}');
                    }
                    this.printer.pln();
                    this.printer.indent().p("Chunk").p(number).p(" chunk").p(number).p(" = column.chunk").p(number).pln(';');
                    this.printer.indent().p("printer.indent().p(\"Chunk(").p(number).p(") = \");");
                    this.printer.pln();
                    this.printer.indent().p("if (null == chunk").p(number).pln(") {").incr();
                    this.printer.indent().pln("printer.pln(\"null;\");");
                    this.printer.pln();
                    this.printer.decr().indent().pln("} else {").incr();
                    this.printer.indent().pln("printer.pln('{').incr();");
                    this.printer.pln();
                }
                String name = p.name.toIdentifier();
                this.printer.indent().p("dump(printer, \"").p(name).p("\", ").buffer().p("chunk").p(number).p('.').p(PREFIX_FIELD).p(name).p(");").fit("     ").pln();
                ++idx;
            }
            this.printer.pln();
            this.printer.indent().pln("printer.decr().indent().pln(\"};\");");
            this.printer.decr().indent().pln('}');
        }
        this.printer.pln();
        this.printer.indent().pln("printer.decr().indent().pln(\"};\");");
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Dump a memoized result.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param printer The printer.");
        this.printer.indent().pln(" * @param name The name of the result.");
        this.printer.indent().pln(" * @param result The value of the result.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("private void dump(Printer printer, String name, ").pln("Result result) {").incr();
        this.printer.indent().pln("printer.indent().p(name).p(\" = \");");
        this.printer.pln();
        this.printer.indent().pln("if (null == result) {").incr();
        this.printer.indent().pln("printer.pln(\"null;\");");
        this.printer.decr().indent().pln("} else if (result.hasValue()) {").incr();
        this.printer.indent().pln("printer.p(\"Value(\").p(result.index).pln(\");\");");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("printer.p(\"Error(\").p(result.index).pln(\");\");");
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void mainMethod(String nt) {
        int align = this.printer.level() * 2 + 8 + Math.max(6, this.className.length()) + 1 + 1;
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Parse the specified files.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param args The file names.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("public static void main(String[] args) {").incr();
        this.printer.indent().pln("if ((null == args) || (0 == args.length)) {").incr();
        this.printer.indent().pln("System.err.println(\"Usage: <file-name>+\");");
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("for (int i=0; i<args.length; i++) {").incr();
        this.printer.indent().p("System.err.println(\"Processing \" + args[i] + ").pln("\" ...\");");
        this.printer.pln();
        this.printer.indent().p("Reader").align(align).pln("in = null;");
        this.printer.indent().pln("try {").incr();
        this.printer.indent().p("in").align(align + 3).pln("= new BufferedReader(new FileReader(args[i]));");
        this.printer.indent().p(this.className).align(align).p("p  = ").buffer().p("new ").p(this.className).p("(in, args[i], (int)new File(args[i]).length());").fitMore().pln();
        this.printer.indent().p("Result").align(align).p("r  = p.p").p(nt).pln("(0);");
        this.printer.pln();
        this.printer.indent().pln("if (r.hasValue()) {").incr();
        this.printer.indent().pln("SemanticValue v = (SemanticValue)r;");
        this.printer.pln();
        if (this.attributePrinter) {
            this.printer.indent().pln("if (v.value instanceof Node) {").incr();
            this.printer.indent().pln("Printer ptr = new");
            this.printer.indentMore().p("Printer(new BufferedWriter(new ").pln("OutputStreamWriter(System.out)));");
            this.printer.indent().p("new ").p(this.printerClassName).pln("(ptr).dispatch((Node)v.value);");
            this.printer.indent().pln("ptr.flush();").pln();
            this.printer.decr().indent().pln("} else {").incr();
            this.printer.indent().pln("System.out.println(v.value.toString());");
            this.printer.decr().indent().pln('}');
        } else {
            this.printer.indent().pln("if (v.value instanceof Node) {").incr();
            this.printer.indent().pln("Printer ptr = new");
            this.printer.indentMore().p("Printer(new BufferedWriter(new ").pln("OutputStreamWriter(System.out)));");
            this.printer.indent().pln("ptr.format((Node)v.value).pln().flush();");
            this.printer.decr().indent().pln("} else {").incr();
            this.printer.indent().pln("System.out.println(v.value.toString());");
            this.printer.decr().indent().pln('}');
        }
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("ParseError err = (ParseError)r;");
        this.printer.indent().pln("if (-1 == err.index) {").incr();
        this.printer.indent().pln("System.err.println(\"  Parse error\");");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().p("System.err.println(\"  \" + p.location(err.index) + ").pln("\": \" + err.msg);");
        this.printer.decr().indent().pln("}");
        this.printer.decr().indent().pln("}");
        this.printer.pln();
        this.printer.decr().indent().pln("} catch (Throwable x) {").incr();
        this.printer.indent().pln("while (null != x.getCause()) {").incr();
        this.printer.indent().pln("x = x.getCause();");
        this.printer.decr().indent().pln("}");
        this.printer.indent().pln("x.printStackTrace();");
        this.printer.decr().indent().pln("} finally {").incr();
        this.printer.indent().pln("try {").incr();
        this.printer.indent().pln("in.close();");
        this.printer.decr().indent().pln("} catch (Throwable x) {").incr();
        this.printer.indent().pln("/* Ignore. */");
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    public void visit(Module m) {
        boolean isVerbose;
        this.analyzer.register(this);
        this.printer.register(this);
        this.analyzer.init(m);
        this.className = Utilities.getName(m.getClassName());
        if (null == m.attributes) {
            m.attributes = new ArrayList<Attribute>();
        }
        this.attributeVerbose = m.hasAttribute(Constants.ATT_VERBOSE);
        this.attributeWithLocation = m.hasAttribute(Constants.ATT_WITH_LOCATION);
        this.attributeConstant = m.hasAttribute(Constants.ATT_CONSTANT);
        this.attributeFlatten = m.hasAttribute(Constants.ATT_FLATTEN);
        this.attributeParseTree = m.hasAttribute(Constants.ATT_PARSE_TREE);
        this.attributeRawTypes = m.hasAttribute(Constants.ATT_RAW_TYPES);
        this.attributeIgnoringCase = m.hasAttribute(Constants.ATT_IGNORING_CASE);
        this.attributeStateful = m.hasAttribute(Constants.ATT_STATEFUL.getName());
        this.attributeStringSet = m.hasAttribute("setOfString");
        this.attributeMain = m.hasAttribute("main");
        this.attributePrinter = m.hasAttribute("printer");
        this.attributeProfile = m.hasAttribute(Constants.ATT_PROFILE);
        this.attributeDump = m.hasAttribute(Constants.ATT_DUMP);
        if (this.attributeStateful) {
            this.stateClassName = (String)m.getAttributeValue(Constants.ATT_STATEFUL.getName());
        }
        if (this.attributeMain) {
            this.mainMethodNonterminal = (String)m.getAttributeValue("main");
        }
        if (this.attributePrinter) {
            this.printerClassName = (String)m.getAttributeValue("printer");
        }
        if (m.hasAttribute("factory")) {
            this.factoryClassName = (String)m.getAttributeValue("factory");
        }
        if (!(isVerbose = this.attributeVerbose)) {
            for (Production p : m.productions) {
                if (!p.hasAttribute(Constants.ATT_VERBOSE)) continue;
                isVerbose = true;
                break;
            }
        }
        this.chunked = false;
        this.chunkMap = null;
        this.chunkCount = 0;
        String packageName = Utilities.getQualifier(m.getClassName());
        if (null != packageName) {
            this.printer.indent().p("package ").p(packageName).pln(';');
            this.printer.pln();
        }
        this.printer.indent().pln("import java.io.Reader;");
        if (this.attributeMain) {
            this.printer.indent().pln("import java.io.BufferedReader;");
            this.printer.indent().pln("import java.io.BufferedWriter;");
            this.printer.indent().pln("import java.io.File;");
            this.printer.indent().pln("import java.io.FileReader;");
            this.printer.indent().pln("import java.io.OutputStreamWriter;");
        }
        this.printer.indent().pln("import java.io.IOException;");
        this.printer.pln();
        if (this.attributeProfile) {
            this.printer.indent().pln("import java.util.HashMap;");
        }
        if (this.attributeStringSet) {
            this.printer.indent().pln("import java.util.HashSet;");
            this.printer.indent().pln("import java.util.Set;");
        }
        if (this.attributeProfile || this.attributeStringSet) {
            this.printer.pln();
        }
        if (m.getBooleanProperty("recursive")) {
            this.printer.indent().pln("import xtc.util.Action;");
        }
        this.printer.indent().pln("import xtc.util.Pair;");
        this.printer.pln();
        boolean needsNewline = false;
        if (m.getBooleanProperty("locatable")) {
            this.printer.indent().pln("import xtc.tree.Locatable;");
            needsNewline = true;
        }
        if (m.getBooleanProperty("generic") || this.attributeMain) {
            this.printer.indent().pln("import xtc.tree.Node;");
            needsNewline = true;
        }
        if (m.getBooleanProperty("generic")) {
            if (null == this.factoryClassName) {
                this.printer.indent().pln("import xtc.tree.GNode;");
            } else if (Utilities.isQualified(this.factoryClassName)) {
                this.printer.indent().p("import ").p(this.factoryClassName).pln(';');
                this.factoryClassName = Utilities.getName(this.factoryClassName);
            }
            needsNewline = true;
        }
        if (this.attributeParseTree) {
            this.printer.indent().pln("import xtc.tree.Token;");
            this.printer.indent().pln("import xtc.tree.Formatting;");
            needsNewline = true;
        }
        if (isVerbose || this.attributeMain || this.attributeProfile || this.attributeDump) {
            this.printer.indent().pln("import xtc.tree.Printer;");
            needsNewline = true;
        }
        if (this.attributePrinter) {
            this.printer.indent().pln("import xtc.tree.Visitor;");
            needsNewline = true;
        }
        if (needsNewline) {
            this.printer.pln();
        }
        this.printer.indent().pln("import xtc.parser.ParserBase;");
        this.printer.indent().pln("import xtc.parser.Column;");
        this.printer.indent().pln("import xtc.parser.Result;");
        this.printer.indent().pln("import xtc.parser.SemanticValue;");
        this.printer.indent().pln("import xtc.parser.ParseError;");
        this.printer.pln();
        if (null != m.header) {
            this.action(m.header);
            this.printer.pln();
        }
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Packrat parser for grammar <code>").p(m.name.name).pln("</code>.");
        this.printer.indent().pln(" *");
        this.printer.indent().p(" * <p />This class has been generated by the ").pln("<i>Rats!</i> parser");
        this.printer.indent().p(" * generator, version ").p("1.15.0").p(", ").p("(C) 2004-2009 Robert Grimm").pln('.');
        this.printer.indent().pln(" */");
        if (this.attributeRawTypes) {
            this.printer.indent().pln("@SuppressWarnings(\"unchecked\")");
        }
        this.printer.indent();
        if (m.hasAttribute("visibility")) {
            String visible = (String)m.getAttributeValue("visibility");
            if (Constants.ATT_PUBLIC.getValue().equals(visible)) {
                this.printer.p("public ");
            }
        } else {
            this.printer.p("public ");
        }
        this.printer.p("final class ").p(this.className).pln(" extends ParserBase {").incr().pln();
        if (isVerbose) {
            this.printer.indent().p("/** Flag for whether to emit tracing information while ").pln("parsing. */");
            this.printer.indent().pln("public static final boolean DEBUG = true;");
            this.printer.pln();
            this.printer.indent().pln("/** Flag for whether to emit a peek into the input. */");
            this.printer.indent().pln("public static final boolean PEEK = true;");
            this.printer.pln();
        }
        if (m.hasAttribute("setOfString") || m.hasAttribute("flag")) {
            for (Attribute att : m.attributes) {
                if (att.getName().equals("setOfString")) {
                    String set = (String)att.getValue();
                    this.printer.indent().p("/** The ").p(set).pln(" set. */");
                    if (this.attributeRawTypes) {
                        this.printer.indent().p("public static final Set ").p(set).pln(" = new HashSet();");
                    } else {
                        this.printer.indent().p("public static final Set<String> ").p(set).pln(" = new HashSet<String>();");
                    }
                    this.printer.pln();
                    continue;
                }
                if (!att.getName().equals("flag")) continue;
                String flag = (String)att.getValue();
                this.printer.indent().p("/** The ").p(flag).pln(" flag. */");
                this.printer.indent().p("public static final boolean ").p(flag).pln(" = true;");
                this.printer.pln();
            }
        }
        int memoCount = 0;
        for (Production p : m.productions) {
            if (this.runtime.test("optimizeTransient") && !p.isMemoized()) continue;
            ++memoCount;
        }
        if (this.runtime.test("optimizeChunks") && 10 <= memoCount) {
            this.chunked = true;
            this.chunkMap = new HashMap<NonTerminal, Integer>(memoCount * 4 / 3);
            Integer number = null;
            String sNumber = null;
            int i = 10;
            boolean first = true;
            for (Production p : m.productions) {
                if (this.runtime.test("optimizeTransient") && !p.isMemoized()) continue;
                if (10 <= i) {
                    ++this.chunkCount;
                    number = new Integer(this.chunkCount);
                    sNumber = Integer.toString(this.chunkCount);
                    i = 0;
                    if (first) {
                        first = false;
                        this.printer.sep();
                    } else {
                        this.printer.decr().indent().pln('}');
                    }
                    this.printer.pln();
                    this.printer.indent().p("/** Chunk ").p(sNumber).pln(" of memoized results. */");
                    this.printer.indent().p("static final class Chunk").p(sNumber).pln(" {").incr();
                }
                NonTerminal nt = p.name;
                this.chunkMap.put(nt, number);
                ++i;
                this.printer.indent().p("Result ").p(PREFIX_FIELD).p(nt.toIdentifier()).pln(';');
                if (!this.attributeProfile) continue;
                this.printer.indent().p("int    ").p(PREFIX_COUNT_FIELD).p(nt.toIdentifier()).pln(';');
            }
            this.printer.decr().indent().pln('}');
            this.printer.pln();
        }
        this.printer.sep().pln();
        this.printer.indent().pln("/** Memoization table column. */");
        this.printer.indent().p("static final class ").p(this.className).pln("Column extends Column {").incr();
        if (this.chunked) {
            for (int i = 1; i <= this.chunkCount; ++i) {
                this.printer.indent().p("Chunk").p(i).p(' ').p("chunk").p(i).pln(';');
            }
        } else {
            for (Production p : m.productions) {
                if (this.runtime.test("optimizeTransient") && !p.isMemoized()) continue;
                this.printer.indent().p("Result ").p(PREFIX_FIELD).p(p.name.toIdentifier()).pln(';');
                if (!this.attributeProfile) continue;
                this.printer.indent().p("int    ").p(PREFIX_COUNT_FIELD).p(p.name.toIdentifier()).pln(';');
            }
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        if (this.attributeStateful || isVerbose) {
            this.printer.sep().pln();
            if (this.attributeStateful) {
                this.printer.indent().pln("/** The global state object. */");
                this.printer.indent().p("protected final ").p(this.stateClassName).p(' ').p(STATE).pln(';');
                this.printer.pln();
            }
            if (isVerbose) {
                this.printer.indent().pln("/** The printer for tracing this parser. */");
                this.printer.indent().p("protected final Printer ").p(PRINTER).pln(';');
                this.printer.pln();
            }
        }
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Create a new packrat parser.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param reader The reader.");
        this.printer.indent().pln(" * @param file The file name.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("public ").p(this.className).pln("(final Reader reader, final String file) {").incr();
        this.printer.indent().pln("super(reader, file);");
        if (this.attributeStateful) {
            this.printer.indent().p(STATE).p(" = new ").p(this.stateClassName).pln("();");
        }
        if (isVerbose) {
            this.printer.indent().p(PRINTER).pln(" = new Printer(System.out);");
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Create a new packrat parser.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param reader The file reader.");
        this.printer.indent().pln(" * @param file The file name.");
        this.printer.indent().pln(" * @param size The file size.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("public ").p(this.className).pln("(final Reader reader, final String file, final int size) {").incr();
        this.printer.indent().pln("super(reader, file, size);");
        if (this.attributeStateful) {
            this.printer.indent().p(STATE).p(" = new ").p(this.stateClassName).pln("();");
        }
        if (isVerbose) {
            this.printer.indent().p(PRINTER).pln(" = new Printer(System.out);");
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.sep().pln();
        this.printer.indent().pln("protected Column newColumn() {").incr();
        this.printer.indent().p("return new ").p(this.className).pln("Column();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        for (Production p : m.productions) {
            boolean savedVerbose = this.attributeVerbose;
            boolean savedLocation = this.attributeWithLocation;
            boolean savedConstant = this.attributeConstant;
            boolean savedCase = this.attributeIgnoringCase;
            if (!savedVerbose && p.hasAttribute(Constants.ATT_VERBOSE)) {
                this.attributeVerbose = true;
            }
            if (!savedLocation && p.hasAttribute(Constants.ATT_WITH_LOCATION)) {
                this.attributeWithLocation = true;
            }
            if (!savedConstant && p.hasAttribute(Constants.ATT_CONSTANT)) {
                this.attributeConstant = true;
            }
            if (!savedCase && p.hasAttribute(Constants.ATT_IGNORING_CASE)) {
                this.attributeIgnoringCase = true;
            }
            this.analyzer.process(p);
            this.attributeIgnoringCase = savedCase;
            this.attributeConstant = savedConstant;
            this.attributeWithLocation = savedLocation;
            this.attributeVerbose = savedVerbose;
        }
        if (null != m.body) {
            this.printer.sep().pln();
            this.action(m.body);
            this.printer.pln();
        }
        if (m.getBooleanProperty("generic") || m.hasAttribute(Constants.ATT_GENERIC_AS_VOID)) {
            this.printer.sep().pln();
            if (this.attributeParseTree) {
                this.printer.indent().pln("/**");
                this.printer.indent().p(" * Get the text for the specified annotated ").pln("token.");
                this.printer.indent().pln(" *");
                this.printer.indent().pln(" * @param n The annotated token.");
                this.printer.indent().pln(" * @return The corresponding text.");
                this.printer.indent().pln(" */");
                this.printer.indent().pln("protected static final String toText(Node n) {").incr();
                this.printer.indent().pln("return n.getTokenText();");
                this.printer.decr().indent().pln('}');
            } else {
                this.printer.indent().pln("/**");
                this.printer.indent().pln(" * Get the specified text.");
                this.printer.indent().pln(" *");
                this.printer.indent().pln(" * @param s The text.");
                this.printer.indent().pln(" * @return The text.");
                this.printer.indent().pln(" */");
                this.printer.indent().pln("protected static final String toText(String s) {").incr();
                this.printer.indent().pln("return s;");
                this.printer.decr().indent().pln('}');
            }
            this.printer.pln();
        }
        if (this.attributeStringSet) {
            this.printer.sep().pln();
            this.printer.indent().pln("/**");
            this.printer.indent().pln(" * Add the specified values to the specified set.");
            this.printer.indent().pln(" *");
            this.printer.indent().pln(" * @param set The set.");
            this.printer.indent().pln(" * @param values The new values.");
            this.printer.indent().pln(" */");
            if (this.attributeRawTypes) {
                this.printer.indent().p("protected static final ").pln("void add(Set set, Object[] values) {").incr();
                this.printer.indent().pln("for (int i=0; i<values.length; i++) {").incr();
                this.printer.indent().pln("set.add(values[i]);");
                this.printer.decr().indent().pln('}');
                this.printer.decr().indent().pln('}');
            } else {
                this.printer.indent().p("protected static final ").pln("<T> void add(Set<T> set, T[] values) {").incr();
                this.printer.indent().pln("for (T v : values) set.add(v);");
                this.printer.decr().indent().pln('}');
            }
            this.printer.pln();
            this.printer.indent().pln("/**");
            this.printer.indent().pln(" * Check whether the specified set contains the specified value.");
            this.printer.indent().pln(" *");
            this.printer.indent().pln(" * @param set The set.");
            this.printer.indent().pln(" * @param value The value.");
            this.printer.indent().pln(" * @return <code>true</code> if the set contains the value.");
            this.printer.indent().pln(" */");
            if (this.attributeRawTypes) {
                this.printer.indent().p("protected static final ").pln("boolean contains(Set set, Object value) {").incr();
                this.printer.indent().pln("return set.contains(value);");
                this.printer.decr().indent().pln('}');
            } else {
                this.printer.indent().p("protected static final ").pln("<T> boolean contains(Set<T> set, T value) {").incr();
                this.printer.indent().pln("return set.contains(value);");
                this.printer.decr().indent().pln('}');
            }
            this.printer.pln();
        }
        if (this.attributeVerbose) {
            this.verbose();
        }
        if (this.attributeProfile) {
            this.profile();
        }
        if (this.attributeDump) {
            this.dump();
        }
        if (this.attributeMain) {
            this.mainMethod(this.mainMethodNonterminal);
        }
        this.printer.decr().indent().pln('}');
        if (null != m.footer) {
            this.printer.pln().sep().pln();
            this.action(m.footer);
        }
    }

    public void visit(FullProduction p) {
        int i;
        MetaData md = (MetaData)p.getProperty("metaData");
        this.repetitionTypes = md.boundRepetitions;
        this.optionTypes = md.options;
        String field = this.fieldName(p.name, PREFIX_FIELD);
        String method = this.methodName(p.name);
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Parse ");
        if (p.getBooleanProperty("xtc.Constants.Synthetic")) {
            this.printer.p("synthetic ");
        }
        this.printer.p("nonterminal ").buffer().p(p.qName.name).p('.').fit(" * ").pln();
        if (p.hasProperty("duplicates")) {
            this.printer.indent();
            this.printer.p(" * This nonterminal represents the duplicate productions ");
            List<String> src = Properties.getDuplicates(p);
            Iterator<String> iter = src.iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                this.printer.buffer();
                if (1 < src.size() && !iter.hasNext()) {
                    this.printer.p("and ");
                }
                this.printer.p(name);
                if (2 == src.size() && iter.hasNext()) {
                    this.printer.p(' ');
                } else if (iter.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p('.');
                }
                this.printer.fit(" * ");
            }
            this.printer.pln();
        }
        this.printer.indent().pln(" *");
        this.printer.indent().p(" * @param ").p(ARG_INDEX).pln(" The index.");
        this.printer.indent().pln(" * @return The result.");
        this.printer.indent().pln(" * @throws IOException Signals an I/O error.");
        this.printer.indent().pln(" */");
        this.printer.indent();
        if (p.hasAttribute(Constants.ATT_PUBLIC)) {
            this.printer.p("public");
        } else {
            this.printer.p("private");
        }
        long line = this.printer.line();
        this.printer.p(" Result ").p(method).p("(final ").p(this.indexT()).p(' ').p(ARG_INDEX).p(") ").buffer().p("throws IOException {").fitMore().pln().incr();
        if (line + 1L < this.printer.line()) {
            this.printer.pln();
        }
        if (!this.runtime.test("optimizeTransient") || p.isMemoized()) {
            this.printer.indent().p(this.className).p("Column ").p(COLUMN).p(" = (").p(this.className).p("Column)column(").p(ARG_INDEX).pln(");");
            if (this.chunked) {
                String chunk = this.chunkMap.get(p.name).toString();
                this.printer.indent().p("if (").p(this.nullExpr()).p(" == ").p(COLUMN).p(".chunk").p(chunk).p(") ").p(COLUMN).p(".chunk").p(chunk).p(" = new Chunk").p(chunk).pln("();");
            }
            this.printer.indent().p("if (").p(this.nullExpr()).p(" == ").p(field).p(") ").buffer().p(field).p(" = ").p(method).p("$1(").p(ARG_INDEX).p(");").fitMore().pln();
            if (this.attributeProfile) {
                this.printer.indent().p(this.fieldName(p.name, PREFIX_COUNT_FIELD)).pln("++;");
            }
            if (this.attributeVerbose) {
                this.printer.indent().p("traceLookup(\"").p(p.name.toIdentifier()).p("\", ").p(ARG_INDEX).p(", ").buffer().p(field).p(");").fitMore().pln();
            }
            this.printer.indent().p("return ").p(field).pln(';');
            this.printer.decr().indent().pln('}');
            this.printer.pln();
            this.printer.indent().p("/** Actually parse ");
            this.printer.p(p.qName.name).pln(". */");
            line = this.printer.line();
            this.printer.indent().p("private Result ").p(method).p("$1(final ").p(this.indexT()).p(' ').p(ARG_INDEX).p(") ").buffer().p("throws IOException {").fitMore().pln().incr();
            if (line + 1L < this.printer.line()) {
                this.printer.pln();
            }
        }
        String ptype = this.extern(p.type);
        if (this.attributeRawTypes) {
            ptype = this.rawT(ptype);
        }
        int w = Math.max("ParseError".length(), ptype.length());
        if (!this.attributeRawTypes) {
            for (Type t : this.repetitionTypes) {
                if (null == t) continue;
                w = Math.max(w, this.extern(t).length());
            }
        }
        for (Type t : this.optionTypes) {
            if (null == t) continue;
            String s = this.extern(t);
            if (this.attributeRawTypes) {
                s = this.rawT(s);
            }
            w = Math.max(w, s.length());
        }
        int align = this.printer.level() * 2 + w + 1 + 1;
        if (md.requiresChar) {
            this.printer.indent().p(this.intT()).align(align).p(CHAR).pln(';');
        }
        if (md.requiresIndex) {
            this.printer.indent().p(this.indexT()).align(align).p(INDEX).pln(';');
        }
        if (md.requiresResult) {
            this.printer.indent().p("Result").align(align).p(RESULT).pln(';');
        }
        if (md.requiresPredIndex) {
            this.printer.indent().p(this.indexT()).align(align).p(PRED_INDEX).pln(';');
        }
        if (md.requiresPredResult) {
            this.printer.indent().p("Result").align(align).p(PRED_RESULT).pln(';');
        }
        if (md.requiresPredMatch) {
            this.printer.indent().p(this.booleanT()).align(align).p(PRED_MATCHED).pln(';');
        }
        if (md.requiresBaseIndex) {
            this.printer.indent().p(this.indexT()).align(align).p(BASE_INDEX).pln(';');
        }
        for (i = 0; i < md.repetitions.size(); ++i) {
            this.printer.indent().p(this.indexT()).align(align).p(REPETITION).p(i + 1).pln(';');
            if (md.repetitions.get(i).booleanValue()) {
                this.printer.indent().p(this.booleanT()).align(align).p(REPEATED).p(i + 1).pln(';');
            }
            if (null == this.repetitionTypes.get(i)) continue;
            this.printer.indent();
            if (this.attributeRawTypes) {
                this.printer.p(this.rawT(this.extern(new InstantiatedT(AST.ANY, AST.LIST))));
            } else {
                this.printer.p(this.extern(this.repetitionTypes.get(i)));
            }
            this.printer.align(align).p(REP_VALUE).p(i + 1).pln(';');
        }
        for (i = 0; i < md.options.size(); ++i) {
            this.printer.indent().p(this.indexT()).align(align).p(OPTION).p(i + 1).pln(';');
            Type t = md.options.get(i);
            if (null == t) continue;
            String s = this.extern(t);
            if (this.attributeRawTypes) {
                s = this.rawT(s);
            }
            this.printer.indent().p(s).align(align).p(OP_VALUE).p(i + 1).pln(';');
        }
        this.printer.indent().p(ptype).align(align).p(VALUE).pln(';');
        this.printer.indent().p("ParseError").align(align).p(PARSE_ERROR).pln(" = ParseError.DUMMY;");
        if (this.attributeVerbose) {
            this.printer.pln();
            this.printer.indent().p("traceEnter(\"").p(p.name.toIdentifier()).p("\", ").p(ARG_INDEX).pln(");");
        }
        if (this.attributeStateful) {
            if (p.hasAttribute(Constants.ATT_RESETTING)) {
                this.printer.pln();
                this.printer.indent().pln("// Reset the global state object.");
                this.printer.indent().p(STATE).p(".reset(column(").p(ARG_INDEX).pln(").file);");
            }
            if (p.hasAttribute(Constants.ATT_STATEFUL)) {
                this.printer.pln();
                this.printer.indent().pln("// Start a state modification.");
                this.printer.indent().p(STATE).pln(".start();");
            }
        }
        this.indexName = INDEX;
        this.resultName = RESULT;
        this.baseIndex = ARG_INDEX;
        this.useBaseIndex = true;
        this.indentLevel = 0;
        this.choiceLevel = -1;
        this.repeated = false;
        this.repeatedOnce = false;
        this.repeatedElement = null;
        this.savedRepeated = false;
        this.savedRepeatedOnce = false;
        this.optional = false;
        this.optionLevel = 0;
        this.optionalElement = null;
        this.savedOptional = false;
        this.createsNodeValue = false;
        this.seenTest = false;
        this.endsWithParseError = false;
        this.dispatch(p.choice);
        if (this.seenTest) {
            if (this.attributeStateful && p.hasAttribute(Constants.ATT_STATEFUL)) {
                this.printer.pln();
                this.printer.indent().pln("// Abort the state modification.");
                this.printer.indent().p(STATE).pln(".abort();");
            }
            this.printer.pln();
            this.printer.indent().pln("// Done.");
            if (this.attributeVerbose) {
                this.printer.indent().p("traceFailure(\"").p(p.name.toIdentifier()).p("\", ").p(ARG_INDEX).pln(");");
            }
            if (p.hasAttribute(Constants.ATT_EXPLICIT)) {
                this.printer.indent().p("return new ParseError(\"").p(Utilities.split(p.name.unqualify().name, ' ')).p(" expected\", ").p(ARG_INDEX).pln(");");
            } else {
                if (this.endsWithParseError && (p.isMemoized() || !this.runtime.test("optimizeErrors2"))) {
                    this.parseError();
                }
                this.printer.indent().p("return ").p(PARSE_ERROR).pln(';');
            }
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void result(String methodName, boolean saveIndex, boolean threadError) {
        this.printer.pln();
        this.firstElement = false;
        String receiver = PARSE_CHAR.equals(methodName) ? CHAR : this.resultName;
        int align = receiver.length();
        if (saveIndex) {
            align = Math.max(align, BASE_INDEX.length());
        }
        if (!this.notFollowedBy() && !PARSE_CHAR.equals(methodName)) {
            align = Math.max(align, PARSE_ERROR.length());
        }
        align += this.printer.level() * 2 + 1 + 1;
        if (this.useBaseIndex) {
            if (saveIndex) {
                this.printer.indent().p(BASE_INDEX).align(align).p("= ").buffer().p(this.baseIndex).p(';').fitMore().pln();
                this.printer.indent().p(receiver).align(align).p("= ").buffer().p(methodName).p('(').p(BASE_INDEX).p(");").fitMore().pln();
            } else {
                this.printer.indent().p(receiver).align(align).p("= ").buffer().p(methodName).p('(').p(this.baseIndex).p(");").fitMore().pln();
            }
            if (threadError) {
                this.threadParseError(align);
            }
            this.useBaseIndex = false;
        } else {
            if (saveIndex) {
                this.printer.indent().p(BASE_INDEX).align(align).p("= ").buffer().p(this.resultName).p(".index;").fitMore().pln();
                this.printer.indent().p(receiver).align(align).p("= ").buffer().p(methodName).p('(').p(BASE_INDEX).p(");").fitMore().pln();
            } else {
                this.printer.indent().p(receiver).align(align).p("= ").buffer().p(methodName).p('(').p(this.resultName).p(".index);").fitMore().pln();
            }
            if (threadError) {
                this.threadParseError(align);
            }
        }
    }

    protected void threadParseError(int align) {
        this.printer.indent().p(PARSE_ERROR).align(align).p("= ").buffer().p(this.resultName).p(".select(").p(PARSE_ERROR);
        if (this.optional) {
            this.printer.p(", ").p(OPTION).p(this.optionLevel);
        } else if (this.repeated && !this.repeatedOnce) {
            this.printer.p(", ").p(REPETITION).p(this.repetitionLevel);
        }
        this.printer.p(");").fitMore().pln();
    }

    protected void valueTest() {
        this.printer.indent().p("if (").p(this.resultName).pln(".hasValue()) {").incr();
    }

    protected void charValueTest() {
        this.printer.indent().p("if (-1 != ").p(CHAR).pln(") {").incr();
    }

    protected void stringValueTest(String text, boolean ignoreCase) {
        if (this.attributeParseTree) {
            if (ignoreCase) {
                this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("    ((Node)").p(this.resultName).p(".semanticValue()).getTokenText().equalsIgnoreCase(\"").escape(text, 8).pln("\")) {").incr();
            } else {
                this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("    ((Node)").p(this.resultName).p(".semanticValue()).getTokenText().equals(\"").escape(text, 8).pln("\")) {").incr();
            }
        } else if (this.runtime.test("optimizeMatches")) {
            if (ignoreCase) {
                this.printer.indent().p("if (").p(this.resultName).p(".hasValueIgnoreCase(\"").escape(text, 8).pln("\")) {").incr();
            } else {
                this.printer.indent().p("if (").p(this.resultName).p(".hasValue(\"").escape(text, 8).pln("\")) {").incr();
            }
        } else if (ignoreCase) {
            this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("   \"").escape(text, 8).p("\".equalsIgnoreCase(").p(this.resultName).pln(".semanticValue().toString())) {").incr();
        } else {
            this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("   \"").escape(text, 8).p("\".equals(").p(this.resultName).pln(".semanticValue())) {").incr();
        }
    }

    protected void index(String oldIndex, boolean isLastChar) {
        if (!this.predicate || this.predicate && (this.predicateIter.hasNext() || !isLastChar || this.repeated || this.optional)) {
            this.printer.indent().p(this.indexName).p(" = ").p(oldIndex).pln(" + 1;");
            this.useBaseIndex = true;
            this.baseIndex = this.indexName;
        }
    }

    protected void saveIndex(String savedIndex, String spacer, String base) {
        if (this.useBaseIndex) {
            if (!savedIndex.equals(base)) {
                this.printer.indent().p(savedIndex).p(spacer).p(" = ").p(base).pln(';');
            }
            this.useBaseIndex = false;
        } else {
            this.printer.indent().p(savedIndex).p(spacer).p(" = ").p(this.resultName).pln(".index;");
        }
    }

    protected void tested() {
        this.seenTest = true;
    }

    protected void nextElement() {
        if (this.predicate) {
            if (this.predicateIter.hasNext()) {
                this.dispatch(this.predicateIter.next());
                return;
            }
            if (this.repeated) {
                this.printer.pln();
                this.saveIndex(REPETITION + this.repetitionLevel, "", this.baseIndex);
                if (this.repeatedOnce) {
                    this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = true;");
                }
                if (null != this.repeatedElement) {
                    this.printer.indent().p(REP_VALUE).p(this.repetitionLevel).p("   = ").buffer();
                    if (this.attributeRawTypes) {
                        this.printer.p("new Pair(");
                    } else {
                        this.printer.p("new ").p(this.extern(this.repetitionTypes.get(this.repetitionLevel - 1))).p('(');
                    }
                    this.printer.p(this.repeatedElement).p(", ").p(REP_VALUE).p(this.repetitionLevel).p(");").fitMore().pln();
                }
                this.printer.indent().pln("continue;");
                return;
            }
            if (this.optional) {
                this.printer.pln();
                this.saveIndex(OPTION + this.optionLevel, " ", this.baseIndex);
                if (null != this.optionalElement) {
                    this.printer.indent().p(OP_VALUE).p(this.optionLevel).p(" = ").p(this.optionalElement).pln(';');
                }
                return;
            }
            if (this.notFollowedBy) {
                this.printer.pln();
                this.printer.indent().p(PRED_MATCHED).pln(" = true;");
                return;
            }
            this.predicate = false;
            this.optional = this.savedOptional;
            this.repeated = this.savedRepeated;
            this.repeatedOnce = this.savedRepeatedOnce;
            this.firstElement = this.savedFirstElement;
            this.baseIndex = this.savedBaseIndex;
            this.useBaseIndex = this.savedUseBaseIndex;
            this.indexName = INDEX;
            this.resultName = RESULT;
        }
        if (this.elementIter.hasNext()) {
            this.dispatch(this.elementIter.next());
        } else if (this.repeated) {
            this.printer.pln();
            this.saveIndex(REPETITION + this.repetitionLevel, "", this.baseIndex);
            if (this.repeatedOnce) {
                this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = true;");
            }
            if (null != this.repeatedElement) {
                this.printer.indent().p(REP_VALUE).p(this.repetitionLevel).p("   = ").buffer();
                if (this.attributeRawTypes) {
                    this.printer.p("new Pair(");
                } else {
                    this.printer.p("new ").p(this.extern(this.repetitionTypes.get(this.repetitionLevel - 1))).p('(');
                }
                this.printer.p(this.repeatedElement).p(", ").p(REP_VALUE).p(this.repetitionLevel).p(");").fitMore().pln();
            }
            this.printer.indent().pln("continue;");
        } else if (this.optional) {
            this.printer.pln();
            this.saveIndex(OPTION + this.optionLevel, " ", this.baseIndex);
            if (null != this.optionalElement) {
                this.printer.indent().p(OP_VALUE).p(this.optionLevel).p(" = ").p(this.optionalElement).pln(';');
            }
        } else {
            this.returnValue();
        }
    }

    private void location() {
        if (!this.attributeWithLocation) {
            return;
        }
        if (this.runtime.test("optimizeLocation") && !this.createsNodeValue) {
            return;
        }
        Constants.FuzzyBoolean hasLocation = this.ast.hasLocation(this.analyzer.current().type);
        if (Constants.FuzzyBoolean.FALSE == hasLocation) {
            return;
        }
        if (Constants.FuzzyBoolean.MAYBE == hasLocation) {
            this.printer.indent().p("if (").p(VALUE).pln(" instanceof Locatable) {").incr();
            this.printer.indent().p("setLocation((Locatable)").p(VALUE).p(", ").p(ARG_INDEX).pln(");");
            this.printer.decr().indent().pln('}');
        } else {
            this.printer.indent().p("setLocation(").p(VALUE).p(", ").p(ARG_INDEX).pln(");");
        }
    }

    protected void returnValue() {
        this.printer.pln();
        if (this.attributeStateful && this.analyzer.current().hasAttribute(Constants.ATT_STATEFUL)) {
            this.printer.indent().pln("// Commit the state modification.");
            this.printer.indent().p(STATE).pln(".commit();");
            this.printer.pln();
        }
        this.location();
        if (this.attributeVerbose) {
            this.printer.indent().p("traceSuccess(\"").p(this.analyzer.current().name.toIdentifier()).p("\", ").p(ARG_INDEX).pln(");");
        }
        if (this.useBaseIndex) {
            this.printer.indent().p("return new SemanticValue(").p(VALUE).p(", ").p(this.baseIndex).p(", ").p(PARSE_ERROR).pln(");");
            this.useBaseIndex = false;
        } else if (this.runtime.test("optimizeValues")) {
            this.printer.indent().p("return ").p(RESULT).p(".createValue(").p(VALUE).p(", ").p(PARSE_ERROR).pln(");");
        } else {
            this.printer.indent().p("return new SemanticValue(").p(VALUE).p(", ").p(RESULT).p(".index, ").p(PARSE_ERROR).pln(");");
        }
    }

    protected void parseError() {
        this.printer.indent().p(PARSE_ERROR).p(" = ").p(PARSE_ERROR).p(".select(\"").p(Utilities.split(this.analyzer.current().name.unqualify().name, ' ')).p(" expected\", ").p(ARG_INDEX).pln(");");
    }

    protected void parseError(String text) {
        this.printer.indent().p(PARSE_ERROR).p(" = ").p(PARSE_ERROR).p(".select(\"'").escape(text, 10).p("' expected\", ").p(BASE_INDEX).pln(");");
    }

    protected String nestedChoice() {
        return NESTED_CHOICE + Integer.toString(this.choiceLevel);
    }

    public void visit(OrderedChoice c) {
        boolean scoped;
        String base = this.baseIndex;
        boolean used = this.useBaseIndex;
        boolean creates = this.createsNodeValue;
        int indent = this.indentLevel;
        this.indentLevel = this.printer.level();
        ++this.choiceLevel;
        boolean bl = scoped = indent == this.indentLevel;
        if (scoped) {
            this.printer.indent().pln("{ // Start scope for nested choice.").incr();
        }
        if (0 != this.choiceLevel) {
            this.printer.pln();
            if (this.useBaseIndex) {
                this.printer.indent().p("final ").p(this.indexT()).p(' ').p(this.nestedChoice()).p(" = ").p(base).pln(';');
                this.useBaseIndex = false;
            } else {
                this.printer.indent().p("final ").p(this.indexT()).p(' ').p(this.nestedChoice()).p(" = ").buffer().p(this.resultName).p(".index;").fitMore().pln();
            }
        }
        int alternativeNumber = 0;
        for (Sequence s : c.alternatives) {
            this.elementIter = s.elements.iterator();
            if (0 == this.choiceLevel) {
                this.firstElement = true;
            }
            this.baseIndex = 0 == this.choiceLevel ? ARG_INDEX : this.nestedChoice();
            this.useBaseIndex = true;
            this.createsNodeValue = creates;
            this.seenTest = false;
            ++alternativeNumber;
            this.printer.pln();
            if (0 == this.choiceLevel) {
                this.printer.indent().p("// Alternative ");
            } else {
                this.printer.indent().p("// Nested alternative ");
            }
            if (null == s.name) {
                this.printer.p(alternativeNumber).pln('.');
            } else {
                this.printer.p('<').p(s.name.name).pln(">.");
            }
            this.nextElement();
        }
        if (scoped) {
            this.printer.decr().indent().pln("} // End scope for nested choice.");
        }
        --this.choiceLevel;
        this.indentLevel = indent;
        this.useBaseIndex = used;
        this.baseIndex = base;
    }

    public void visit(Repetition r) {
        Iterator<Element> iter;
        assert (r.element instanceof Sequence);
        this.firstElement = false;
        String base = this.baseIndex;
        boolean used = this.useBaseIndex;
        String repel = this.repeatedElement;
        if (this.hasBinding()) {
            Binding b = Analyzer.getBinding(((Sequence)r.element).elements);
            this.repeatedElement = b.name;
            this.bindingType = AST.listOf(this.ast.concretize(this.analyzer.type(b.element), AST.ANY));
        } else {
            this.repeatedElement = null;
            this.bindingType = null;
        }
        String name = this.bindingName;
        this.bindingName = null;
        Element bound = this.bindingElement;
        this.bindingElement = null;
        Type type = this.bindingType;
        this.bindingType = null;
        boolean rep = this.repeated;
        this.repeated = true;
        boolean once = this.repeatedOnce;
        this.repeatedOnce = r.once;
        boolean opt = this.optional;
        this.optional = false;
        ++this.repetitionLevel;
        this.printer.pln();
        this.saveIndex(REPETITION + this.repetitionLevel, "", base);
        if (this.repeatedOnce) {
            this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = false;");
        }
        if (null != name) {
            this.printer.indent().p(REP_VALUE).p(this.repetitionLevel).p("   = ").p(this.emptyListExpr()).pln(';');
        }
        if (this.predicate) {
            iter = this.predicateIter;
            this.predicateIter = ((Sequence)r.element).elements.iterator();
        } else {
            iter = this.elementIter;
            this.elementIter = ((Sequence)r.element).elements.iterator();
        }
        this.printer.indent().pln("while (true) {").incr();
        this.baseIndex = REPETITION + this.repetitionLevel;
        this.useBaseIndex = true;
        this.nextElement();
        this.printer.indent().pln("break;");
        this.printer.decr().indent().pln('}');
        if (this.predicate) {
            this.predicateIter = iter;
        } else {
            this.elementIter = iter;
        }
        if (this.repeatedOnce) {
            this.printer.pln();
            this.printer.indent().p("if (").p(REPEATED).p(this.repetitionLevel).pln(") {").incr();
        }
        --this.repetitionLevel;
        this.repeated = rep;
        this.repeatedOnce = once;
        this.repeatedElement = repel;
        this.optional = opt;
        this.bindingName = name;
        this.bindingElement = bound;
        this.bindingType = type;
        boolean closeBrace = false;
        String blockName = name;
        if (this.hasBinding()) {
            if (!r.once) {
                this.printer.indent().p("{ // Start scope for ").p(blockName).pln('.').incr();
                closeBrace = true;
            }
            this.binding();
            this.clearBinding();
        }
        this.baseIndex = REPETITION + Integer.toString(this.repetitionLevel + 1);
        this.useBaseIndex = true;
        if (!r.once) {
            this.seenTest = false;
        }
        this.nextElement();
        if (r.once) {
            this.printer.decr().indent().pln('}');
            this.tested();
        } else if (closeBrace) {
            this.printer.decr().indent().p("} // End scope for ").p(blockName).pln('.');
        }
        this.baseIndex = base;
        this.useBaseIndex = used;
    }

    public void visit(Option o) {
        Iterator<Element> iter;
        assert (o.element instanceof Sequence);
        this.firstElement = false;
        String base = this.baseIndex;
        boolean used = this.useBaseIndex;
        String optel = this.optionalElement;
        if (this.hasBinding()) {
            Binding b = Analyzer.getBinding(((Sequence)o.element).elements);
            this.optionalElement = b.name;
            this.bindingType = this.ast.concretize(this.analyzer.type(b.element), AST.ANY);
        } else {
            this.optionalElement = null;
            this.bindingType = null;
        }
        String name = this.bindingName;
        this.bindingName = null;
        Element bound = this.bindingElement;
        this.bindingElement = null;
        Type type = this.bindingType;
        this.bindingType = null;
        boolean opt = this.optional;
        this.optional = true;
        boolean rep = this.repeated;
        this.repeated = false;
        ++this.optionLevel;
        this.printer.pln();
        this.saveIndex(OPTION + this.optionLevel, " ", base);
        if (null != name) {
            this.printer.indent().p(OP_VALUE).p(this.optionLevel).p(" = ").p(this.nullExpr()).pln(';');
        }
        if (this.predicate) {
            iter = this.predicateIter;
            this.predicateIter = ((Sequence)o.element).elements.iterator();
        } else {
            iter = this.elementIter;
            this.elementIter = ((Sequence)o.element).elements.iterator();
        }
        this.baseIndex = OPTION + this.optionLevel;
        this.useBaseIndex = true;
        this.nextElement();
        if (this.predicate) {
            this.predicateIter = iter;
        } else {
            this.elementIter = iter;
        }
        --this.optionLevel;
        this.optional = opt;
        this.optionalElement = optel;
        this.repeated = rep;
        this.bindingName = name;
        this.bindingElement = bound;
        this.bindingType = type;
        boolean closeBrace = false;
        String blockName = name;
        if (this.hasBinding()) {
            this.printer.indent().p("{ // Start scope for ").p(blockName).pln('.').incr();
            closeBrace = true;
            this.binding();
            this.clearBinding();
        }
        this.baseIndex = OPTION + Integer.toString(this.optionLevel + 1);
        this.useBaseIndex = true;
        this.seenTest = false;
        this.nextElement();
        if (closeBrace) {
            this.printer.decr().indent().p("} // End scope for ").p(blockName).pln('.');
        }
        this.baseIndex = base;
        this.useBaseIndex = used;
    }

    public void visit(FollowedBy p) {
        assert (!this.predicate);
        assert (p.element instanceof Sequence);
        this.predicate = true;
        this.notFollowedBy = false;
        this.savedOptional = this.optional;
        this.optional = false;
        this.savedRepeated = this.repeated;
        this.repeated = false;
        this.savedRepeatedOnce = this.repeatedOnce;
        this.repeatedOnce = false;
        this.savedFirstElement = this.firstElement;
        this.savedBaseIndex = this.baseIndex;
        if (!this.useBaseIndex) {
            this.baseIndex = "yyResult.index";
        }
        this.savedUseBaseIndex = this.useBaseIndex;
        this.useBaseIndex = true;
        this.indexName = PRED_INDEX;
        this.resultName = PRED_RESULT;
        this.predicateIter = ((Sequence)p.element).elements.iterator();
        this.nextElement();
        this.tested();
    }

    protected boolean notFollowedBy() {
        return this.predicate && this.notFollowedBy;
    }

    public void visit(NotFollowedBy p) {
        assert (!this.predicate);
        assert (p.element instanceof Sequence);
        this.predicate = true;
        this.notFollowedBy = true;
        this.savedOptional = this.optional;
        this.optional = false;
        this.savedRepeated = this.repeated;
        this.repeated = false;
        this.savedRepeatedOnce = this.repeatedOnce;
        this.repeatedOnce = false;
        this.savedFirstElement = this.firstElement;
        this.savedBaseIndex = this.baseIndex;
        if (!this.useBaseIndex) {
            this.baseIndex = "yyResult.index";
        }
        this.savedUseBaseIndex = this.useBaseIndex;
        this.useBaseIndex = true;
        this.indexName = PRED_INDEX;
        this.resultName = PRED_RESULT;
        this.predicateIter = ((Sequence)p.element).elements.iterator();
        this.printer.pln();
        this.printer.indent().p(PRED_MATCHED).pln(" = false;");
        this.nextElement();
        this.predicate = false;
        this.optional = this.savedOptional;
        this.repeated = this.savedRepeated;
        this.repeatedOnce = this.savedRepeatedOnce;
        this.firstElement = this.savedFirstElement;
        this.baseIndex = this.savedBaseIndex;
        this.useBaseIndex = this.savedUseBaseIndex;
        this.indexName = INDEX;
        this.resultName = RESULT;
        this.printer.pln();
        this.printer.indent().p("if (! ").p(PRED_MATCHED).pln(") {").incr();
        this.nextElement();
        this.printer.decr().indent().pln("} else {").incr();
        this.parseError();
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(SemanticPredicate p) {
        this.printer.pln().indent().p("if (");
        Action a = (Action)p.element;
        if (1 == a.code.size()) {
            this.printer.p(a.code.get(0)).pln(") {").incr();
        } else {
            boolean first = true;
            int column = this.printer.column();
            for (String s : a.code) {
                if (first) {
                    this.printer.p(s);
                    first = false;
                    continue;
                }
                this.printer.pln().align(column).p(s);
            }
            this.printer.pln(") {").incr();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(VoidedElement v) {
        this.dispatch(v.element);
    }

    public void visit(Binding b) {
        String oldName = this.bindingName;
        Element oldElement = this.bindingElement;
        Type oldType = this.bindingType;
        this.bindingName = b.name;
        this.bindingElement = b.element;
        this.bindingType = null;
        this.dispatch(b.element);
        this.bindingName = oldName;
        this.bindingElement = oldElement;
        this.bindingType = oldType;
    }

    protected boolean hasBinding() {
        return null != this.bindingName;
    }

    protected void binding() {
        switch (this.bindingElement.tag()) {
            case NONTERMINAL: {
                Type type = VALUE.equals(this.bindingName) ? this.analyzer.current().type : this.analyzer.lookup((NonTerminal)((NonTerminal)this.bindingElement)).type;
                Type cast = this.attributeRawTypes && !AST.isAny(type) ? type : null;
                this.binding1(this.extern(type), this.bindingName, this.extern(cast), this.resultName + ".semanticValue()");
                break;
            }
            case ANY_CHAR: 
            case CHAR_CLASS: 
            case CHAR_LITERAL: 
            case CHAR_SWITCH: {
                if (VALUE.equals(this.bindingName)) {
                    this.binding1(this.extern(AST.CHAR), this.bindingName, null, "Character.valueOf((" + this.charT() + ")" + CHAR + ")");
                    break;
                }
                this.binding1(this.charT(), this.bindingName, null, "(" + this.charT() + ")" + CHAR);
                break;
            }
            case STRING_LITERAL: {
                String text = ((StringLiteral)this.bindingElement).text;
                this.binding1(this.extern(AST.STRING), this.bindingName, null, '\"' + Utilities.escape(text, 8) + '\"');
                break;
            }
            case STRING_MATCH: {
                if (this.attributeParseTree) {
                    String cast = this.attributeRawTypes ? this.extern(AST.NODE) : null;
                    this.binding1(this.extern(AST.NODE), this.bindingName, cast, this.resultName + ".semanticValue()");
                    break;
                }
                this.binding1(this.extern(AST.STRING), this.bindingName, null, "\"" + Utilities.escape(((StringMatch)this.bindingElement).text, 8) + "\"");
                break;
            }
            case REPETITION: {
                int level = this.repetitionLevel + 1;
                String expr = REP_VALUE + level + ".reverse()";
                if (!this.attributeRawTypes && !this.repetitionTypes.get(this.repetitionLevel).equals(this.bindingType)) {
                    expr = "cast(" + expr + ')';
                }
                this.binding1(this.extern(this.bindingType), this.bindingName, null, expr);
                break;
            }
            case OPTION: {
                int level = this.optionLevel + 1;
                String cast = null;
                String expr = OP_VALUE + level;
                if (!this.optionTypes.get(this.optionLevel).equals(this.bindingType)) {
                    if (this.attributeRawTypes) {
                        cast = this.extern(this.bindingType);
                    } else {
                        expr = "cast(" + expr + ')';
                    }
                }
                this.binding1(this.extern(this.bindingType), this.bindingName, cast, expr);
                break;
            }
            case NULL: {
                this.binding1(this.extern(AST.ANY), this.bindingName, null, this.nullExpr());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized binding element " + this.bindingElement));
            }
        }
    }

    private void binding1(String type, String name, String cast, String expr) {
        if (this.attributeRawTypes) {
            type = this.rawT(type);
            if (null != cast) {
                cast = this.rawT(cast);
            }
        }
        this.printer.indent();
        if (VALUE.equals(name)) {
            this.printer.p(VALUE);
        } else {
            if (this.attributeConstant) {
                this.printer.p("final ");
            }
            this.printer.p(type).p(' ').p(name);
        }
        this.printer.p(" = ");
        if (null != cast) {
            this.printer.p('(').p(cast).p(')');
        }
        this.printer.p(expr).pln(';');
    }

    protected void clearBinding() {
        this.bindingName = null;
        this.bindingElement = null;
    }

    public void visit(StringMatch m) {
        boolean first = this.firstElement;
        NonTerminal nt = (NonTerminal)m.element;
        this.result(this.methodName(nt), !this.notFollowedBy() && (!this.runtime.test("optimizeErrors1") || !first), false);
        this.stringValueTest(m.text, this.attributeIgnoringCase);
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        if (this.notFollowedBy()) {
            this.printer.decr().indent().pln('}');
        } else if (this.runtime.test("optimizeErrors1") && first) {
            this.printer.decr().indent().pln('}');
            this.endsWithParseError = true;
        } else {
            this.printer.decr().indent().pln("} else {").incr();
            this.parseError(m.text);
            this.printer.decr().indent().pln('}');
        }
        this.tested();
    }

    public void visit(NonTerminal nt) {
        this.result(this.methodName(nt), false, !this.notFollowedBy());
        this.valueTest();
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        if (!this.notFollowedBy() && !this.analyzer.lookup(nt).isMemoized() && this.runtime.test("optimizeErrors2")) {
            this.endsWithParseError = true;
        }
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(AnyChar a) {
        String oldIndex = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false, false);
        this.charValueTest();
        this.index(oldIndex, true);
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(CharLiteral l) {
        String oldIndex = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false, false);
        this.printer.indent().p("if ('").escape(l.c, 8).p("' == ").p(CHAR).pln(") {").incr();
        this.index(oldIndex, true);
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(CharClass c) {
        String name;
        String oldIndex = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false, false);
        this.charValueTest();
        this.index(oldIndex, true);
        if (this.hasBinding()) {
            this.binding();
            name = this.bindingName;
            this.clearBinding();
            this.printer.pln();
        } else {
            name = CHAR;
        }
        int length = c.ranges.size();
        Iterator<CharRange> iter = c.ranges.iterator();
        if (1 == length) {
            this.printer.indent().p("if ");
        } else {
            this.printer.indent().p("if (");
        }
        while (iter.hasNext()) {
            CharRange r = iter.next();
            if (c.exclusive) {
                if (r.first == r.last) {
                    this.printer.p("('").escape(r.first, 8).p("' != ").p(name).p(')');
                } else {
                    this.printer.p('(').p(name).p(" < '").escape(r.first, 8).p(") || ('").escape(r.last, 8).p("' < ").p(name).p("))");
                }
            } else if (r.first == r.last) {
                this.printer.p("('").escape(r.first, 8).p("' == ").p(name).p(')');
            } else {
                this.printer.p("(('").escape(r.first, 8).p("' <= ").p(name).p(") && (").p(name).p(" <= '").escape(r.last, 8).p("'))");
            }
            if (!iter.hasNext()) continue;
            if (c.exclusive) {
                this.printer.pln(" &&");
            } else {
                this.printer.pln(" ||");
            }
            this.printer.indent().p("    ");
        }
        if (1 == length) {
            this.printer.pln(" {").incr();
        } else {
            this.printer.pln(") {").incr();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(StringLiteral l) {
        int i;
        boolean first = this.firstElement;
        int length = l.text.length();
        for (i = 0; i < length; ++i) {
            char c = l.text.charAt(i);
            String oldIndex = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
            this.result(PARSE_CHAR, 0 == i && !this.notFollowedBy() && (!this.runtime.test("optimizeErrors1") || !first), false);
            this.printer.indent().p("if ('").escape(c, 8).p("' == ").p(CHAR).pln(") {").incr();
            this.index(oldIndex, i == length - 1);
        }
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        for (i = 0; i < length; ++i) {
            if (this.notFollowedBy()) {
                this.printer.decr().indent().pln('}');
                continue;
            }
            if (this.runtime.test("optimizeErrors1") && first) {
                this.printer.decr().indent().pln('}');
                this.endsWithParseError = true;
                continue;
            }
            this.printer.decr().indent().pln("} else {").incr();
            this.parseError(l.text);
            this.printer.decr().indent().pln('}');
        }
        this.tested();
    }

    public void visit(CharSwitch s) {
        String name;
        String oldIndex = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false, false);
        this.charValueTest();
        this.index(oldIndex, true);
        this.printer.pln();
        String base = this.baseIndex;
        boolean used = this.useBaseIndex;
        if (this.hasBinding()) {
            this.binding();
            name = this.bindingName;
            this.clearBinding();
            this.printer.pln();
        } else {
            name = CHAR;
        }
        this.printer.indent().p("switch (").p(name).pln(") {").incr();
        for (CharCase c : s.cases) {
            for (CharRange r : c.klass.ranges) {
                for (char k = r.first; k <= r.last; k = (char)(k + '\u0001')) {
                    this.printer.indentLess().p("case '").escape(k, 8).pln("':");
                }
            }
            if (null == c.element) {
                this.printer.indent().pln("/* No match. */");
                this.printer.indent().pln("break;");
            } else {
                this.printer.indent().p('{').incr();
                this.baseIndex = base;
                this.useBaseIndex = used;
                this.seenTest = false;
                if (c.element instanceof OrderedChoice) {
                    this.dispatch(c.element);
                } else {
                    this.elementIter = ((Sequence)c.element).elements.iterator();
                    this.nextElement();
                }
                this.printer.decr().indent().pln('}');
                if (this.seenTest || this.optional) {
                    this.printer.indent().pln("break;");
                }
            }
            this.printer.pln();
        }
        if (null == s.base) {
            this.printer.indentLess().pln("default:");
            this.printer.indent().pln("/* No match. */");
        } else {
            this.printer.indentLess().pln("default:");
            this.printer.indent().p('{').incr();
            this.baseIndex = base;
            this.useBaseIndex = used;
            if (s.base instanceof OrderedChoice) {
                this.dispatch(s.base);
            } else {
                this.elementIter = ((Sequence)s.base).elements.iterator();
                this.nextElement();
            }
            this.printer.decr().indent().pln('}');
        }
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.endsWithParseError = true;
        this.tested();
    }

    public void visit(NodeMarker m) {
        this.nextElement();
    }

    protected void action(Action a) {
        int baseLevel = this.printer.level();
        int level = 0;
        Iterator<String> codeIter = a.code.iterator();
        Iterator<Integer> indentIter = a.indent.iterator();
        while (codeIter.hasNext()) {
            int i;
            int newLevel = indentIter.next();
            int diff = newLevel - level;
            level = newLevel;
            if (0 < diff) {
                for (i = 0; i < diff; ++i) {
                    this.printer.incr();
                }
            } else {
                for (i = 0; i > diff; --i) {
                    this.printer.decr();
                }
            }
            this.printer.indent().pln(codeIter.next());
        }
        this.printer.setLevel(baseLevel);
    }

    public void visit(Action a) {
        if (a.setsValue()) {
            this.createsNodeValue = true;
        }
        this.printer.pln();
        this.action(a);
        this.nextElement();
    }

    public void visit(ParserAction pa) {
        this.createsNodeValue = true;
        this.printer.pln();
        this.saveIndex(BASE_INDEX, "", this.baseIndex);
        this.printer.pln();
        this.action((Action)pa.element);
        this.printer.pln();
        if (!this.notFollowedBy()) {
            this.threadParseError(0);
        }
        this.valueTest();
        this.printer.indent().p(VALUE).p(" = ");
        if (this.attributeRawTypes && !AST.isAny(this.analyzer.current().type)) {
            this.printer.p('(').p(this.rawT(this.extern(this.analyzer.current().type))).p(')');
        }
        this.printer.p(RESULT).p(".semanticValue();");
        this.nextElement();
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(ParseTreeNode n) {
        assert (this.hasBinding());
        this.printer.indent();
        if (VALUE.equals(this.bindingName)) {
            this.printer.p(VALUE);
        } else {
            if (this.attributeConstant) {
                this.printer.p("final ");
            }
            this.printer.p(this.extern(AST.NODE)).p(' ').p(this.bindingName);
        }
        String node = null == n.node ? this.nullExpr() : this.var(n.node);
        this.printer.p(" = Formatting.");
        if (1 == n.predecessors.size() && 0 == n.successors.size()) {
            this.printer.p("before1(").p(this.var(n.predecessors.get(0))).p(", ").p(node).p(')');
        } else if (1 == n.predecessors.size() && 1 == n.successors.size()) {
            this.printer.p("round1(").p(this.var(n.predecessors.get(0))).p(", ").p(node).p(", ").p(this.var(n.successors.get(0))).p(')');
        } else if (0 == n.predecessors.size() && 1 == n.successors.size()) {
            this.printer.p("after1(").p(node).p(", ").p(this.var(n.successors.get(0))).p(')');
        } else {
            this.printer.pln("variable().").indentMore();
            boolean first = true;
            for (Binding b : n.predecessors) {
                if (first) {
                    first = false;
                } else {
                    this.printer.p('.');
                }
                this.printer.p("add(").p(this.var(b)).p(')');
            }
            if (null != n.node) {
                if (!first) {
                    this.printer.p('.');
                }
                this.printer.p("addNode(").p(node).p(')');
                for (Binding b : n.successors) {
                    this.printer.p(".add(").p(this.var(b)).p(')');
                }
            }
        }
        this.printer.pln(';');
        this.clearBinding();
        this.nextElement();
    }

    public void visit(NullLiteral l) {
        boolean emit = false;
        String name = null;
        if (this.hasBinding()) {
            if (!Analyzer.isSynthetic(this.bindingName)) {
                emit = true;
                name = this.bindingName;
                this.printer.indent().p("{ // Start scope for ").p(name).pln('.').incr();
                this.binding();
            }
            this.clearBinding();
        }
        this.nextElement();
        if (emit) {
            this.printer.decr().indent().p("} // End scope for ").p(name).pln('.');
        }
    }

    public void visit(NullValue v) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ").p(this.nullExpr()).pln(';');
        this.nextElement();
    }

    protected void emitDifference() {
        if (this.firstElement) {
            this.printer.p("\"\"");
        } else {
            this.printer.p("difference(").p(ARG_INDEX).p(", ");
            if (this.useBaseIndex) {
                this.printer.p(this.baseIndex);
            } else {
                this.printer.p(RESULT).p(".index");
            }
            this.printer.p(')');
        }
    }

    public void visit(StringValue v) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ");
        if (null == v.text) {
            this.emitDifference();
        } else {
            this.printer.p('\"').escape(v.text, 8).p('\"');
        }
        this.printer.pln(';');
        this.nextElement();
    }

    public void visit(TokenValue v) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = new Token(");
        if (null == v.text) {
            this.emitDifference();
        } else {
            this.printer.p('\"').escape(v.text, 8).p('\"');
        }
        this.printer.pln(");");
        Type type = this.analyzer.current().type;
        if (this.attributeWithLocation && this.runtime.test("optimizeLocation") && AST.isNode(type)) {
            this.printer.indent().p(VALUE).p(".setLocation(location(").p(ARG_INDEX).pln("));");
        } else {
            this.createsNodeValue = true;
        }
        this.nextElement();
    }

    protected String var(Binding b) {
        return Analyzer.isSynthetic(b.name) && b.element instanceof NullLiteral ? this.nullExpr() : b.name;
    }

    public void visit(BindingValue v) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ").p(this.var(v.binding)).pln(';');
        this.nextElement();
    }

    public void visit(EmptyListValue v) {
        this.printer.pln().indent().p(VALUE).p(" = ").p(this.emptyListExpr()).pln(';');
        this.nextElement();
    }

    public void visit(ProperListValue v) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ");
        boolean first = true;
        for (Binding b : v.elements) {
            if (first) {
                first = false;
            } else {
                this.printer.p(", ");
            }
            this.printer.p("new ");
            if (this.attributeRawTypes) {
                this.printer.p("Pair");
            } else {
                this.printer.p(this.extern(v.type));
            }
            this.printer.p('(').p(this.var(b));
        }
        if (null != v.tail) {
            this.printer.p(", ").p(this.var(v.tail));
        }
        for (int i = 0; i < v.elements.size(); ++i) {
            this.printer.p(')');
        }
        this.printer.pln(';');
        this.nextElement();
    }

    public void visit(ActionBaseValue v) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ");
        if (!AST.isAny(this.analyzer.current().type) && this.attributeRawTypes) {
            this.printer.p('(').p(this.rawT(this.extern(this.analyzer.current().type))).p(')');
        }
        this.printer.p("apply(").p(this.var(v.list)).p(", ").p(this.var(v.seed));
        if (this.attributeWithLocation && Constants.FuzzyBoolean.TRUE == this.ast.hasLocation(this.analyzer.current().type)) {
            this.printer.p(", ").p(ARG_INDEX);
        }
        this.printer.pln(");");
        this.nextElement();
    }

    protected int numberOfChildren(int base, List<Binding> children) {
        for (Binding b : children) {
            if (this.attributeFlatten && AST.isList(this.analyzer.type(b.element))) {
                if (this.analyzer.mayBeNull(b.element)) {
                    return Integer.MIN_VALUE;
                }
                base = Integer.MAX_VALUE;
                continue;
            }
            if (base == Integer.MAX_VALUE) continue;
            ++base;
        }
        return base;
    }

    protected void emitNumberOfChildren(int base, List<Binding> children) {
        boolean printed = false;
        for (Binding b : children) {
            if (this.attributeFlatten && AST.isList(this.analyzer.type(b.element))) {
                if (printed) {
                    this.printer.p(" + ");
                } else {
                    printed = true;
                }
                boolean test = this.analyzer.mayBeNull(b.element);
                if (test) {
                    this.printer.pln().indentMore().p('(').p(this.nullExpr()).p(" == ").p(b.name).p(" ? 0 : ");
                }
                this.printer.p(b.name).p(".size()");
                if (!test) continue;
                this.printer.p(')');
                continue;
            }
            ++base;
        }
        if (!printed) {
            this.printer.p(base);
        } else if (0 != base) {
            this.printer.p(" + ").p(base);
        }
    }

    protected void emitChildren(String first, List<Binding> children) {
        this.printer.p(')');
        boolean indent = true;
        if (null != first) {
            if (indent) {
                this.printer.pln('.').indentMore();
                indent = false;
            } else {
                this.printer.p('.');
            }
            this.printer.p("add(").p(first).p(')');
        }
        boolean statement = false;
        for (Binding b : children) {
            if (!this.attributeFlatten || !AST.isList(this.analyzer.type(b.element))) {
                if (statement) {
                    this.printer.pln(';').indent().p(VALUE).p('.');
                    statement = false;
                    indent = false;
                } else if (indent) {
                    this.printer.pln('.').indentMore();
                    indent = false;
                } else {
                    this.printer.p('.');
                }
                this.printer.p("add(");
            } else if (this.analyzer.mayBeNull(b.element)) {
                this.printer.pln(';').indent().p("if (").p(this.nullExpr()).p(" != ").p(this.var(b)).p(") ").p(VALUE).p(".addAll(");
                statement = true;
                indent = false;
            } else {
                if (statement) {
                    this.printer.pln(';').indent().p(VALUE).p('.');
                    statement = false;
                    indent = false;
                } else if (indent) {
                    this.printer.pln('.').indentMore();
                    indent = false;
                } else {
                    this.printer.p('.');
                }
                this.printer.p("addAll(");
            }
            this.printer.p(this.var(b)).p(')');
        }
    }

    protected void emitFactoryName() {
        if (null == this.factoryClassName) {
            this.printer.p("GNode");
        } else {
            this.printer.p(this.factoryClassName);
        }
    }

    protected void emitFormatting(List<Binding> formatting) {
        int size = formatting.size();
        if (0 == size) {
            return;
        }
        this.printer.indent().p(VALUE).p(" = Formatting.");
        if (1 == size) {
            this.printer.p("after1(").p(VALUE).p(", ").p(this.var(formatting.get(0))).p(')');
        } else {
            this.printer.p("variable().addNode(").p(VALUE).pln(").").indentMore();
            boolean first = true;
            for (Binding b : formatting) {
                if (first) {
                    first = false;
                } else {
                    this.printer.p('.');
                }
                this.printer.p("add(").p(this.var(b)).p(')');
            }
        }
        this.printer.pln(';');
    }

    protected void emitAction(GenericActionValue v) {
        boolean defineValue;
        if (this.attributeRawTypes) {
            this.printer.indent().p("public Object run(Object ").p(v.first).pln(") {").incr();
        } else {
            this.printer.indent().p("public Node run(Node ").p(v.first).pln(") {").incr();
        }
        String name = Utilities.unqualify(v.name);
        int numChildren = this.numberOfChildren(1, v.children);
        boolean bl = defineValue = Integer.MIN_VALUE == numChildren || 0 < v.formatting.size();
        if (defineValue) {
            this.printer.indent().p("Node ").p(VALUE).p(" = ");
        } else {
            this.printer.indent().p("return ");
        }
        this.emitFactoryName();
        boolean emitAdditions = true;
        if (this.runtime.test("optimizeGenericNodes") && 0 <= numChildren) {
            if (1 == numChildren) {
                this.printer.p(".create(\"").p(name).p("\", ").p(v.first).p(')');
                emitAdditions = false;
            } else if (8 >= numChildren) {
                this.printer.p(".create(\"").p(name).p("\", ").p(v.first).p(", ");
                Iterator iter = v.children.iterator();
                while (iter.hasNext()) {
                    Binding b = (Binding)iter.next();
                    this.printer.p(this.var(b));
                    if (iter.hasNext()) {
                        this.printer.p(", ");
                        continue;
                    }
                    this.printer.p(')');
                }
                emitAdditions = false;
            } else if (1 == v.children.size()) {
                Binding b = (Binding)v.children.get(0);
                this.printer.p(".createFromPair(\"").p(name).p("\", ").p(v.first).p(", ").p(this.var(b)).p(')');
                emitAdditions = false;
            }
        }
        if (emitAdditions) {
            this.printer.p(".create(\"").p(name).p("\", ");
            this.emitNumberOfChildren(1, v.children);
            this.emitChildren(v.first, v.children);
        }
        this.printer.pln(';');
        this.emitFormatting(v.formatting);
        if (defineValue) {
            this.printer.indent().p("return ").p(VALUE).pln(';');
        }
        this.printer.decr().indent().p('}');
    }

    public void visit(GenericNodeValue v) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ");
        this.emitFactoryName();
        String name = Utilities.unqualify(v.name);
        int numChildren = this.numberOfChildren(0, v.children);
        boolean emitAdditions = true;
        if (this.runtime.test("optimizeGenericNodes") && 0 <= numChildren) {
            if (0 == numChildren) {
                this.printer.p(".create(\"").p(name).p("\", false)");
                emitAdditions = false;
            } else if (8 >= numChildren) {
                this.printer.p(".create(\"").p(name).p("\", ");
                Iterator iter = v.children.iterator();
                while (iter.hasNext()) {
                    Binding b = (Binding)iter.next();
                    this.printer.p(this.var(b));
                    if (iter.hasNext()) {
                        this.printer.p(", ");
                        continue;
                    }
                    this.printer.p(')');
                }
                emitAdditions = false;
            } else if (1 == v.children.size()) {
                Binding b = (Binding)v.children.get(0);
                this.printer.p(".createFromPair(\"").p(name).p("\", ").p(this.var(b)).p(')');
                emitAdditions = false;
            } else if (2 == v.children.size()) {
                Binding b1 = (Binding)v.children.get(0);
                Binding b2 = (Binding)v.children.get(1);
                if (!AST.isList(this.analyzer.type(b1.element)) && AST.isList(this.analyzer.type(b2.element))) {
                    this.printer.p(".createFromPair(\"").p(name).p("\", ").p(this.var(b1)).p(", ").p(this.var(b2)).p(')');
                    emitAdditions = false;
                }
            }
        }
        if (emitAdditions) {
            this.printer.p(".create(\"").p(name).p("\", ");
            this.emitNumberOfChildren(0, v.children);
            this.emitChildren(null, v.children);
        }
        this.printer.pln(';');
        if (this.attributeWithLocation && this.runtime.test("optimizeLocation") && AST.isNode(this.analyzer.current().type)) {
            this.printer.indent().p(VALUE).p(".setLocation(location(").p(ARG_INDEX).pln("));");
        } else {
            this.createsNodeValue = true;
        }
        this.emitFormatting(v.formatting);
        this.nextElement();
    }

    public void visit(GenericActionValue v) {
        this.printer.pln();
        if (this.attributeRawTypes) {
            this.printer.indent().p(VALUE).pln(" = new Action() {").incr();
        } else {
            this.printer.indent().p(VALUE).pln(" = new Action<Node>() {").incr();
        }
        this.emitAction(v);
        this.printer.pln("};").decr();
        this.nextElement();
    }

    public void visit(GenericRecursionValue v) {
        this.printer.pln();
        if (this.attributeRawTypes) {
            this.printer.indent().p(VALUE).pln(" = new Pair(new Action() {").incr();
        } else {
            this.printer.indent().p(VALUE).pln(" = new Pair<Action<Node>>(new Action<Node>() {").incr();
        }
        this.emitAction(v);
        this.printer.p("}, ").p(this.var(v.list)).pln(");").decr();
        this.nextElement();
    }
}

