/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.MetaData;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.parser.StringValue;
import xtc.parser.TokenValue;
import xtc.parser.ValueElement;
import xtc.type.AST;
import xtc.util.Runtime;

public class ChoiceExpander
extends GrammarVisitor {
    protected boolean hasState;
    protected Mode mode;

    public ChoiceExpander(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    protected NonTerminal candidate(Sequence alternative, boolean top) {
        Element e = Analyzer.strip(alternative);
        if (e instanceof Binding) {
            Binding b = (Binding)e;
            if (top && "yyValue".equals(b.name) && b.element instanceof NonTerminal) {
                return (NonTerminal)b.element;
            }
        } else if (AST.isVoid(this.analyzer.current().type) || this.analyzer.current().getBooleanProperty("textOnly") || this.analyzer.current().getBooleanProperty("token")) {
            Sequence s;
            if (e instanceof NonTerminal) {
                return (NonTerminal)e;
            }
            if (e instanceof Sequence && 2 == (s = (Sequence)e).size() && s.get(0) instanceof NonTerminal && s.get(1) instanceof ValueElement) {
                return (NonTerminal)s.get(0);
            }
        }
        return null;
    }

    protected void inlined(Production p) {
        if (this.runtime.test("optionVerbose")) {
            System.err.println("[Inlining " + p.qName + " into " + this.analyzer.current().qName + "]");
        }
    }

    @Override
    public Object visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        this.hasState = m.hasAttribute(Constants.ATT_STATEFUL.getName());
        for (Production p : m.productions) {
            this.mode = Mode.INLINE;
            if (!this.runtime.test("optimizeChoices2") && !AST.isVoid(p.type) && !p.getBooleanProperty("textOnly") && !p.getBooleanProperty("token")) continue;
            this.analyzer.process(p);
        }
        return null;
    }

    @Override
    public Element visit(OrderedChoice c) {
        boolean top = this.isTopLevel;
        this.isTopLevel = false;
        boolean last = this.isLastElement;
        this.isLastElement = false;
        for (int i = 0; i < c.alternatives.size(); ++i) {
            NonTerminal date;
            Sequence alternative = c.alternatives.get(i);
            if (Mode.INLINE == this.mode && null != (date = this.candidate(alternative, top))) {
                FullProduction p = this.analyzer.lookup(date);
                MetaData md = (MetaData)p.getProperty("metaData");
                if ((!p.isMemoized() && !p.hasAttribute(Constants.ATT_NO_INLINE) && !p.hasAttribute(Constants.ATT_EXPLICIT) && (AST.isVoid(p.type) || p.getBooleanProperty("textOnly") || p.getBooleanProperty("token")) || p.hasAttribute(Constants.ATT_INLINE) && this.runtime.test("optimizeChoices2")) && 0 == md.selfCount && (!this.hasState || !p.hasAttribute(Constants.ATT_STATEFUL) && !p.hasAttribute(Constants.ATT_RESETTING))) {
                    OrderedChoice choice = this.analyzer.copy(p.choice);
                    if (1 == choice.alternatives.size()) {
                        choice.alternatives.get(0).setLocation(alternative);
                    }
                    if (!top && !last) {
                        this.mode = Mode.RM_VALUES;
                        choice = (OrderedChoice)this.dispatch(choice);
                        this.mode = Mode.INLINE;
                    } else if (AST.isVoid(this.analyzer.current().type)) {
                        this.mode = Mode.VOID_VALUES;
                        choice = (OrderedChoice)this.dispatch(choice);
                        this.mode = Mode.INLINE;
                    } else if (this.analyzer.current().getBooleanProperty("textOnly") && !top) {
                        this.mode = Mode.TEXT_VALUES;
                        choice = (OrderedChoice)this.dispatch(choice);
                        this.mode = Mode.INLINE;
                    } else if (this.analyzer.current().getBooleanProperty("token")) {
                        this.mode = Mode.TOKEN_VALUES;
                        choice = (OrderedChoice)this.dispatch(choice);
                        this.mode = Mode.INLINE;
                    }
                    c.alternatives.remove(i);
                    c.alternatives.addAll(i, choice.alternatives);
                    this.inlined(p);
                    --i;
                    continue;
                }
            }
            if (top || last) {
                this.isLastElement = true;
            }
            c.alternatives.set(i, (Sequence)this.dispatch(alternative));
        }
        return c;
    }

    @Override
    public Element visit(Sequence s) {
        this.isTopLevel = false;
        boolean last = this.isLastElement;
        int size = s.size();
        if (Mode.RM_VALUES == this.mode && s.get(size - 1) instanceof ValueElement) {
            s.elements.remove(size - 1);
            --size;
        }
        for (int i = 0; i < size; ++i) {
            this.isLastElement = last && i == size - 1;
            s.elements.set(i, (Element)this.dispatch(s.get(i)));
        }
        this.isLastElement = false;
        return s;
    }

    public Element visit(ValueElement v) {
        this.isTopLevel = false;
        this.isLastElement = false;
        if (Mode.VOID_VALUES == this.mode) {
            return NullValue.VALUE;
        }
        if (Mode.TEXT_VALUES == this.mode) {
            return StringValue.VALUE;
        }
        if (Mode.TOKEN_VALUES == this.mode) {
            return TokenValue.VALUE;
        }
        return v;
    }

    public static enum Mode {
        INLINE,
        RM_VALUES,
        VOID_VALUES,
        TEXT_VALUES,
        TOKEN_VALUES;

    }
}

