/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.List;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharTerminal;
import xtc.parser.Element;
import xtc.parser.InternalElement;

public class CharSwitch
extends CharTerminal
implements InternalElement {
    public List<CharCase> cases;
    public Element base;

    public CharSwitch(List<CharCase> cases) {
        this(cases, null);
    }

    public CharSwitch(List<CharCase> cases, Element base) {
        this.cases = cases;
        this.base = base;
    }

    public CharSwitch(CharClass klass, Element element) {
        this(new ArrayList<CharCase>(), null);
        if (klass.exclusive) {
            klass.exclusive = false;
            this.base = element;
            this.cases.add(new CharCase(klass));
        } else {
            this.cases.add(new CharCase(klass, element));
        }
    }

    @Override
    public Element.Tag tag() {
        return Element.Tag.CHAR_SWITCH;
    }

    public CharCase hasCase(CharClass klass) {
        for (CharCase kase : this.cases) {
            if (!klass.equals(kase.klass)) continue;
            return kase;
        }
        return null;
    }

    public boolean overlaps(CharClass klass) {
        for (CharCase kase : this.cases) {
            if (!klass.overlaps(kase.klass)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.cases.hashCode();
        if (null == this.base) {
            return hash;
        }
        return hash * 37 + this.base.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharSwitch)) {
            return false;
        }
        CharSwitch other = (CharSwitch)o;
        if (null == this.base ? this.base != other.base : !this.base.equals(other.base)) {
            return false;
        }
        return this.cases.equals(other.cases);
    }
}

