/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.tree.Node;

public class CharRange
extends Node
implements Comparable<CharRange> {
    public final char first;
    public final char last;

    public CharRange(char c) {
        this(c, c);
    }

    public CharRange(char first, char last) {
        if (first > last) {
            this.first = last;
            this.last = first;
        } else {
            this.first = first;
            this.last = last;
        }
    }

    public int count() {
        return this.last - this.first + 1;
    }

    public boolean contains(char c) {
        return this.first <= c && c <= this.last;
    }

    public int hashCode() {
        if (this.first == this.last) {
            return this.first;
        }
        return this.first + this.last;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharRange)) {
            return false;
        }
        CharRange other = (CharRange)o;
        if (this.first != other.first) {
            return false;
        }
        return this.last == other.last;
    }

    @Override
    public int compareTo(CharRange other) {
        return this.first - other.first;
    }
}

