/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import xtc.parser.CharRange;
import xtc.parser.CharTerminal;
import xtc.parser.Element;
import xtc.util.Utilities;

public class CharClass
extends CharTerminal {
    public boolean exclusive;
    public List<CharRange> ranges;

    public CharClass(List<CharRange> ranges) {
        this(false, ranges);
    }

    public CharClass(boolean exclusive, List<CharRange> ranges) {
        this.exclusive = exclusive;
        this.ranges = ranges;
    }

    public CharClass(char c) {
        this.exclusive = false;
        this.ranges = new ArrayList<CharRange>(1);
        this.ranges.add(new CharRange(c));
    }

    public CharClass(String s) {
        this.exclusive = false;
        this.ranges = new ArrayList<CharRange>();
        Parser p = new Parser(s);
        while (p.hasNext()) {
            char c1 = p.next();
            char c2 = p.hasRange() ? p.next() : c1;
            this.ranges.add(new CharRange(c1, c2));
        }
    }

    @Override
    public Element.Tag tag() {
        return Element.Tag.CHAR_CLASS;
    }

    public CharClass normalize() {
        Collections.sort(this.ranges);
        for (int i = 0; i < this.ranges.size() - 1; ++i) {
            CharRange r1 = this.ranges.get(i);
            CharRange r2 = this.ranges.get(i + 1);
            if (r1.last >= r2.last) {
                this.ranges.remove(i + 1);
                --i;
                continue;
            }
            if (r1.last < r2.first - '\u0001') continue;
            this.ranges.set(i, new CharRange(r1.first, r2.last));
            this.ranges.remove(i + 1);
            --i;
        }
        return this;
    }

    public boolean overlaps(CharClass klass) {
        if (this.exclusive) {
            throw new IllegalStateException("overlap test for exclusive character class " + this);
        }
        if (klass.exclusive) {
            throw new IllegalStateException("overlap test for exclusive character class " + klass);
        }
        for (CharRange r1 : klass.ranges) {
            for (CharRange r2 : this.ranges) {
                if (!r1.contains(r2.first) && !r1.contains(r2.last) && !r2.contains(r1.first) && !r2.contains(r1.last)) continue;
                return true;
            }
        }
        return false;
    }

    public int count() {
        int count = 0;
        for (CharRange r : this.ranges) {
            count += r.count();
        }
        return count;
    }

    public int hashCode() {
        int hash = 0;
        for (CharRange r : this.ranges) {
            hash += r.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharClass)) {
            return false;
        }
        CharClass other = (CharClass)o;
        if (this.exclusive != other.exclusive) {
            return false;
        }
        if (this.ranges.size() != other.ranges.size()) {
            return false;
        }
        return this.ranges.containsAll(other.ranges);
    }

    @Override
    public void write(Appendable out) throws IOException {
        if (this.exclusive) {
            out.append('!');
        }
        out.append('[');
        for (CharRange r : this.ranges) {
            if (r.first == r.last) {
                Utilities.escape(r.first, out, 12);
                continue;
            }
            Utilities.escape(r.first, out, 12);
            out.append('-');
            Utilities.escape(r.last, out, 12);
        }
        out.append(']');
        if (this.exclusive) {
            out.append(" _");
        }
    }

    public static class Parser {
        protected String s;
        protected int idx;

        public Parser(String s) {
            this.s = s;
            this.idx = 0;
        }

        public boolean hasNext() {
            return this.idx < this.s.length();
        }

        public boolean hasRange() {
            if (this.idx >= this.s.length()) {
                return false;
            }
            char c = this.s.charAt(this.idx);
            if ('-' == c) {
                ++this.idx;
                return true;
            }
            return false;
        }

        public char next() {
            char c = this.s.charAt(this.idx);
            ++this.idx;
            if ('\\' != c) {
                return c;
            }
            c = this.s.charAt(this.idx);
            ++this.idx;
            switch (c) {
                case 'b': {
                    return '\b';
                }
                case 't': {
                    return '\t';
                }
                case 'n': {
                    return '\n';
                }
                case 'f': {
                    return '\f';
                }
                case 'r': {
                    return '\r';
                }
                case '\"': {
                    return '\"';
                }
                case '\'': {
                    return '\'';
                }
                case '-': {
                    return '-';
                }
                case '[': {
                    return '[';
                }
                case '\\': {
                    return '\\';
                }
                case ']': {
                    return ']';
                }
                case 'u': {
                    int n;
                    this.idx += 4;
                    try {
                        n = Integer.parseInt(this.s.substring(this.idx - 4, this.idx), 16);
                    }
                    catch (NumberFormatException x) {
                        throw new IllegalArgumentException("Illegal Unicode escape ('\\u" + this.s.substring(this.idx - 4, this.idx) + "')");
                    }
                    return (char)n;
                }
            }
            throw new IllegalArgumentException("Illegal character escape ('\\" + c + "')");
        }
    }
}

