/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.UnaryOperator;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.util.Runtime;

public class Annotator
extends Visitor {
    public static final String MARKER = "pt";
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean isGeneric;
    protected boolean isList;
    protected boolean isRecursive;
    protected boolean isTopLevel;
    protected int toProcessIdx;
    protected List<Sequence> sequences;
    protected List<List<Binding>> before;
    protected List<Index> sequenceIdx;
    protected List<Index> elementIdx;
    protected List<List<Binding>> after;

    public Annotator(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.toProcessIdx = 0;
        this.sequences = new ArrayList<Sequence>();
        this.before = new ArrayList<List<Binding>>();
        this.sequenceIdx = new ArrayList<Index>();
        this.elementIdx = new ArrayList<Index>();
        this.after = new ArrayList<List<Binding>>();
    }

    protected void push() {
        assert (this.before.size() == this.sequenceIdx.size());
        assert (this.before.size() == this.elementIdx.size());
        assert (this.before.size() == this.after.size());
        if (0 == this.before.size()) {
            this.before.add(new ArrayList());
            this.sequenceIdx.add(new Index());
            this.elementIdx.add(new Index());
            this.after.add(new ArrayList());
        } else {
            this.before.add(new ArrayList(this.before.get(this.before.size() - 1)));
            this.sequenceIdx.add(new Index(this.sequenceIdx.get(this.sequenceIdx.size() - 1)));
            this.elementIdx.add(new Index(this.elementIdx.get(this.elementIdx.size() - 1)));
            this.after.add(new ArrayList(this.after.get(this.after.size() - 1)));
        }
    }

    protected void pop() {
        assert (this.before.size() == this.sequenceIdx.size());
        assert (this.before.size() == this.elementIdx.size());
        assert (this.before.size() == this.after.size());
        this.before.remove(this.before.size() - 1);
        this.sequenceIdx.remove(this.sequenceIdx.size() - 1);
        this.elementIdx.remove(this.elementIdx.size() - 1);
        this.after.remove(this.after.size() - 1);
    }

    protected void reset() {
        this.before.set(this.before.size() - 1, new ArrayList());
        this.sequenceIndex().index = -1;
        this.elementIndex().index = -1;
        this.after.set(this.after.size() - 1, new ArrayList());
    }

    protected List<Binding> before() {
        return this.before.get(this.before.size() - 1);
    }

    protected Index sequenceIndex() {
        return this.sequenceIdx.get(this.sequenceIdx.size() - 1);
    }

    protected Index elementIndex() {
        return this.elementIdx.get(this.elementIdx.size() - 1);
    }

    protected List<Binding> after() {
        return this.after.get(this.after.size() - 1);
    }

    protected boolean isValuable(Element e) {
        switch (e.tag()) {
            case VOIDED: {
                assert (this.isValuable(((VoidedElement)e).element));
                return true;
            }
            case NONTERMINAL: {
                return Annotator.isValuable(this.analyzer.lookup((NonTerminal)e));
            }
            case CHOICE: 
            case OPTION: 
            case REPETITION: 
            case ANY_CHAR: 
            case CHAR_CLASS: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case STRING_MATCH: 
            case PARSE_TREE_NODE: 
            case BINDING: {
                return true;
            }
        }
        return false;
    }

    protected boolean isParseTreeNode(Element e) {
        switch (e.tag()) {
            case VOIDED: 
            case BINDING: {
                return this.isParseTreeNode(((UnaryOperator)e).element);
            }
            case PARSE_TREE_NODE: {
                return true;
            }
        }
        return false;
    }

    protected boolean hasBindable() {
        return -1 != this.sequenceIndex().index;
    }

    protected boolean hasValuable() {
        return 0 < this.before().size() || 0 < this.after().size();
    }

    protected boolean isBoundAndVoided(Element e) {
        return e instanceof VoidedElement && ((VoidedElement)e).element instanceof Binding;
    }

    protected VoidedElement bindAndVoid(Element e) {
        Element tmp = e;
        if (tmp instanceof VoidedElement) {
            tmp = ((VoidedElement)tmp).element;
        }
        if (tmp instanceof Binding) {
            Binding b = (Binding)tmp;
            if ("yyValue".equals(b.name)) {
                b.name = this.analyzer.variable(MARKER);
            }
            assert (!this.isParseTreeNode(b.element));
        } else {
            assert (!this.isParseTreeNode(tmp));
            tmp = new Binding(this.analyzer.variable(MARKER), tmp);
            tmp.setLocation(e);
        }
        VoidedElement result = new VoidedElement(tmp);
        result.setLocation(e);
        return result;
    }

    protected Binding bindAndVoid() {
        Sequence s = this.sequences.get(this.sequenceIndex().index);
        VoidedElement v = this.bindAndVoid(s.get(this.elementIndex().index));
        s.elements.set(this.elementIndex().index, v);
        return (Binding)v.element;
    }

    protected void annotate() {
        Sequence s;
        int i;
        for (Sequence s2 : this.sequences) {
            for (Element e : s2.elements) {
                if (!(e instanceof Action) || !((Action)e).setsValue()) continue;
                ++this.toProcessIdx;
                this.push();
                assert (this.toProcessIdx == this.before.size());
                return;
            }
        }
        int valueSequenceIdx = -1;
        int valueElementIdx = -1;
        boolean requiresAnnotation = false;
        int size = this.sequences.size();
        for (i = 0; i < size; ++i) {
            s = this.sequences.get(i);
            int seqsize = s.hasTrailingChoice() ? s.size() - 1 : s.size();
            for (int j = 0; j < seqsize; ++j) {
                if (this.isRecursive && 0 == i && 0 == j) continue;
                Element e = s.get(j);
                if (e instanceof Binding && "yyValue".equals(((Binding)e).name)) {
                    valueSequenceIdx = i;
                    valueElementIdx = j;
                    continue;
                }
                if (!this.isValuable(e)) continue;
                requiresAnnotation = true;
            }
        }
        if (-1 != valueSequenceIdx) {
            if (!requiresAnnotation) {
                ++this.toProcessIdx;
                this.push();
                assert (this.toProcessIdx == this.before.size());
                return;
            }
            if (requiresAnnotation) {
                Binding value = null;
                this.before.clear();
                this.sequenceIdx.clear();
                this.elementIdx.clear();
                this.after.clear();
                for (int i2 = 0; i2 < size; ++i2) {
                    Sequence s3 = this.sequences.get(i2);
                    this.push();
                    int seqsize = s3.hasTrailingChoice() ? s3.size() - 1 : s3.size();
                    for (int j = 0; j < seqsize; ++j) {
                        if (this.isRecursive && 0 == i2 && 0 == j) continue;
                        Element e = s3.get(j);
                        if (i2 < this.toProcessIdx) {
                            if (i2 == valueSequenceIdx && j == valueElementIdx) {
                                value = (Binding)((VoidedElement)e).element;
                                continue;
                            }
                            if (this.isBoundAndVoided(e)) {
                                if (null == value) {
                                    this.before().add((Binding)((VoidedElement)e).element);
                                    continue;
                                }
                                this.after().add((Binding)((VoidedElement)e).element);
                                continue;
                            }
                            if (!this.analyzer.isBindable(e) || this.isParseTreeNode(e)) continue;
                            if (!(e instanceof Binding)) {
                                e = new Binding(this.analyzer.variable(MARKER), e);
                                s3.elements.set(j, e);
                            }
                            if (null == value) {
                                this.before().add((Binding)e);
                                continue;
                            }
                            this.after().add((Binding)e);
                            continue;
                        }
                        if (!this.isValuable(e)) continue;
                        VoidedElement v = this.bindAndVoid(e);
                        s3.elements.set(j, v);
                        if (i2 == valueSequenceIdx && j == valueElementIdx) {
                            value = (Binding)v.element;
                            continue;
                        }
                        if (null == value) {
                            this.before().add((Binding)v.element);
                            continue;
                        }
                        this.after().add((Binding)v.element);
                    }
                }
                assert (null != value);
                ParseTreeNode n = new ParseTreeNode(this.before(), value, this.after());
                Binding b = new Binding("yyValue", n);
                this.sequences.get(this.sequences.size() - 1).add(b);
                this.toProcessIdx = this.sequences.size();
                assert (this.toProcessIdx == this.before.size());
                return;
            }
        }
        for (i = this.toProcessIdx; i < size; ++i) {
            s = this.sequences.get(i);
            this.push();
            for (int j = 0; j < (s.hasTrailingChoice() ? s.size() - 1 : s.size()); ++j) {
                if (this.isRecursive && 0 == i && 0 == j) continue;
                Element e = s.get(j);
                if (this.analyzer.isBindable(e)) {
                    if ((this.isGeneric || this.isList) && AST.isList(this.analyzer.type(e))) {
                        if (this.hasValuable()) {
                            Binding b = this.hasBindable() ? this.bindAndVoid() : null;
                            s.elements.add(j, new ParseTreeNode(this.before(), b, this.after()));
                            ++j;
                        }
                        this.reset();
                        continue;
                    }
                    if (!this.hasBindable() || !this.hasValuable()) {
                        this.sequenceIndex().index = i;
                        this.elementIndex().index = j;
                        continue;
                    }
                    s.elements.add(j, new ParseTreeNode(this.before(), this.bindAndVoid(), this.after()));
                    this.reset();
                    continue;
                }
                if (!this.isValuable(e)) continue;
                VoidedElement v = this.bindAndVoid(e);
                s.elements.set(j, v);
                if (!this.hasBindable()) {
                    this.before().add((Binding)v.element);
                    continue;
                }
                this.after().add((Binding)v.element);
            }
            if (i >= size - 1 || !this.hasBindable()) continue;
            if (this.hasValuable()) {
                s.elements.add(s.size() - 1, new ParseTreeNode(this.before(), this.bindAndVoid(), this.after()));
            }
            this.reset();
        }
        if (this.hasValuable()) {
            if (this.isGeneric && !this.hasBindable()) {
                this.sequences.get(this.sequences.size() - 1).setProperty("formatting", this.before());
            } else {
                Binding b = this.hasBindable() ? this.bindAndVoid() : null;
                this.sequences.get(this.sequences.size() - 1).add(new ParseTreeNode(this.before(), b, this.after()));
            }
        }
        this.toProcessIdx = this.sequences.size();
        assert (this.toProcessIdx == this.before.size());
    }

    protected void recurse(Element e) {
        switch (e.tag()) {
            case VOIDED: 
            case OPTION: 
            case REPETITION: 
            case STRING_MATCH: 
            case BINDING: {
                this.recurse(((UnaryOperator)e).element);
                break;
            }
            case CHOICE: 
            case SEQUENCE: {
                boolean savedIsGeneric = this.isGeneric;
                boolean savedIsList = this.isList;
                boolean savedIsRecursive = this.isRecursive;
                boolean savedIsTopLevel = this.isTopLevel;
                int savedToProcessIdx = this.toProcessIdx;
                List<Sequence> savedSequences = this.sequences;
                List<List<Binding>> savedBefore = this.before;
                List<Index> savedSequenceIdx = this.sequenceIdx;
                List<Index> savedElementIdx = this.elementIdx;
                List<List<Binding>> savedAfter = this.after;
                this.isGeneric = false;
                this.isList = false;
                this.isRecursive = false;
                this.isTopLevel = false;
                this.toProcessIdx = 0;
                this.sequences = new ArrayList<Sequence>();
                this.before = new ArrayList<List<Binding>>();
                this.sequenceIdx = new ArrayList<Index>();
                this.elementIdx = new ArrayList<Index>();
                this.after = new ArrayList<List<Binding>>();
                this.dispatch(e);
                this.isGeneric = savedIsGeneric;
                this.isList = savedIsList;
                this.isRecursive = savedIsRecursive;
                this.isTopLevel = savedIsTopLevel;
                this.toProcessIdx = savedToProcessIdx;
                this.sequences = savedSequences;
                this.before = savedBefore;
                this.sequenceIdx = savedSequenceIdx;
                this.elementIdx = savedElementIdx;
                this.after = savedAfter;
                break;
            }
        }
    }

    public void visit(Module m) {
        new Detector().dispatch(m);
        new Rewriter().dispatch(m);
        this.analyzer.register(this);
        this.analyzer.init(m);
        for (Production p : m.productions) {
            Type elem;
            if (p.getBooleanProperty("lexical") || AST.isVoid(p.type) && !p.getBooleanProperty("consumer")) continue;
            boolean processed = false;
            if (Annotator.isSingleRepetition((FullProduction)p)) {
                for (Sequence s : p.choice.alternatives) {
                    this.recurse(s.get(0));
                }
                processed = true;
            } else if (AST.isVoid(p.type) || AST.isString(p.type) || AST.isNode(p.type) || AST.isAny(p.type)) {
                this.analyzer.process(p);
                processed = true;
            } else if (AST.isList(p.type) && (AST.isString(elem = AST.getArgument(p.type)) || AST.isNode(elem) || AST.isAny(elem))) {
                this.analyzer.process(p);
                processed = true;
            }
            if (processed || m.hasAttribute(Constants.ATT_NO_WARNINGS) || p.hasAttribute(Constants.ATT_NO_WARNINGS)) continue;
            this.runtime.warning("unable to add parse tree annotations", p);
        }
        for (Production p : m.productions) {
            Type elem;
            if (!p.getBooleanProperty("token") && (p.getBooleanProperty("lexical") || AST.isVoid(p.type) && !p.getBooleanProperty("consumer"))) continue;
            if (p.getBooleanProperty("token")) {
                p.type = AST.TOKEN;
                continue;
            }
            if (AST.isVoid(p.type)) {
                p.type = AST.GENERIC;
                continue;
            }
            if (AST.isString(p.type) || AST.isToken(p.type)) {
                p.type = AST.NODE;
                continue;
            }
            if (!AST.isList(p.type) || !AST.isString(elem = AST.getArgument(p.type)) && !AST.isToken(elem)) continue;
            p.type = AST.listOf(AST.NODE);
        }
    }

    public void visit(FullProduction p) {
        this.isGeneric = Annotator.isGeneric(p);
        this.isList = AST.isList(p.type);
        this.isRecursive = DirectLeftRecurser.isTransformable(p);
        this.isTopLevel = true;
        this.dispatch(p.choice);
    }

    public void visit(OrderedChoice c) {
        boolean rec = this.isRecursive;
        boolean top = this.isTopLevel;
        this.isTopLevel = false;
        for (Sequence alt : c.alternatives) {
            if (top) {
                this.isRecursive = rec ? DirectLeftRecurser.isRecursive(alt, (FullProduction)this.analyzer.current()) : false;
            }
            this.dispatch(alt);
        }
    }

    public void visit(Sequence s) {
        this.sequences.add(s);
        int size = s.elements.size();
        for (int i = 0; i < size; ++i) {
            Element e = s.get(i);
            if (size - 1 == i && e instanceof OrderedChoice) {
                this.dispatch(e);
                continue;
            }
            this.recurse(e);
        }
        if (!s.hasTrailingChoice()) {
            this.annotate();
        }
        this.sequences.remove(this.sequences.size() - 1);
        --this.toProcessIdx;
        this.pop();
        assert (this.toProcessIdx == this.before.size());
    }

    public static boolean isGeneric(FullProduction p) {
        return Generifier.isGeneric(p) || AST.isVoid(p.type) && !p.getBooleanProperty("lexical") && p.getBooleanProperty("consumer");
    }

    public static boolean isValuable(FullProduction p) {
        return !AST.isVoid(p.type) || p.getBooleanProperty("consumer");
    }

    public static boolean isList(Type type) {
        if (!AST.isList(type)) {
            return false;
        }
        Type elem = AST.getArgument(type);
        return AST.isAny(elem) || AST.isNode(elem) || AST.isString(elem);
    }

    public static boolean isSingleRepetition(FullProduction p) {
        if (!Annotator.isList(p.type)) {
            return false;
        }
        for (Sequence s : p.choice.alternatives) {
            if (1 != s.size()) {
                return false;
            }
            Element e = s.get(0);
            if (e instanceof Repetition || e instanceof Binding && ((Binding)e).element instanceof Repetition) continue;
            return false;
        }
        return true;
    }

    public class Rewriter
    extends Visitor {
        protected List<Element> elements = new ArrayList<Element>();
        protected boolean isTopLevel;
        protected Sequence alternative;
        protected List<Sequence> replacements;

        public void visit(Module m) {
            Annotator.this.analyzer.register(this);
            Annotator.this.analyzer.init(m);
            for (int i = 0; i < m.productions.size(); ++i) {
                FullProduction p = (FullProduction)m.productions.get(i);
                if (!p.getBooleanProperty("split")) continue;
                Annotator.this.analyzer.startAdding();
                Annotator.this.analyzer.process(p);
                i += Annotator.this.analyzer.addNewProductionsAt(i + 1);
            }
        }

        public void visit(FullProduction p) {
            this.isTopLevel = true;
            this.dispatch(p.choice);
        }

        public void visit(OrderedChoice c) {
            boolean top = this.isTopLevel;
            this.isTopLevel = false;
            if (top) {
                this.replacements = new ArrayList<Sequence>(c.alternatives.size());
            }
            for (Sequence s : c.alternatives) {
                if (top) {
                    this.alternative = s;
                }
                this.dispatch(s);
            }
            if (top) {
                c.alternatives = this.replacements;
            }
        }

        public void visit(Sequence s) {
            int base = this.elements.size();
            Iterator<Element> iter = s.elements.iterator();
            while (iter.hasNext()) {
                Element e = iter.next();
                if (!iter.hasNext() && e instanceof OrderedChoice) {
                    this.dispatch(e);
                    continue;
                }
                this.elements.add(e);
            }
            if (!s.hasTrailingChoice()) {
                IndexPair split = (IndexPair)s.getProperty("split");
                if (null == split) {
                    Sequence r = new Sequence(new ArrayList<Element>(this.elements));
                    r.name = this.alternative.name;
                    r.setLocation(this.alternative);
                    this.replacements.add(r);
                } else {
                    Sequence r;
                    Sequence alt;
                    Production p = Annotator.this.analyzer.current();
                    NodeMarker mark = null;
                    for (Element e : this.elements) {
                        if (!(e instanceof NodeMarker)) continue;
                        mark = (NodeMarker)e;
                    }
                    if (null == mark) {
                        mark = new NodeMarker(p.name.name);
                    }
                    NonTerminal nt = Annotator.this.analyzer.split();
                    if (-1 == split.index2) {
                        alt = new Sequence(this.elements.size() - split.index1 + 1);
                        alt.addAll(this.elements.subList(split.index1, this.elements.size()));
                        alt.add(mark);
                    } else if (-1 == split.index1) {
                        alt = new Sequence(split.index2 + 2);
                        alt.addAll(this.elements.subList(0, split.index2 + 1));
                        alt.add(mark);
                    } else {
                        alt = new Sequence(split.index2 - split.index1 + 2);
                        alt.addAll(this.elements.subList(split.index1, split.index2 + 1));
                        alt.add(mark);
                    }
                    alt.name = this.alternative.name;
                    alt.setLocation(this.alternative);
                    FullProduction q = new FullProduction(new ArrayList<Attribute>(p.attributes), AST.GENERIC, nt, nt.qualify(Annotator.this.analyzer.module().name.name), new OrderedChoice(alt));
                    q.attributes.remove(Constants.ATT_PUBLIC);
                    q.attributes.remove(Constants.ATT_EXPLICIT);
                    q.attributes.remove(Constants.ATT_STATEFUL);
                    q.attributes.remove(Constants.ATT_RESETTING);
                    if (!q.hasAttribute(Constants.ATT_TRANSIENT) && !q.hasAttribute(Constants.ATT_INLINE)) {
                        q.attributes.add(Constants.ATT_TRANSIENT);
                    }
                    if (Annotator.this.runtime.test("optionVerbose")) {
                        System.err.println("[Lifting split sequence into new production " + q.qName + ']');
                    }
                    Annotator.this.analyzer.add(q);
                    if (-1 == split.index2) {
                        r = new Sequence(split.index1 + 1);
                        r.addAll(this.elements.subList(0, split.index1));
                        r.add(new Binding("yyValue", nt));
                    } else if (-1 == split.index1) {
                        r = new Sequence(this.elements.size() - split.index2);
                        r.add(new Binding("yyValue", nt));
                        r.addAll(this.elements.subList(split.index2 + 1, this.elements.size()));
                    } else {
                        r = new Sequence(split.index1 + this.elements.size() - split.index2);
                        r.addAll(this.elements.subList(0, split.index1));
                        r.add(new Binding("yyValue", nt));
                        r.addAll(this.elements.subList(split.index2 + 1, this.elements.size()));
                    }
                    r.name = this.alternative.name;
                    r.setLocation(this.alternative);
                    this.replacements.add(r);
                }
            }
            if (0 == base) {
                this.elements.clear();
            } else {
                this.elements.subList(base, this.elements.size()).clear();
            }
        }
    }

    public class Detector
    extends Visitor {
        protected boolean needToSplit;
        protected List<Element> elements = new ArrayList<Element>();

        public void visit(Module m) {
            Annotator.this.analyzer.register(this);
            Annotator.this.analyzer.init(m);
            for (Production p : m.productions) {
                if (!Generifier.isGeneric((FullProduction)p) && !Annotator.isList(p.type) || DirectLeftRecurser.isTransformable((FullProduction)p)) continue;
                this.needToSplit = false;
                Annotator.this.analyzer.process(p);
                if (!this.needToSplit) continue;
                p.setProperty("split", Boolean.TRUE);
            }
        }

        public void visit(FullProduction p) {
            this.dispatch(p.choice);
        }

        public void visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                this.dispatch(alt);
            }
        }

        public void visit(Sequence s) {
            int base = this.elements.size();
            Iterator<Element> iter = s.elements.iterator();
            while (iter.hasNext()) {
                Element e = iter.next();
                if (!iter.hasNext() && e instanceof OrderedChoice) {
                    this.dispatch(e);
                    continue;
                }
                this.elements.add(e);
            }
            if (!s.hasTrailingChoice()) {
                boolean hasBindable = false;
                boolean hasValuable = false;
                int first = -1;
                int last = -1;
                boolean hasFollowing = false;
                int size = this.elements.size();
                for (int i = 0; i < size; ++i) {
                    Element e = this.elements.get(i);
                    if (Annotator.this.analyzer.isBindable(e)) {
                        if (AST.isList(Annotator.this.analyzer.type(e))) {
                            if (!hasBindable && hasValuable) {
                                first = i;
                            }
                            last = i;
                        } else {
                            last = -1;
                        }
                        hasFollowing = false;
                        hasBindable = true;
                        continue;
                    }
                    if (!Annotator.this.isValuable(e)) continue;
                    if (-1 != last) {
                        hasFollowing = true;
                    }
                    hasValuable = true;
                }
                if (-1 != first || hasFollowing) {
                    IndexPair result = new IndexPair();
                    if (-1 != first) {
                        result.index1 = first;
                    }
                    if (hasFollowing) {
                        result.index2 = last;
                    }
                    this.needToSplit = true;
                    s.setProperty("split", result);
                }
            }
            if (0 == base) {
                this.elements.clear();
            } else {
                this.elements.subList(base, this.elements.size()).clear();
            }
        }
    }

    public static class IndexPair {
        public int index1 = -1;
        public int index2 = -1;
    }

    public static class Index {
        public int index;

        public Index() {
            this.index = -1;
        }

        public Index(Index index) {
            this.index = index.index;
        }
    }
}

