/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Copier;
import xtc.parser.Element;
import xtc.parser.FollowedBy;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleName;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Renamer;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.UnaryOperator;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;
import xtc.tree.Utility;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.type.VoidT;
import xtc.type.Wildcard;
import xtc.util.Utilities;

public class Analyzer
extends Utility {
    public static final String SEPARATOR = "$$";
    public static final String SHARED = "$$Shared";
    public static final String VARIABLE = "v$";
    public static final String DUMMY = "v$dummy";
    public static final String SPLIT = "$$Split";
    public static final String CHOICE = "$$Choice";
    public static final String STAR = "$$Star";
    public static final String PLUS = "$$Plus";
    public static final String OPTION = "$$Option";
    public static final String TAIL = "$$Tail";
    public static final int MAX_COUNT = 22;
    protected final Copier xerox;
    protected boolean isGrammarMode = false;
    protected Grammar grammar;
    protected Map<String, Module> moduleMap;
    protected Map<NonTerminal, Object> grammarPMap;
    protected Module mCurrent;
    protected Module module;
    protected Map<NonTerminal, FullProduction> pMap;
    protected Production pCurrent;
    protected Set<NonTerminal> pWorking;
    protected Set<NonTerminal> pMarked;
    protected Set<NonTerminal> pProcessed;
    protected List<Production> pNew;
    protected int varCount;
    protected int splitCount;
    protected int choiceCount;
    protected int starCount;
    protected int plusCount;
    protected int optionCount;
    protected int tailCount;
    protected int sharedCount = 1;
    private final Visitor restrictsInputVisitor = new Visitor(){

        public Boolean visit(FullProduction p) {
            assert (!Analyzer.this.isBeingWorkedOn(p.qName));
            assert (!p.hasProperty("restrict"));
            Object closure = Analyzer.this.enter(p);
            Analyzer.this.workingOn(p.qName);
            Boolean result = (Boolean)this.dispatch(p.choice);
            p.setProperty("restrict", result);
            Analyzer.this.notWorkingOn(p.qName);
            Analyzer.this.exit(closure);
            return result;
        }

        public Boolean visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                if (((Boolean)this.dispatch(alt)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(Repetition r) {
            return r.once;
        }

        public Boolean visit(Option o) {
            return Boolean.FALSE;
        }

        public Boolean visit(Sequence s) {
            for (Element e : s.elements) {
                if (!((Boolean)this.dispatch(e)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visit(Predicate p) {
            return Boolean.TRUE;
        }

        public Boolean visit(NonTerminal nt) {
            FullProduction p;
            try {
                p = Analyzer.this.lookup(nt);
            }
            catch (IllegalArgumentException x) {
                return Boolean.TRUE;
            }
            if (null != p) {
                if (p.hasProperty("restrict")) {
                    return (Boolean)p.getProperty("restrict");
                }
                if (Analyzer.this.isBeingWorkedOn(p.qName)) {
                    return Boolean.TRUE;
                }
                return (Boolean)this.dispatch(p);
            }
            return Boolean.TRUE;
        }

        public Boolean visit(Terminal t) {
            return Boolean.TRUE;
        }

        public Boolean visit(UnaryOperator op) {
            return (Boolean)this.dispatch(op.element);
        }

        public Boolean visit(ParserAction pa) {
            return Boolean.TRUE;
        }

        public Boolean visit(Element e) {
            return Boolean.FALSE;
        }
    };
    private final Visitor consumesInputVisitor = new Visitor(){

        public Boolean visit(FullProduction p) {
            assert (!Analyzer.this.isBeingWorkedOn(p.qName));
            assert (!p.hasProperty("consumer"));
            Object closure = Analyzer.this.enter(p);
            Analyzer.this.workingOn(p.qName);
            Boolean result = (Boolean)this.dispatch(p.choice);
            p.setProperty("consumer", result);
            Analyzer.this.notWorkingOn(p.qName);
            Analyzer.this.exit(closure);
            return result;
        }

        public Boolean visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                if (!((Boolean)this.dispatch(alt)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visit(Sequence s) {
            for (Element e : s.elements) {
                if (!((Boolean)this.dispatch(e)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visit(Predicate p) {
            return Boolean.FALSE;
        }

        public Boolean visit(NonTerminal nt) {
            FullProduction p;
            try {
                p = Analyzer.this.lookup(nt);
            }
            catch (IllegalArgumentException x) {
                return Boolean.TRUE;
            }
            if (null != p) {
                if (p.hasProperty("consumer")) {
                    return (Boolean)p.getProperty("consumer");
                }
                if (Analyzer.this.isBeingWorkedOn(p.qName)) {
                    return Boolean.TRUE;
                }
                return (Boolean)this.dispatch(p);
            }
            return Boolean.TRUE;
        }

        public Boolean visit(Terminal t) {
            return Boolean.TRUE;
        }

        public Boolean visit(UnaryOperator op) {
            return (Boolean)this.dispatch(op.element);
        }

        public Boolean visit(ParserAction pa) {
            return Boolean.TRUE;
        }

        public Boolean visit(Element e) {
            return Boolean.FALSE;
        }
    };
    private final Visitor matchesEmptyVisitor = new Visitor(){

        public Boolean visit(FullProduction p) {
            assert (!Analyzer.this.isBeingWorkedOn(p.qName));
            assert (!p.hasProperty("empty"));
            Object closure = Analyzer.this.enter(p);
            Analyzer.this.workingOn(p.qName);
            Boolean result = (Boolean)this.dispatch(p.choice);
            p.setProperty("empty", result);
            Analyzer.this.notWorkingOn(p.qName);
            Analyzer.this.exit(closure);
            return result;
        }

        public Boolean visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                if (!((Boolean)this.dispatch(alt)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visit(Repetition r) {
            return !r.once;
        }

        public Boolean visit(Option o) {
            return Boolean.TRUE;
        }

        public Boolean visit(Sequence s) {
            for (Element e : s.elements) {
                if (((Boolean)this.dispatch(e)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(FollowedBy p) {
            return (Boolean)this.dispatch(p.element);
        }

        public Boolean visit(NotFollowedBy p) {
            return (Boolean)this.dispatch(p.element) == false;
        }

        public Boolean visit(SemanticPredicate p) {
            return Boolean.FALSE;
        }

        public Boolean visit(NonTerminal nt) {
            FullProduction p;
            try {
                p = Analyzer.this.lookup(nt);
            }
            catch (IllegalArgumentException x) {
                return Boolean.FALSE;
            }
            if (null != p) {
                if (p.hasProperty("empty")) {
                    return (Boolean)p.getProperty("empty");
                }
                if (Analyzer.this.isBeingWorkedOn(p.qName)) {
                    return Boolean.FALSE;
                }
                return (Boolean)this.dispatch(p);
            }
            return Boolean.FALSE;
        }

        public Boolean visit(Terminal t) {
            return Boolean.FALSE;
        }

        public Boolean visit(UnaryOperator op) {
            return (Boolean)this.dispatch(op.element);
        }

        public Boolean visit(ParserAction pa) {
            return Boolean.FALSE;
        }

        public Boolean visit(Element e) {
            return Boolean.TRUE;
        }
    };
    private final Visitor isNotFollowedByVisitor = new Visitor(){

        public Boolean visit(FullProduction p) {
            Object closure = Analyzer.this.enter(p);
            Boolean result = (Boolean)this.dispatch(Analyzer.strip(p.choice));
            Analyzer.this.exit(closure);
            return result;
        }

        public Boolean visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                if (((Boolean)this.dispatch(alt)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(Sequence s) {
            for (Element e : s.elements) {
                if (((Boolean)this.dispatch(e)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(NonTerminal nt) {
            FullProduction p;
            try {
                p = Analyzer.this.lookup(nt);
            }
            catch (IllegalArgumentException x) {
                return Boolean.FALSE;
            }
            return null != p ? (Boolean)this.dispatch(p) : Boolean.FALSE;
        }

        public Boolean visit(NotFollowedBy p) {
            return Boolean.TRUE;
        }

        public Boolean visit(Element e) {
            return Boolean.FALSE;
        }
    };

    public Analyzer() {
        this.xerox = new Copier();
        this.moduleMap = new HashMap<String, Module>();
        this.grammarPMap = new HashMap<NonTerminal, Object>();
        this.pMap = new HashMap<NonTerminal, FullProduction>();
        this.pWorking = new HashSet<NonTerminal>();
        this.pMarked = new HashSet<NonTerminal>();
        this.pProcessed = new HashSet<NonTerminal>();
        this.pNew = new ArrayList<Production>();
    }

    public void reset() {
        this.isGrammarMode = false;
        this.grammar = null;
        this.moduleMap.clear();
        this.grammarPMap.clear();
        this.mCurrent = null;
        this.module = null;
        this.pCurrent = null;
        this.pMap.clear();
        this.pWorking.clear();
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pNew.clear();
        this.varCount = 1;
        this.splitCount = 1;
        this.choiceCount = 1;
        this.starCount = 1;
        this.plusCount = 1;
        this.optionCount = 1;
        this.tailCount = 1;
        this.sharedCount = 1;
    }

    public void init(Grammar g) {
        if (this.grammar != g) {
            this.grammar = g;
            this.moduleMap.clear();
            this.grammarPMap.clear();
            for (Module m : g.modules) {
                this.moduleMap.put(m.name.name, m);
                for (Production p : m.productions) {
                    if (null == p.qName) {
                        p.qName = p.name.qualify(m.name.name);
                        p.qName.setLocation(p.name);
                    }
                    if (!p.isFull()) continue;
                    this.addToGrammarMap((FullProduction)p);
                }
            }
        }
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pCurrent = null;
        this.mCurrent = null;
        this.isGrammarMode = true;
    }

    public boolean isImported(String name, Module m) {
        while (null != m) {
            if (null != m.dependencies) {
                for (ModuleDependency dep : m.dependencies) {
                    if (!dep.isImport() || !dep.visibleName().name.equals(name)) continue;
                    return true;
                }
                if (null != m.modification) {
                    m = this.lookup(m.modification.visibleName());
                    continue;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void trace(Module m, Set<ModuleName> imports, Map<ModuleName, Boolean> modified) {
        if (null != m.modification) {
            if (modified.containsKey(m.modification.visibleName())) {
                modified.put(m.modification.visibleName(), Boolean.TRUE);
            } else {
                modified.put(m.modification.visibleName(), Boolean.FALSE);
                Module m2 = this.lookup(m.modification.visibleName());
                if (null != m2) {
                    this.trace(m2, imports, modified);
                }
            }
        }
        if (null != m.dependencies) {
            for (ModuleDependency dep : m.dependencies) {
                if (!dep.isImport() || imports.contains(dep.visibleName())) continue;
                imports.add(dep.visibleName());
                Module m2 = this.lookup(dep.visibleName());
                if (null == m2) continue;
                this.trace(m2, imports, modified);
            }
        }
    }

    public boolean hasAttribute(Module m, String name, Set<ModuleName> visited) {
        if (!visited.contains(m.name)) {
            visited.add(m.name);
            if (m.hasAttribute(name)) {
                return true;
            }
            if (null != m.dependencies) {
                for (ModuleDependency dep : m.dependencies) {
                    Module m2;
                    if (!dep.isImport() && !dep.isModification() || null == (m2 = this.lookup(dep.visibleName())) || !this.hasAttribute(m2, name, visited)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void add(Module m) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        if (!this.moduleMap.containsKey(m.name.name)) {
            this.moduleMap.put(m.name.name, m);
            for (Production p : m.productions) {
                if (!p.isFull()) continue;
                this.addToGrammarMap((FullProduction)p);
            }
        }
    }

    public void remove(Module m) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        this.moduleMap.remove(m.name.name);
        for (Production p : m.productions) {
            if (!p.isFull()) continue;
            this.removeFromGrammarMap((FullProduction)p);
        }
    }

    private List<FullProduction> toFullProductionList(Object o) {
        return (List)o;
    }

    private void addToGrammarMap(FullProduction p) {
        if (!this.grammarPMap.containsKey(p.qName)) {
            this.grammarPMap.put(p.qName, p);
            if (this.grammarPMap.containsKey(p.name)) {
                Object o = this.grammarPMap.get(p.name);
                if (o instanceof FullProduction) {
                    ArrayList<FullProduction> l = new ArrayList<FullProduction>();
                    l.add((FullProduction)o);
                    l.add(p);
                    this.grammarPMap.put(p.name, l);
                } else {
                    List<FullProduction> l = this.toFullProductionList(o);
                    l.add(p);
                }
            } else {
                this.grammarPMap.put(p.name, p);
            }
        }
    }

    private void removeFromGrammarMap(FullProduction p) {
        this.grammarPMap.remove(p.qName);
        Object o = this.grammarPMap.get(p.name);
        if (o instanceof FullProduction) {
            if (p.qName.equals(((FullProduction)o).qName)) {
                this.grammarPMap.remove(p.name);
            }
        } else {
            List<FullProduction> l = this.toFullProductionList(o);
            Iterator<FullProduction> iter = l.iterator();
            while (iter.hasNext()) {
                if (!p.qName.equals(iter.next().qName)) continue;
                iter.remove();
                break;
            }
            if (1 == l.size()) {
                o = l.get(0);
                this.grammarPMap.put(p.name, o);
            }
        }
    }

    public Grammar grammar() {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        return this.grammar;
    }

    public boolean isTopLevel(Module m) {
        return this.isGrammarMode ? m == this.grammar.modules.get(0) : m == this.module;
    }

    public Module topLevel() {
        return this.isGrammarMode ? this.grammar.modules.get(0) : this.module;
    }

    public void init(Module m) {
        if (this.module != m) {
            this.module = m;
            this.pMap.clear();
            for (Production p : m.productions) {
                if (!p.isFull()) continue;
                this.pMap.put(p.name, (FullProduction)p);
                this.pMap.put(p.qName, (FullProduction)p);
            }
        }
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pCurrent = null;
        this.mCurrent = null;
        this.isGrammarMode = false;
    }

    public Module module() {
        if (this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with module");
        }
        return this.module;
    }

    public Module lookup(String module) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        return this.moduleMap.get(module);
    }

    public Module lookup(ModuleName module) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        return this.moduleMap.get(module.name);
    }

    public FullProduction lookupGlobally(NonTerminal nt) {
        if (this.isGrammarMode) {
            return nt.isQualified() ? (FullProduction)this.grammarPMap.get(nt) : null;
        }
        return this.pMap.get(nt);
    }

    public FullProduction lookup(NonTerminal nt, Module m) {
        Object o;
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        if (nt.isQualified()) {
            if (nt.getQualifier().equals(m.name.name)) {
                if (this.grammarPMap.containsKey(nt)) {
                    return (FullProduction)this.grammarPMap.get(nt);
                }
                nt = nt.unqualify();
            } else {
                return null;
            }
        }
        if (null == (o = this.grammarPMap.get(nt))) {
            return null;
        }
        if (o instanceof FullProduction) {
            FullProduction p = (FullProduction)o;
            return this.isDefined(p, m) ? p : null;
        }
        FullProduction result = null;
        for (FullProduction p : this.toFullProductionList(o)) {
            if (!this.isDefined(p, m)) continue;
            if (null == result) {
                result = p;
                continue;
            }
            throw new IllegalArgumentException("Multiple definitions for " + nt);
        }
        return result;
    }

    public FullProduction lookup(NonTerminal nt) {
        if (this.isGrammarMode) {
            if (nt.isQualified()) {
                String qualifier = nt.getQualifier();
                if (qualifier.equals(this.mCurrent.name.name)) {
                    return this.lookup(nt, this.mCurrent);
                }
                if (this.isImported(qualifier, this.mCurrent)) {
                    Module m = this.lookup(qualifier);
                    return null != m ? this.lookup(nt, m) : null;
                }
                return null;
            }
            Object o = this.grammarPMap.get(nt);
            if (null == o) {
                return null;
            }
            if (o instanceof FullProduction) {
                FullProduction p = (FullProduction)o;
                return this.isDefined(p, this.mCurrent) || this.isImported(p, this.mCurrent) ? p : null;
            }
            FullProduction result = null;
            List<FullProduction> list = this.toFullProductionList(o);
            for (FullProduction p : list) {
                if (!this.isDefined(p, this.mCurrent)) continue;
                if (null == result) {
                    result = p;
                    continue;
                }
                throw new IllegalArgumentException("Multiple definitions for " + nt);
            }
            if (null != result) {
                return result;
            }
            for (FullProduction p : list) {
                if (!this.isImported(p, this.mCurrent)) continue;
                if (null == result) {
                    result = p;
                    continue;
                }
                throw new IllegalArgumentException("Multiple imported definitions for " + nt);
            }
            return result;
        }
        return this.pMap.get(nt);
    }

    public boolean isDefined(Production p, Module m) {
        String qualifier = p.qName.getQualifier();
        if (m.name.name.equals(qualifier)) {
            return true;
        }
        while (null != m.modification && null != (m = this.moduleMap.get(m.modification.visibleName().name))) {
            if (!m.name.name.equals(qualifier)) continue;
            return true;
        }
        return false;
    }

    public boolean isImported(Production p, Module m) {
        if (this.isImported1(p, m)) {
            return !p.hasAttribute(Constants.ATT_PRIVATE);
        }
        while (null != m.modification && null != (m = this.moduleMap.get(m.modification.visibleName().name))) {
            if (!this.isImported1(p, m)) continue;
            return !p.hasAttribute(Constants.ATT_PRIVATE);
        }
        return false;
    }

    private boolean isImported1(Production p, Module m) {
        if (null != m.dependencies) {
            for (ModuleDependency dep : m.dependencies) {
                if (!dep.isImport() || null == (m = this.moduleMap.get(dep.visibleName().name)) || !this.isDefined(p, m)) continue;
                return true;
            }
        }
        return false;
    }

    public void uniquify() {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        HashSet<NonTerminal> renamed = new HashSet<NonTerminal>();
        HashSet<NonTerminal> remove = new HashSet<NonTerminal>();
        for (Module m : this.grammar.modules) {
            for (FullProduction fullProduction : m.productions) {
                if (renamed.contains(fullProduction.qName)) continue;
                Object o = this.grammarPMap.get(fullProduction.name);
                if (o instanceof FullProduction) {
                    renamed.add(fullProduction.qName);
                    continue;
                }
                List<FullProduction> l = this.toFullProductionList(o);
                remove.add(fullProduction.name);
                ArrayList<NonTerminal> names = new ArrayList<NonTerminal>();
                for (FullProduction p2 : l) {
                    String qual = p2.qName.getQualifier();
                    if (Utilities.isQualified(qual)) {
                        names.add(p2.name.qualify(Utilities.getName(qual)));
                        continue;
                    }
                    names.add(p2.qName);
                }
                if (names.size() == new HashSet(names).size()) {
                    Iterator<FullProduction> iter2 = l.iterator();
                    Iterator iter3 = names.iterator();
                    while (iter2.hasNext()) {
                        FullProduction p2 = iter2.next();
                        p2.name = (NonTerminal)iter3.next();
                        renamed.add(p2.qName);
                    }
                    continue;
                }
                for (FullProduction p2 : l) {
                    p2.name = p2.qName;
                    renamed.add(p2.qName);
                }
            }
        }
        new Renamer(null, this, new Renamer.Translation(){

            @Override
            public NonTerminal map(NonTerminal nt, Analyzer analyzer) {
                NonTerminal result = analyzer.lookup((NonTerminal)nt).name;
                if (nt.equals(result)) {
                    result = nt;
                } else {
                    result = new NonTerminal(result.name);
                    result.setLocation(nt);
                }
                return result;
            }
        }).dispatch(this.grammar);
        for (NonTerminal name : remove) {
            this.grammarPMap.remove(name);
        }
    }

    public void process(Module m) {
        if (this.isGrammarMode) {
            this.mCurrent = m;
        } else if (m != this.module) {
            throw new IllegalArgumentException("Invalid module " + m);
        }
    }

    public Module currentModule() {
        return this.isGrammarMode ? this.mCurrent : this.module;
    }

    public Object enter(Production p) {
        if (this.isGrammarMode) {
            Module m = this.mCurrent;
            this.mCurrent = this.lookup(p.qName.getQualifier());
            return m;
        }
        return null;
    }

    public void exit(Object closure) {
        if (this.isGrammarMode) {
            this.mCurrent = (Module)closure;
        }
    }

    public void process(Production p) {
        this.pWorking.clear();
        this.varCount = 1;
        this.splitCount = 1;
        this.choiceCount = 1;
        this.starCount = 1;
        this.plusCount = 1;
        this.optionCount = 1;
        this.tailCount = 1;
        this.pCurrent = p;
        this.visitor().dispatch(p);
    }

    public Production current() {
        return this.pCurrent;
    }

    public void workingOn(NonTerminal nt) {
        this.pWorking.add(nt);
    }

    public void notWorkingOn(NonTerminal nt) {
        this.pWorking.remove(nt);
    }

    public void notWorkingOnAny() {
        this.pWorking.clear();
    }

    public boolean isBeingWorkedOn(NonTerminal nt) {
        return this.pWorking.contains(nt);
    }

    public Set<NonTerminal> working() {
        return this.pWorking;
    }

    public void mark(NonTerminal nt) {
        this.pMarked.add(nt);
    }

    public void mark(Collection<NonTerminal> nts) {
        this.pMarked.addAll(nts);
    }

    public void markAll() {
        for (Production p : this.module.productions) {
            this.pMarked.add(p.qName);
        }
    }

    public void unmark(NonTerminal nt) {
        this.pMarked.remove(nt);
    }

    public void unmarkAll() {
        this.pMarked.clear();
    }

    public boolean hasMarked() {
        return !this.pMarked.isEmpty();
    }

    public boolean isMarked(NonTerminal nt) {
        return this.pMarked.contains(nt);
    }

    public Set<NonTerminal> marked() {
        return this.pMarked;
    }

    public void clearProcessed() {
        this.pProcessed.clear();
    }

    public void processed(NonTerminal nt) {
        this.pProcessed.add(nt);
    }

    public boolean isProcessed(NonTerminal nt) {
        return this.pProcessed.contains(nt);
    }

    public void startAdding() {
        this.pNew.clear();
    }

    public void add(FullProduction p) {
        p.setProperty("xtc.Constants.Synthetic", Boolean.TRUE);
        this.pNew.add(p);
        this.pMap.put(p.name, p);
        this.pMap.put(p.qName, p);
    }

    public int addNewProductionsAt(int idx) {
        int size = this.pNew.size();
        if (0 != size) {
            this.module.productions.addAll(idx, this.pNew);
        }
        return size;
    }

    public void remove(FullProduction p) {
        this.pMap.remove(p.name);
        this.pMap.remove(p.qName);
    }

    public void resetVarCount() {
        this.varCount = 1;
    }

    public int getVarCount() {
        return this.varCount;
    }

    public void setVarCount(int count) {
        this.varCount = count;
    }

    public String variable() {
        return VARIABLE + Integer.toString(this.varCount++);
    }

    public String variable(String marker) {
        return VARIABLE + marker + "$" + Integer.toString(this.varCount++);
    }

    public static boolean isSynthetic(String var) {
        return var.startsWith(VARIABLE);
    }

    public NonTerminal split() {
        return new NonTerminal(this.pCurrent.name + SPLIT + Integer.toString(this.splitCount++));
    }

    public NonTerminal choice() {
        return new NonTerminal(this.pCurrent.name + CHOICE + Integer.toString(this.choiceCount++));
    }

    public NonTerminal star() {
        return new NonTerminal(this.pCurrent.name + STAR + Integer.toString(this.starCount++));
    }

    public NonTerminal plus() {
        return new NonTerminal(this.pCurrent.name + PLUS + Integer.toString(this.plusCount++));
    }

    public NonTerminal option() {
        return new NonTerminal(this.pCurrent.name + OPTION + Integer.toString(this.optionCount++));
    }

    public NonTerminal tail() {
        return new NonTerminal(this.pCurrent.name + TAIL + Integer.toString(this.tailCount++));
    }

    public NonTerminal shared() {
        return new NonTerminal(SHARED + Integer.toString(this.sharedCount++));
    }

    public static boolean isSynthetic(NonTerminal nt) {
        return -1 != nt.name.indexOf(SEPARATOR);
    }

    public static Element strip(Element e) {
        switch (e.tag()) {
            case CHOICE: {
                OrderedChoice c = (OrderedChoice)e;
                if (1 != c.alternatives.size()) break;
                e = Analyzer.strip(c.alternatives.get(0));
                break;
            }
            case SEQUENCE: {
                Sequence s = (Sequence)e;
                if (1 != s.size()) break;
                e = Analyzer.strip(s.get(0));
            }
        }
        return e;
    }

    public static OrderedChoice stripChoices(OrderedChoice c) {
        boolean changed = false;
        block4: do {
            if (1 != c.alternatives.size()) continue;
            Element e = c.alternatives.get(0);
            switch (e.tag()) {
                case CHOICE: {
                    c = (OrderedChoice)e;
                    changed = true;
                    break;
                }
                case SEQUENCE: {
                    Sequence s = (Sequence)e;
                    if (1 != s.size() || !(s.get(0) instanceof OrderedChoice)) continue block4;
                    c = (OrderedChoice)s.get(0);
                    changed = true;
                }
            }
        } while (changed);
        return c;
    }

    public Module copy(Module m) {
        return (Module)this.xerox.dispatch(m);
    }

    public <T extends Element> T copy(T e) {
        return this.xerox.copy(e);
    }

    public boolean hasTerminalPrefix(Sequence s) {
        Element e;
        return 1 <= s.size() && ((e = s.get(0)) instanceof CharLiteral || e instanceof StringLiteral || e instanceof CharClass && ((CharClass)e).count() <= 22);
    }

    private int normalLength(Sequence s) {
        int size = s.size();
        boolean normal = true;
        int count = 0;
        block5: for (int i = 0; i < size; ++i) {
            Element e = s.get(i);
            switch (e.tag()) {
                case CHAR_LITERAL: {
                    normal = false;
                    ++count;
                    continue block5;
                }
                case STRING_LITERAL: {
                    normal = false;
                    count += ((StringLiteral)e).text.length();
                    continue block5;
                }
                case CHAR_CLASS: {
                    ++count;
                    continue block5;
                }
                default: {
                    count += size - i;
                    break block5;
                }
            }
        }
        return normal ? -1 : count;
    }

    public Sequence normalizeTerminals(Sequence s) {
        int nl = this.normalLength(s);
        if (-1 == nl) {
            return s;
        }
        int l = s.size();
        Sequence s2 = new Sequence(new ArrayList<Element>(nl));
        s2.setLocation(s);
        block5: for (int i = 0; i < l; ++i) {
            Element e = s.get(i);
            switch (e.tag()) {
                case CHAR_LITERAL: {
                    s2.add(new CharClass(((CharLiteral)e).c));
                    continue block5;
                }
                case STRING_LITERAL: {
                    StringLiteral sl = (StringLiteral)e;
                    for (int j = 0; j < sl.text.length(); ++j) {
                        s2.add(new CharClass(sl.text.charAt(j)));
                    }
                    continue block5;
                }
                case CHAR_CLASS: {
                    s2.add(e);
                    continue block5;
                }
                default: {
                    s2.addAll(s.elements.subList(i, l));
                    break block5;
                }
            }
        }
        return s2;
    }

    public Element joinTerminals(Sequence source, Element target) {
        Element e;
        Sequence s;
        if (null == target) {
            return source;
        }
        if (target instanceof Sequence && 1 == (s = (Sequence)target).size() && (e = s.get(0)) instanceof OrderedChoice) {
            target = e;
        }
        if (target instanceof Sequence) {
            Element s1;
            Sequence t = (Sequence)target;
            Element t1 = t.isEmpty() ? null : t.get(0);
            Element element = s1 = source.isEmpty() ? null : source.get(0);
            if (s1 instanceof CharClass && t1 instanceof CharClass && s1.equals(t1)) {
                Sequence result = new Sequence(this.joinTerminals(source.subSequence(1), t.subSequence(1)));
                result.setLocation(source);
                result.elements.add(0, s1);
                return result;
            }
            if (s1 instanceof CharClass && ((CharClass)s1).count() <= 22) {
                CharClass sk = (CharClass)s1;
                if (t1 instanceof CharClass) {
                    CharClass tk = (CharClass)t1;
                    if (tk.count() <= 22) {
                        return this.joinTerminals(source, new Sequence(new CharSwitch(tk, (Element)t.subSequence(1))));
                    }
                } else if (t1 instanceof CharSwitch) {
                    CharSwitch sw = (CharSwitch)t1;
                    CharClass klass = new CharClass(sk.ranges);
                    CharCase kase = sw.hasCase(klass);
                    if (sk.exclusive) {
                        if (null != kase && 1 == sw.cases.size()) {
                            sw.base = this.joinTerminals(source.subSequence(1), sw.base);
                            return target;
                        }
                    } else {
                        if (null != kase) {
                            kase.element = this.joinTerminals(source.subSequence(1), kase.element);
                            return target;
                        }
                        if (!sw.overlaps(klass) && null == sw.base) {
                            sw.cases.add(new CharCase(klass, (Element)source.subSequence(1)));
                            return target;
                        }
                    }
                }
            }
            OrderedChoice c = new OrderedChoice();
            c.alternatives.add(Sequence.ensure(target));
            c.alternatives.add(source);
            return c;
        }
        if (target instanceof OrderedChoice) {
            OrderedChoice c = (OrderedChoice)target;
            int l = c.alternatives.size();
            Element e2 = this.joinTerminals(source, c.alternatives.get(l - 1));
            if (e2 instanceof OrderedChoice) {
                c.alternatives.remove(l - 1);
                c.alternatives.addAll(((OrderedChoice)e2).alternatives);
            } else {
                c.alternatives.set(l - 1, Sequence.ensure(e2));
            }
            return c;
        }
        return this.joinTerminals(source, new Sequence(target));
    }

    public boolean haveCommonPrefix(Sequence s1, Sequence s2) {
        Element e2;
        Element e1 = s1.isEmpty() ? null : s1.get(0);
        Element element = e2 = s2.isEmpty() ? null : s2.get(0);
        if (e1 instanceof Binding) {
            return e1.equals(e2);
        }
        if (null != e1) {
            return e1.equals(e2);
        }
        return false;
    }

    public Sequence normalizePrefix(Sequence s1, Sequence s2) {
        return s2;
    }

    public Element joinPrefixes(Sequence source, Element target) {
        Element e;
        Sequence s;
        if (null == target) {
            return source;
        }
        if (target instanceof Sequence && 1 == (s = (Sequence)target).size() && (e = s.get(0)) instanceof OrderedChoice) {
            target = e;
        }
        if (target instanceof Sequence) {
            Element s1;
            Sequence t = (Sequence)target;
            if (source.equals(t)) {
                return source;
            }
            Element t1 = t.isEmpty() ? null : t.get(0);
            Element element = s1 = source.isEmpty() ? null : source.get(0);
            if (null != s1 && s1.equals(t1)) {
                Sequence result = new Sequence(this.joinPrefixes(source.subSequence(1), t.subSequence(1)));
                result.setLocation(source);
                result.elements.add(0, s1);
                return result;
            }
            OrderedChoice c = new OrderedChoice();
            c.alternatives.add(Sequence.ensure(target));
            c.alternatives.add(source);
            return c;
        }
        if (target instanceof OrderedChoice) {
            OrderedChoice c = (OrderedChoice)target;
            int l = c.alternatives.size();
            Element e2 = this.joinPrefixes(source, c.alternatives.get(l - 1));
            if (e2 instanceof OrderedChoice) {
                c.alternatives.remove(l - 1);
                c.alternatives.addAll(((OrderedChoice)e2).alternatives);
            } else {
                c.alternatives.set(l - 1, Sequence.ensure(e2));
            }
            return c;
        }
        return this.joinPrefixes(source, new Sequence(target));
    }

    public String matchingText(Element e) {
        StringBuilder buf = new StringBuilder();
        return this.matchingText(e, buf) ? buf.toString() : null;
    }

    private boolean matchingText(Element e, StringBuilder buf) {
        switch (e.tag()) {
            case CHOICE: {
                OrderedChoice c = (OrderedChoice)e;
                if (1 == c.alternatives.size()) {
                    return this.matchingText(c.alternatives.get(0), buf);
                }
                return false;
            }
            case SEQUENCE: {
                for (Element el : ((Sequence)e).elements) {
                    if (this.matchingText(el, buf)) continue;
                    return false;
                }
                return true;
            }
            case FOLLOWED_BY: 
            case NOT_FOLLOWED_BY: 
            case SEMANTIC_PREDICATE: 
            case ACTION: 
            case NODE_MARKER: 
            case NULL: {
                return true;
            }
            case BINDING: 
            case STRING_MATCH: {
                return this.matchingText(((UnaryOperator)e).element, buf);
            }
            case NONTERMINAL: {
                return this.matchingText(this.lookup((NonTerminal)((NonTerminal)e)).choice, buf);
            }
            case STRING_LITERAL: {
                buf.append(((StringLiteral)e).text);
                return true;
            }
            case CHAR_LITERAL: {
                buf.append(((CharLiteral)e).c);
                return true;
            }
            case CHAR_CLASS: {
                CharClass c = (CharClass)e;
                if (1 == c.ranges.size()) {
                    CharRange r = c.ranges.get(0);
                    if (r.first == r.last) {
                        buf.append(r.first);
                        return true;
                    }
                }
                return false;
            }
        }
        return e instanceof ValueElement;
    }

    public boolean restrictsInput(Element e) {
        return (Boolean)this.restrictsInputVisitor.dispatch(e);
    }

    public boolean consumesInput(Element e) {
        return (Boolean)this.consumesInputVisitor.dispatch(e);
    }

    public boolean matchesEmpty(Element e) {
        return (Boolean)this.matchesEmptyVisitor.dispatch(e);
    }

    public boolean isNotFollowedBy(Element e) {
        return (Boolean)this.isNotFollowedByVisitor.dispatch(Analyzer.strip(e));
    }

    public boolean isBindable(Element e) {
        switch (e.tag()) {
            case NONTERMINAL: {
                return !AST.isVoid(this.lookup((NonTerminal)((NonTerminal)e)).type);
            }
            case CHOICE: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case CHAR_CLASS: 
            case NULL: 
            case BINDING: 
            case STRING_MATCH: 
            case OPTION: 
            case REPETITION: 
            case ANY_CHAR: 
            case PARSE_TREE_NODE: {
                return true;
            }
        }
        return false;
    }

    public Binding bind(List<Element> l) {
        return this.bind(l, null);
    }

    public Binding bind(List<Element> l, String marker) {
        Binding binding = null;
        Element bound = null;
        int idx = -1;
        int length = l.size();
        block7: for (int i = 0; i < length; ++i) {
            Element e = l.get(i);
            switch (e.tag()) {
                case NONTERMINAL: {
                    if (AST.isVoid(this.lookup((NonTerminal)((NonTerminal)e)).type)) continue block7;
                }
                case CHOICE: 
                case CHAR_LITERAL: 
                case STRING_LITERAL: 
                case CHAR_CLASS: 
                case NULL: 
                case STRING_MATCH: 
                case OPTION: 
                case REPETITION: 
                case ANY_CHAR: 
                case PARSE_TREE_NODE: {
                    if (-1 == idx) {
                        bound = e;
                        idx = i;
                        continue block7;
                    }
                    binding = null;
                    idx = -1;
                    break block7;
                }
                case BINDING: {
                    if (-1 == idx) {
                        binding = (Binding)e;
                        idx = i;
                        continue block7;
                    }
                    binding = null;
                    idx = -1;
                    break block7;
                }
                case FOLLOWED_BY: 
                case NOT_FOLLOWED_BY: 
                case SEMANTIC_PREDICATE: 
                case NODE_MARKER: 
                case VOIDED: {
                    continue block7;
                }
                case ACTION: {
                    if (!((Action)e).setsValue()) continue block7;
                }
                default: {
                    binding = null;
                    idx = -1;
                    break block7;
                }
            }
        }
        if (null != binding) {
            return binding;
        }
        if (-1 == idx) {
            return null;
        }
        binding = null == marker ? new Binding(this.variable(), bound) : new Binding(this.variable(marker), bound);
        l.set(idx, binding);
        return binding;
    }

    public static Binding getBinding(List<Element> l) {
        Binding binding = null;
        for (Element e : l) {
            if (!(e instanceof Binding)) continue;
            if (null == binding) {
                binding = (Binding)e;
                continue;
            }
            return null;
        }
        return binding;
    }

    public static Element unbind(Element e) {
        return e instanceof Binding ? ((Binding)e).element : e;
    }

    public static Element stripAndUnbind(Element e) {
        return Analyzer.strip(Analyzer.unbind(Analyzer.strip(e)));
    }

    public Element getValue(List<Element> list, boolean ignoreActions) {
        Element value = null;
        block10: for (Element e : list) {
            switch (e.tag()) {
                case BINDING: {
                    Binding b = (Binding)e;
                    if (!"yyValue".equals(b.name)) continue block10;
                    value = b;
                    break;
                }
                case ACTION: {
                    Action a = (Action)e;
                    if (ignoreActions || !a.setsValue()) continue block10;
                    value = a;
                    break;
                }
                case PARSER_ACTION: {
                    if (ignoreActions) break;
                    value = e;
                    break;
                }
                case ACTION_BASE_VALUE: 
                case BINDING_VALUE: 
                case GENERIC_ACTION_VALUE: 
                case GENERIC_RECURSION_VALUE: 
                case GENERIC_NODE_VALUE: 
                case EMPTY_LIST_VALUE: 
                case PROPER_LIST_VALUE: 
                case NULL_VALUE: 
                case STRING_VALUE: 
                case TOKEN_VALUE: {
                    value = e;
                }
            }
        }
        if (null != value) {
            return value;
        }
        boolean foundMany = false;
        for (Element e : list) {
            switch (e.tag()) {
                case NONTERMINAL: {
                    if (AST.isVoid(this.lookup((NonTerminal)((NonTerminal)e)).type)) break;
                }
                case CHOICE: 
                case CHAR_LITERAL: 
                case STRING_LITERAL: 
                case CHAR_CLASS: 
                case NULL: 
                case BINDING: 
                case STRING_MATCH: 
                case OPTION: 
                case REPETITION: 
                case ANY_CHAR: 
                case PARSE_TREE_NODE: {
                    if (foundMany) break;
                    if (null == value) {
                        value = e;
                        break;
                    }
                    foundMany = true;
                    value = null;
                    break;
                }
            }
        }
        return value;
    }

    public static boolean setsValue(List<Element> l, boolean all) {
        return Analyzer.setsValue(new Sequence(l), all);
    }

    public static boolean setsValue(Element e, final boolean all) {
        return (Boolean)new Visitor(){
            private boolean isLast = true;

            public Boolean visit(OrderedChoice c) {
                if (!this.isLast) {
                    return Boolean.FALSE;
                }
                for (Sequence alt : c.alternatives) {
                    if (all) {
                        if (((Boolean)this.dispatch(alt)).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    if (!((Boolean)this.dispatch(alt)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return all;
            }

            public Boolean visit(Sequence s) {
                if (!this.isLast) {
                    return Boolean.FALSE;
                }
                Iterator<Element> iter = s.elements.iterator();
                while (iter.hasNext()) {
                    boolean bl = this.isLast = !iter.hasNext();
                    if (!((Boolean)this.dispatch(iter.next())).booleanValue()) continue;
                    this.isLast = true;
                    return Boolean.TRUE;
                }
                this.isLast = true;
                return Boolean.FALSE;
            }

            public Boolean visit(VoidedElement v) {
                return (Boolean)this.dispatch(v.element);
            }

            public Boolean visit(Binding b) {
                return "yyValue".equals(b.name);
            }

            public Boolean visit(StringMatch m) {
                return (Boolean)this.dispatch(m.element);
            }

            public Boolean visit(Action a) {
                return a.setsValue();
            }

            public Boolean visit(ParserAction a) {
                return Boolean.TRUE;
            }

            public Boolean visit(ValueElement v) {
                return Boolean.TRUE;
            }

            public Boolean visit(Element e) {
                return Boolean.FALSE;
            }
        }.dispatch(e);
    }

    public static boolean setsNullValue(List<Element> l) {
        boolean hasNull = false;
        for (Element e : l) {
            switch (e.tag()) {
                case BINDING: {
                    if (!"yyValue".equals(((Binding)e).name)) break;
                    return false;
                }
                case ACTION: {
                    if (!((Action)e).setsValue()) break;
                    return false;
                }
                case NULL_VALUE: {
                    hasNull = true;
                    break;
                }
                case ACTION_BASE_VALUE: 
                case BINDING_VALUE: 
                case GENERIC_ACTION_VALUE: 
                case GENERIC_RECURSION_VALUE: 
                case GENERIC_NODE_VALUE: 
                case EMPTY_LIST_VALUE: 
                case PROPER_LIST_VALUE: 
                case STRING_VALUE: 
                case TOKEN_VALUE: {
                    return false;
                }
            }
        }
        return hasNull;
    }

    public boolean mayBeNull(Element element) {
        switch (element.tag()) {
            case OPTION: {
                return true;
            }
            case NONTERMINAL: {
                NonTerminal nt = (NonTerminal)element;
                FullProduction p = this.lookup(nt);
                if (!p.getBooleanProperty("option")) break;
                return true;
            }
        }
        return false;
    }

    public Type type(Element element) {
        switch (element.tag()) {
            case CHOICE: 
            case SEQUENCE: {
                return AST.ANY;
            }
            case REPETITION: {
                Binding b = Analyzer.getBinding(Sequence.ensure((Element)((Repetition)element).element).elements);
                return AST.listOf(null == b ? AST.ANY : this.type(b.element));
            }
            case OPTION: {
                Binding b = Analyzer.getBinding(Sequence.ensure((Element)((Option)element).element).elements);
                return null == b ? AST.ANY : AST.markOptional(this.type(b.element));
            }
            case VOIDED: {
                return VoidT.TYPE;
            }
            case BINDING: {
                return this.type(((Binding)element).element);
            }
            case NONTERMINAL: {
                return this.lookup((NonTerminal)((NonTerminal)element)).type.deannotate();
            }
            case CHAR_LITERAL: 
            case CHAR_CLASS: 
            case ANY_CHAR: 
            case CHAR_SWITCH: {
                return AST.CHAR;
            }
            case STRING_LITERAL: {
                return AST.STRING;
            }
            case STRING_MATCH: {
                return this.module.hasAttribute(Constants.ATT_PARSE_TREE) ? AST.NODE : AST.STRING;
            }
            case PARSE_TREE_NODE: {
                return AST.NODE;
            }
            case NULL: {
                return Wildcard.TYPE;
            }
        }
        throw new IllegalArgumentException("Unable to type " + element);
    }
}

