/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.List;
import xtc.parser.Element;
import xtc.util.Utilities;

public class Action
extends Element {
    public final List<String> code;
    public final List<Integer> indent;

    public Action(String s, List<Integer> indent) {
        int i;
        int i2;
        String[] ss = Utilities.SPACE_NEWLINE_SPACE.split(s);
        this.indent = indent;
        if (indent.size() < ss.length) {
            throw new IllegalArgumentException("List of indentation levels too short");
        }
        if (0 < ss.length) {
            ss[0] = ss[0].trim();
            if (1 != ss.length) {
                ss[ss.length - 1] = ss[ss.length - 1].trim();
            }
        }
        int start = ss.length;
        int end = ss.length - 1;
        for (i2 = 0; i2 < ss.length; ++i2) {
            if ("".equals(ss[i2])) continue;
            start = i2;
            break;
        }
        for (i2 = ss.length - 1; i2 >= 0; --i2) {
            if ("".equals(ss[i2])) continue;
            end = i2;
            break;
        }
        int size = indent.size();
        for (i = 0; i < start; ++i) {
            indent.remove(0);
        }
        for (i = end + 1; i < size; ++i) {
            indent.remove(indent.size() - 1);
        }
        this.code = new ArrayList<String>(end - start + 1);
        for (i = start; i <= end; ++i) {
            this.code.add(ss[i]);
        }
    }

    public Action(List<String> code, List<Integer> indent) {
        if (indent.size() != code.size()) {
            throw new IllegalArgumentException("Number of code lines and indentation levels inconsistent");
        }
        this.code = code;
        this.indent = indent;
    }

    @Override
    public Element.Tag tag() {
        return Element.Tag.ACTION;
    }

    public void add(Action a) {
        this.code.addAll(a.code);
        this.indent.addAll(a.indent);
    }

    public boolean setsValue() {
        for (String s : this.code) {
            if (-1 == s.indexOf("yyValue")) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action other = (Action)o;
        if (!this.code.equals(other.code)) {
            return false;
        }
        return this.indent.equals(other.indent);
    }
}

