/*
 * Decompiled with CFR 0.152.
 */
package xtc;

import java.math.BigInteger;

public class Limits {
    public static final String OS = "Mac OS X 10.6.1";
    public static final String ARCH = "x86_64";
    public static final boolean IS_ELF = false;
    public static final String COMPILER_NAME = "gcc";
    public static final String COMPILER_VERSION = "4.2.1 (Apple Inc. build 5646)";
    public static final int COMPILER_VERSION_MAJOR = 4;
    public static final int COMPILER_VERSION_MINOR = 2;
    public static final boolean IS_BIG_ENDIAN = false;
    public static final int VOID_SIZE = 1;
    public static final int VOID_ALIGN = 1;
    public static final int FUNCTION_SIZE = 1;
    public static final int FUNCTION_ALIGN = 1;
    public static final int POINTER_SIZE = 8;
    public static final int POINTER_ALIGN = 8;
    public static final int POINTER_NAT_ALIGN = 8;
    public static final int PTRDIFF_SIZE = 8;
    public static final int PTRDIFF_RANK = 4;
    public static final int SIZEOF_SIZE = 8;
    public static final int SIZEOF_RANK = 4;
    public static final BigInteger ARRAY_MAX = BigInteger.valueOf(0x10000000000L);
    public static final int BOOL_SIZE = 1;
    public static final int BOOL_ALIGN = 1;
    public static final int BOOL_NAT_ALIGN = 1;
    public static final boolean IS_CHAR_SIGNED = true;
    public static final int CHAR_BITS = 8;
    public static final BigInteger CHAR_MIN = new BigInteger("-128");
    public static final BigInteger CHAR_MAX = new BigInteger("127");
    public static final BigInteger UCHAR_MAX = new BigInteger("255");
    public static final boolean IS_WCHAR_SIGNED = true;
    public static final int WCHAR_SIZE = 4;
    public static final int WCHAR_RANK = 3;
    public static final boolean IS_STRING_CONST = true;
    public static final int SHORT_SIZE = 2;
    public static final int SHORT_ALIGN = 2;
    public static final int SHORT_NAT_ALIGN = 2;
    public static final BigInteger SHORT_MIN = new BigInteger("-32768");
    public static final BigInteger SHORT_MAX = new BigInteger("32767");
    public static final BigInteger USHORT_MAX = new BigInteger("65535");
    public static final boolean IS_INT_SIGNED = true;
    public static final int INT_SIZE = 4;
    public static final int INT_ALIGN = 4;
    public static final int INT_NAT_ALIGN = 4;
    public static final BigInteger INT_MIN = new BigInteger("-2147483648");
    public static final BigInteger INT_MAX = new BigInteger("2147483647");
    public static final BigInteger UINT_MAX = new BigInteger("4294967295");
    public static final int LONG_SIZE = 8;
    public static final int LONG_ALIGN = 8;
    public static final int LONG_NAT_ALIGN = 8;
    public static final BigInteger LONG_MIN = new BigInteger("-9223372036854775808");
    public static final BigInteger LONG_MAX = new BigInteger("9223372036854775807");
    public static final BigInteger ULONG_MAX = new BigInteger("18446744073709551615");
    public static final int LONG_LONG_SIZE = 8;
    public static final int LONG_LONG_ALIGN = 8;
    public static final int LONG_LONG_NAT_ALIGN = 8;
    public static final BigInteger LONG_LONG_MIN = new BigInteger("-9223372036854775808");
    public static final BigInteger LONG_LONG_MAX = new BigInteger("9223372036854775807");
    public static final BigInteger ULONG_LONG_MAX = new BigInteger("18446744073709551615");
    public static final int FLOAT_SIZE = 4;
    public static final int FLOAT_ALIGN = 4;
    public static final int FLOAT_NAT_ALIGN = 4;
    public static final int DOUBLE_SIZE = 8;
    public static final int DOUBLE_ALIGN = 8;
    public static final int DOUBLE_NAT_ALIGN = 8;
    public static final int LONG_DOUBLE_SIZE = 16;
    public static final int LONG_DOUBLE_ALIGN = 16;
    public static final int LONG_DOUBLE_NAT_ALIGN = 16;
    private static final BigInteger CHAR_MOD = CHAR_MAX.add(BigInteger.ONE);
    private static final BigInteger UCHAR_MOD = UCHAR_MAX.add(BigInteger.ONE);
    private static final BigInteger SHORT_MOD = SHORT_MAX.add(BigInteger.ONE);
    private static final BigInteger USHORT_MOD = USHORT_MAX.add(BigInteger.ONE);
    private static final BigInteger INT_MOD = INT_MAX.add(BigInteger.ONE);
    private static final BigInteger UINT_MOD = UINT_MAX.add(BigInteger.ONE);
    private static final BigInteger LONG_MOD = LONG_MAX.add(BigInteger.ONE);
    private static final BigInteger ULONG_MOD = ULONG_MAX.add(BigInteger.ONE);
    private static final BigInteger LONG_LONG_MOD = LONG_LONG_MAX.add(BigInteger.ONE);
    private static final BigInteger ULONG_LONG_MOD = ULONG_LONG_MAX.add(BigInteger.ONE);

    private Limits() {
    }

    public static long toWidth(long size) {
        return size * 8L;
    }

    public static boolean fitsChar(BigInteger value) {
        return CHAR_MIN.compareTo(value) <= 0 && CHAR_MAX.compareTo(value) >= 0;
    }

    public static boolean fitsUnsignedChar(BigInteger value) {
        return BigInteger.ZERO.compareTo(value) <= 0 && UCHAR_MAX.compareTo(value) >= 0;
    }

    public static boolean fitsShort(BigInteger value) {
        return SHORT_MIN.compareTo(value) <= 0 && SHORT_MAX.compareTo(value) >= 0;
    }

    public static boolean fitsUnsignedShort(BigInteger value) {
        return BigInteger.ZERO.compareTo(value) <= 0 && USHORT_MAX.compareTo(value) >= 0;
    }

    public static boolean fitsInt(BigInteger value) {
        return INT_MIN.compareTo(value) <= 0 && INT_MAX.compareTo(value) >= 0;
    }

    public static boolean fitsUnsignedInt(BigInteger value) {
        return BigInteger.ZERO.compareTo(value) <= 0 && UINT_MAX.compareTo(value) >= 0;
    }

    public static boolean fitsLong(BigInteger value) {
        return LONG_MIN.compareTo(value) <= 0 && LONG_MAX.compareTo(value) >= 0;
    }

    public static boolean fitsUnsignedLong(BigInteger value) {
        return BigInteger.ZERO.compareTo(value) <= 0 && ULONG_MAX.compareTo(value) >= 0;
    }

    public static boolean fitsLongLong(BigInteger value) {
        return LONG_LONG_MIN.compareTo(value) <= 0 && LONG_LONG_MAX.compareTo(value) >= 0;
    }

    public static boolean fitsUnsignedLongLong(BigInteger value) {
        return BigInteger.ZERO.compareTo(value) <= 0 && ULONG_LONG_MAX.compareTo(value) >= 0;
    }

    public static BigInteger maskAsSignedChar(BigInteger value) {
        return value.remainder(CHAR_MOD);
    }

    public static BigInteger maskAsUnsignedChar(BigInteger value) {
        return value.signum() >= 0 ? value.remainder(UCHAR_MOD) : UCHAR_MOD.add(value.remainder(UCHAR_MOD));
    }

    public static BigInteger maskAsShort(BigInteger value) {
        return value.remainder(SHORT_MOD);
    }

    public static BigInteger maskAsUnsignedShort(BigInteger value) {
        return value.signum() >= 0 ? value.remainder(USHORT_MOD) : USHORT_MOD.add(value.remainder(USHORT_MOD));
    }

    public static BigInteger maskAsInt(BigInteger value) {
        return value.remainder(INT_MOD);
    }

    public static BigInteger maskAsUnsignedInt(BigInteger value) {
        return value.signum() >= 0 ? value.remainder(UINT_MOD) : UINT_MOD.add(value.remainder(UINT_MOD));
    }

    public static BigInteger maskAsLong(BigInteger value) {
        return value.remainder(LONG_MOD);
    }

    public static BigInteger maskAsUnsignedLong(BigInteger value) {
        return value.signum() >= 0 ? value.remainder(ULONG_MOD) : ULONG_MOD.add(value.remainder(ULONG_MOD));
    }

    public static BigInteger maskAsLongLong(BigInteger value) {
        return value.remainder(LONG_LONG_MOD);
    }

    public static BigInteger maskAsUnsignedLongLong(BigInteger value) {
        return value.signum() >= 0 ? value.remainder(ULONG_LONG_MOD) : ULONG_LONG_MOD.add(value.remainder(ULONG_LONG_MOD));
    }
}

