/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring.remoting;

import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.BeanInvoker;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.Invoker;
import org.codehaus.xfire.spring.remoting.XFireServletControllerAdapter;
import org.codehaus.xfire.wsdl11.WSDL11ParameterBinding;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class Jsr181HandlerMapping
extends AbstractUrlHandlerMapping {
    private WebAnnotations webAnnotations;
    private XFire xFire;
    private TypeMappingRegistry typeMappingRegistry;
    private String urlPrefix = "/services/";

    protected void initApplicationContext() throws BeansException {
        if (!(this.getApplicationContext() instanceof ConfigurableApplicationContext)) {
            throw new ApplicationContextException("[" + ((Object)((Object)this)).getClass().getName() + "] needs to run in a ConfigurableApplicationContext");
        }
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.getApplicationContext()).getBeanFactory();
        String[] beanNames = this.getApplicationContext().getBeanDefinitionNames();
        AnnotationServiceFactory serviceFactory = new AnnotationServiceFactory(this.webAnnotations, this.xFire.getTransportManager(), (BindingProvider)new AegisBindingProvider(this.typeMappingRegistry));
        for (int i = 0; i < beanNames.length; ++i) {
            Class clazz = this.getApplicationContext().getType(beanNames[i]);
            if (this.webAnnotations.hasWebServiceAnnotation(clazz)) {
                Service endpoint = serviceFactory.create(clazz);
                ServiceInfo service = endpoint.getServiceInfo();
                if (this.logger.isInfoEnabled()) {
                    WSDL11ParameterBinding binding = (WSDL11ParameterBinding)endpoint.getBinding();
                    this.logger.info((Object)("Exposing SOAP v." + endpoint.getSoapVersion().getVersion() + " service " + service.getName() + " to " + this.urlPrefix + endpoint.getName() + " as " + binding.getStyle() + "/" + binding.getUse()));
                }
                this.xFire.getServiceRegistry().register(endpoint);
                endpoint.getBinding().setInvoker((Invoker)new BeanInvoker(beanFactory.getBean(beanNames[i])));
                XFireServletControllerAdapter controller = new XFireServletControllerAdapter(this.xFire, endpoint.getServiceInfo().getName());
                this.registerHandler(this.urlPrefix + endpoint.getName(), (Object)controller);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Rejected bean '" + beanNames[i] + "' since it has no WebService annotation"));
        }
    }

    public void setWebAnnotations(WebAnnotations webAnnotations) {
        this.webAnnotations = webAnnotations;
    }

    public void setXfire(XFire xFire) {
        this.xFire = xFire;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }
}

