/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.java5;

import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class EnumType
extends Type {
    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        String value = reader.getValue();
        return Enum.valueOf(this.getTypeClass(), value);
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        writer.writeValue((Object)((Enum)object).toString());
    }

    public void setTypeClass(Class typeClass) {
        if (!typeClass.isEnum()) {
            throw new XFireRuntimeException("Type class must be an enum.");
        }
        super.setTypeClass(typeClass);
    }

    public void writeSchema(Element root) {
        T[] constants;
        Element simple = new Element("xsd:simpleType", "http://www.w3.org/2001/XMLSchema");
        simple.addAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
        root.appendChild((Node)simple);
        Element restriction = new Element("xsd:restriction", "http://www.w3.org/2001/XMLSchema");
        restriction.addAttribute(new Attribute("base", "xsd:string"));
        simple.appendChild((Node)restriction);
        for (Object constant : constants = this.getTypeClass().getEnumConstants()) {
            Element enumeration = new Element("xsd:enumeration", "http://www.w3.org/2001/XMLSchema");
            enumeration.addAttribute(new Attribute("value", ((Enum)constant).toString()));
            restriction.appendChild((Node)enumeration);
        }
    }

    public boolean isComplex() {
        return true;
    }
}

