/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.builder;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderInfo;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Document;
import org.codehaus.yom.Element;
import org.codehaus.yom.Elements;
import org.codehaus.yom.Node;
import org.codehaus.yom.Serializer;
import org.codehaus.yom.converters.DOMConverter;

public abstract class AbstractWSDL
implements WSDLWriter {
    private Definition def;
    private String targetNamespace;
    private Service service;
    private Document wsdlDocument;
    private Map dependencies = new HashMap();
    private Map namespaceImports = new HashMap();
    private Element schemaTypes;
    private Map typeMap;
    private WSDLBuilderInfo info;
    public static final String schemaQ = "xsd:schema";
    public static final String elementQ = "xsd:element";
    public static final String complexQ = "xsd:complexType";
    public static final String sequenceQ = "xsd:sequence";

    public AbstractWSDL(Service service) throws WSDLException {
        this.service = service;
        this.info = (WSDLBuilderInfo)service.getProperty(WSDLBuilderInfo.KEY);
        if (this.info == null) {
            this.info = new WSDLBuilderInfo(service);
        }
        this.setDefinition(WSDLFactory.newInstance().newDefinition());
        this.getDefinition().setTargetNamespace(this.info.getTargetNamespace());
        Element root = new Element("wsdl:types", "http://schemas.xmlsoap.org/wsdl/");
        this.setSchemaTypes(root);
        root.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespace("soap", service.getSoapVersion().getNamespace());
        this.addNamespace("soapenc", service.getSoapVersion().getSoapEncodingStyle());
        this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.addNamespace("tns", this.info.getTargetNamespace());
        this.typeMap = new HashMap();
    }

    protected void writeDocument() throws WSDLException {
        this.writeImports();
        org.w3c.dom.Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.def);
        this.wsdlDocument = DOMConverter.convert((org.w3c.dom.Document)doc);
        this.writeComplexTypes();
    }

    protected void writeImports() {
        Iterator itr = this.namespaceImports.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String uri = (String)entry.getKey();
            Set imports = (Set)entry.getValue();
            Element schema = this.createSchemaType(uri);
            Iterator importItr = imports.iterator();
            while (importItr.hasNext()) {
                String ns = (String)importItr.next();
                if (ns.equals("http://www.w3.org/2001/XMLSchema") || this.hasImport(schema, ns)) continue;
                Element importEl = new Element("xsd:import", "http://www.w3.org/2001/XMLSchema");
                importEl.addAttribute(new Attribute("namespace", ns));
                schema.insertChild((Node)importEl, 0);
            }
        }
    }

    public boolean hasImport(Element schema, String ns) {
        Elements children = schema.getChildElements("import", "http://www.w3.org/2001/XMLSchema");
        for (int i = 0; i < children.size(); ++i) {
            Element importEl = children.get(i);
            String value = importEl.getAttributeValue("namespace");
            if (value == null || !value.equals(ns)) continue;
            return true;
        }
        return false;
    }

    protected void writeComplexTypes() throws WSDLException {
        Element rootEl = this.getDocument().getRootElement();
        if (this.schemaTypes.getChildCount() > 0) {
            this.schemaTypes.detach();
            rootEl.insertChild((Node)this.schemaTypes, 0);
        }
    }

    public void addDependency(SchemaType type) {
        if (!type.isComplex()) {
            return;
        }
        if (!this.hasDependency(type)) {
            this.dependencies.put(type.getSchemaType(), type);
            Element e = this.createSchemaType(type.getSchemaType().getNamespaceURI());
            type.writeSchema(e);
            Set deps = type.getDependencies();
            if (deps != null) {
                Iterator itr = deps.iterator();
                while (itr.hasNext()) {
                    SchemaType child = (SchemaType)itr.next();
                    this.addDependency(child);
                    this.addNamespaceImport(type.getSchemaType().getNamespaceURI(), child.getSchemaType().getNamespaceURI());
                }
            }
        }
    }

    protected boolean hasDependency(SchemaType type) {
        return this.dependencies.containsKey(type.getSchemaType());
    }

    public void addNamespaceImport(String uri, String imported) {
        if (uri.equals(imported)) {
            return;
        }
        HashSet<String> imports = (HashSet<String>)this.namespaceImports.get(uri);
        if (imports == null) {
            imports = new HashSet<String>();
            this.namespaceImports.put(uri, imports);
        }
        imports.add(imported);
    }

    public void write(OutputStream out) throws IOException {
        Serializer writer = new Serializer(out);
        writer.write(this.getDocument());
        writer.flush();
    }

    public void addNamespace(String prefix, String uri) {
        this.def.addNamespace(prefix, uri);
        String declaredUri = this.schemaTypes.getNamespaceURI(prefix);
        if (declaredUri == null) {
            this.schemaTypes.addNamespaceDeclaration(prefix, uri);
        } else if (!declaredUri.equals(uri)) {
            throw new XFireRuntimeException("Namespace conflict: " + declaredUri + " was declared but " + uri + " was attempted.");
        }
    }

    public String getNamespacePrefix(String uri) {
        return NamespaceHelper.getUniquePrefix(this.schemaTypes, uri);
    }

    public WSDLBuilderInfo getInfo() {
        return this.info;
    }

    public Document getDocument() {
        return this.wsdlDocument;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public void setDefinition(Definition definition) {
        this.def = definition;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Element createSchemaType(String namespace) {
        Element e = (Element)this.typeMap.get(namespace);
        if (e == null) {
            e = new Element(schemaQ, "http://www.w3.org/2001/XMLSchema");
            e.addAttribute(new Attribute("targetNamespace", namespace));
            e.addAttribute(new Attribute("elementFormDefault", "qualified"));
            e.addAttribute(new Attribute("attributeFormDefault", "qualified"));
            this.setSchema(namespace, e);
        }
        return e;
    }

    protected boolean hasSchema(String namespace) {
        return this.typeMap.containsKey(namespace);
    }

    protected void setSchema(String namespace, Element schema) {
        this.typeMap.put(namespace, schema);
        this.getSchemaTypes().appendChild((Node)schema);
    }

    protected Element getSchemaTypes() {
        return this.schemaTypes;
    }

    protected void setSchemaTypes(Element schemaTypes) {
        this.schemaTypes = schemaTypes;
    }
}

