/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.local;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.local.LocalTransport;
import org.codehaus.xfire.util.STAXUtils;

public class LocalChannel
extends AbstractChannel {
    private String uri;
    protected static final String SENDER_URI = "senderUri";
    protected static final String OLD_CONTEXT = "urn:xfire:transport:local:oldContext";

    public LocalChannel(String uri, LocalTransport transport) {
        this.setUri(uri);
        this.setTransport(transport);
    }

    public void open() {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if (message.getUri().equals("urn:xfire:channel:backchannel")) {
            OutputStream out = (OutputStream)context.getProperty("urn:xfire:channel:backchannel");
            if (out != null) {
                XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(out, message.getEncoding());
                message.getSerializer().writeMessage(message, writer, context);
            } else {
                MessageContext oldContext = (MessageContext)context.getProperty(OLD_CONTEXT);
                this.sendViaNewChannel(context, oldContext, message, (String)context.getProperty(SENDER_URI));
            }
        } else {
            MessageContext receivingContext = new MessageContext();
            receivingContext.setXFire(context.getXFire());
            receivingContext.setService(this.getService(context.getXFire(), message.getUri()));
            receivingContext.setProperty(OLD_CONTEXT, context);
            receivingContext.setProperty(SENDER_URI, this.getUri());
            this.sendViaNewChannel(context, receivingContext, message, message.getUri());
        }
    }

    protected Service getService(XFire xfire, String uri) {
        int i = uri.indexOf("//");
        if (i == -1 || xfire == null) {
            return null;
        }
        return xfire.getServiceRegistry().getService(uri.substring(i + 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendViaNewChannel(final MessageContext context, final MessageContext receivingContext, final OutMessage message, final String uri) throws XFireException {
        try {
            Channel channel;
            final PipedInputStream stream = new PipedInputStream();
            final PipedOutputStream outStream = new PipedOutputStream(stream);
            try {
                channel = this.getTransport().createChannel(uri);
            }
            catch (Exception e) {
                throw new XFireException("Couldn't create channel.", e);
            }
            final Object readNotify = new Object();
            Thread writeThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(outStream, message.getEncoding());
                        message.getSerializer().writeMessage(message, writer, context);
                        writer.close();
                        outStream.close();
                    }
                    catch (Exception e) {
                        throw new XFireRuntimeException("Couldn't write stream.", e);
                    }
                }
            });
            Thread readThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        XMLStreamReader reader = STAXUtils.createXMLStreamReader(stream, message.getEncoding());
                        InMessage inMessage = new InMessage(reader, uri);
                        inMessage.setEncoding(message.getEncoding());
                        channel.receive(receivingContext, inMessage);
                        reader.close();
                        stream.close();
                    }
                    catch (Exception e) {
                        throw new XFireRuntimeException("Couldn't read stream.", e);
                    }
                    finally {
                        Object object = readNotify;
                        synchronized (object) {
                            readNotify.notifyAll();
                        }
                    }
                }
            });
            writeThread.start();
            readThread.start();
            Object object = readNotify;
            synchronized (object) {
                try {
                    readNotify.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            throw new XFireRuntimeException("Couldn't create stream.", e);
        }
    }

    public void close() {
    }
}

