/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.soap.SoapTransport;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.transport.http.HtmlServiceWriter;
import org.codehaus.xfire.transport.http.SoapHttpTransport;
import org.codehaus.xfire.transport.http.XFireHttpSession;
import org.codehaus.xfire.util.STAXUtils;

public class XFireServletController {
    private static ThreadLocal requests = new ThreadLocal();
    private static ThreadLocal responses = new ThreadLocal();
    private static final Log logger = LogFactory.getLog((Class)(class$org$codehaus$xfire$transport$http$XFireServletController == null ? (class$org$codehaus$xfire$transport$http$XFireServletController = XFireServletController.class$("org.codehaus.xfire.transport.http.XFireServletController")) : class$org$codehaus$xfire$transport$http$XFireServletController));
    protected XFire xfire;
    protected Transport transport;
    static /* synthetic */ Class class$org$codehaus$xfire$transport$http$XFireServletController;

    public XFireServletController(XFire xfire) {
        this.xfire = xfire;
        this.transport = SoapTransport.createSoapTransport(new SoapHttpTransport());
        this.registerTransport();
    }

    protected void registerTransport() {
        TransportManager service = this.getTransportManager();
        service.register(this.transport);
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)requests.get();
    }

    public static HttpServletResponse getResponse() {
        return (HttpServletResponse)responses.get();
    }

    protected TransportManager getTransportManager() {
        return this.getXFire().getTransportManager();
    }

    public void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String serviceName = this.getService(request);
        ServiceRegistry reg = this.getServiceRegistry();
        response.setHeader("Content-Type", "UTF-8");
        requests.set(request);
        responses.set(response);
        if (serviceName == null || serviceName.length() == 0 || !reg.hasService(serviceName)) {
            if (!reg.hasService(serviceName)) {
                response.setStatus(404);
            }
            this.generateServices(response);
            return;
        }
        try {
            if (request.getQueryString() != null && request.getQueryString().trim().equalsIgnoreCase("wsdl")) {
                this.generateWSDL(response, serviceName);
            } else {
                this.invoke(request, response, serviceName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't invoke servlet request.", (Throwable)e);
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            throw new ServletException((Throwable)e);
        }
        finally {
            requests.set(null);
            responses.set(null);
        }
    }

    protected void generateService(HttpServletResponse response, String serviceName) throws ServletException, IOException {
        response.setContentType("text/html");
        Service endpoint = this.getServiceRegistry().getService(serviceName);
        HtmlServiceWriter writer = new HtmlServiceWriter();
        try {
            writer.write((OutputStream)response.getOutputStream(), endpoint);
        }
        catch (XMLStreamException e) {
            throw new ServletException("Error writing HTML services list", (Throwable)e);
        }
    }

    protected void generateServices(HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        HtmlServiceWriter writer = new HtmlServiceWriter();
        try {
            writer.write((OutputStream)response.getOutputStream(), this.getServiceRegistry().getServices());
        }
        catch (XMLStreamException e) {
            throw new ServletException("Error writing HTML services list", (Throwable)e);
        }
    }

    protected void invoke(HttpServletRequest request, HttpServletResponse response, String service) throws ServletException, IOException, UnsupportedEncodingException {
        Channel channel;
        response.setStatus(200);
        XFireHttpSession session = new XFireHttpSession(request);
        MessageContext context = new MessageContext();
        context.setXFire(this.getXFire());
        context.setSession(session);
        context.setService(this.getService(service));
        try {
            channel = this.transport.createChannel(request.getRequestURI());
        }
        catch (Exception e) {
            throw new ServletException("Couldn't open channel.", (Throwable)e);
        }
        String contentType = request.getContentType();
        if (null == contentType) {
            response.setContentType("text/html; charset=UTF-8");
            response.getWriter().write("<html><body>Invalid SOAP request.</body></html>");
            response.getWriter().close();
        } else if (contentType.toLowerCase().indexOf("multipart/related") != -1) {
            try {
                response.setContentType("text/xml; charset=UTF-8");
                InputStream stream = this.createMIMERequest(request, context);
                XMLStreamReader reader = STAXUtils.createXMLStreamReader(stream, request.getCharacterEncoding());
                InMessage message = new InMessage(reader, request.getRequestURI());
                channel.receive(context, message);
            }
            catch (MessagingException e) {
                throw new XFireRuntimeException("Couldn't parse request message.", e);
            }
        } else {
            response.setContentType("text/xml; charset=UTF-8");
            XMLStreamReader reader = STAXUtils.createXMLStreamReader((InputStream)request.getInputStream(), request.getCharacterEncoding());
            InMessage message = new InMessage(reader, request.getRequestURI());
            channel.receive(context, message);
        }
    }

    protected InputStream createMIMERequest(HttpServletRequest request, MessageContext context) throws MessagingException, IOException {
        Session session = Session.getDefaultInstance((Properties)new Properties(), null);
        MimeMessage inMsg = new MimeMessage(session, (InputStream)request.getInputStream());
        inMsg.addHeaderLine("Content-Type: " + request.getContentType());
        Object content = inMsg.getContent();
        if (content instanceof MimeMultipart) {
            MimeMultipart inMP = (MimeMultipart)content;
            JavaMailAttachments atts = new JavaMailAttachments(inMP);
            context.setProperty("xfire.attachments", atts);
            return atts.getSoapMessage().getDataHandler().getInputStream();
        }
        throw new UnsupportedOperationException();
    }

    protected void generateWSDL(HttpServletResponse response, String service) throws ServletException, IOException {
        response.setStatus(200);
        response.setContentType("text/xml");
        this.getXFire().generateWSDL(service, (OutputStream)response.getOutputStream());
    }

    protected String getService(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        String serviceName = pathInfo.startsWith("/") ? pathInfo.substring(1) : pathInfo;
        return serviceName;
    }

    protected Service getService(String name) {
        return this.getXFire().getServiceRegistry().getService(name);
    }

    public XFire getXFire() {
        return this.xfire;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.xfire.getServiceRegistry();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

