/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.STAXUtils;

public class HttpMessageSender {
    private String username;
    private String password;
    private String encoding;
    private String urlString;
    private HttpURLConnection urlConn;
    private InputStream is;
    private String action;

    public HttpMessageSender(String urlString, String encoding) {
        this.urlString = urlString;
        this.encoding = encoding;
    }

    public void open() throws IOException, XFireFault {
        URL url = new URL(this.urlString);
        this.urlConn = this.createConnection(url);
        this.urlConn.setDoInput(true);
        this.urlConn.setDoOutput(true);
        this.urlConn.setUseCaches(false);
        this.urlConn.setRequestMethod("POST");
        this.urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.urlConn.setRequestProperty("User-Agent", "XFire Client +http://xfire.codehaus.org");
        this.urlConn.setRequestProperty("Accept", "text/xml; text/html");
        this.urlConn.setRequestProperty("Content-type", "text/xml; charset=" + this.encoding);
        String action = this.getAction();
        if (action == null) {
            action = "";
        }
        this.urlConn.setRequestProperty("SOAPAction", "\"" + action + "\"");
    }

    public OutputStream getOutputStream() throws IOException, XFireFault {
        return this.urlConn.getOutputStream();
    }

    public InMessage getInMessage() throws IOException {
        block2: {
            try {
                this.is = this.urlConn.getInputStream();
            }
            catch (IOException ioe) {
                if (this.urlConn.getResponseCode() != 500) break block2;
                this.is = this.urlConn.getErrorStream();
            }
        }
        return new InMessage(STAXUtils.createXMLStreamReader(this.is, this.encoding), this.urlString);
    }

    public void close() throws XFireException {
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            throw new XFireException("Couldn't close stream.", e);
        }
        finally {
            if (this.urlConn != null) {
                this.urlConn.disconnect();
            }
        }
    }

    private HttpURLConnection createConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    public String getUrl() {
        return this.urlString;
    }

    public void setUrl(String url) {
        this.urlString = url;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

