/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.service.Service;

public class HtmlServiceWriter {
    private static final String XHTML_STRICT_DTD = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";

    public void write(OutputStream out, Collection services) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(out);
        writer.writeStartDocument();
        this.writePreamble(writer, "XFire Services");
        writer.writeStartElement("body");
        writer.writeStartElement("p");
        writer.writeCharacters("No such service");
        writer.writeEndElement();
        if (!services.isEmpty()) {
            writer.writeStartElement("p");
            writer.writeCharacters("Services:");
            writer.writeEndElement();
            writer.writeStartElement("ul");
            Iterator iterator = services.iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                writer.writeStartElement("li");
                writer.writeCharacters(service.getName().toString());
                writer.writeEndElement();
            }
        }
        writer.writeEndDocument();
        writer.flush();
    }

    public void write(OutputStream out, Service service) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(out);
        writer.writeStartDocument();
        String title = service.getName() + " Web Service";
        this.writePreamble(writer, title);
        writer.writeStartElement("body");
        writer.writeStartElement("h1");
        writer.writeCharacters(title);
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private void writePreamble(XMLStreamWriter writer, String title) throws XMLStreamException {
        writer.writeDTD(XHTML_STRICT_DTD);
        writer.writeStartElement("html");
        writer.writeStartElement("head");
        writer.writeStartElement("title");
        writer.writeCharacters(title);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

