/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.util.ArrayList;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.transport.AbstractTransport;
import org.codehaus.xfire.wsdl11.WSDL11ParameterBinding;
import org.codehaus.xfire.wsdl11.WSDL11Transport;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilder;

public abstract class AbstractWSDLTransport
extends AbstractTransport
implements WSDL11Transport {
    public abstract String getServiceURL(Service var1);

    public abstract String getTransportURI(Service var1);

    public Binding createBinding(WSDLBuilder builder, PortType portType, WSDL11ParameterBinding paramBinding) {
        Definition def = builder.getDefinition();
        ServiceInfo info = builder.getService().getServiceInfo();
        Binding binding = def.createBinding();
        binding.setQName(new QName(info.getName().getNamespaceURI(), info.getName().getLocalPart() + this.getName() + "Binding"));
        binding.setPortType(portType);
        binding.setUndefined(false);
        binding.addExtensibilityElement((ExtensibilityElement)this.createSoapBinding(builder.getService(), paramBinding));
        return binding;
    }

    protected SOAPBinding createSoapBinding(Service endpoint, WSDL11ParameterBinding binding) {
        SOAPBindingImpl soapBind = new SOAPBindingImpl();
        String style = binding.getStyle();
        if (style.equals("wrapped")) {
            style = "document";
        }
        soapBind.setStyle(style);
        soapBind.setTransportURI(this.getTransportURI(endpoint));
        return soapBind;
    }

    public Port createPort(WSDLBuilder builder, Binding transportBinding) {
        Definition def = builder.getDefinition();
        Service service = builder.getService();
        SOAPAddressImpl add = new SOAPAddressImpl();
        add.setLocationURI(this.getServiceURL(service));
        Port port = def.createPort();
        port.setBinding(transportBinding);
        port.setName(service.getName() + this.getName() + "Port");
        port.addExtensibilityElement((ExtensibilityElement)add);
        return port;
    }

    public BindingOperation createBindingOperation(WSDLBuilder builder, PortType portType, Operation wsdlOp, WSDL11ParameterBinding binding) {
        Definition def = builder.getDefinition();
        BindingOperation bindOp = def.createBindingOperation();
        SOAPBody body = this.createSoapBody(builder.getService(), binding);
        SOAPOperationImpl soapOp = new SOAPOperationImpl();
        soapOp.setSoapActionURI("");
        BindingInput bindIn = def.createBindingInput();
        bindIn.setName(wsdlOp.getInput().getName());
        bindIn.addExtensibilityElement((ExtensibilityElement)body);
        if (wsdlOp.getOutput() != null) {
            BindingOutput bindOut = def.createBindingOutput();
            bindOut.setName(wsdlOp.getOutput().getName());
            bindOut.addExtensibilityElement((ExtensibilityElement)body);
            bindOp.setBindingOutput(bindOut);
        }
        bindOp.setName(wsdlOp.getName());
        bindOp.setOperation(wsdlOp);
        bindOp.setBindingInput(bindIn);
        bindOp.addExtensibilityElement((ExtensibilityElement)soapOp);
        return bindOp;
    }

    public SOAPBody createSoapBody(Service endpoint, WSDL11ParameterBinding binding) {
        SOAPBodyImpl body = new SOAPBodyImpl();
        body.setUse(binding.getUse());
        if (binding.getStyle().equals("rpc")) {
            body.setNamespaceURI(endpoint.getServiceInfo().getName().getNamespaceURI());
        }
        if (binding.getUse().equals("encoded")) {
            ArrayList<String> encodingStyles = new ArrayList<String>();
            encodingStyles.add(endpoint.getSoapVersion().getSoapEncodingStyle());
            body.setEncodingStyles(encodingStyles);
        }
        return body;
    }

    public SOAPHeader createSoapHeader(Service endpoint, WSDL11ParameterBinding binding) {
        SOAPHeaderImpl header = new SOAPHeaderImpl();
        header.setUse(binding.getUse());
        if (binding.getStyle().equals("rpc")) {
            header.setNamespaceURI(endpoint.getServiceInfo().getName().getNamespaceURI());
        }
        if (binding.getUse().equals("encoded")) {
            ArrayList<String> encodingStyles = new ArrayList<String>();
            encodingStyles.add(endpoint.getSoapVersion().getSoapEncodingStyle());
            header.setEncodingStyles(encodingStyles);
        }
        return header;
    }
}

