/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import junit.framework.TestCase;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.binding.MessageBindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.SoapTransport;
import org.codehaus.xfire.test.XPathAssert;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.transport.http.SoapHttpTransport;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.yom.Document;
import org.codehaus.yom.Node;
import org.codehaus.yom.Serializer;
import org.codehaus.yom.stax.StaxBuilder;

public abstract class AbstractXFireTest
extends TestCase {
    private XFire xfire;
    private ServiceFactory factory;
    private static String basedirPath;
    private XMLInputFactory defaultInputFactory = XMLInputFactory.newInstance();
    private Map namespaces = new HashMap();

    protected void printNode(Node node) throws Exception {
        Serializer writer = new Serializer((OutputStream)System.out);
        writer.setOutputStream((OutputStream)System.out);
        if (node instanceof Document) {
            writer.write((Document)node);
        } else {
            writer.flush();
            writer.writeChild(node);
        }
    }

    protected Document invokeService(String service, String document) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageContext context = new MessageContext();
        context.setXFire(this.getXFire());
        context.setProperty("urn:xfire:channel:backchannel", out);
        if (service != null) {
            context.setService(this.getServiceRegistry().getService(service));
        }
        InputStream stream = this.getResourceAsStream(document);
        InMessage msg = new InMessage(STAXUtils.createXMLStreamReader(stream, "UTF-8"));
        Transport t = this.getXFire().getTransportManager().getTransport("urn:xfire:transport:local");
        Channel c = t.createChannel();
        c.receive(context, msg);
        String response = out.toString();
        if (response == null || response.length() == 0) {
            return null;
        }
        return this.readDocument(response);
    }

    protected Document readDocument(String text) throws XMLStreamException {
        return this.readDocument(text, this.defaultInputFactory);
    }

    protected Document readDocument(String text, XMLInputFactory ifactory) throws XMLStreamException {
        try {
            StaxBuilder builder = new StaxBuilder(ifactory);
            return builder.build((Reader)new StringReader(text));
        }
        catch (XMLStreamException e) {
            System.err.println("Could not read the document!");
            System.err.println(text);
            throw e;
        }
    }

    protected Document getWSDLDocument(String service) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getXFire().generateWSDL(service, out);
        return this.readDocument(out.toString());
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.xfire == null) {
            this.xfire = new DefaultXFire();
        }
        this.addNamespace("s", Soap11.getInstance().getNamespace());
        this.addNamespace("soap12", Soap12.getInstance().getNamespace());
        TransportManager trans = this.getXFire().getTransportManager();
        trans.register(SoapTransport.createSoapTransport(new SoapHttpTransport()));
    }

    public List assertValid(String xpath, Node node) throws Exception {
        return XPathAssert.assertValid(xpath, node, this.namespaces);
    }

    public List assertInvalid(String xpath, Node node) throws Exception {
        return XPathAssert.assertInvalid(xpath, node, this.namespaces);
    }

    public void assertXPathEquals(String xpath, String value, Node node) throws Exception {
        XPathAssert.assertXPathEquals(xpath, value, node, this.namespaces);
    }

    public void assertNoFault(Node node) throws Exception {
        XPathAssert.assertNoFault(node);
    }

    public void addNamespace(String ns, String uri) {
        this.namespaces.put(ns, uri);
    }

    protected WSDLWriter getWSDL(String service) throws Exception {
        ServiceRegistry reg = this.getServiceRegistry();
        Service hello = reg.getService(service);
        return hello.getWSDLWriter();
    }

    protected XFire getXFire() {
        return this.xfire;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.getXFire().getServiceRegistry();
    }

    public ServiceFactory getServiceFactory() {
        if (this.factory == null) {
            ObjectServiceFactory ofactory = new ObjectServiceFactory(this.getXFire().getTransportManager(), new MessageBindingProvider());
            ofactory.setStyle("message");
            this.factory = ofactory;
        }
        return this.factory;
    }

    public void setServiceFactory(ServiceFactory factory) {
        this.factory = factory;
    }

    protected InputStream getResourceAsStream(String resource) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(resource);
    }

    protected Reader getResourceAsReader(String resource) {
        return new InputStreamReader(this.getResourceAsStream(resource));
    }

    public File getTestFile(String relativePath) {
        return new File(AbstractXFireTest.getBasedir(), relativePath);
    }

    public static String getBasedir() {
        if (basedirPath != null) {
            return basedirPath;
        }
        basedirPath = System.getProperty("basedir");
        if (basedirPath == null) {
            basedirPath = new File("").getAbsolutePath();
        }
        return basedirPath;
    }
}

