/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.WrappedBinding;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.stax.DepthXMLStreamReader;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl11.WSDL11ParameterBinding;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilder;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class RPCEncodedBinding
extends WrappedBinding
implements WSDL11ParameterBinding {
    public RPCEncodedBinding() {
        this.setStyle("rpc");
        this.setUse("encoded");
    }

    public void readMessage(InMessage inMessage, MessageContext context) throws XFireFault {
        int index;
        Service endpoint = context.getService();
        ArrayList<Object> parameters = new ArrayList<Object>();
        DepthXMLStreamReader dr = new DepthXMLStreamReader(context.getInMessage().getXMLStreamReader());
        if (!STAXUtils.toNextElement(dr)) {
            throw new XFireFault("There must be a method name element.", "Sender");
        }
        String opName = dr.getLocalName();
        OperationInfo operation = endpoint.getServiceInfo().getOperation(opName);
        if (operation == null && (index = opName.indexOf("Request")) > 0) {
            operation = endpoint.getServiceInfo().getOperation(opName.substring(0, index));
        }
        this.nextEvent(dr);
        this.setOperation(operation, context);
        if (operation == null) {
            throw new XFireFault("Invalid operation.", "Sender");
        }
        while (STAXUtils.toNextElement(dr)) {
            MessagePartInfo p = operation.getInputMessage().getMessagePart(dr.getName());
            if (p == null) {
                throw new XFireFault("Parameter " + dr.getName() + " does not exist!", "Sender");
            }
            parameters.add(this.getBindingProvider().readParameter(p, dr, context));
        }
        context.getInMessage().setBody(parameters);
    }

    public void createInputParts(WSDLBuilder builder, Message req, OperationInfo op) {
        this.writeParametersSchema(builder, req, op.getInputMessage());
    }

    public void createOutputParts(WSDLBuilder builder, Message req, OperationInfo op) {
        this.writeParametersSchema(builder, req, op.getOutputMessage());
    }

    protected void writeParametersSchema(WSDLBuilder builder, Message message, MessageInfo xmsg) {
        List params = xmsg.getMessageParts();
        Iterator itr = params.iterator();
        while (itr.hasNext()) {
            MessagePartInfo param = (MessagePartInfo)itr.next();
            QName pName = param.getName();
            SchemaType type = param.getSchemaType();
            builder.addDependency(type);
            QName schemaType = type.getSchemaType();
            Part part = builder.getDefinition().createPart();
            part.setName(pName.getLocalPart());
            if (type.isComplex()) {
                part.setElementName(pName);
                Element schemaEl = builder.createSchemaType(builder.getInfo().getTargetNamespace());
                Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
                schemaEl.appendChild((Node)element);
                element.addAttribute(new Attribute("name", pName.getLocalPart()));
                String prefix = builder.getNamespacePrefix(schemaType.getNamespaceURI());
                builder.addNamespace(prefix, schemaType.getNamespaceURI());
                element.addAttribute(new Attribute("type", prefix + ":" + schemaType.getLocalPart()));
            } else {
                part.setElementName(type.getSchemaType());
            }
            message.addPart(part);
        }
    }

    public Object clone() {
        RPCEncodedBinding binding = new RPCEncodedBinding();
        binding.setBindingProvider(this.getBindingProvider());
        return binding;
    }
}

