/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.stax.DepthXMLStreamReader;
import org.codehaus.xfire.wsdl11.WSDL11ParameterBinding;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilder;

public class DocumentBinding
extends AbstractBinding
implements WSDL11ParameterBinding,
Cloneable {
    public DocumentBinding() {
        this.setStyle("document");
        this.setUse("literal");
    }

    public void readMessage(InMessage inMessage, MessageContext context) throws XFireFault {
        Service endpoint = context.getService();
        ArrayList<Object> parameters = new ArrayList<Object>();
        DepthXMLStreamReader dr = new DepthXMLStreamReader(context.getInMessage().getXMLStreamReader());
        while (STAXUtils.toNextElement(dr)) {
            MessagePartInfo p = this.findMessagePart(endpoint, dr.getName());
            if (p == null) {
                throw new XFireFault("Parameter " + dr.getName() + " does not exist!", "Sender");
            }
            parameters.add(this.getBindingProvider().readParameter(p, dr, context));
        }
        if (!this.isClientModeOn()) {
            this.setOperation(this.findOperation(endpoint, parameters), context);
        }
        context.getInMessage().setBody(parameters);
    }

    public void writeMessage(OutMessage message, XMLStreamWriter writer, MessageContext context) throws XFireFault {
        OperationInfo op = context.getExchange().getOperation();
        Object[] values = (Object[])message.getBody();
        int i = 0;
        MessageInfo msgInfo = null;
        msgInfo = this.isClientModeOn() ? op.getInputMessage() : op.getOutputMessage();
        Iterator itr = msgInfo.getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo outParam = (MessagePartInfo)itr.next();
            this.getBindingProvider().writeParameter(outParam, writer, context, values[i]);
            ++i;
        }
    }

    protected OperationInfo findOperation(Service endpoint, List parameters) {
        Iterator itr = endpoint.getServiceInfo().getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo o = (OperationInfo)itr.next();
            List messageParts = o.getInputMessage().getMessageParts();
            if (messageParts.size() != parameters.size() || !this.checkParameters(messageParts, parameters)) continue;
            return o;
        }
        return null;
    }

    private boolean checkParameters(List messageParts, List parameters) {
        Iterator messagePartIterator = messageParts.iterator();
        Iterator parameterIterator = parameters.iterator();
        while (parameterIterator.hasNext()) {
            Object param = parameterIterator.next();
            MessagePartInfo mpi = (MessagePartInfo)messagePartIterator.next();
            if (mpi.getTypeClass().isAssignableFrom(param.getClass())) continue;
            return false;
        }
        return true;
    }

    protected MessagePartInfo findMessagePart(Service endpoint, QName name) {
        Iterator itr = endpoint.getServiceInfo().getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo op = (OperationInfo)itr.next();
            MessageInfo msgInfo = null;
            msgInfo = this.isClientModeOn() ? op.getOutputMessage() : op.getInputMessage();
            MessagePartInfo p = msgInfo.getMessagePart(name);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public void createInputParts(WSDLBuilder builder, Message req, OperationInfo op) {
        this.writeParameters(builder, req, op.getInputMessage().getMessageParts());
    }

    public void createOutputParts(WSDLBuilder builder, Message req, OperationInfo op) {
        this.writeParameters(builder, req, op.getOutputMessage().getMessageParts());
    }

    private void writeParameters(WSDLBuilder builder, Message message, Collection params) {
        Iterator itr = params.iterator();
        while (itr.hasNext()) {
            MessagePartInfo param = (MessagePartInfo)itr.next();
            builder.addNamespaceImport(builder.getService().getServiceInfo().getName().getNamespaceURI(), param.getSchemaType().getSchemaType().getNamespaceURI());
            Part part = builder.createPart(param);
            message.addPart(part);
        }
    }

    public Object clone() {
        DocumentBinding binding = new DocumentBinding();
        binding.setBindingProvider(this.getBindingProvider());
        return binding;
    }
}

