/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Visitable;
import org.codehaus.xfire.service.Visitor;

public class ServiceInfo
implements Visitable {
    private QName name;
    private Map operations = new HashMap();
    private Map opsByAction = new HashMap();
    private Class serviceClass;

    public ServiceInfo(QName name, Class serviceClass) {
        this.name = name;
        this.serviceClass = serviceClass;
    }

    public void accept(Visitor visitor) {
        visitor.startService(this);
        Iterator iterator = this.operations.values().iterator();
        while (iterator.hasNext()) {
            OperationInfo operationInfo = (OperationInfo)iterator.next();
            operationInfo.accept(visitor);
        }
        visitor.endService(this);
    }

    public OperationInfo addOperation(String name, Method method) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        if (this.operations.containsKey(name)) {
            throw new IllegalArgumentException("An operation with name [" + name + "] already exists in this service");
        }
        OperationInfo operation = new OperationInfo(name, method, this);
        this.addOperation(operation);
        return operation;
    }

    void addOperation(OperationInfo operation) {
        this.operations.put(operation.getName(), operation);
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public OperationInfo getOperation(String name) {
        return (OperationInfo)this.operations.get(name);
    }

    public OperationInfo getOperationByAction(String name) {
        Iterator itr = this.operations.values().iterator();
        while (itr.hasNext()) {
            OperationInfo op = (OperationInfo)itr.next();
            if (op.getAction() == null || !op.getAction().equals(name)) continue;
            return op;
        }
        if (!name.equals("*")) {
            return this.getOperationByAction("*");
        }
        return null;
    }

    public Collection getOperations() {
        return Collections.unmodifiableCollection(this.operations.values());
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    public void removeOperation(String name) {
        this.operations.remove(name);
    }
}

